<?php
/**
Plugin Name: CityBook Import Add-On
Plugin URI: https://citybook.cththemes.com/
Description: CityBook Import Add-On for WP All Import!
Version: 2.4.5
Author: CTHthemes
Author URI: http://themeforest.net/user/cththemes
Text Domain: citybook-import-addon
Domain Path: /languages/
Copyright: ( C ) 2014 cththemes.com . All rights reserved.
License: GNU General Public License version 3.0
License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

if ( ! defined('ABSPATH') ) {
    die('Please do not load this file directly!');
}


// Define CITYBOOK_IMPORT_ADDON_PLUGIN_FILE.
if ( ! defined( 'CITYBOOK_IMPORT_ADDON_PLUGIN_FILE' ) ) {
    define( 'CITYBOOK_IMPORT_ADDON_PLUGIN_FILE', __FILE__ );
}
define ('CITYBOOK_IMPORT_ADDON_DIR',plugin_dir_path(__FILE__ ));
define ('CITYBOOK_IMPORT_ADDON_DIR_URL',plugin_dir_url(__FILE__ ));


register_activation_hook( __FILE__, 'citybook_import_addon_activation_hook_callback' );

function citybook_import_addon_activation_hook_callback(){
	if(!class_exists('CityBook_Addons')) {
		deactivate_plugins( plugin_basename( __FILE__ ) );
		wp_die( __( 'This plugin requires CityBook Add-Ons plugin.  Sorry about that.', 'citybook-import-addon' ) );
	}
}

if(!function_exists('citybook_addons_get_listing_price_range')) return;


include CITYBOOK_IMPORT_ADDON_DIR . 'wp-all-import-rapid-addon/rapid-addon.php';


$citybook_import_addon = new RapidAddon('CityBook Import Add-On', 'citybook-import-addon');

include CITYBOOK_IMPORT_ADDON_DIR . 'includes/options.php';

// add_field($field_slug, $field_name, $field_type, $enum_values = null, $tooltip = "", $is_html = true, $default_text = '')

$adon_fields = array(
	'location_opts_title'=> array(
		'is_title'			=> true,
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Address/Contacts', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),
	'_cth_address' => array(
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Address', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),
	'listing_location_lat_lng'=> array(
		'field_type' 		=> 'radio',
		'field_name'		=> __( 'Listing Coordinates', 'citybook-import-addon' ),
		'enum_values' 		=> listing_coordinates($citybook_import_addon), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),
	
	'_cth_phone' => array(
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Phone', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),
	'_cth_email' => array(
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Email', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),
	'_cth_website' => array(
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Website', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),
	'price_opts_title'=> array(
		'is_title'			=> true,
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Price Options', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),

	'_cth_price_range'=> array(
		'field_type' 		=> 'radio',
		'field_name'		=> __( 'Price Range', 'citybook-import-addon' ),
		'enum_values' 		=> citybook_addons_get_listing_price_range(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),
	'_cth_price_from' => array(
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Price From', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),
	'_cth_price_to' => array(
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Price To', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),
	'media_opts_title'=> array(
		'is_title'			=> true,
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Media Options', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),
	'_cth_listing_thumbnail' => array(
		'field_type' 		=> 'image',
		'field_name'		=> __( 'Listing Featured Image', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),
	'_cth_listing_header_imgs' => array(
		'field_type' 		=> 'images',
		'field_name'		=> __( 'Listing Header Images', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),

	'_cth_headertype' => array(
		'field_type' 		=> 'radio',
		'field_name'		=> __( 'Listing Header Type. Images for header are from <strong>Listing Header Images</strong> section', 'citybook-import-addon' ),
		'enum_values' 		=> citybook_addons_get_listing_header_types($citybook_import_addon), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),

	'content_widget_opts_title'=> array(
		'is_title'			=> true,
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Content Widgets', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),

	'content_widget_gallery_text'=> array(
		'is_text'			=> true,
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Gallery Widget - Images is imported from Listing Gallery Images section', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),
	'content_widget_slider_text'=> array(
		'is_text'			=> true,
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Slider Widget - Images is imported from Listing Slider Images section', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),

	'_cth_promovideo_url'=> array(
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Promo Video', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),
	'_cth_promo_bg' => array(
		'field_type' 		=> 'image',
		'field_name'		=> __( 'Promo Video Background', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> __( 'Set promo video a background image to display as popup', 'citybook-import-addon' ),
		'is_html'			=> true,
		'default_text'		=> '',
	),


	'_cth_listing_gallery_imgs' => array(
		'field_type' 		=> 'images',
		'field_name'		=> __( 'Listing Gallery Images', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),

	'_cth_listing_slider_imgs' => array(
		'field_type' 		=> 'images',
		'field_name'		=> __( 'Listing Slider Images', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),

	'event_opts_title'=> array(
		'is_title'			=> true,
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Event Listing Options', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),

	'listing_event_date'=> array(
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Event Date', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),

	'listing_event_date_end'=> array(
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Event Date End', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),

	'_cth_working_hours' => array(
		'is_options'		=> true,
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Working Hours', 'citybook-import-addon' ),
		'enum_values' 		=> citybook_import_addon_working_hours('_cth_wkh_',$citybook_import_addon), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),


	'_cth_socials' => array(
		'is_options'		=> true,
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Socials', 'citybook-import-addon' ),
		'enum_values' 		=> citybook_import_addon_socials('_cth_socials',$citybook_import_addon), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),

	'other_opts_title'=> array(
		'is_title'			=> true,
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Other Options', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> '',
		'is_html'			=> true,
		'default_text'		=> '',
	),

	'_cth_plan_id'=> array(
		'field_type' 		=> 'text',
		'field_name'		=> __( 'Listing Plan ID (Optional)', 'citybook-import-addon' ),
		'enum_values' 		=> array(), //null,
		'tooltip'			=> __( 'Membership package ID ( Listing Plans post ), which this listing get field settings from.', 'citybook-import-addon' ),
		'is_html'			=> true,
		'default_text'		=> '',
	),

);


foreach ($adon_fields as $field_slug => $field_opts) {
	if(isset($field_opts['is_options']) && $field_opts['is_options']){
		$citybook_import_addon->add_options(
		        null,
		        $field_opts['field_name'], 
		        $field_opts['enum_values']
		);
	}elseif(isset($field_opts['is_title']) && $field_opts['is_title']){
		$citybook_import_addon->add_title( $field_opts['field_name'], $field_opts['tooltip'] );
	}elseif(isset($field_opts['is_text']) && $field_opts['is_text']){
		$citybook_import_addon->add_text( $field_opts['field_name'] );
	}elseif($field_opts['field_type'] == 'images'){
		$citybook_import_addon->import_images( $field_slug, $field_opts['field_name'] );
	}else{
		$citybook_import_addon->add_field(
			$field_slug, 
			$field_opts['field_name'], 
			$field_opts['field_type'], 
			$field_opts['enum_values'], 
			$field_opts['tooltip'], 
			$field_opts['is_html'], 
			$field_opts['default_text']
		);
	}
		
}

$citybook_import_addon->set_import_function('citybook_import_addon_function');


function citybook_import_addon_function( $post_id, $data, $import_options, $article ) {
  	global $citybook_import_addon;
  	global $adon_fields;

  	// $citybook_import_addon->log( 'Data Array: ' . json_encode($data) );  

  	foreach ( $adon_fields as $field => $field_opts ) {
	    if ( empty( $article['ID'] ) or $citybook_import_addon->can_update_meta( $field, $import_options ) ) {
	    	
	    	// don't update socials
	    	if(strpos($field, '_cth_socials_') === false || !in_array($field, array('_cth_no_lat_lng','listing_location_lat_lng','_cth_listing_thumbnail','location_opts_title','price_opts_title','media_opts_title','hour_opts_title','social_opts_title','_cth_working_hours','other_opts_title','_cth_listing_header_imgs','content_widget_opts_title','_cth_listing_gallery_imgs','_cth_listing_slider_imgs','content_widget_slider_text','content_widget_gallery_text','event_opts_title','listing_event_date','listing_event_date_end'))){
	    		update_post_meta( $post_id, $field, $data[ $field ] );  
	    	}
	    	
	    	// $citybook_import_addon->log( 'Field name: ' . $field );  
	    	// $citybook_import_addon->log( 'Field value: ' . $data[ $field ] );  

	      	// if($field == '_cth_no_lat_lng' && $data[ $field ] == 'yes' ){
      		// 	$lat_lng = citybook_import_addondo_geocode($data[ '_cth_address' ]);
      		// 	if($lat_lng){
      		// 		update_post_meta( $post_id, '_cth_latitude', $lat_lng['lat'] ); 
      		// 		update_post_meta( $post_id, '_cth_longitude', $lat_lng['lng'] ); 
      		// 	}
	      	// }

	      	if($field == 'listing_location_lat_lng'){
	      		if($data[$field] == 'search_by_address' && $data['google_api_key'] ){
	      			$lat_lng = citybook_import_addondo_geocode($data[ '_cth_address' ], $data['google_api_key'] );
	      			if($lat_lng){
	      				update_post_meta( $post_id, '_cth_latitude', $lat_lng['lat'] ); 
	      				update_post_meta( $post_id, '_cth_longitude', $lat_lng['lng'] ); 
	      			}
	      		}

	      		if( $data[$field] == 'enter_coordinates' ) {
	      			update_post_meta( $post_id, '_cth_latitude', $data['_cth_latitude'] ); 
      				update_post_meta( $post_id, '_cth_longitude', $data['_cth_longitude'] ); 
	      		}
	      	}

	      	// update socials
	      	if($field == '_cth_socials'){
	      		$socials = citybook_addons_get_socials_list();
	      		$socials_val = array();
				foreach ($socials as $val => $lbl) {
					if( isset($data[ '_cth_socials_'.$val ]) && $data[ '_cth_socials_'.$val ] != '' ) $socials_val[] = array('name'=>$val,'url'=>$data[ '_cth_socials_'.$val ]);
			    }
			    if(!empty($socials_val)) update_post_meta( $post_id, '_cth_socials', $socials_val ); 
	      	}
	      	// end update socials
	      	// update for _price
	      	if($field == '_cth_price_from'){
	      		update_post_meta( $post_id, '_price', $data[ $field ] ); 
	      	}
	      	// update listing thumbnail
	      	if($field == '_cth_listing_thumbnail' && isset($data[ $field ]['attachment_id']) && $data[ $field ]['attachment_id'] != ''){
	      		set_post_thumbnail( $post_id, $data[ $field ]['attachment_id'] );
	      	}
	      	// update working hours
	      	if($field == '_cth_working_hours'){

	      		// update listing expiration
	      		update_post_meta( $post_id, '_cth_expire_date',  'NEVER'  );

	      		update_post_meta($post_id, "_cth_wkh_tz", $data['_cth_wkh_tz']);
	            update_post_meta($post_id, "_cth_wkh_tz_offset", citybook_addons_get_timezone_offset($data['_cth_wkh_tz']));
	            update_post_meta($post_id, "_cth_wkh_tz_utc_offset", citybook_addons_get_mysql_timezone_offset($data['_cth_wkh_tz']));

	            foreach (citybook_addons_get_working_days_array() as $dayname => $lbl) {
	            	update_post_meta($post_id, '_cth_wkh_status_'.$dayname , $data['_cth_wkh_status_'.$dayname]);
	            	update_post_meta($post_id, '_cth_wkh_hours_'.$dayname , $data['_cth_wkh_hours_'.$dayname]);
	            }

	      	}
	      	// update header images
	      	if($field == '_cth_listing_header_imgs'){ // not exist for import images field
	      		// $citybook_import_addon->log( 'Field _cth_listing_header_imgs value: ' . $data[ $field ] );  
	      	}

	      	// update header video 
	      	if($field == '_cth_headertype'){ // not exist for import images field
	      		if( isset($data[ '_cth_headerbg_youtube']) && $data[ '_cth_headerbg_youtube'] != '' ) update_post_meta( $post_id, '_cth_headerbg_youtube', $data[ '_cth_headerbg_youtube' ] ); 
	      		if( isset($data[ '_cth_headerbg_vimeo']) && $data[ '_cth_headerbg_vimeo'] != '' ) update_post_meta( $post_id, '_cth_headerbg_vimeo', $data[ '_cth_headerbg_vimeo' ] ); 
	      		if( isset($data[ '_cth_headerbg_mp4']) && $data[ '_cth_headerbg_mp4'] != '' ) update_post_meta( $post_id, '_cth_headerbg_mp4', $data[ '_cth_headerbg_mp4' ] ); 
	      	}

	      	// update event date
	      	if($field == 'listing_event_date' && $data[$field] != ''){
	      		$formated_date = citybook_addons_re_format_date( $data[$field], 'Y-m-d H:i:s' );
	      		$event_datetime = explode(" ", $formated_date);
	      		update_post_meta($post_id, "_cth_levent_date", $event_datetime[0]);
	      		update_post_meta($post_id, "_cth_levent_time", $event_datetime[1]);
	      	}
	      	if($field == 'listing_event_date_end' && $data[$field] != ''){
	      		$formated_date = citybook_addons_re_format_date( $data[$field], 'Y-m-d H:i:s' );
	      		$event_datetime = explode(" ", $formated_date);
	      		update_post_meta($post_id, "_cth_levent_end_date", $event_datetime[0]);
	      		update_post_meta($post_id, "_cth_levent_end_time", $event_datetime[1]);

	      	}
	      	

	    }  
  	}  
}

function citybook_import_addondo_geocode($address = '', $api_key = ''){
	global $citybook_import_addon;

	$address   = urlencode($address);
	if(citybook_addons_get_option('use_osm') == 'yes'){
		$url       = "https://nominatim.openstreetmap.org/?format=json&addressdetails=1&q={$address}&format=json&limit=1";
	}else{
		$url       = "https://maps.googleapis.com/maps/api/geocode/json?address={$address}&key={$api_key}";
	}
	
	$response = wp_remote_get( $url );
	if ( is_array( $response ) ) {
	    $body = json_decode($response['body'],true); // use the content

	    if(citybook_addons_get_option('use_osm') == 'yes'){
	    	if(!empty($body) && isset($body[0])){
	    		return array(
		        	'lat' => $body[0]['lat'],
		        	'lng' => $body[0]['lon'],
		        );
	    	}else {
		        return false;
		    }
	    }else{
	    	if ($body['status'] == 'OK') {
		        // get the important data
		        $lati  = $body['results'][0]['geometry']['location']['lat'];
		        $longi = $body['results'][0]['geometry']['location']['lng'];
		        return array(
		        	'lat' => $lati,
		        	'lng' => $longi,
		        );
		    } else {
		        return false;
		    }
	    }
	}else{
		return false;
	}

}

// http://www.wpallimport.com/documentation/addon-dev/best-practices/
$citybook_import_addon->run(
	array(
		"themes" => array("CityBook")
	)
	// ,
	// array(
	// 	"post_types" => array( "listing" ),
	// )
);



function citybook_import_adon_plugins_init() {
    $plugin_dir = basename(dirname(__FILE__));
    load_plugin_textdomain( 'citybook-import-addon', false, $plugin_dir . '/languages' );
}
add_action('plugins_loaded', 'citybook_import_adon_plugins_init');

