<?php
/**
 * @package CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 17-04-2018
 * @since 1.0.0
 * @version 1.0.0
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */
// Your php code goes here
function citybook_child_enqueue_styles() {
    $parent_style = 'citybook-style'; // This is 'citybook-style' for the Anakual theme.
    wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css', array('citybook-fonts', 'font-awesome', 'lightgallery', 'slick','citybook-plugins'), null );
    wp_enqueue_style( 'citybook-child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array( $parent_style , 'citybook-color'),
        wp_get_theme()->get('Version')
    );
}
add_action( 'wp_enqueue_scripts', 'citybook_child_enqueue_styles' );

function citybook_child_modify_footer(){
	// if(is_page(551) || is_page(2170) || is_page(2172) || is_page(2185) || is_page(2193) || is_page(2196) || is_singular( 'listing' )){
	if(!is_page(531) && !is_page(294) && !is_page(547) && !is_page(545) && !is_page(116) && !is_page(1624) && !is_page(920) && !is_page(553) && !is_page(697) && !is_page(2321) ){
	?>
	<!--section -->
	<section class="gradient-bg">
	    <div class="cirle-bg">
	        <div class="bg" data-bg="<?php echo get_template_directory_uri();?>/assets/images/bg/circle.png"></div>
	    </div>
	    <div class="container">
	        <div class="join-wrap fl-wrap">
	        	<div class="row">
                    <div class="col-md-8">
                        <h3>Join our online community</h3>
                        <p>Grow your marketing and be happy with your online business</p>
                    </div>
                    <div class="col-md-4 text-center"><a href="#" class="join-wrap-btn logreg-modal-open">Sign Up <i class="fa fa-sign-in"></i></a></div>
                </div>
	        </div>
	    </div>
	</section>
	<!-- section end -->
<?php
	}
}

// add_action( 'citybook_footer_before', 'citybook_child_modify_footer');