<?php
/**
 * Blog Block
 * 
 * @var array  $atts  Shortcode attribs.
 * @var string $tag   Shortcode used, example: highlights.
 * 
 * @var ContentBerg_Block $block  Block object from the plugin.
 * @var WP_Query          $query  Query setup by block object.
 * 
 * @see ContentBerg_Block::process()
 * @see ContentBerg_ShortCodes::_render()
 */

/**
 * Determine the listing style to use
 */
$tag = str_replace('_', '-', $tag);

// Default to shortcode tag if type isn't defined, but not for base shortcode blog
if (empty($type) && $tag !== 'blog') {
	$type = $tag;
}

if (empty($type) OR $type == 'loop-default') {
	$type = Bunyad::options()->category_loop;
}

// loop template
$template = empty($type) ? 'loop' : $type;

?>

	<section <?php Bunyad::markup()->attribs('blog-block', array('class' => array('cf block', $tag), 'data-id' => $block->block_id)); ?>>
	
		<?php echo $block->output_heading(); // XSS ok. HTML generated by ContentBerg_Block::output_heading() ?>
		
		<div class="block-content">
		<?php
		
			// Get our loop template with include to preserve local variable scope
			$data = compact('block', 'query', 'atts', 'grid_cols', 'pagination', 'pagination_type', 'show_excerpt', 'excerpt_length', 'show_footer');
			Bunyad::get('helpers')->loop($template, $data);
		
		?>
		</div>
	
	</section>

<?php wp_reset_postdata(); ?>