<?php

$footer_social = get_theme_mod(
	'colormag_footer_socials',
	array(
		array(
			'id'    => uniqid(),
			'label' => 'facebook',
			'url'   => '#',
			'icon'  => 'fa-brands fa-facebook',
		),
		array(
			'id'    => uniqid(),
			'label' => 'twitter',
			'url'   => '#',
			'icon'  => 'fa-brands fa-x-twitter',
		),
		array(
			'id'    => uniqid(),
			'label' => 'instagram',
			'url'   => '#',
			'icon'  => 'fa-brands fa-square-instagram',
		),
	)
);

$enable_brand_color = get_theme_mod( 'colormag_enable_footer_socials_brand_color', false );

$file_path = CUSTOMIND_DIR . '/data/social-networks.php';

if ( file_exists( $file_path ) ) {
	$social_networks = include $file_path;
} else {
	$social_networks = array();
}
?>

<?php if ( ! empty( $footer_social ) ) : ?>
	<div class="social-icons footer-social-icons">
		<?php foreach ( $footer_social as $key => $value ) : ?>
			<?php if ( ! empty( $value ) ) : ?>
				<?php $brand = $social_networks[ strtolower( $value['label'] ) ] ?? false; ?>
				<a <?php ( $brand && $enable_brand_color ) ? printf( 'style="color:%s;"', $brand ) : ''; ?> href="<?php echo esc_url( $value['url'] ); ?>" target="_blank" rel="noopener noreferrer">
					<i class="<?php echo esc_attr( $value['icon'] ); ?>"></i>
				</a>
			<?php endif; ?>
		<?php endforeach; ?>
	</div>
<?php endif; ?>
