<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.4.1
 */

namespace radiustheme\Classima;

use Rtcl\Helpers\Link;

$nav_menu_args = Helper::nav_menu_args();

$light_logo       = empty( RDTheme::$options['logo_light']['url'] ) ? Helper::get_img( 'logo-light.png' ) : RDTheme::$options['logo_light'];
$dark_logo        = empty( RDTheme::$options['logo']['url'] ) ? Helper::get_img( 'logo-dark.png' ) : RDTheme::$options['logo'];
$menu_class       = "col-md-12 col-sm-12 col-12";
$login_icon_title = is_user_logged_in() ? esc_html__( 'My Account', 'classima' ) : esc_html__( 'Login/Register', 'classima' );
?>

<div class="header-top-part">
    <div class="container">
        <div class="header-top-part-inner">
            <div class="site-branding">

				<?php if ( ! empty( $dark_logo['url'] ) ): ?>
                    <a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <img src="<?php echo esc_url( $dark_logo['url'] ); ?>"
                             width="<?php echo isset( $dark_logo['width'] ) ? esc_attr( $dark_logo['width'] ) : '150'; ?>"
                             height="<?php echo isset( $dark_logo['height'] ) ? esc_attr( $dark_logo['height'] ) : '45'; ?>"
                             alt="<?php esc_attr( bloginfo( 'name' ) ); ?>">
                    </a>
				<?php else: ?>
                    <a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <img src="<?php echo esc_url( $dark_logo ); ?>" width="150" height="45"
                             alt="<?php esc_attr( bloginfo( 'name' ) ); ?>">
                    </a>
				<?php endif; ?>

				<?php if ( ! empty( $light_logo['url'] ) ): ?>
                    <a class="light-logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <img src="<?php echo esc_url( $light_logo['url'] ); ?>"
                             height="<?php echo isset( $light_logo['height'] ) ? esc_attr( $light_logo['height'] ) : '45'; ?>"
                             width="<?php echo isset( $light_logo['width'] ) ? esc_attr( $light_logo['width'] ) : '150'; ?>"
                             alt="<?php esc_attr( bloginfo( 'name' ) ); ?>">
                    </a>
				<?php else: ?>
                    <a class="light-logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <img src="<?php echo esc_url( $light_logo ); ?>" width="150" height="45"
                             alt="<?php esc_attr( bloginfo( 'name' ) ); ?>">
                    </a>
				<?php endif; ?>

            </div>
            <div class="header-icon-area">

				<?php if ( RDTheme::$options['header_icon'] && class_exists( 'RtclPro' ) && class_exists( 'Rtcl' ) ): ?>
                    <a class="header-login-icon" data-toggle="tooltip" title="<?php echo esc_attr( $login_icon_title ); ?>"
                       href="<?php echo esc_url( Link::get_my_account_page_link() ); ?>">
                        <svg width="15" height="15" viewBox="0 0 15 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M13.6551 14.1953C13.5811 14.1953 13.5077 14.1806 13.4394 14.152C13.3711 14.1234 13.3092 14.0816 13.2573 14.0288C13.2053 13.9761 13.1644 13.9136 13.1369 13.845C13.1094 13.7763 13.0958 13.7029 13.097 13.6289C13.0944 12.8417 12.9337 12.063 12.6245 11.3388C12.3153 10.6147 11.8638 9.95981 11.2967 9.41296C10.8024 8.92474 10.2267 8.52625 9.59549 8.23536C8.84959 8.7026 7.99135 8.96035 7.11111 8.98147C6.24567 8.98096 5.39872 8.73128 4.67174 8.26233C3.61657 8.71464 2.71827 9.46747 2.0891 10.4267C1.45994 11.386 1.1278 12.5092 1.1342 13.6559C1.1342 13.8061 1.07446 13.9501 0.968109 14.0563C0.86176 14.1626 0.717519 14.2222 0.567119 14.2222C0.416718 14.2222 0.272478 14.1626 0.166128 14.0563C0.059779 13.9501 3.26033e-05 13.8061 3.26033e-05 13.6559C-0.00378417 12.3962 0.327578 11.1581 0.960214 10.0682C1.59285 8.97841 2.50405 8.07598 3.60058 7.45329L3.69059 7.39936L3.60058 7.31845C3.14847 6.75934 2.8372 6.10011 2.69287 5.39605C2.54855 4.69199 2.57539 3.96364 2.77113 3.27208C2.96687 2.58052 3.32581 1.94591 3.81784 1.42149C4.30988 0.897063 4.92066 0.49811 5.59896 0.25809C6.27726 0.0180691 7.00331 -0.0560207 7.7162 0.0420344C8.42909 0.140089 9.10805 0.40743 9.69613 0.821635C10.2842 1.23584 10.7642 1.78483 11.096 2.42256C11.4278 3.06029 11.6015 3.76817 11.6028 4.48683C11.6087 5.52796 11.2452 6.53753 10.5766 7.33643L10.5136 7.41734L10.6036 7.47127C11.1652 7.78545 11.6828 8.17234 12.1429 8.6219C12.8043 9.27919 13.3287 10.0609 13.6856 10.9219C14.0425 11.7829 14.2249 12.7061 14.2222 13.6379C14.2198 13.7866 14.159 13.9283 14.0529 14.0326C13.9469 14.1368 13.804 14.1953 13.6551 14.1953ZM7.11111 1.12484C6.44528 1.12484 5.7944 1.32202 5.24078 1.69144C4.68716 2.06086 4.25566 2.58593 4.00086 3.20025C3.74606 3.81458 3.67939 4.49056 3.80929 5.14272C3.93919 5.79488 4.25981 6.39393 4.73063 6.86412C5.20144 7.3343 5.8013 7.6545 6.45434 7.78422C7.10738 7.91394 7.78427 7.84737 8.39942 7.59291C9.01457 7.33844 9.54035 6.90753 9.91026 6.35465C10.2802 5.80178 10.4776 5.15177 10.4776 4.48683C10.4776 3.59518 10.1229 2.74004 9.4916 2.10954C8.86025 1.47905 8.00397 1.12484 7.11111 1.12484Z"
                                  fill="#E10808"/>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M14.0334 11.9984C13.9468 11.6317 13.8306 11.2717 13.6856 10.9219C13.6813 10.9117 13.6771 10.9014 13.6728 10.8912C13.3441 10.1089 12.8769 9.39268 12.2941 8.77681C12.2891 8.77158 12.2842 8.76636 12.2792 8.76115C12.2344 8.71414 12.189 8.66772 12.1429 8.6219C12.1319 8.61116 12.1209 8.60045 12.1098 8.58977C12.1065 8.58658 12.1032 8.58338 12.0998 8.58019C11.8955 8.38383 11.6802 8.1997 11.4549 8.02865C11.3413 7.94244 11.2253 7.85955 11.1068 7.7801C10.9435 7.67053 10.7756 7.56749 10.6036 7.47127L10.5136 7.41734L10.5766 7.33643C10.6725 7.22186 10.7621 7.10295 10.8453 6.98024C10.949 6.82706 11.0428 6.66795 11.126 6.50394C11.1953 6.36743 11.2574 6.22754 11.312 6.08484C11.5058 5.57862 11.6059 5.03713 11.6028 4.48683C11.6015 3.76817 11.4278 3.06029 11.096 2.42256C10.883 2.01304 10.6088 1.64011 10.2841 1.31597C10.1032 1.13534 9.90657 0.969857 9.69613 0.821635C9.10805 0.40743 8.42909 0.140089 7.7162 0.0420344C7.5151 0.0143734 7.31294 0.000411378 7.11111 8.95788e-06C6.59748 -0.00101515 6.08591 0.0857781 5.59896 0.25809C5.25001 0.381569 4.91892 0.547111 4.61268 0.750161C4.32365 0.941802 4.05675 1.16685 3.81784 1.42149C3.4491 1.8145 3.15511 2.2694 2.94854 2.76378C2.87947 2.92908 2.82018 3.09879 2.77113 3.27208C2.57814 3.9539 2.54934 4.67148 2.68688 5.36628C2.68884 5.37621 2.69084 5.38613 2.69287 5.39605C2.73781 5.61525 2.79892 5.8301 2.87543 6.03894C2.93836 6.21072 3.01172 6.37844 3.09504 6.54116C3.23579 6.816 3.40501 7.0766 3.60058 7.31845L3.69059 7.39936L3.60058 7.45329C3.51228 7.50344 3.42518 7.55539 3.33934 7.60911C3.13803 7.73509 2.9436 7.87077 2.75668 8.01554C2.4535 8.25035 2.17005 8.50907 1.90903 8.78904C1.61948 9.09961 1.35751 9.43633 1.12679 9.79558C1.06931 9.88509 1.01376 9.97599 0.960214 10.0682C0.604171 10.6816 0.343552 11.3419 0.184401 12.0266C0.102 12.3811 0.0467993 12.7422 0.0196383 13.1066C0.00604631 13.289 -0.000523949 13.4722 3.26033e-05 13.6559C3.26033e-05 13.658 4.44201e-05 13.6601 6.80171e-05 13.6622C0.00172231 13.8101 0.0612746 13.9516 0.166128 14.0563C0.272478 14.1626 0.416718 14.2222 0.567119 14.2222C0.717519 14.2222 0.86176 14.1626 0.968109 14.0563C1.07446 13.9501 1.1342 13.8061 1.1342 13.6559C1.1342 13.6548 1.13419 13.6536 1.13419 13.6525C1.1332 13.4539 1.14235 13.2561 1.16144 13.0597C1.19096 12.756 1.24424 12.4557 1.32048 12.1615C1.45809 11.6306 1.67049 11.1197 1.95301 10.6445C1.9967 10.5711 2.04207 10.4984 2.0891 10.4267C2.49332 9.81045 3.00862 9.27937 3.60524 8.85844C3.79302 8.72595 3.98887 8.60437 4.19184 8.49449C4.20005 8.49004 4.20827 8.48562 4.21651 8.48121C4.24738 8.46469 4.27842 8.44843 4.30962 8.43245C4.42808 8.37177 4.54885 8.31501 4.67174 8.26233C5.01087 8.48109 5.3761 8.65213 5.75714 8.77243C5.91358 8.82182 6.07269 8.86265 6.23374 8.89472C6.52133 8.95198 6.81514 8.9813 7.11111 8.98147C7.55564 8.97081 7.99455 8.89979 8.41622 8.77192C8.55523 8.72977 8.69236 8.68144 8.82721 8.62706C9.09329 8.51974 9.35045 8.38886 9.59549 8.23536C9.70712 8.2868 9.81701 8.34161 9.92502 8.39968C9.95586 8.41626 9.98655 8.4331 10.0171 8.45021C10.0269 8.45574 10.0368 8.4613 10.0466 8.46689C10.2491 8.58189 10.4447 8.70856 10.6322 8.84621C10.8668 9.01839 11.089 9.20774 11.2967 9.41296C11.307 9.42281 11.3172 9.4327 11.3273 9.44263C11.3296 9.44491 11.332 9.44719 11.3343 9.44947C11.8838 9.98887 12.3222 10.6307 12.6245 11.3388C12.6273 11.3453 12.6301 11.3518 12.6328 11.3583C12.7399 11.6116 12.8288 11.8714 12.8992 12.1359C12.9769 12.4279 13.0321 12.7256 13.0641 13.0264C13.085 13.2232 13.096 13.4213 13.097 13.62C13.097 13.623 13.097 13.626 13.097 13.6289C13.097 13.6308 13.097 13.6328 13.097 13.6347C13.0965 13.7067 13.1101 13.7781 13.1369 13.845C13.1644 13.9136 13.2053 13.9761 13.2573 14.0288C13.3092 14.0816 13.3711 14.1234 13.4394 14.152C13.5077 14.1806 13.5811 14.1953 13.6551 14.1953C13.804 14.1953 13.9469 14.1368 14.0529 14.0326C14.1569 13.9305 14.2173 13.7924 14.222 13.6471C14.2221 13.644 14.2221 13.641 14.2222 13.6379C14.2222 13.6337 14.2222 13.6294 14.2222 13.6252C14.2223 13.5538 14.2213 13.4825 14.2192 13.4113C14.2161 13.3063 14.2107 13.2015 14.2029 13.0969C14.188 12.8954 14.1644 12.6948 14.1322 12.4957C14.1053 12.3288 14.0723 12.1629 14.0334 11.9984ZM7.34469 7.84072C7.70543 7.81566 8.06173 7.73259 8.39942 7.59291C8.60862 7.50637 8.80749 7.39942 8.99341 7.27421C9.2254 7.11796 9.43722 6.93328 9.6238 6.72432C9.64658 6.6988 9.66899 6.67292 9.69101 6.64669C9.69945 6.63663 9.70783 6.62653 9.71616 6.61637C9.78485 6.53257 9.84965 6.44525 9.91026 6.35465C9.98514 6.24274 10.0529 6.12686 10.1135 6.00767C10.3511 5.53992 10.4766 5.02137 10.4776 4.49324C10.4776 4.49176 10.4776 4.49027 10.4776 4.48879C10.4776 4.48814 10.4776 4.48748 10.4776 4.48683C10.4776 3.94365 10.346 3.41403 10.1004 2.94049C9.94282 2.63668 9.73834 2.35596 9.4916 2.10954C9.35446 1.97259 9.20671 1.84867 9.05028 1.73859C8.60916 1.42817 8.099 1.22776 7.56308 1.15526C7.41411 1.13511 7.26314 1.12484 7.11111 1.12484C6.72196 1.12484 6.33791 1.1922 5.9754 1.32193C5.71767 1.41416 5.47083 1.53793 5.24078 1.69144C5.02213 1.83734 4.82253 2.00751 4.64535 2.19788C4.37389 2.48952 4.15503 2.82855 4.00086 3.20025C3.94895 3.32542 3.90484 3.45315 3.86862 3.58271C3.72705 4.08905 3.70586 4.62344 3.80929 5.14272C3.81085 5.15056 3.81244 5.1584 3.81406 5.16622C3.87846 5.47792 3.98649 5.77724 4.1337 6.05584C4.20628 6.19321 4.28839 6.32554 4.37949 6.45184C4.40353 6.48517 4.4282 6.51809 4.45349 6.55056C4.46594 6.56655 4.47854 6.58244 4.49129 6.59821C4.56605 6.69073 4.64591 6.77951 4.73063 6.86412C4.89997 7.03323 5.08599 7.18293 5.28519 7.31135C5.63982 7.53999 6.03617 7.70116 6.45434 7.78422C6.6627 7.82561 6.87349 7.84702 7.08393 7.84871C7.09321 7.84879 7.1025 7.84882 7.11178 7.84882C7.17731 7.84881 7.2428 7.84688 7.30816 7.84306C7.32034 7.84234 7.33252 7.84157 7.34469 7.84072Z"
                                  fill="white"/>
                        </svg>

                    </a>
				<?php endif; ?>

				<?php if ( Helper::is_chat_enabled() ): ?>
                    <a class="header-chat-icon rtcl-chat-unread-count" data-toggle="tooltip" title="<?php esc_attr_e( 'Chat', 'classima' ); ?>"
                       href="<?php echo esc_url( Link::get_my_account_page_link( 'chat' ) ); ?>">
                        <svg width="20" height="16" viewBox="0 0 20 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_1032_1954)">
                                <path d="M17.5112 10.3704C17.5112 10.7895 17.3447 11.1914 17.0483 11.4878C16.752 11.7842 16.35 11.9506 15.9309 11.9506H6.44943L3.28894 15.1111V2.46916C3.28894 2.05006 3.45543 1.64811 3.75178 1.35176C4.04814 1.05541 4.45008 0.888916 4.86919 0.888916H15.9309C16.35 0.888916 16.752 1.05541 17.0483 1.35176C17.3447 1.64811 17.5112 2.05006 17.5112 2.46916V10.3704Z"
                                      stroke="white" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>
                            </g>
                            <defs>
                                <clipPath id="clip0_1032_1954">
                                    <rect width="19.2" height="16" fill="white" transform="translate(0.400024)"/>
                                </clipPath>
                            </defs>
                        </svg>
                    </a>
				<?php endif; ?>

				<?php if ( RDTheme::$options['phone'] ): ?>
                    <div class="header-phone-area">
                        <span class="header-phone-icon">
                            <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M15.5156 13.7421L13.9942 15.2636C13.9525 15.3071 13.9163 15.3325 13.8637 15.3615C11.7149 16.5185 7.59149 14.3569 5.69659 12.3603C5.67662 12.3386 5.6603 12.3223 5.64037 12.3023C3.64388 10.4073 1.48241 6.28357 2.63931 4.13465C2.66832 4.08207 2.6937 4.04759 2.73723 4.00592L4.25858 2.48264C4.37101 2.37021 4.49613 2.31944 4.65206 2.31944H4.66475C4.82794 2.32126 4.95488 2.3793 5.06549 2.49897L7.02748 4.61706C7.2342 4.8383 7.22693 5.17921 7.01297 5.39322L5.74546 6.66081C5.38824 7.01987 5.23229 7.49316 5.30665 7.99368C5.46439 9.04726 5.99389 10.0374 6.92592 11.0185C6.94588 11.0384 6.96218 11.0565 6.98214 11.0747C7.96315 12.0068 8.9514 12.5363 10.0049 12.6941C10.5072 12.7684 10.9805 12.6125 11.3395 12.2534L12.6052 10.9876C12.8192 10.7737 13.1601 10.7664 13.3831 10.9713L15.501 12.9334C15.6207 13.044 15.6769 13.171 15.6806 13.3342C15.6842 13.4973 15.6316 13.6261 15.5156 13.7421ZM16.1792 12.2008L14.0613 10.2386C13.4448 9.66739 12.4946 9.68554 11.8998 10.2804L10.6323 11.5479C10.4999 11.6803 10.3385 11.7329 10.1536 11.7057C9.30862 11.5787 8.49807 11.1363 7.66938 10.3493C7.66211 10.3438 7.65669 10.3366 7.64942 10.3293C6.86425 9.50237 6.4218 8.68995 6.2949 7.84673C6.2677 7.66175 6.32028 7.50036 6.45267 7.36618L7.72018 6.1004C8.31495 5.50559 8.33309 4.55535 7.76007 3.93697L5.7999 1.81889C5.50434 1.50154 5.11811 1.32746 4.68471 1.32019C4.25134 1.31295 3.85965 1.46888 3.55141 1.77718L2.03003 3.29867C1.91941 3.40929 1.83418 3.52354 1.75985 3.66136C1.40627 4.316 1.26482 5.11572 1.33918 6.03331C1.40263 6.82577 1.62386 7.69258 1.99741 8.60657C2.67014 10.2568 3.77446 11.9106 4.95128 13.0277C4.96033 13.035 4.96579 13.0404 4.97302 13.0476C6.09003 14.2246 7.74192 15.3308 9.39203 16.0035C10.3077 16.3753 11.1727 16.5965 11.9651 16.6618C12.1229 16.6745 12.277 16.6799 12.4275 16.6799C13.1546 16.6799 13.7947 16.5331 14.3369 16.2411C14.4747 16.1667 14.5908 16.0815 14.7014 15.9709L16.2227 14.4476C16.5292 14.1412 16.6869 13.7495 16.6797 13.3161C16.6706 12.8808 16.4984 12.4963 16.1792 12.2008Z"
                                      fill="white"/>
                            </svg>
                        </span>
                        <span>
                            <?php _e( 'Helpline:', 'classima' ); ?>
                            <a href="tel:<?php echo esc_attr( RDTheme::$options['phone'] ); ?>"><?php echo esc_html( RDTheme::$options['phone'] ); ?></a>
                        </span>
                    </div>
				<?php endif; ?>

            </div>
        </div>
    </div>
</div>
<div class="header-bottom-part">
    <div class="container">
        <div class="row align-items-center">
            <div class="<?php echo esc_attr( $menu_class ); ?>">
                <div class="main-navigation-area">
					<?php if ( RDTheme::$options['header_btn_txt'] && RDTheme::$options['header_btn_url'] ): ?>
                        <div class="header-btn-area">
                            <a class="header-btn" href="<?php echo esc_url( RDTheme::$options['header_btn_url'] ); ?>">
                                <i class="fas fa-plus" aria-hidden="true"></i><?php echo esc_html( RDTheme::$options['header_btn_txt'] ); ?>
                            </a>
                        </div>
					<?php endif; ?>
                    <div id="main-navigation" class="main-navigation"><?php wp_nav_menu( $nav_menu_args ); ?></div>
                </div>
            </div>
        </div>
    </div>
</div>