<?php
/**
 * Template name: Reset Password Page
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiera
 * @since classiera 1.0
 */

if ( is_user_logged_in() ) { 

	global $redux_demo; 
	$profile = $redux_demo['profile'];
	wp_redirect( $profile ); exit;

}

global $resetSuccess;

if (!$user_ID) {

	if($_POST['submit'] == 'Reset') 

	{

		// First, make sure the email address is set
		if ( isset( $_POST['email'] ) && ! empty( $_POST['email'] ) ) {

		  	// Next, sanitize the data
		  	$email_addr = trim( strip_tags( stripslashes( $_POST['email'] ) ) );

		  	$user = get_user_by( 'email', $email_addr );
			$userEmail = $email_addr;
		  	$user_ID = $user->ID;
			$userName = $user->user_login;

		  	if( !empty($user_ID)) {

				$new_password = wp_generate_password( 12, false ); 

				if ( isset($new_password) ) {

					wp_set_password( $new_password, $user_ID );
					
					classieraResetPassword($new_password, $userName, $userEmail);					
					$message =  esc_html__( 'Check your email for new password. Check your inbox or spam/junk and get your password', 'classiera' );
					
					$resetSuccess = 1;
				}

		    } else {
		      	
				$message =  esc_html__( 'There is no user available for this email.', 'classiera' );

		    } // end if/else

		} else {			
			$message =  esc_html__( 'Email should not be empty.', 'classiera' );
		}

	}

}

get_header(); ?>
<?php 
	$page = get_page($post->ID);
	$current_page_id = $page->ID;
?>
<?php $page_custom_title = get_post_meta($current_page_id, 'page_custom_title', true); ?>
<?php global $redux_demo;
?>
<!-- page Heading -->
<?php $titleBg = $redux_demo['title-bg']['url']; ?>	
<section class="pageHeading" style="background:url(<?php echo $titleBg; ?>);">
    <div class="row">
    <h3><?php the_title(); ?></h3>
	<p><?php echo $page_custom_title; ?></p>
    </div>
</section><!-- End page Heading -->
<section id="advertisement" class="noBorder removePad">
	<div class="row">
		<div class="large-6 columns <?php if(is_rtl()){ echo "loginborder-left"; }else{ echo "loginborder-right";} ?>">
			<div class="row">
				<div class="large-8 large-centered columns">
					<div class="loginContent">
						<div class="loginLogo">
							<?php
							global $redux_demo;
							$logo = $redux_demo['logo']['url'];
							$register = $redux_demo['register'];
							if (!empty($logo)) { ?>
							<img src="<?php echo $logo; ?>" alt="Logo" />
							<?php } else { ?>
							<img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="Logo" />
							<?php } ?>
							<p><?php esc_html_e('Dont have an account?', 'classiera') ?> <a href="<?php echo $register; ?>"><?php esc_html_e('Create your account.', 'classiera') ?></a> <?php esc_html_e('It takes less than a minute', 'classiera') ?></p>
							<span class="loginSep"><?php esc_html_e('OR', 'classiera') ?></span>
						</div>
						<div class="loginSocial">
							<h4><?php esc_html_e('LOGIN VIA SOCIAL ACCOUNT', 'classiera') ?></h4>
							<?php
							/* Detect plugin. For use on Front End only.*/
							include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
							// check for plugin using plugin name
							if ( is_plugin_active( "nextend-facebook-connect/nextend-facebook-connect.php" ) ) {
								//plugin is activated
								?>
								<a class="loginSocialbtn fb" href="<?php echo get_site_url(); ?>/wp-login.php?loginFacebook=1" onclick="window.location = '<?php echo get_site_url(); ?>/wp-login.php?loginFacebook=1&redirect='+window.location.href; return false;"><i class="fa fa-facebook"></i><?php esc_html_e('Login via Facebook', 'classiera') ?></a>
							<?php } ?>
							<?php
							/* Detect plugin. For use on Front End only.*/
							include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
							// check for plugin using plugin name
							if ( is_plugin_active( "nextend-twitter-connect/nextend-twitter-connect.php" ) ) {
								//plugin is activated
								?>
								<a class="loginSocialbtn twitter" href="<?php echo get_site_url(); ?>/wp-login.php?loginTwitter=1" onclick="window.location = '<?php echo get_site_url(); ?>/wp-login.php?loginTwitter=1&redirect='+window.location.href; return false;"><i class="fa fa-twitter"></i><?php esc_html_e('Login via Twitter', 'classiera') ?></a>
							<?php }	?>
							<?php
							/* Detect plugin. For use on Front End only.*/
							include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
							// check for plugin using plugin name
							if ( is_plugin_active( "nextend-google-connect/nextend-google-connect.php" ) ) {
								//plugin is activated
								?>
								<a class="loginSocialbtn google" href="<?php echo get_site_url(); ?>/wp-login.php?loginGoogle=1" onclick="window.location = '<?php echo get_site_url(); ?>/wp-login.php?loginGoogle=1&redirect='+window.location.href; return false;"><i class="fa fa-google-plus"></i><?php esc_html_e('Login via Google', 'classiera') ?></a>
								<?php
							}
							?>
						</div>
					</div>
				</div>
			</div>
		</div><!-- End Social Login -->	
		<div class="large-6 columns">
			<div class="row">
				<div class="large-8 large-centered columns">
					<div class="loginContent">
						<div class="loginHead">
							<h4><?php esc_html_e('Reset Your Password', 'classiera') ?></h4>
						</div>
						<div class="loginSocial">
							<form class="form-item login-form" action="" id="myform" method="POST" enctype="multipart/form-data" data-abide>
							<?php if($_POST){?>
								<span>
								<?php echo $message; ?>
								</span>
							<?php } ?>
							<?php if($resetSuccess == 1) { 
							} else { ?>
								<div class="inner-addon left-addon name-field">
									<i class="icon fa fa-envelope"></i>
									<input type="email" id="email" Placeholder="<?php esc_html_e( 'Type You Email', 'classiera' ); ?>" name="email" class="text input-textarea half" value="" />
									<small class="error"><?php esc_html_e( 'Email is required', 'classiera' ); ?></small>
								</div><!-- End UserName Div -->								
								<div class="row">
									<div class="large-12 columns">
										<div class="inner-addon left-addon">
											<input type="hidden" id="submit" name="submit" value="Reset" />				
											<button class="button round btnfull form-submit" id="edit-submit" name="op" value="Reset" type="submit"><?php esc_html_e('Reset Password', 'classiera') ?></button>											
										</div>										
									</div>
								</div><!-- End LoginButton Div -->
							<?php } ?>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div><!-- End Custom Login Form -->
	</div>
</section>
<?php get_footer(); ?>