<?php
/**
 * Template name: Register Page
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Classiera
 * @since Classiera
 */

if ( is_user_logged_in() ) { 

	global $redux_demo; 
	$profile = $redux_demo['profile'];
	wp_redirect( $profile ); exit;

}

global $user_ID, $user_identity, $user_level, $registerSuccess;

$registerSuccess = "";
global $redux_demo;
$classieraEmailVerify = $redux_demo['registor-email-verify'];
$classieraSocialLogin = $redux_demo['classiera_social_login'];


if (!$user_ID) {

	if($_POST) 

	{
		$message =  esc_html__( 'Registration successful.', 'classiera' );

		$username = $wpdb->escape($_POST['username']);

		$email = $wpdb->escape($_POST['email']);

		$password = $wpdb->escape($_POST['pwd']);

		$confirm_password = $wpdb->escape($_POST['confirm']);
		
		$remember = $wpdb->escape($_POST['remember']);

		$registerSuccess = 1;


		if(!empty($remember)) {			
			
			if(empty($username)) {					
					$message =  esc_html__( 'User name should not be empty.', 'classiera' );
					$registerSuccess = 0;
			}

			

			if(isset($email)) {

				if (preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/", $email)){ 

					wp_update_user( array ('ID' => $user_ID, 'user_email' => $email) ) ;

				}

				else { 				 
				$message =  esc_html__( 'Please enter a valid email.', 'classiera' );
				}

				$registerSuccess = 0;

			}else{
				$registerSuccess = 0;
				$message =  esc_html__( 'Please enter a valid email.', 'classiera' );
			}
			/*If Admin Turn Of Email Verification then this code will work*/
			if($classieraEmailVerify != 1){
				if($password) {

					if (strlen($password) < 5 || strlen($password) > 15) {
						
						$message =  esc_html__( 'Password must be 5 to 15 characters in length.', 'classiera' );
						$registerSuccess = 0;
						
					}elseif(isset($password) && $password != $confirm_password) {
						
						$message =  esc_html__( 'Password Mismatch', 'classiera' );

						$registerSuccess = 0;

					}elseif ( isset($password) && !empty($password) ) {

						$update = wp_set_password( $password, $user_ID );						
						$message =  esc_html__( 'Registration successful', 'classiera' );
						$registerSuccess = 1;

					}

				}
			}else{/*If Admin Turn Of Email Verification then this code will work*/
				$password = wp_generate_password( $length=12, $special_chars=false );
			}
			

			
			$status = wp_create_user( $username, $password, $email );
			if ( is_wp_error($status) ) {
				$registerSuccess = 0;
				
				$message =  esc_html__( 'Username or E-mail already exists. Please try another one.', 'classiera' );
			}else{
				
				classieraUserNotification( $email, $password, $username );			
				global $redux_demo; 
				$newUsernotification = $redux_demo['newusernotification'];	
					if($newUsernotification == 1){
					classieraNewUserNotifiy($email, $username);	
					}

				$registerSuccess = 1;
			}
			
			/*If Turn OFF Email verification*/
			if($registerSuccess == 1 && $classieraEmailVerify != 1) {
				$login_data = array();
				$login_data['user_login'] = $username;
				$login_data['user_password'] = $password;
				$user_verify = wp_signon( $login_data, false );
				global $redux_demo; 
				$profile = $redux_demo['profile'];
				wp_redirect( $profile ); exit;

			}elseif($registerSuccess == 1) {					
				$message =  esc_html__( 'Check Your Inbox for User Name And Password', 'classiera' );
			}

		}else{			
			$message =  esc_html__( 'You Must Need to Agree With Terms And Condations.', 'classiera' );
			$registerSuccess = 0;
		}
	}

}

get_header(); ?>
<?php 
	$page = get_page($post->ID);
	$current_page_id = $page->ID;
?>
<?php $page_custom_title = get_post_meta($current_page_id, 'page_custom_title', true); ?>
<!-- page Heading -->
<?php $titleBg = $redux_demo['title-bg']['url']; ?>
<section class="pageHeading" style="background:url(<?php echo $titleBg; ?>);">
	<div class="row">
		<h3><?php the_title(); ?></h3>
		<p><?php echo $page_custom_title; ?></p>
	</div>
</section><!-- End page Heading -->
<?php 
global $redux_demo;
$regS = $redux_demo['registor-style'];
$termsandcondition = $redux_demo['termsandcondition'];
?>	
<section id="advertisement <?php if($regS == 2){echo "noBorder";} ?>">
<?php if(get_option('users_can_register')) { ?>
	<div class="<?php if($regS == 2){echo "full-row removeMargin";}else{ echo "row";} ?>">
		<div class="large-6 columns <?php if($regS == 2){echo "loginBg";} ?><?php if(is_rtl()){ echo "loginborder-left"; }else{ echo "loginborder-right";} ?>">
			<div class="row">
				<div class="<?php if($regS == 2){echo "large-7";}else{ echo "large-8";} ?> large-centered columns">
					<div class="loginContent <?php if($regS == 2){echo "loginContentV1";} ?>">
						<div class="loginLogo <?php if($regS == 2){echo "loginlogoV1";} ?>">
						<?php 
							global $redux_demo;
							$logo = $redux_demo['logo']['url'];
							$login = $redux_demo['login'];
							if (!empty($logo)) {								
						?>
							<img src="<?php echo $logo; ?>" alt="Logo" />
						<?php } else { ?>
							<img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="Logo" />
						<?php } ?>
							<p><?php esc_html_e('Already have account?', 'classiera') ?> <a href="<?php echo $login; ?>"><?php esc_html_e('Login Here.', 'classiera') ?></a> <?php esc_html_e('It takes less than a minute', 'classiera') ?></p>
							<?php if($classieraSocialLogin == 1){?>
							<span class="loginSep"><?php esc_html_e('OR', 'classiera') ?></span>
							<?php } ?>
						</div><!--End Logo Section -->
						<div class="loginSocial <?php if($regS == 2){echo "loginSocialV1";} ?>">
						<?php if($classieraSocialLogin == 1){?>
							<h4><?php esc_html_e( 'LOGIN VIA SOCIAL ACCOUNT', 'classiera' ); ?></h4>
							<?php 
								/*Detect plugin. For use on Front End only. */
								include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
								// check for plugin using plugin name
								if ( is_plugin_active( "nextend-facebook-connect/nextend-facebook-connect.php" ) ) {
									//plugin is activated
							?>
							<a class="loginSocialbtn fb" href="<?php echo get_site_url(); ?>/wp-login.php?loginFacebook=1" onclick="window.location = '<?php echo get_site_url(); ?>/wp-login.php?loginFacebook=1&redirect='+window.location.href; return false;"><i class="fa fa-facebook-f"></i><?php esc_html_e('Login with Facebook', 'classiera') ?></a>
								<?php }?>
							<?php 
								/*Detect plugin. For use on Front End only. */
								include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
								// check for plugin using plugin name
								if ( is_plugin_active( "nextend-twitter-connect/nextend-twitter-connect.php" ) ) {
									//plugin is activated
							?>	
							<a class="loginSocialbtn twitter" href="<?php echo get_site_url(); ?>/wp-login.php?loginTwitter=1" onclick="window.location = '<?php echo get_site_url(); ?>/wp-login.php?loginTwitter=1&redirect='+window.location.href; return false;"><i class="fa fa-twitter"></i><?php esc_html_e('Login with Twitter', 'classiera') ?></a>
								<?php } ?>
							<?php 
							/* Detect plugin. For use on Front End only. */
							include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
							// check for plugin using plugin name
							if ( is_plugin_active( "nextend-google-connect/nextend-google-connect.php" ) ) {
								//plugin is activated
							?>
							<a class="loginSocialbtn google" href="<?php echo get_site_url(); ?>/wp-login.php?loginGoogle=1" onclick="window.location = '<?php echo get_site_url(); ?>/wp-login.php?loginGoogle=1&redirect='+window.location.href; return false;"><i class="fa fa-google"></i><?php esc_html_e('Login with Google', 'classiera') ?></a>
							<?php } ?>
							<!--AccessPress Socil Login-->
							<?php
							include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
							if ( is_plugin_active( "accesspress-social-login-lite/accesspress-social-login-lite.php" )){
								echo do_shortcode('[apsl-login-lite]');
							}								
							?>
							<!--AccessPress Socil Login-->
						<?php }?>	
						</div><!--End loginSocial -->
					</div>					
				</div>
			</div>
		</div><!--End Social Register Section -->
		<div class="large-6 columns <?php if($regS == 1){echo "loginborder";} ?> ">
			<div class="row">
				<div class="large-8 large-centered columns">
					<div class="loginContent <?php if($regS == 2){echo "loginContentV1";} ?>">
						<div class="loginHead">
                            <h4><?php esc_html_e('REGISTER', 'classiera') ?></h4>
                        </div>
						<div class="loginSocial <?php if($regS == 2){echo "loginSocialV1";} ?>">						
							<form data-abide novalidate id="myform" action="" method="POST" enctype="multipart/form-data">
								<?php 
								/* Echo Results*/
								if($_POST) { 
									global $redux_demo;
									$login = $redux_demo['login'];
									echo "<div id='result' style='margin-bottom: 30px;'><div class='message'><h4>".$message." ";
									if($registerSuccess == 1) {
										$loginmessage =  esc_html__( 'Click here for Login', 'classiera' );
											echo "<a href='".$login."'>".$loginmessage."</a>.";
										}
									echo "</h4></div></div>";	
								}
								?>
								<?php if($registerSuccess == 1) { } else { ?>
								<div class="inner-addon left-addon name-field">
									<i class="icon fa fa-user"></i>
									<input id="contactName" pattern=".{4,}" required title="4 characters minimum" placeholder="<?php esc_html_e('User Name', 'classiera') ?>" type="text" name="username" class="text input-textarea half" value="" maxlength="30" required />
									<small class="error"><?php esc_html_e('Name is required and must be a string.', 'classiera') ?></small>
								</div><!--End Name Input Div -->
								<div class="inner-addon left-addon email-field">
									<i class="icon fa fa-envelope"></i>
									<input id="email" placeholder="<?php esc_html_e('Email Address', 'classiera') ?>" type="email" name="email" class="text input-textarea half" value=""  maxlength="50" required />
									<small class="error"><?php esc_html_e('Email is required ...', 'classiera') ?></small>
								</div><!--End Email Input Div -->
								<?php 
								/*Show options if Email Verification is Turn OFF*/
								if($classieraEmailVerify != 1){
								?>
								<div class="inner-addon left-addon password-field">
									<i class="icon fa fa-unlock-alt"></i>
									<input id="password" pattern=".{6,}" required title="6 characters minimum" placeholder="<?php esc_html_e('Password', 'classiera') ?>" type="password" name="pwd" class="text input-textarea half" maxlength="15"  value="" required />
									<small class="error"><?php esc_html_e('An password is required.', 'classiera') ?></small>
								</div><!--End password Input Div -->
								<div class="inner-addon left-addon password-confirmation-field">
									<i class="icon fa fa-unlock-alt"></i>									
									<input id="passwordr" placeholder="<?php esc_html_e('Retype Password', 'classiera') ?>" type="password" name="confirm" class="text input-textarea half" maxlength="15" value="" required pattern="[a-zA-Z]+" data-equalto="password" />
									<small class="error"><?php esc_html_e('The password did not match', 'classiera') ?></small>
								</div><!--End retype password Input Div -->
								<?php }
								/*Show options if Email Verification is Turn OFF*/
								?>
								<div class="checkbox">
									<input id="remember" type="checkbox" name="remember" value="forever" required>
									<label for="remember"><?php esc_html_e('By creating account you agree 
									to our', 'classiera') ?>&nbsp;<a class="termsA" href="<?php echo $termsandcondition; ?>" target="_blank"><?php esc_html_e('Terms And Conditions?', 'classiera') ?></a></label>
								</div><!--End Checkbox Div -->
								<div class="row">
									<div class="large-12 columns">
										<div class="inner-addon left-addon">
											<input type="hidden" name="submit" value="Register" id="submit" />
											<button class="button round btnfull form-submit" id="edit-submit" name="op" value="Publish Ad" type="submit"><?php esc_html_e('Register', 'classiera') ?></button>
										</div>
									</div>
								</div><!--End Registor Button Div -->
								<?php } ?>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div><!--End Custom Register Section -->
	</div>
<?php }else{
	?>
	<div data-alert class="alert-box warning round">
		<i class="fa fa-exclamation-triangle"></i>
		<span><?php esc_html_e( 'Registration is currently disabled. Please try again later.', 'classiera' ); ?></span>		  
	</div>	
	<?php 
} 
/* End Registration Option Check*/
?> 	
</section>

<?php get_footer(); ?>