<?php
/**
 * Template name: Locations
 *
 * This is the most generic template file in a WordPress theme and one of the
 * two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * For example, it puts together the home page when no home.php file exists.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Classiera
 * @since Classiera 1.0
 */

get_header(); 

	global $redux_demo, $maximRange; 
	$trns_skeywords = $redux_demo['trns_skeywords'];
	$locShownBy = $redux_demo['location-shown-by'];	
	$max_range = $redux_demo['max_range'];
	if(!empty($max_range)) {
		$maximRange = $max_range;
	} else {
		$maximRange = 1000;
	}
	$locationName = '';
	if(isset($_GET['location'])){
		$locationName = $_GET['location'];
	}
	$category_icon_code = "";
	$category_icon_color = "";
	$your_image_url = "";
	$catName ="";
	$caticoncolor="";
	$category_icon="";

?>
<?php $titleBg = $redux_demo['title-bg']['url']; ?>	
<section class="pageHeading removeMargin" style="background:url(<?php echo $titleBg; ?>);">
    <div class="row">
    <h3><?php echo $locationName; ?></h3>
    </div>
</section><!-- End page Heading -->

    <section id="big-map">
		<div class="mainSearch">
		<div id="classiera-main-map"></div>

		<script type="text/javascript">
		var mapDiv,
			map,
			infobox;
		jQuery(document).ready(function($) {

			mapDiv = $("#classiera-main-map");
			mapDiv.height(650).gmap3({
				map: {
					options: {
						"draggable": true
						,"mapTypeControl": true
						,"mapTypeId": google.maps.MapTypeId.ROADMAP
						,"scrollwheel": false
						,"panControl": true
						,"rotateControl": false
						,"scaleControl": true
						,"streetViewControl": true
						,"zoomControl": true
						<?php global $redux_demo; $map_style = $redux_demo['map-style']; if(!empty($map_style)) { ?>,"styles": <?php echo $map_style; ?> <?php } ?>
					}
				}
				,marker: {
					values: [

					<?php

						$wp_query= null;

						$wp_query = new WP_Query();

						$category_id = get_cat_ID($catName);
						global $redux_demo;
						$locShownBy = $redux_demo['location-shown-by'];
						$mapPost = array(
								'post_type'  => 'post',
								'posts_per_page' => -1,
								'paged' => $paged,
									'meta_query' => array(
										array(
											'key'     => $locShownBy,
											'value'   => $locationName,
										),
									),
								);

						//$wp_query->query('post_type=post&posts_per_page=-1&cat='.$category_id);
						$wp_query = new WP_Query($mapPost);
						while ($wp_query->have_posts()) : $wp_query->the_post(); 

						$post_latitude = get_post_meta($post->ID, 'post_latitude', true);
						$post_longitude = get_post_meta($post->ID, 'post_longitude', true);

						$theTitle = get_the_title(); 

						$post_price = get_post_meta($post->ID, 'post_price', true);


						$category = get_the_category();
						$tag = $category[0]->cat_ID;
						$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
						if (isset($tag_extra_fields[$tag])) {
								$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
								$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
								$your_image_url = $tag_extra_fields[$tag]['your_image_url'];
							}
						if (empty($category_icon_code) || empty($category_icon_color) || empty($your_image_url)) {

							$tag = $category[0]->category_parent;

							$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
							if (isset($tag_extra_fields[$tag])) {
								if (empty($category_icon_code)){
									$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
								}
								if (empty($category_icon_color)){
									$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
								}
								if (empty($your_image_url)){
									$your_image_url = $tag_extra_fields[$tag]['your_image_url'];
								}
							}

						}	
						if(!empty($category_icon_code)) {

							$category_icon = stripslashes($category_icon_code);

					     }
						

						if(!empty($your_image_url)) {

					    	$iconPath = $your_image_url;

					    } else {

					    	$iconPath = get_template_directory_uri() .'/images/icon-services.png';

					    }
						$postCatgory = get_the_category( $post->ID );
						if(!empty($post_latitude)) {?>

							 	{
							 		<?php require_once get_template_directory() . '/inc/BFI_Thumb.php'; ?>
									<?php $params = array( "width" => 370, "height" => 240, "crop" => true ); $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), "single-post-thumbnail" ); ?>

									latLng: [<?php echo $post_latitude; ?>,<?php echo $post_longitude; ?>],
									options: {
										icon: "<?php echo $iconPath; ?>",
										shadow: "<?php echo get_template_directory_uri() ?>/images/shadow.png",
									},
									data: '<section id="advertisement" class="removePad removeMargin"><div class="row"><div class="advContent"><div class="tabs-content removeMargin"><div class="large-12 medium-6 columns advItems end removeMargin"><div class="advItem"> <div class="advItem-img" id="AdvMapImg"><img src="<?php echo bfi_thumb( "$image[0]", $params ) ?>" /></div><span class="price"><?php echo $post_price; ?></span><a class="hover" href="<?php the_permalink(); ?>"></a><div class="info"><a href="<?php the_permalink(); ?>"><i class="<?php echo $category_icon_code; ?>" style="background-color:<?php echo $category_icon_color; ?>"></i><span class="title"><?php echo $theTitle; ?></span><span class="cat">category &nbsp;:&nbsp;<?php echo $postCatgory[0]->name; ?><span></a></div></div></div></div></div><div class="close"></div></div></section>'
								}
							,


					<?php } endwhile; ?>	

					<?php wp_reset_query(); ?>
						
					],
					options:{
						draggable: false
					},
					cluster:{
		          		radius: 20,
						// This style will be used for clusters with more than 0 markers
						0: {
							content: "<div class='cluster cluster-1'>CLUSTER_COUNT</div>",
							width: 62,
							height: 62
						},
						// This style will be used for clusters with more than 20 markers
						20: {
							content: "<div class='cluster cluster-2'>CLUSTER_COUNT</div>",
							width: 82,
							height: 82
						},
						// This style will be used for clusters with more than 50 markers
						50: {
							content: "<div class='cluster cluster-3'>CLUSTER_COUNT</div>",
							width: 102,
							height: 102
						},
						events: {
							click: function(cluster) {
								map.panTo(cluster.main.getPosition());
								map.setZoom(map.getZoom() + 2);
							}
						}
		          	},
					events: {
						click: function(marker, event, context){
							map.panTo(marker.getPosition());

							var ibOptions = {
							    pixelOffset: new google.maps.Size(-125, -88),
							    alignBottom: true
							};

							infobox.setOptions(ibOptions)

							infobox.setContent(context.data);
							infobox.open(map,marker);

							// if map is small
							var iWidth = 370;
							var iHeight = 370;
							if((mapDiv.width() / 2) < iWidth ){
								var offsetX = iWidth - (mapDiv.width() / 2);
								map.panBy(offsetX,0);
							}
							if((mapDiv.height() / 2) < iHeight ){
								var offsetY = -(iHeight - (mapDiv.height() / 2));
								map.panBy(0,offsetY);
							}

						}
					}
				}
				 		 	},"autofit");

			map = mapDiv.gmap3("get");
		    infobox = new InfoBox({
		    	pixelOffset: new google.maps.Size(-50, -65),
		    	closeBoxURL: '',
		    	enableEventPropagation: true
		    });
		    mapDiv.delegate('.infoBox .close','click',function () {
		    	infobox.close();
		    });

		    if (Modernizr.touch){
		    	map.setOptions({ draggable : false });
		        var draggableClass = 'inactive';
		        var draggableTitle = "Activate map";
		        var draggableButton = $('<div class="draggable-toggle-button '+draggableClass+'">'+draggableTitle+'</div>').appendTo(mapDiv);
		        draggableButton.click(function () {
		        	if($(this).hasClass('active')){
		        		$(this).removeClass('active').addClass('inactive').text("Activate map");
		        		map.setOptions({ draggable : false });
		        	} else {
		        		$(this).removeClass('inactive').addClass('active').text("Deactivate map");
		        		map.setOptions({ draggable : true });
		        	}
		        });
		    }

		jQuery( "#advance-search-slider" ).slider({
		      	range: "min",
		      	value: 500,
		      	min: 1,
		      	max: <?php echo $maximRange; ?>,
		      	slide: function( event, ui ) {
		       		jQuery( "#geo-radius" ).val( ui.value );
		       		jQuery( "#geo-radius-search" ).val( ui.value );

		       		jQuery( ".geo-location-switch" ).removeClass("off");
		      	 	jQuery( ".geo-location-switch" ).addClass("on");
		      	 	jQuery( "#geo-location" ).val("on");

		       		mapDiv.gmap3({
						getgeoloc:{
							callback : function(latLng){
								if (latLng){
									jQuery('#geo-search-lat').val(latLng.lat());
									jQuery('#geo-search-lng').val(latLng.lng());
								}
							}
						}
					});

		      	}
		    });
		    jQuery( "#geo-radius" ).val( jQuery( "#advance-search-slider" ).slider( "value" ) );
		    jQuery( "#geo-radius-search" ).val( jQuery( "#advance-search-slider" ).slider( "value" ) );

		    jQuery('.geo-location-button .fa').click(function()
			{
				
				if(jQuery('.geo-location-switch').hasClass('off'))
			    {
			        jQuery( ".geo-location-switch" ).removeClass("off");
				    jQuery( ".geo-location-switch" ).addClass("on");
				    jQuery( "#geo-location" ).val("on");

				    mapDiv.gmap3({
						getgeoloc:{
							callback : function(latLng){
								if (latLng){
									jQuery('#geo-search-lat').val(latLng.lat());
									jQuery('#geo-search-lng').val(latLng.lng());
								}
							}
						}
					});

			    } else {
			    	jQuery( ".geo-location-switch" ).removeClass("on");
				    jQuery( ".geo-location-switch" ).addClass("off");
				    jQuery( "#geo-location" ).val("off");
			    }
		           
		    });

		});
		</script>

		<?php 

			global $redux_demo; 
			

		?>
		<!--Search Section Start -->
		<div class="advanceSearch">
			<div class="advSearchBtn"><!--Search bar hide Show Button -->
				<div class="row">
					<a id="searchbtn" href="#">
						<i class="fa fa-search"></i>
						<span><?php esc_html_e( 'Advance Search', 'classiera' ); ?></span>
						<i class="fa fa-caret-down"></i>
					</a>
				</div>
			</div><!--END Search bar hide Show Button -->
			<div class="advSeachBar"><!--AdvSeachBar Start -->
				<div class="row"><!--row Start -->
					<form action="<?php echo home_url(); ?>" method="get" id="views-exposed-form-search-view-other-ads-page" accept-charset="UTF-8">
						<input placeholder="<?php esc_html_e( 'Enter keyword...', 'classiera' ); ?>" type="text" id="edit-search-api-views-fulltext" name="s" value="" size="30" maxlength="128" class="form-text">
						<!--<input type="hidden" id="hidden-keyword" name="s" value="all" size="30" maxlength="128" class="form-text">-->
						<!--Select Category-->
						<select id="edit-field-category" name="category_name" class="form-select">
							<option value="All" selected="selected"><?php esc_html_e( 'Category...', 'classiera' ); ?></option>
							<?php
							$args = array(
								'hierarchical' => '0',
								'hide_empty' => '0'
							);
							$categories = get_categories($args);
							foreach ($categories as $cat) {
								if ($cat->category_parent == 0) { 
									$catID = $cat->cat_ID;
									?>
									<option value="<?php echo $cat->slug; ?>"><?php echo $cat->cat_name; ?></option>
									<?php 
									$args2 = array(
										'hide_empty' => '0',
										'parent' => $catID
									);
									$categories = get_categories($args2);
									foreach ($categories as $cat) { ?>
									<option value="<?php echo $cat->slug; ?>">- <?php echo $cat->cat_name; ?></option>
									<?php } ?>
								<?php } else { ?>
								<?php }
							} ?>

						</select>
						<!--Select Category -->
						<!--Choose Location-->
						<select id="edit-ad-location" name="post_location" class="form-select">
							<option value="All" selected="selected"><?php esc_html_e( 'Location...', 'classiera' ); ?></option>
							<?php
							$args_location = array( 'posts_per_page' => -1 );
							$lastposts = get_posts( $args_location );
							$all_post_location = array();
							foreach( $lastposts as $post ) {
								//$all_post_location[] = get_post_meta( $post->ID, 'post_location', true );
								$all_post_location[] = get_post_meta( $post->ID, $locShownBy, true );
							}
							$directors = array_unique($all_post_location);
							foreach ($directors as $director) { ?>
								<option value="<?php echo $director; ?>"><?php echo $director; ?></option>
							<?php }?>
							<?php wp_reset_query(); ?>
						</select>
						<!--End Choose Location -->
						<!--Range Slider-->
						<div class="range" id="advance-search-slider"> 
							<div class="range-slider round" data-slider data-options="display_selector: #sliderOutput3;">
							  <span class="range-slider-handle" role="slider" aria-valuenow="50" aria-valuemin="1" aria-valuemax="1000">
								 <!--<span class="range-slider-out" id="sliderOutput3"></span>-->
								 <input type="text" class="range-slider-out" name="geo-radius" id="geo-radius" value="100" data-default-value="100" />
							  </span>
							  <span class="range-slider-active-segment"></span>
							</div>
						</div>
						
						<input type="text" name="geo-location" id="geo-location" value="off" data-default-value="off">
						<input type="text" name="geo-radius-search" id="geo-radius-search" value="500" data-default-value="500">
						<input type="text" name="geo-search-lat" id="geo-search-lat" value="0" data-default-value="0">
						<input type="text" name="geo-search-lng" id="geo-search-lng" value="0" data-default-value="0">
						<!--End Range Slider -->
						<button class="btn btn-primary form-submit submit" id="edit-submit-search-view" name="search" value="Search" type="submit">
                                <span><?php esc_html_e( 'Search Now', 'classiera' ); ?></span>
                                <i class="fa fa-search"></i>
                        </button>
					</form>
				</div><!--row END -->
			</div><!--AdvSeachBar END -->
		</div>
		<!--END Search Section -->

	
		</div>
	</section>
<?php 
	global $current_view_type;
	global $permalink_type;
	global $redux_demo;
	$ad_desc = $redux_demo['ad-desc'];
	$view = $redux_demo['home-ads-view'];
?>	
<!-- Advertisement Section Start -->
<section id="advertisement">
	<div class="row">
		<div class="advContent"> 
			<div class="tabs-content">
				<div class="content active" id="panel1">
				<?php 
					global $paged, $wp_query, $wp;
					$args = wp_parse_args($wp->matched_query);
					
					if ( !empty ( $args['paged'] ) && 0 == $paged ) {
						$wp_query->set('paged', $args['paged']);
						$paged = $args['paged'];
					}
					$cat_id = get_cat_ID(single_cat_title('', false));
					$temp = $wp_query;
					global $redux_demo;
					$locShownBy = $redux_demo['location-shown-by'];
					$wp_query= null;
					$wp_query = new WP_Query();
					$kulPost = array(
							'post_type'  => 'post',
							'posts_per_page' => 12,
							'paged' => $paged,
								'meta_query' => array(
									array(
										'key'     => $locShownBy,
										'value'   => $locationName,
									),
								),
							);
					$wp_query = new WP_Query($kulPost);
					$current = -1;
					$current2 = 0;
				?>
				<?php while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; ?>
					<div class="large-4 medium-6 columns advItems end">
						<div class="advItem"> 
							<?php 
								if ( has_post_thumbnail()) {
									$imageurl = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'classiera-grid');
									$thumb_id = get_post_thumbnail_id($post->id);
									$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);	
									?>
									<div class="advItem-img">
									<img src="<?php echo $imageurl[0]; ?>" alt="<?php if(empty($alt)){echo "Image";}else{ echo $alt; } ; ?>"/>
									</div>
									<?php
								}else{
									?>
									<div class="advItem-img">
										<img src="<?php echo get_template_directory_uri() . '/images/nothumb/nothumb370x300.png' ?>" alt="No Thumb"/>
									</div>
									<?php
								}
								/*Get Category Extra Fields For Price Icon Background */
								$category = get_the_category();
									if ($category[0]->category_parent == 0) {
										$tag = $category[0]->cat_ID;
										$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
										if (isset($tag_extra_fields[$tag])) {
											$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
											$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
										}
									}else{
										$tag = $category[0]->category_parent;
										$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
										if (isset($tag_extra_fields[$tag])) {
											$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
											$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
										}
									}
									if(!empty($category_icon_code)) {
										$category_icon = stripslashes($category_icon_code);
									}
									$category_icon_code = "";
								/*Get Category Extra Fields For Price Icon Background */
							$post_price = get_post_meta($post->ID, 'post_price', true);
							if(!empty($post_price)){
							?>
							<span class="price" style="background-color:<?php echo $category_icon_color; ?>"><?php echo $post_price; ?></span>
							<?php }?>
							<a class="hover" href="<?php the_permalink(); ?>"></a>
							<div class="info">
								<a href="<?php the_permalink(); ?>">
								<?php 
									$postCatgory = get_the_category( $post->ID );
									//echo $postCatgory['name'];
								?>
									<i class="<?php echo $category_icon; ?>" style="background-color:<?php echo $category_icon_color; ?>"></i>
									<span class="title"><?php $theTitle = get_the_title(); $theTitle = (strlen($theTitle) > 25) ? substr($theTitle,0,25).'...' : $theTitle; echo $theTitle; ?></span>
									<span class="cat"><?php esc_html_e( 'Category', 'classiera' ); ?> &nbsp;:&nbsp;<?php echo $postCatgory[0]->name; ?></span>
								</a>
							</div>
						</div>
					</div>
					<?php endwhile; ?>
				<!-- Begin classiera_pagination-->	
				<?php get_template_part('pagination'); ?>
				<!-- End classiera_pagination-->	
					<?php wp_reset_postdata(); ?>
				</div>				
				<!-- End Latest Ads -->				
			</div>
		</div>
	</div><!-- END Main Ads Section Row-->
	<div class="row">
		<div class="large-8 large-centered medium-10 medium-centered columns">
			<div class="locationAdv">
				<?php 
			$homeAd2 = '';
			$homeAdImg2 = $redux_demo['post_ad']['url']; 
			$homeAdImglink2 = $redux_demo['post_ad_url']; 
			$homeAdCode2 = $redux_demo['post_ad_code_html']; 
			
			if(!empty($homeAdCode2) || !empty($homeAdImg2)){
				if(!empty($homeAdCode2)){
						$homeAd2 = $homeAdCode2;
				}else{
						$homeAd2 = '<a href="'.$homeAdImglink2.'" target="_blank"><img alt="image" src="'.$homeAdImg2.'" /></a>';
				}
			}
			?>	
				<?php echo $homeAd2; ?>
			</div>
		</div>
	</div>
	<div class="janChuti"><?php comment_form(); ?></div>
</section>
<!-- END Advertisement Section-->
<?php get_footer(); ?>