<?php
/**
 * Template name: Favorite Posts
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiera
 * @since classiera 1.0
 */
if ( !is_user_logged_in() ) { 

	global $redux_demo; 
	$login = $redux_demo['login'];
	wp_redirect( $login ); exit;

}
get_header(); 
if(isset($_POST['unfavorite'])){
	$author_id = $_POST['author_id'];
	$post_id = $_POST['post_id'];
	echo classiera_authors_unfavorite($author_id, $post_id);	
}
global $current_user, $user_id;
global $redux_demo;
wp_get_current_user();
$user_info = get_userdata($user_ID);
$user_id = $current_user->ID; // You can set $user_id to any users, but this gets the current users ID.
$edit = $redux_demo['edit'];
$pagepermalink = get_permalink($post->ID);
$featured_ads_option = $redux_demo['featured-options-on'];
$profile = $redux_demo['profile'];
$all_adds = $redux_demo['all-ads'];
$allFavourite = $redux_demo['all-favourite'];
$newPostAds = $redux_demo['new_post'];
$caticoncolor="";
$category_icon_code ="";
$category_icon="";
$category_icon_color="";

?>
<?php 
	$page = get_page($post->ID);
	$current_page_id = $page->ID;
?>
<?php $page_custom_title = get_post_meta($current_page_id, 'page_custom_title', true); ?>
<!-- page Heading -->
<?php $titleBg = $redux_demo['title-bg']['url']; ?>	
<section class="pageHeading" style="background:url(<?php echo $titleBg; ?>);">
    <div class="row">
    <h3><?php the_title(); ?></h3>
	<p><?php echo $page_custom_title; ?></p>
    </div>
</section><!-- End page Heading -->
<section id="advertisement" class="noBorder">
	<div class="row">
		<div class="large-8 medium-12 columns">
			<section class="adSubmit boxPad">
				<div class="row">
					<div class="large-12 columns">
						<div class="adHeading">
							<i class="fa fa-heart"></i>
							<h4><?php esc_html_e("Favourites", 'classiera') ?></h4>
						</div>
					</div>
				</div><!-- End ROW -->
				<div class="row">
					<div class="large-12 columns">
						<div class="authorBio">
							<?php 
							global $paged, $wp_query, $wp;
							$args = wp_parse_args($wp->matched_query);
							if ( !empty ( $args['paged'] ) && 0 == $paged ) {
								$wp_query->set('paged', $args['paged']);
								$paged = $args['paged'];
							}
							$cat_id = get_cat_ID(single_cat_title('', false));
							$temp = $wp_query;
							$wp_query= null;
							$wp_query = new WP_Query();
							global $current_user;
							wp_get_current_user();
							$user_id = $current_user->ID;
							$myarray = classiera_authors_all_favorite($user_id);
							if(!empty($myarray)){
								$args = array(
							   'post_type' => 'post',
							   'post__in'      => $myarray
								);
								// The Query
								$wp_query = new WP_Query( $args );
								$current = -1;
								$current2 = 0;
								?>
								<?php while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; ?>
							<div class="userAds border">
								<div class="ad-image">
									<?php
									if ( has_post_thumbnail()) {
									   $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'large');
									   echo '<a target="_blank" class="ad-image" href="' .get_permalink($post->ID). '" title="' . the_title_attribute('echo=0') . '" >';
									   echo get_the_post_thumbnail($post->ID, 'thumbnail'); 
									   echo '</a>';
									 }else{
										 ?>
										 <a class="ad-image" href="<?php echo get_permalink($post->ID); ?>">
											<img src="<?php echo get_template_directory_uri() . '/images/nothumb/nothumb80.png' ?>" alt="No Thumb"/>
										</a> 
										 <?php
									 }
									?>
								</div><!-- End ad-image -->
								<div class="ad-description">
									<h5>
										<a target="_blank" class="my-ad-title" href="<?php the_permalink(); ?>"><?php $theTitle = get_the_title(); $theTitle = (strlen($theTitle) > 22) ? substr($theTitle,0,22).'...' : $theTitle; echo $theTitle; ?></a>
									</h5>
									<div class="ad-rating">
										<?php if(function_exists('the_ratings')) { ?>
										<?php the_ratings(); ?>
										<?php } ?>
									</div>
									<ul class="inline-list">
										<li><span><i class="fa fa-user"></i><?php //echo author_name(); ?></span></li>
										<?php $dateFormat = get_option( 'date_format' );?>
										<li><span><i class="fa fa-clock-o"></i><?php echo the_date($dateFormat); ?></span></li>
									</ul>
									<?php echo classiera_authors_favorite_remove($user_id, $post->ID);?>
								</div><!-- End ad-description -->
							</div><!-- End Favourites userAds -->
								<?php endwhile; ?>
								<?php wp_reset_query(); ?>								
							<?php }else{
								?>
								<p><?php esc_html_e("You do not have any favourite ad yet!", 'classiera') ?></p>
								<?php 
							}?>	
						</div><!-- End authorBio -->
					</div><!-- End large-12 columns -->
				</div><!-- End ROW -->
			</section><!-- End adSubmit boxPad-->
		</div><!-- End large-8 -->
		<!-- Start Sidebar -->
		<div class="large-4 medium-12 columns">
			<section class="sidebar">
				<div class="row">
					<div class="large-12 medium-6 columns medium-centered">
						<div class="widgetBox">
							<div class="widgetTitle">
								<i class="fa fa-user"></i>
								<h4><?php esc_html_e("ACCOUNT OVERVIEW", 'classiera') ?></h4>
							</div><!-- End widgetTitle -->
							<div class="widgetContent">
							<?php $profile = $redux_demo['profile']; ?>
							<?php require_once get_template_directory() . '/inc/BFI_Thumb.php'; ?>
								<div class="authorAccount">
									<div class="large-7 medium-8 large-centered medium-centered small-centered columns">
										<div class="widgetAuthorImg">
											<?php $author_avatar_url = get_user_meta($user_ID, "classify_author_avatar_url", true); 
											if(!empty($author_avatar_url)) {
												$params = array( 'width' => 120, 'height' => 120, 'crop' => true );
												echo "<img class='author-avatar' src='" . bfi_thumb( "$author_avatar_url", $params ) . "' alt='' />";
											}else{
												$avatar_url = classiera_get_avatar_url ( get_the_author_meta('user_email', $user_ID), $size = '150' );?>
												<img class="avatar" src="<?php echo $avatar_url; ?>" alt="" /><?php
											}
											?>
											<h5><?php echo $user_identity; ?></h5>
											<?php 
												$role = $current_user->roles;
												$classieraRole = $role[0];
											?>
											<p><?php classieraRoleTrns($classieraRole); ?> </p>
										</div><!-- End widgetAuthorImg -->
									</div><!-- End large-7 -->
									<ul class="authorList clearfix">
									<?php 
									global $redux_demo; 
									$allads = $redux_demo['all-ads']; 
									?>
										<li>
											<a href="<?php echo $profile; ?>">
												<i class="fa fa-user"></i>
												<?php esc_html_e("About Me", 'classiera') ?>												
											</a>
                                        </li>
										<li>
											<a href="<?php echo $allads; ?>">
												<i class="fa fa-briefcase"></i>
												<?php esc_html_e("My Ads", 'classiera') ?>
												<span><?php echo count_user_posts($user_ID);?></span>
											</a>
                                        </li>
										<li>										
											<a href="<?php echo $allFavourite; ?>">
												<i class="fa fa-heart"></i>
												<?php esc_html_e("Favourites", 'classiera') ?>
												<span>
													<?php 
													global $current_user;
													wp_get_current_user();
													$user_id = $current_user->ID;
													$myarray = classiera_authors_all_favorite($user_id);
													if(!empty($myarray)){
														$args = array(
														   'post_type' => 'post',
														   'post__in'      => $myarray
														);
													$wp_query = new WP_Query( $args );
													$current = -1;
													$current2 = 0;
													while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; 													
													endwhile;
													echo $current2;
													}else{
														echo "0";
													}
													?>
												</span>
											</a>
										</li>
										<li>
											<a href="<?php echo $edit; ?>">
												<i class="fa fa-gears"></i>
												<?php esc_html_e("Profile Settings", 'classiera') ?>
											</a>
										</li>
										<li>
											<a href="<?php echo wp_logout_url(get_option('siteurl')); ?>">
												<i class="fa fa-sign-out"></i>
												<?php esc_html_e("Logout", 'classiera') ?>
											</a>
										</li>
										<li>
											<a href="<?php echo $newPostAds; ?>" class="button"><?php esc_html_e("POST NEW AD", 'classiera') ?></a>
											
										</li>
									</ul><!-- End UL authorList -->
								</div><!-- End authorAccount -->
							</div><!-- End widgetContent -->
						</div><!-- End widgetBox -->
					</div><!-- End large-12 -->
					<?php get_sidebar('pages'); ?>
				</div><!-- End row -->
			</section><!-- End Section sidebar -->
		</div><!-- End large-4 medium-12 columns -->
		<!-- End Sidebar -->
	</div><!-- End ROW -->
</section><!-- End advertisement -->
<?php get_footer(); ?>