<?php

/**

 * Template name: Edit Post

 *

 * Learn more: http://codex.wordpress.org/Template_Hierarchy

 *

 * @package WordPress

 * @subpackage classiera

 * @since classiera 1.0

 */



if ( !is_user_logged_in() ) {
	wp_redirect( home_url() ); exit;
}
global $redux_demo;
$googleFieldsOn = $redux_demo['google-lat-long'];
$classieraLatitude = $redux_demo['contact-latitude'];
$classieraLongitude = $redux_demo['contact-longitude'];
$locationsByPlugin = $redux_demo['custom_location_by_plugin'];
$postCurrency = $redux_demo['classierapostcurrency'];
$postContent = '';
$caticoncolor="";
$category_icon_code ="";
$category_icon="";
$category_icon_color="";
global $current_user;
wp_get_current_user();
$userID = $current_user->ID;
$query = new WP_Query(array('post_type' => 'post', 'posts_per_page' =>'-1') );
if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post();

	if(isset($_GET['post'])) {	

		if($_GET['post'] == $post->ID)

		{
			$posts_id = $_GET['post'];
			$author = get_post_field( 'post_author', $posts_id );
			if(current_user_can('administrator') ){
				
			}else{
				if($author != $userID) {
					wp_redirect( home_url() ); exit;
				}
			}
			$current_post = $post->ID;
			$title = get_the_title();
			$content = get_the_content();
			$posttags = get_the_tags($current_post);
			if ($posttags) {
			  foreach($posttags as $tag) {
				$tags_list = $tag->name . ' '; 
			  }
			}

			$postcategory = get_the_category( $current_post );
			
			$category_id = $postcategory[0]->cat_ID;
			
			$post_category_type = get_post_meta($post->ID, 'post_category_type', true);

			$post_price = get_post_meta($post->ID, 'post_price', true);
			
			$post_old_price = get_post_meta($post->ID, 'post_old_price', true);
			$post_phone = get_post_meta($post->ID, 'post_phone', true);

			$post_location = get_post_meta($post->ID, 'post_location', true);
			
			$post_state = get_post_meta($post->ID, 'post_state', true);
			$post_city = get_post_meta($post->ID, 'post_city', true);

			$post_latitude = get_post_meta($post->ID, 'post_latitude', true);

			$post_longitude = get_post_meta($post->ID, 'post_longitude', true);

			$post_price_plan_id = get_post_meta($post->ID, 'post_price_plan_id', true);

			$post_address = get_post_meta($post->ID, 'post_address', true);

			$post_video = get_post_meta($post->ID, 'post_video', true);
			
			$featuredIMG = get_post_meta($post->ID, 'featured_img', true);
			
			$itemCondition = get_post_meta($post->ID, 'item-condition', true);



			$featured_post = "0";



			$post_price_plan_activation_date = get_post_meta($post->ID, 'post_price_plan_activation_date', true);

			$post_price_plan_expiration_date = get_post_meta($post->ID, 'post_price_plan_expiration_date', true);

			$todayDate = strtotime(date('d/m/Y H:i:s'));

			$expireDate = strtotime($post_price_plan_expiration_date);  



			if(!empty($post_price_plan_activation_date)) {

				if(($todayDate < $expireDate) or empty($post_price_plan_expiration_date)) {
					$featured_post = "1";
				}
			}
			if(empty($post_latitude)) {
				$post_latitude = 0;
			}
			
			if(empty($post_longitude)) {
				$post_longitude = 0;
				$mapZoom = 2;
			} else {
				$mapZoom = 16;
			}

			

			if ( has_post_thumbnail() ) {		

				$post_thumbnail = get_the_post_thumbnail($current_post, 'thumbnail');		

			} 

		}

	}



endwhile; endif;
wp_reset_query();

global $current_post;

$postTitleError = '';
$post_priceError = '';
$catError = '';
$featPlanMesage = '';

if(isset($_POST['submitted']) && isset($_POST['post_nonce_field']) && wp_verify_nonce($_POST['post_nonce_field'], 'post_nonce')) {

	if(trim($_POST['postTitle']) === '') {		
		$postTitleError =  esc_html__( 'Please select a title.', 'classiera' );
		$hasError = true;
	} else {
		$postTitle = trim($_POST['postTitle']);
	}

	if(trim($_POST['cat']) === '-1') {		
		$catError =  esc_html__( 'Please select a category.', 'classiera' );
		$hasError = true;
	} 
	
	
	if($hasError != true) {
		if(is_super_admin() ){
			$postStatus = 'publish';
		}elseif(!is_super_admin()){		

			if($redux_demo['post-options-edit-on'] == 1){
				$postStatus = 'private';
			}else{
				$postStatus = 'publish';
			}

		}
		
		$mCatID = $_POST['cat'];
		
		
		$post_information = array(
			'ID' => $current_post,
			'post_title' => esc_attr(strip_tags($_POST['postTitle'])),
			'post_content' => strip_tags($_POST['postContent'], '<h1><h2><h3><strong><b><ul><ol><li><i><a><blockquote><center><embed><iframe><pre><table><tbody><tr><td><video>'),

			'post-type' => 'post',
			'post_category' => array($mCatID),
	        'tags_input'    => explode(',', $_POST['post_tags']),
			'tax_input' => array(
			'location' => $_POST['post_location'],
			),
	        'comment_status' => 'open',
	        'ping_status' => 'open',
			'post_author' => $_POST['postAuthor'],
			'post_status' => $postStatus
		);

		

		

		$post_id = wp_insert_post($post_information);

		$googleLat = wp_kses($_POST['latitude'], $allowed);

		$googleLong = wp_kses($_POST['longitude'], $allowed);
		
		/*Check If Latitude is OFF */		
		if(empty($googleLat)){
			$latitude = $classieraLatitude;
		}else{
			$latitude = $googleLat;
		}
		/*Check If longitude is OFF */		
		if(empty($googleLong)){
			$longitude = $classieraLongitude;
		}else{
			$longitude = $googleLong;
		}

		$post_price_status = trim($_POST['post_price']);
		$old_price_status = trim($_POST['post_old_price']);
		
		$itemCondition = $_POST['item-condition'];


		global $redux_demo; 
		$free_listing_tag = $redux_demo['free_price_text'];

		if(empty($post_price_status)) {
			$post_price_content = $free_listing_tag;
		} else {
			$post_price_content = $post_price_status;
		}
		
		if(empty($old_price_status)) {
			$old_price_content = $free_listing_tag;
		} else {
			$old_price_content = $old_price_status;
		}

		$catID = $mCatID.'custom_field';		
		$custom_fields = $_POST[$catID];
		/*If We are using CSC Plugin*/
		if($locationsByPlugin == 1){
			/*Get Country Name*/
			if(isset($_POST['post_location'])){
				$postLo = $_POST['post_location'];
				$allCountry = get_posts( array( 'include' => $postLo, 'post_type' => 'countries', 'posts_per_page' => -1, 'suppress_filters' => 0, 'orderby'=>'post__in' ) );
				foreach( $allCountry as $country_post ){
					$postCounty = $country_post->post_title;
				}
			}			
			
		}else{
			$county = $_POST['post_location'];
			if(!empty($county)){
				$location = get_term_by('id', $county, 'location');
				if($location){
					$postCounty = $location->name;
				}
			}
		}
		$new_featured = $_POST['new_featured'];
		if(isset($new_featured) && !empty($new_featured)){
			update_post_meta($post_id, '_thumbnail_id', $new_featured);
		}
		$poststate = $_POST['post_state'];
		$postCity = $_POST['post_city'];
		$classiera_CF_Front_end = $_POST['classiera_CF_Front_end'];
		$classiera_sub_fields = $_POST['classiera_sub_fields'];
		/*If We are using CSC Plugin*/		

		update_post_meta($post_id, 'post_category_type', esc_attr( $_POST['post_category_type'] ) );

		update_post_meta($post_id, 'custom_field', $custom_fields);
		update_post_meta($post_id, 'classiera_CF_Front_end', $classiera_CF_Front_end);
		update_post_meta($post_id, 'classiera_sub_fields', $classiera_sub_fields);

		update_post_meta($post_id, 'post_price', $post_price_content, $allowed);
		
		update_post_meta($post_id, 'post_old_price', $old_price_content, $allowed);
		update_post_meta($post_id, 'post_phone', $_POST['post_phone'], $allowed);

		update_post_meta($post_id, 'post_location', wp_kses($postCounty, $allowed));
		
		update_post_meta($post_id, 'post_state', wp_kses($poststate, $allowed));
		update_post_meta($post_id, 'post_city', wp_kses($postCity, $allowed));

		update_post_meta($post_id, 'post_latitude', $latitude);

		update_post_meta($post_id, 'post_longitude', $longitude);

		update_post_meta($post_id, 'post_address', wp_kses($_POST['address'], $allowed));

		update_post_meta($post_id, 'post_video', $_POST['video'], $allowed);
		
		update_post_meta($post_id, 'featured_img', $_POST['featured-image'], $allowed);
		
		if(isset($_POST['item-condition'])){
			update_post_meta($post_id, 'item-condition', $itemCondition, $allowed);
		}


		$permalink = get_permalink( $post_id );


		if(trim($_POST['edit-feature-plan']) != '') {
			$featurePlanID = trim($_POST['edit-feature-plan']);
			global $wpdb;
			global $current_user;
		    wp_get_current_user();
		    $userID = $current_user->ID;
			$result = $wpdb->get_results( "SELECT * FROM wpcads_paypal WHERE main_id = $featurePlanID" );

			if ( $result ) {
				$featuredADS = 0;

				foreach ( $result as $info ) { 
					if($info->status != "in progress" && $info->status != "pending") {

						$featuredADS++;

						if(empty($info->ads)) {
							$availableADS = esc_html__( 'Unlimited', 'classiera' );
							$infoAds = esc_html__( 'Unlimited', 'classiera' );
						} else {
							$availableADS = $info->ads - $info->used;
							$infoAds = $info->ads;
						} 



						if(empty($info->days)) {
							$infoDays = esc_html__( 'Unlimited', 'classiera' );
						} else {
							$infoDays = $info->days;
						} 
						
						if($info->used != "Unlimited" && $infoAds != "Ulimited" && $info->used == $infoAds) {
							$featPlanMesage = esc_html__( 'Please select another plan.', 'classiera' );
						} else {

							global $wpdb;
							$newUsed = $info->used +1;
							$update_data = array('used' => $newUsed);
						    $where = array('main_id' => $featurePlanID);
						    $update_format = array('%s');
						    $wpdb->update('wpcads_paypal', $update_data, $where, $update_format);
						    update_post_meta($post_id, 'post_price_plan_id', $featurePlanID );

							$dateActivation = date('m/d/Y H:i:s');
							update_post_meta($post_id, 'post_price_plan_activation_date', $dateActivation );							

							$daysToExpire = $infoDays;
							$dateExpiration_Normal = date("m/d/Y H:i:s", strtotime("+ ".$daysToExpire." days"));
							update_post_meta($post_id, 'post_price_plan_expiration_date_normal', $dateExpiration_Normal );
							
							$dateExpiration = strtotime(date("m/d/Y H:i:s", strtotime("+ ".$daysToExpire." days")));
							update_post_meta($post_id, 'post_price_plan_expiration_date', $dateExpiration );

							update_post_meta($post_id, 'featured_post', "1" );

					    }

					}

				}

			}

		}

		if ( $_FILES ) {
			$files = $_FILES['upload_attachment'];
			foreach ($files['name'] as $key => $value) {
				if ($files['name'][$key]) {
					$file = array(
						'name'     => $files['name'][$key],
						'type'     => $files['type'][$key],
						'tmp_name' => $files['tmp_name'][$key],
						'error'    => $files['error'][$key],
						'size'     => $files['size'][$key]
					);		 

					$_FILES = array("upload_attachment" => $file);		 

					foreach ($_FILES as $file => $array) {
						$newupload = classiera_insert_attachment($file,$post_id);
					}

				}

			}

		}


		if (isset($_POST['att_remove'])) {
			foreach ($_POST['att_remove'] as $att_id){
				wp_delete_attachment($att_id);
			}
		}		

		wp_redirect( $permalink ); exit;

	}

} 


get_header();  ?>
<?php 
	global $redux_demo;
	$titleBg = $redux_demo['title-bg']['url']; 
?>
<?php 
	$page = get_page($post->ID);
	$current_page_id = $page->ID;
?>
<?php $page_custom_title = get_post_meta($current_page_id, 'page_custom_title', true); ?>	
<?php while ( have_posts() ) : the_post(); ?>

<section class="pageHeading" style="background:url(<?php echo $titleBg; ?>);"><!-- page Heading -->
	<div class="row">
		 <h3><?php the_title(); ?></h3>
		 <p><?php echo $page_custom_title; ?></p>
	</div>
</section><!-- End page Heading -->
<section id="advertisement">
	<div class="row">
		<div class="large-8 medium-12 columns">
			<!-- Ad submit -->
			<section class="adSubmit boxPad">
				<div class="adHeading">
					<i class="fa fa-pencil-square-o"></i>
					<h4><?php esc_html_e('EDIT YOUR AD', 'classiera') ?></h4>
				</div><!--adHeading -->
				<div class="authorForm">
					<form class="form-item" action="" id="primaryPostForm" method="POST" enctype="multipart/form-data">
						<?php if($postTitleError != '') { ?>
							<span class="error" style="color: #d20000; margin-bottom: 20px; font-size: 18px; font-weight: bold; float: left;"><?php echo $postTitleError; ?></span>
							<div class="clearfix"></div>
						<?php } ?>
						<?php if($catError != '') { ?>
							<span class="error" style="color: #d20000; margin-bottom: 20px; font-size: 18px; font-weight: bold; float: left;"><?php echo $catError; ?></span>
							<div class="clearfix"></div>
						<?php } ?>
						<h2 class="expireDate"><?php echo $expireDate; ?></h2>
						<div class="row">
							<div class="large-12 medium-12 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-text-height"></i>
									<?php 
										$post_id = $_GET['post'];
										$author = get_post_field ('post_author', $post_id);
									?>
									<input type="hidden" id="postAuthor"  name="postAuthor" value="<?php echo $author; ?>">
									<input type="text" id="postTitle" value="<?php echo $title; ?>" name="postTitle" placeholder="<?php esc_html_e('Ad Title Goes here |', 'classiera') ?>" size="60" maxlength="255" class="form-text required input-textarea half">
								</div>
							</div><!--large-12-->
							<div class="large-12 columns">
								<div class="inner-addon left-addon">
									<?php
									$settings = array(
										'wpautop' => true,
										'postContent' => 'content',
										'media_buttons' => false,
										'tinymce' => array(
										'theme_advanced_buttons1' => 'bold,italic,underline,blockquote,separator,strikethrough,bullist,numlist,justifyleft,justifycenter,justifyright,undo,redo,link,unlink,fullscreen',

										'theme_advanced_buttons2' => 'pastetext,pasteword,removeformat,|,charmap,|,outdent,indent,|,undo,redo',

										'theme_advanced_buttons3' => '',
										'theme_advanced_buttons4' => ''
										),

									'quicktags' => array(
										'buttons' => 'b,i,ul,ol,li,link,close'
										)
									);
									wp_editor( $content, 'postContent', $settings );
									?>
								</div>
							</div><!--End Editor large-12-->
							<div class="large-12 medium-12 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-tags"></i>									
									<?php
										echo "<input type='text' id='post_tags' placeholder='Tags' name='post_tags' value='";
										$posttags = get_the_tags($current_post);
										if ($posttags) {
										  foreach($posttags as $tag) {
											$tags_list = $tag->name . ', '; 
											echo $tags_list;
										  }
										}
										echo "' size='12' maxlength='110' class='required'>"; 
									 ?>
								</div>
							</div><!--End tags Div -->
							<div class="large-12 medium-12 columns">
								<div class="form-heading">
									<p><?php esc_html_e('Select Category Type', 'classiera') ?></p>
								</div>
							</div><!--End Category Header -->
							<div class="large-12 medium-12 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-bars"></i>
									<select id="cat" class="postform" name="cat">
									<option value="All" disabled><?php esc_html_e('Select Category..', 'classiera') ?></option>
									<?php 	
										$currCatID = $category_id;
										$args = array(
											'hierarchical' => '0',
											'hide_empty' => '0'
										);
										$categories = get_categories($args);
										foreach ($categories as $cat){
											if($cat->category_parent == 0){
												$catID = $cat->cat_ID;
												?>
												<option <?php if($currCatID == $catID){echo "selected";} ?> value="<?php echo $cat->cat_ID; ?>">
													<?php echo $cat->cat_name; ?>
												</option>
												<?php
												$args2 = array(
													'hide_empty' => '0',
													'parent' => $catID
												);
												$categories = get_categories($args2);
												foreach($categories as $cat){
													?>
													<option <?php if($currCatID == $cat->cat_ID){echo "selected";} ?> value="<?php echo $cat->cat_ID; ?>">- <?php echo $cat->cat_name; ?></option>
													<?php
												}
											}
										}
									?>
									</select>
								</div>
							</div><!--End Category DropDown -->	
							<?php 
								if (function_exists('classieraCustomFieldsEditPost')){
									echo classieraCustomFieldsEditPost($currCatID);							
								}
								if (function_exists('classiera_sub_Fields_Div')){
									echo classiera_sub_Fields_Div();
								}
							?>
						<?php $classieraPriceSecOFF = $redux_demo['classiera_sale_price_off'];?>
						<?php if($classieraPriceSecOFF == 1){?>
							<div class="large-12 medium-12 columns">
								<div class="form-heading">
									<p><?php esc_html_e('Price Setting', 'classiera') ?></p>
								</div>
							</div><!--End Price Heading -->
							<?php if (!empty($postCurrency)){?>
								<div class="large-12 medium-12 columns">
								<p style="margin-top:10px; margin-left:15px;"><?php esc_html_e('Currency sign is already set as', 'classiera') ?>&nbsp;<?php echo $postCurrency; ?>&nbsp;<?php esc_html_e('Please do not use currency sign in price field. Only use numbers ex: 12345', 'classiera') ?></p>
								</div>
							<?php }?>
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-money"></i>
									<input type="text" id="post_price" value="<?php echo $post_price; ?>" name="post_price" placeholder="<?php esc_html_e('Sale Price', 'classiera') ?>"  size="12" class="form-text input-textarea half">
								</div>
							</div><!--End Price -->
							<?php $saleprice= $redux_demo['regularpriceon']; ?>
							<?php if($saleprice == 1){?>
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-money"></i>
									<input type="text" id="post_old_price" value="<?php echo $post_old_price; ?>" name="post_old_price" placeholder="<?php esc_html_e('Regular Price', 'classiera') ?>"  size="12" class="form-text input-textarea half">
								</div>
							</div><!--End OLD Price -->
							<?php }?>
						<?php }?>
							<!--Phone-->
							<?php $phoneon= $redux_demo['phoneon']; ?>
							<?php if($phoneon == 1){?>
							<div class="large-12 medium-12 columns">
								<div class="form-heading">
									<p><?php esc_html_e('Contact Info', 'classiera') ?></p>
								</div>
							</div><!--End Phone -->
							<div class="large-6 medium-6 columns end">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-phone"></i>
									<input type="text" id="post_phone" value="<?php echo $post_phone; ?>" name="post_phone" placeholder="<?php esc_html_e('Phone Number', 'classiera') ?>"  size="12" class="form-text input-textarea half">
								</div>
								<p><?php esc_html_e('Put phone number if you want to display otherwise leave it blank.', 'classiera') ?></p>
							</div><!--End Phone -->
							<?php }?>
							<!--Phone-->							
							<?php 
							global $redux_demo;
							$adpostCondition= $redux_demo['adpost-condition'];
							if($adpostCondition == 1){
							?>
							<!--Select Item Condition-->
								<div class="large-12 medium-12 columns">
									<div class="form-heading">
										<p><?php esc_html_e('Select Item Condition', 'classiera') ?></p>
									</div>
								</div><!--End Item Type Heading -->
								<div class="large-12 medium-12 columns">
									<div class="radio removeMargin removePad">
										<input type="radio" id="brand-new" name="item-condition" value="<?php esc_html_e('new', 'classiera') ?>" <?php if($itemCondition == 'new'){echo "checked";}?>>
										<label class="item-type" for="brand-new">
											<?php esc_html_e('Brand New', 'classiera') ?>
										</label>
										<input type="radio" name="item-condition" id="used" value="<?php esc_html_e('used', 'classiera') ?>" <?php if($itemCondition == 'used'){echo "checked";}?>>
										<label class="item-type" for="used"><?php esc_html_e('Used', 'classiera') ?></label>
									</div>
								</div>
								<!--Select Item Condition-->
							<?php } ?>	
							<!--Custom Fields Start -->
					<div class="extraFields">	
								
								<?php 
								$args = array(
								  'hide_empty' => false,
								  'orderby' => 'count',
								  'order' => 'ASC'
								);
								$inum = 0;
								$categories = get_categories($args);
								foreach($categories as $category) {;
								
								$inum++;
								global $user_id;
								
								$user_name = $category->name;
								$user_id = $category->term_id;
								
								$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
								
								$wpcrown_category_custom_field_option = $tag_extra_fields[$user_id]['category_custom_fields'];
								$wpcrown_category_custom_field_type = $tag_extra_fields[$user_id]['category_custom_fields_type'];
								
								if(empty($wpcrown_category_custom_field_option)) {
									
									$catobject = get_category($user_id,false);
									$parentcat = $catobject->category_parent;
									
									$wpcrown_category_custom_field_option = $tag_extra_fields[$parentcat]['category_custom_fields'];
									$wpcrown_category_custom_field_type = $tag_extra_fields[$parentcat]['category_custom_fields_type'];
								}
							?>
							<div id="cat-<?php echo $user_id; ?>" class="wrap-content custom_fielder" <?php if($currCatID == $user_id) { ?>style="display: block;"<?php  } else { ?>style="display: none;"<?php } ?>>
							
								<?php $wpcrown_custom_fields = get_post_meta($current_post, 'custom_field', true);?>
								<?php if($wpcrown_category_custom_field_option){ ?>
									<div class="large-12 medium-12 columns">
										<div class="form-heading">
										<p><?php esc_html_e('Extra Fields For', 'classiera') ?>&nbsp;<?php echo $user_name;?></p>
										</div>
									</div>
								<?php } ?>
								
								<?php for ($i = 0; $i < (count($wpcrown_category_custom_field_option)); $i++) { 
									if($wpcrown_category_custom_field_type[$i][1] == 'text'){
								?>
								
								<div class="large-6 medium-6 columns end" id="cat-<?php echo $user_id; ?>">
									<div class="inner-addon left-addon">
										<i class="icon fa fa-pencil"></i>
										
										<input type="hidden" class="custom_field" id="custom_field[<?php echo $i; ?>][0]" name="<?php echo $user_id; ?>custom_field[<?php echo $i; ?>][0]" value="<?php echo $wpcrown_category_custom_field_option[$i][0] ?>" size="12">
										
										<input type="hidden" class="custom_field" id="custom_field[<?php echo $i; ?>][2]" name="<?php echo $user_id; ?>custom_field[<?php echo $i; ?>][2]" value="<?php echo $wpcrown_category_custom_field_type[$i][1] ?>" size="12">
										
										<input type="text" placeholder="<?php if (!empty($wpcrown_category_custom_field_option[$i][0])) echo $wpcrown_category_custom_field_option[$i][0]; ?>" class="custom_field custom_field_visible input-textarea" id="custom_field[<?php echo $i; ?>][1]" name="<?php echo $user_id; ?>custom_field[<?php echo $i; ?>][1]" value="<?php if($currCatID == $user_id) { echo $wpcrown_custom_fields[$i][1]; } ?>" size="12">
									</div>
								</div>
									<?php } ?>
								<?php } ?>
								<!--If text fields -->
								<!--If DropDown -->
								<?php 
								 for ($i = 0; $i < (count($wpcrown_category_custom_field_option)); $i++) {
									 if($wpcrown_category_custom_field_type[$i][1] == 'dropdown'){
								?>
									<div class="large-6 medium-6 columns end" id="cat-<?php echo $user_id; ?>">
										<div class="inner-addon left-addon">
											<i class="icon fa fa-caret-down"></i>
											<input type="hidden" class="custom_field" id="custom_field[<?php echo $i; ?>][0]" name="<?php echo $user_id; ?>custom_field[<?php echo $i; ?>][0]" value="<?php echo $wpcrown_category_custom_field_option[$i][0] ?>" size="12">
											<input type="hidden" class="custom_field" id="custom_field[<?php echo $i; ?>][2]" name="<?php echo $user_id; ?>custom_field[<?php echo $i; ?>][2]" value="<?php echo $wpcrown_category_custom_field_type[$i][1] ?>" size="12">
											<select class="optional_select" id="custom_field[<?php echo $i; ?>][1]" name="<?php echo $user_id; ?>custom_field[<?php echo $i; ?>][1]" >
												<?php
												echo '<option>'.$wpcrown_category_custom_field_option[$i][0].'</option>';
												$options = $wpcrown_category_custom_field_type[$i][2];
												$optionsarray = explode(',',$options);
												foreach($optionsarray as $option){
													if($wpcrown_custom_fields[$i][1] == $option){
														$selected = 'selected';
													}
													else{
														$selected = '';
													}
													echo '<option '.$selected.' value="'.$option.'">'.$option.'</option>';
												}
												?>
												
											</select>
										</div>
									</div>
									<?php } ?>
								<?php } ?>
								<!--If DropDown -->
								<!--If checkbox -->
								<?php 
								for ($i = 0; $i < (count($wpcrown_category_custom_field_option)); $i++) {
									if($wpcrown_category_custom_field_type[$i][1] == 'checkbox'){
										if($wpcrown_custom_fields[$i][1] == 'on'){
											$checked = 'checked';
										}else{
											$checked = '';
										}
								?>
								<div class="large-12 medium-12 columns end" id="cat-<?php echo $user_id; ?>">
									<div class="inner-addon left-addon">
										<p class="featurehide featurehide<?php echo $i; ?>"><?php esc_html_e('Select Features', 'classiera') ?></p>
										<input type="hidden" class="custom_field" id="custom_field[<?php echo $i; ?>][0]" name="<?php echo $user_id; ?>custom_field[<?php echo $i; ?>][0]" value="<?php echo $wpcrown_category_custom_field_option[$i][0] ?>" size="12">
										<input type="hidden" class="custom_field" id="custom_field[<?php echo $i; ?>][2]" name="<?php echo $user_id; ?>custom_field[<?php echo $i; ?>][2]" value="<?php echo $wpcrown_category_custom_field_type[$i][1] ?>" size="12">
										<div class="checkbox">
											<input type="checkbox" <?php echo $checked; ?> class="custom_field custom_field_visible input-textarea newcehckbox" id="<?php echo $user_id; ?>custom_field[<?php echo $i; ?>][1]" name="<?php echo $user_id; ?>custom_field[<?php echo $i; ?>][1]">
											<label for="<?php echo $user_id; ?>custom_field[<?php echo $i; ?>][1]" class="newcehcklabel"><?php echo $wpcrown_category_custom_field_option[$i][0]; ?></label>
										</div>
									</div>
								</div>
									<?php } ?>
								<?php } ?>
								<!--If checkbox -->
							</div>
							<?php } ?>
							
							<!--Custom Fields End -->
					</div>		
							<div class="large-12 medium-12 columns">
								<div class="form-heading">
									<p><?php esc_html_e('Address', 'classiera') ?></p>
								</div>
							</div><!--End Address Heading-->
							<!--Country States City by Plugin-->
								<?php 
								$locationsByPlugin = $redux_demo['custom_location_by_plugin'];
								if($locationsByPlugin == 1){
									$country_posts = get_posts( array( 'post_type' => 'countries', 'posts_per_page' => -1, 'suppress_filters' => 0 ) );
									if(!empty($country_posts)){
									?>
									<!--Select Location-->
									<div class="large-4 medium-4 columns">
										<div class="inner-addon left-addon chooseSelect">
											<i class="icon fa fa-map-marker"></i>
											<select name="post_location" id="post_location" data-placeholder="<?php esc_html_e('Select Country', 'classiera'); ?>" required>
											
												<option <?php if(empty($post_location)){ echo "selected"; }?> disabled value=""><?php esc_html_e('Select Country', 'classiera'); ?></option>
												
											<?php 
											foreach( $country_posts as $country_post ){
												?>
												<option <?php if($post_location == $country_post->post_title){ echo "selected"; }?> value="<?php echo $country_post->ID; ?>"><?php echo $country_post->post_title; ?></option>
												<?php
											}
											?>
											</select>
										</div>
									</div>
									<!--Select Location-->
									<!--Select States-->
									<div class="large-4 medium-4 columns">
										<div class="inner-addon left-addon chooseSelect">
											<i class="icon fa fa-map-marker"></i>
											<select name="post_state" id="post_state" class="selectState" required>
												<option><?php echo $post_state; ?></option>
											</select>
										</div>
									</div>
									<!--Select States-->
									<!--Select city-->
									<?php $locationsCityOn= $redux_demo['location_city_on']; ?>
										<?php if($locationsCityOn == 1){ ?>
									<div class="large-4 medium-4 columns">
										<div class="inner-addon left-addon chooseSelect">
											<i class="icon fa fa-map-marker"></i>
											<select name="post_city" id="post_city" class="selectCity" required>
												<option><?php echo $post_city; ?></option>
											</select>
										</div>
									</div>
										<?php } ?>
									<!--Select city-->
									<?php }
								}else{
									?>
									<!--Post Country without CSC-->
									<?php 
									$locationsCountryOn= $redux_demo['location_country_on'];
										if($locationsCountryOn == 1){
									?>
									<div class="large-4 medium-4 columns">
									<?php 
										$locations = get_terms( array(
											'taxonomy' => 'location',
											'hide_empty' => false,
											'order'=> 'DESC',
										) );
									?>
										<div class="inner-addon left-addon chooseSelect">
											<i class="icon fa fa-map-marker"></i>
											<select name="post_location" id="post_location" required>
											<option><?php echo $post_location; ?></option>
											<?php 
											foreach ($locations as $location) { 
											if(!empty($location)){
											?>
											<option value="<?php echo wp_kses_post($location->term_id); ?>">
										   <?php echo wp_kses_post($location->name); ?>
										   </option> 
											<?php }} ?> 
											</select>										
										</div>
									</div>
									<!--Post Country without CSC-->
									<!--Post States without CSC-->
									<?php 
										}
										$locationsStateOn= $redux_demo['location_states_on'];
										if($locationsStateOn == 1){
									?>
									<div class="large-4 medium-4 columns">
										<div class="inner-addon left-addon">
											<i class="icon fa fa-map-marker"></i>
											<input type="text" id="post_state" value="<?php echo $post_state; ?>" name="post_state" placeholder="<?php esc_html_e('State', 'classiera') ?>"  size="12" maxlength="110" class="form-text last required input-textarea half">
										</div>
									</div>
										<?php } ?>
									<!--Post States End without CSC-->
									<!--Post city start without CSC-->
									<?php 
										$locationsCityOn= $redux_demo['location_city_on'];
										if($locationsCityOn == 1){
									?>
									<div class="large-4 medium-4 columns">
										<div class="inner-addon left-addon">
											<i class="icon fa fa-map-marker"></i>
											<input type="text" id="post_city" value="<?php echo $post_city; ?>" name="post_city" placeholder="<?php esc_html_e('City', 'classiera') ?>"  size="12" maxlength="110" class="form-text last required input-textarea half">
										</div>
									</div>
										<?php } ?>
									<!--Post city end without CSC-->
									<?php
								}
								?>
							<div class="large-4 medium-4 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-map-marker"></i>
									<input id="address" name="address" type="text" value="<?php echo $post_address; ?>" placeholder="<?php esc_html_e('Address', 'classiera') ?>"  class="input-textarea half">
								</div>
							</div><!--End Address -->
							<?php 
								global $redux_demo;
								$currType = "";
								$googleFieldsOn = $redux_demo['google-lat-long'];
								if($googleFieldsOn == 1){
									$currType = 'text';
								}else{
									$currType = 'hidden';
								}								
							?>
							<div class="large-4 medium-4 columns">
								<div class="inner-addon left-addon">
								<?php if($googleFieldsOn == 1){?>
									<i class="icon fa fa-map-marker"></i>
								<?php } ?>	
									<input type="<?php echo $currType; ?>" id="latitude" value="<?php echo $post_latitude; ?>" name="latitude" placeholder="<?php esc_html_e('Latitude', 'classiera') ?>"  size="12" maxlength="10" class="form-text required input-textarea half">
								</div>
							</div><!--End Latitude -->
							<div class="large-4 medium-4 columns">
								<div class="inner-addon left-addon">
								<?php if($googleFieldsOn == 1){?>
									<i class="icon fa fa-map-marker"></i>
								<?php } ?>		
									<input type="<?php echo $currType; ?>" id="longitude" value="<?php echo $post_longitude; ?>" name="longitude" placeholder="<?php esc_html_e('Longitude', 'classiera') ?>"  size="12" maxlength="10" class="form-text last required input-textarea half">
								</div>
							</div><!--End Longitude -->
							<div class="clearfix"></div>
							<p class="help-block"><?php esc_html_e('Start typing an address  and select from the dropdown.', 'classiera') ?></p>
							<?php 
								global $redux_demo;
								$googleMapadPost = $redux_demo['google-map-adpost']; 
								if($googleMapadPost == 1){
								?>
							<!-- MAP Section Start-->
							<div class="large-12 medium-12 columns">
								<div class="inner-addon left-addon">
									<div id="map-canvas"></div>
									<script type="text/javascript">
									jQuery(document).ready(function($) {
									var geocoder;
									var map;
									var marker;
									var geocoder = new google.maps.Geocoder();
									function geocodePosition(pos) {
										geocoder.geocode({
										latLng: pos
									}, function(responses) {
									if (responses && responses.length > 0) {
									  updateMarkerAddress(responses[0].formatted_address);
									} else {
									  updateMarkerAddress('Cannot determine address at this location.');
									}

								  });

								}

								function updateMarkerPosition(latLng) {
								  jQuery('#latitude').val(latLng.lat());
								  jQuery('#longitude').val(latLng.lng());
								}



								function updateMarkerAddress(str) {
								  jQuery('#address').val(str);
								}



								function initialize() {
								  var latlng = new google.maps.LatLng(<?php echo $post_latitude; ?>, <?php echo $post_longitude; ?>);
								  var mapOptions = {
									zoom: <?php echo $mapZoom; ?>,
									center: latlng
								  }

								  map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);
								  geocoder = new google.maps.Geocoder();
								  marker = new google.maps.Marker({
									position: latlng,
									map: map,
									draggable: true
								  });
								  // Add dragging event listeners.
								  google.maps.event.addListener(marker, 'dragstart', function() {
									updateMarkerAddress('Dragging...');
								  });									  

								  google.maps.event.addListener(marker, 'drag', function() {
									updateMarkerPosition(marker.getPosition());
								  });									  

								  google.maps.event.addListener(marker, 'dragend', function() {
									geocodePosition(marker.getPosition());
								  });
								}



								google.maps.event.addDomListener(window, 'load', initialize);
								jQuery(document).ready(function() {							         

								  initialize();									          

								  jQuery(function() {
									jQuery("#address").autocomplete({
									  //This bit uses the geocoder to fetch address values
									  source: function(request, response) {
										geocoder.geocode( {'address': request.term }, function(results, status) {
										  response(jQuery.map(results, function(item) {
											return {
											  label:  item.formatted_address,
											  value: item.formatted_address,
											  latitude: item.geometry.location.lat(),
											  longitude: item.geometry.location.lng()
											}

										  }));

										})

									  },

									  //This bit is executed upon selection of an address

									  select: function(event, ui) {
										jQuery("#latitude").val(ui.item.latitude);
										jQuery("#longitude").val(ui.item.longitude);
										var location = new google.maps.LatLng(ui.item.latitude, ui.item.longitude);
										marker.setPosition(location);
										map.setZoom(16);
										map.setCenter(location);
									  }

									});

								  });

								  

								  //Add listener to marker for reverse geocoding
								  google.maps.event.addListener(marker, 'drag', function() {
									geocoder.geocode({'latLng': marker.getPosition()}, function(results, status) {
									  if (status == google.maps.GeocoderStatus.OK) {
										if (results[0]) {
										  jQuery('#address').val(results[0].formatted_address);
										  jQuery('#latitude').val(marker.getPosition().lat());
										  jQuery('#longitude').val(marker.getPosition().lng());
										}

									  }
									});
								  });							  

								});
							});
									</script>
								</div>
							</div>
							<!-- MAP Section End-->
							<?php } ?>
							<div class="large-12 medium-12 columns">
								<div class="form-heading">
									<p><?php esc_html_e('Image And Video', 'classiera') ?></p>
								</div>
							</div><!-- Image Heading End-->
							<div class="large-12 medium-12 columns">
							<?php require_once get_template_directory() . '/inc/BFI_Thumb.php'; ?>
							<?php
							$params = array( 'width' => 110, 'height' => 70, 'crop' => true );
							$attachments = get_children(array('post_parent' => $current_post,
											'post_status' => 'inherit',
											'post_type' => 'attachment',
											'post_mime_type' => 'image',
											'order' => 'ASC',
											'orderby' => 'menu_order ID'));
							foreach($attachments as $att_id => $attachment) {
									$attachment_ID = $attachment->ID;
									$full_img_url = wp_get_attachment_url($attachment->ID);
									$split_pos = strpos($full_img_url, 'wp-content');
									$split_len = (strlen($full_img_url) - $split_pos);
									$abs_img_url = substr($full_img_url, $split_pos, $split_len);
									$full_info = @getimagesize(ABSPATH.$abs_img_url);
							?>
								<div id="<?php echo $attachment_ID; ?>" class="edit-post-image-block clickFeature">
									<img class="edit-post-image" src="<?php echo bfi_thumb( "$full_img_url", $params ) ?>" />
									<div class="remove-edit-post-image">
										<i class="fa fa-minus-square-o"></i>
										<span class="remImage"><?php esc_html_e('Remove', 'classiera');?></span>
										<input type="hidden" name="" value="<?php echo $attachment_ID; ?>">
									</div><!--remove-edit-post-image-->
								</div>
							<?php }?>
								<div class="inputBtnSection inner-addon left-addon">	
									<!--<input id="upload-images-ad" type="file" name="upload_attachment[]" multiple />-->
									<input name="upload_attachment[]" type="file"  id="upload-images-ads" class="multi with-preview" />
									<input name="featured-image" id="fIMGcount" type="hidden" value="<?php echo $featuredIMG; ?>" />
									<input name="new_featured" id="new_featured" type="hidden" value="" />
									<script>
										// wait for document to load
										jQuery(function(){

											// invoke plugin
											jQuery('#upload-images-ads').MultiFile({
												onFileChange: function(){
													console.log('TEST CHANGE:', this, arguments);
												}
											});

										});
									</script>
								</div>
							</div><!-- Image Upload End-->
							<?php 
							global $redux_demo;
							$classiera_video_postads = $redux_demo['classiera_video_postads'];
							if($classiera_video_postads == 1){
							?>
							<div class="large-12 medium-12 columns">
								<div class="inner-addon left-addon">
									<textarea name="video" id="video" cols="8" rows="5" placeholder="<?php esc_html_e('Put here iframe or video url.', 'classiera') ?>" ><?php echo $post_video; ?></textarea>
									<label><?php esc_html_e('Add video embedding code here (youtube, vimeo, etc)', 'classiera') ?></label>
								</div>
							</div><!-- Video Upload End-->
							<?php } ?>
							<div class="large-12 medium-12 columns">
								<div class="form-heading">
									<p><?php esc_html_e('Select Ads Type', 'classiera') ?></p>
								</div>
							</div><!-- End Package Heading-->
							<?php
							/*Get Current Ad Type*/
							$featured_post = "0";
							$post_price_plan_activation_date = get_post_meta($current_post, 'post_price_plan_activation_date', true);
							$post_price_plan_expiration_date = get_post_meta($current_post, 'post_price_plan_expiration_date', true);
							$post_price_plan_expiration_date_noarmal = get_post_meta($current_post, 'post_price_plan_expiration_date_normal', true);
							$todayDate = strtotime(date('m/d/Y h:i:s'));
							$expireDate = $post_price_plan_expiration_date;
							if(!empty($post_price_plan_activation_date)) {
								if(($todayDate < $expireDate) or $post_price_plan_expiration_date == 0) {
									$featured_post = "1";
								}
							}
							/*Get Current Ad Type*/
							?>
							<?php if($featured_post == "1") { ?>
								<div class="large-12 medium-12 columns">
									<div class="radio">
										<input style="margin-right: 10px;margin-top: -2px;" type="radio" id="feature-post" name="feature-post" value="featured" class="form-checkbox" checked><?php esc_html_e('Featured. Expires:', 'classiera') ?> <?php if($post_price_plan_expiration_date_noarmal == 0) { ?> <?php esc_html_e( 'Never', 'classiera' ); ?> <?php } else { echo $post_price_plan_expiration_date_noarmal; } ?>
									</div>
								</div>
							<?php }else{ ?>
							<div class="large-12 medium-12 columns">
								<div class="radio">
							<?php 
							global $redux_demo;
							$featured_ads_option = $redux_demo['featured-options-on'];
							$regular_ads = $redux_demo['regular-ads'];
							global $current_user;
							wp_get_current_user();
							$userID = $current_user->ID;
							$result = $wpdb->get_results( "SELECT * FROM wpcads_paypal WHERE user_id = $userID ORDER BY main_id DESC" );
							$planCount = 1;
							if ( $result ) {
								$featuredADS = 0;
								foreach ( $result as $info ) { 
									if($info->status != "in progress" && $info->status != "pending" && $info->status != "failed") {
										$featuredADS++;
										if(empty($info->ads)) {
											$availableADS = esc_html__( 'Unlimited', 'classiera' );
											$infoAds = esc_html__( 'Unlimited', 'classiera' );
										}else{
											$availableADS = $info->ads - $info->used;
											$infoAds = $info->ads;
										}
										if(empty($info->days)) {
											$infoDays = esc_html__( 'Unlimited', 'classiera' );
										}else{
											$infoDays = $info->days;
										}
										if($info->used != "Unlimited" && $infoAds != "Unlimited" && $info->used == $infoAds) {
											
										}else{
											?>
											<p>
												<input type="radio" id="edit-feature-plan<?php echo $planCount;?>" name="edit-feature-plan" value="<?php echo $info->main_id; ?>" class="" <?php if($regular_ads == 0 ){ echo 'checked';} ?> >
												<label class="" for="edit-feature-plan<?php echo $planCount;?>"><?php echo $infoAds; ?> <?php if($infoAds>1) { ?><?php esc_html_e('Ads', 'classiera') ?><?php } elseif($infoAds=="Unlimited") { ?><?php esc_html_e('Ads', 'classiera') ?><?php } elseif($infoAds==1) { ?><?php esc_html_e('Ad', 'classiera') ?><?php } ?> <?php esc_html_e('Active for', 'classiera') ?> <?php echo $infoDays ?> <?php esc_html_e('Days', 'classiera') ?> (<?php echo $availableADS; ?> <?php if($availableADS>1) { ?><?php esc_html_e('Ads', 'classiera') ?><?php } elseif($availableADS=="Unlimited") { ?><?php esc_html_e('Ads', 'classiera') ?><?php } elseif($availableADS==1) { ?><?php esc_html_e('Ad', 'classiera') ?><?php } ?> <?php esc_html_e('available', 'classiera') ?>)</label>
											</p>
											<?php
										}
										
									}
									$planCount++;
								}
							}
							?>
							<?php if($regular_ads == 1 ){ ?>  
									<p>
										<input type="radio" id="edit-regular-plan" name="edit-feature-plan" value="" class="" <?php if($featured_post == "0") { ?>checked<?php } ?>>
										<label class="" for="edit-regular-plan"><?php esc_html_e('Regular', 'classiera') ?></label>
										<input type="hidden" name="regular-ads-enable" value=""  >
									</p>
							<?php } ?>
								</div><!-- End radio-->
							</div><!-- End Package Large-12-->
							<?php 
								$featured_plans = $redux_demo['featured_plans'];
								if(!empty($featured_plans)){
									if($featuredADS == "0" || empty($result)){
										?>
										<p><?php esc_html_e('Currently you have no active plan for featured ads. You must purchase a', 'classiera') ?> <a href="<?php echo $featured_plans; ?>" target="_blank"><?php esc_html_e('Featured Pricing Plan', 'classiera') ?></a> <?php esc_html_e('to be able to publish a Featured Ad.', 'classiera') ?></p>
										<?php
									}
								}
							}/*featured_post */	
							?>
							<div class="large-12 medium-12 columns">
								<?php wp_nonce_field('post_nonce', 'post_nonce_field'); ?>
								<input type="hidden" name="submitted" id="submitted" value="true" />
								<button class="btn button form-submit full-btn" id="edit-submit" name="op" value="Publish Ad" type="submit"><?php esc_html_e('Update Ad', 'classiera') ?></button>
							</div>
						</div><!--End authorForm Main Row-->
					</form>
				</div><!--authorForm -->
			</section>
		</div><!-- End large-8 -->
		<!-- Sidebar Start -->
		<div class="large-4 medium-12 columns">
			<aside class="sidebar">
				<div class="row">					
				<?php get_sidebar('pages'); ?>
				</div>
			</aside>
		</div>
		<!-- Sidebar END -->
	</div><!-- End section Row -->
</section><!-- End section advertisement -->
<?php endwhile; ?>
<script>
jQuery(document).ready(function(){
	jQuery('#post_location').on('change', function(e) {
		jQuery(".chosen-select").val('').trigger("chosen:updated");
		var data = {
			'action': 'get_states_of_country',
			'CID': jQuery(this).val()
		};

		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
		jQuery.post(ajaxurl, data, function(response) {
			if(jQuery("#post_state").length>0)
			{
				jQuery("#post_state").html(response);
				
			}
		});
    });
	jQuery('#post_state').on('change', function(e) {
		jQuery(".chosen-select").val('').trigger("chosen:updated");
		var data = {
			'action': 'get_city_of_states',
			'ID': jQuery(this).val()
		};

		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
		jQuery.post(ajaxurl, data, function(response) {
			if(jQuery("#post_city").length>0)
			{
				jQuery("#post_city").html(response);				
			}
		});
    });
	
	jQuery('#post').validate();
	jQuery("#post_location").chosen();	
});
</script>
<?php get_footer(); ?>