<?php
/**
 * Template name: Coming Soon
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Classiera
 * @since Classiera
 */

?>
<!doctype html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
<title><?php wp_title( '|', true, 'right' ); ?></title>

<?php  wp_head(); ?>
</head>
<body>
<?php 
global $redux_demo; 
$comingBG = $redux_demo['coming-soon-bg']['url'];
$cominglogo = $redux_demo['coming-soon-logo']['url'];
$comingtxt = $redux_demo['coming-soon-txt'];
$facebook_link = $redux_demo['facebook-link'];
$twitter_link = $redux_demo['twitter-link'];
$google_plus_link = $redux_demo['google-plus-link'];
$instagram_link = $redux_demo['instagram-link'];
$trnsDays = $redux_demo['coming-trns-days'];
$trnsHours = $redux_demo['coming-trns-hours'];
$trnsMin = $redux_demo['coming-trns-minutes'];
$trnsSec = $redux_demo['coming-trns-seconds'];

$comingMonth = $redux_demo['coming-month'];
$comingDays = $redux_demo['coming-days'];
$comingYear = $redux_demo['coming-year'];
$copyRight = $redux_demo['coming-copyright'];
?>
    <div id="bg">
        <img src="<?php echo $comingBG; ?>" alt="comingSoon">
    </div>
    <section id="comingSoon">
        <div class="row">
            <div class="large-8 large-centered columns">
                <div class="comingSoon-content">
                    <div class="logo">
                        <img src="<?php echo $cominglogo; ?>" alt="logo">
                    </div>
                    <div class="text">
                        <h3><?php echo $comingtxt; ?></h3>
                    </div>
                    <ul id="countdown" class="inline-list">
                        <li>
                            <span class="days">00</span>
                            <p class="countText"><?php echo $trnsDays; ?></p>
                        </li>
                        <li>
                            <span class="hours">00</span>
                            <p class="countText"><?php echo $trnsHours; ?></p>
                        </li>
                        <li>
                            <span class="minutes">00</span>
                            <p class="countText"><?php echo $trnsMin; ?></p>
                        </li>
                        <li>
                            <span class="seconds">00</span>
                            <p class="countText"><?php echo $trnsSec; ?></p>
                        </li>
                    </ul>                    
                    <div class="icons">
                        <a href="<?php echo $facebook_link; ?>"><i class="fa fa-facebook-f"></i></a>
                        <a href="<?php echo $twitter_link; ?>"><i class="fa fa-twitter"></i></a>
                        <a href="<?php echo $google_plus_link; ?>"><i class="fa fa-google-plus"></i></a>
                        <a href="<?php echo $instagram_link; ?>"><i class="fa fa-instagram"></i></a>                        
                    </div>
                    <div class="text">
                        <p><?php echo $copyRight; ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
   <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/countdown.js"></script>
   <script type="text/javascript">
        jQuery(document).ready(function(){
            //countdown
            jQuery("#countdown").countdown({
                date: "<?php echo $comingDays; ?> <?php echo $comingMonth; ?> <?php echo $comingYear; ?> 1:50:30", // add the countdown's end date (i.e. 3 november 2012 12:00:00)
                format: "on" // on (03:07:52) | off (3:7:52) - two_digits set to ON maintains layout consistency
            },
            
            function() { 
                
                // the code here will run when the countdown ends
                alert("done!") 

            });
        });
    </script>
</body>
</html>