<?php
/**
 * The template for displaying archives of any blog taxonomy
 *
 * @package WordPress
 * @subpackage classify-child
 * @since classify 1.0
 */

get_header();
$titleBg = $redux_demo['title-bg']['url'];
 ?>
<section class="pageHeading" style="background:url(<?php echo $titleBg; ?>);">
	<div class="row">
		<h3><?php $tax_term = $wp_query->get_queried_object(); echo $tax_term->name; ?> <?php esc_html_e( 'Archive', 'classiera' ); ?></h3>		
	</div>
</section><!-- End page Heading --> 
<section id="advertisement noBorder">
	<div class="row">
		<div class="large-8 medium-12 columns">
			<?php if ( have_posts() ): ?>
			<?php while ( have_posts() ) : the_post(); ?>
			<?php get_template_part( 'content', 'blog-loop' ); ?>
			<?php endwhile; ?>
			<div class="row">
				<div class="large-12 columns">
					<div class="pagination-nav">
						<?php //pagination
                        $big = 999999999; // need an unlikely integer		
                        echo paginate_links( array(
                                'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
                                'format' => '?paged=%#%',
                                'current' => max( 1, get_query_var('paged') ),
                                'total' => $blog_query->max_num_pages
                            ) );
                        ?>
               		</div>
				</div>
			</div><!--rowforpagenumber-->
			<?php else :
					echo "Sorry, Nothing found";
				endif; ?>
			<!--Ads area -->	
			<div class="row">
				<div class="large-12 columns">
					<div class="blog-ads">
						<?php 
						$homeAd2 = '';
						$homeAdImg2 = $redux_demo['post_ad']['url']; 
						$homeAdImglink2 = $redux_demo['post_ad_url']; 
						$homeAdCode2 = $redux_demo['post_ad_code_client']; 
						$homeAdCodeslot2 = $redux_demo['post_ad_code_slot']; 
						$homeAdCodewidth2 = $redux_demo['post_ad_code_width']; 
						$homeAdCodeheight2 = $redux_demo['post_ad_code_height']; 
						if(!empty($homeAdCode2) || !empty($homeAdImg2)){
							if(!empty($homeAdCode2)){
									$homeAd2 = '<ins class="adsbygoogle"
											 style="display:inline-block;width:'.$homeAdCodewidth2.'px;height:'.$homeAdCodeheight2.'px"
											 data-ad-client="'.$homeAdCode2.'"
											 data-ad-slot="'.$homeAdCodeslot2.'"></ins>';
							}else{
									$homeAd2 = '<a href="'.$homeAdImglink2.'" target="_blank"><img alt="image" src="'.$homeAdImg2.'" /></a>';
							}
						}
						?>	
						<?php echo $homeAd2; ?>
					</div>
				</div>
			</div>	
			<!--Ads area -->
		</div><!--large-8-->
		<div class="large-4 medium-12 columns">
			<aside class="sidebar blog-sidebar">
				<div class="row">
					<?php get_sidebar('blog'); ?>					
				</div>
			</aside>
		</div><!-- large-4 medium-12 columns -->
	<div><!--row-->
</section><!--mainsection-->
<?php get_footer(); ?>