<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * e.g., it puts together the home page when no home.php file exists.
 *
 * Learn more: {@link https://codex.wordpress.org/Template_Hierarchy}
 *
 * @package WordPress
 * @subpackage classiera
 * @since classiera
 */

get_header(); ?>
<section id="advertisement noBorder">
	<div class="row">
		<div class="large-8 medium-12 columns">	
				<?php if ( have_posts() ) : ?>
					<?php if ( is_home() && ! is_front_page() ) : ?>
						<header>
							<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
						</header>
					<?php endif; ?>
					<?php
					// Start the loop.
					while ( have_posts() ) : the_post();						
						get_template_part( 'content', get_post_format() );

					// End the loop.
					endwhile;
					?>
					<div class="row pagIn">						
						<?php get_template_part('pagination'); ?>
					</div>
					<div class="linkPages">
					<?php wp_link_pages( array(
						'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'classiera' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						) );
					?>
					</div>
				<?php
				// If no content, include the "No posts found" template.
				else :
					get_template_part( 'content', 'none' );

				endif;
				?>
		</div><!--Large8-->
		<div class="large-4 medium-12 columns">
			<section class="sidebar">
				<div class="row">
					<?php get_sidebar('pages'); ?>
				</div><!-- sidebar inner row End-->
			</section><!-- section sidebar-->
		</div><!-- large-4 medium-12 columns End-->
	</div><!--End Row -->	
</section>
<?php get_footer(); ?>