<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "container" div.
 *
 * @package WordPress
 * @subpackage classiera
 * @since classiera 1.0
 */

?>
<!doctype html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<?php 
	if (isset($_SERVER['HTTP_USER_AGENT']) &&
    (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false))
        header('X-UA-Compatible: IE=9');
	global $redux_demo; 
	$favicon = $redux_demo['favicon']['url'];
?>
	<head>	
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="user-scalable = yes">
	<title><?php wp_title( '|', true, 'right' ); ?></title>	
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php 
	if(is_single()){
		$ID = $wp_query->post->ID;
		$feat_image = wp_get_attachment_url( get_post_thumbnail_id($ID) );
		?>
		<meta property="og:image" content="<?php echo $feat_image; ?>"/>
		<?php
	}
	?>
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0" />
		<?php 
		
		if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {
				
				if (!empty($favicon)){
					?>
					<link rel="shortcut icon" href="<?php echo $favicon; ?>" type="image/x-icon" />
					<?php
				}else{
					?>
					<link rel="icon" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/icons/favicon.ico" type="image/x-icon">
					<?php
				}
			}
		?>	
		
		<link rel="apple-touch-icon-precomposed" sizes="144x144" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/icons/apple-touch-icon-144x144-precomposed.png">
		<link rel="apple-touch-icon-precomposed" sizes="114x114" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/icons/apple-touch-icon-114x114-precomposed.png">
		<link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/icons/apple-touch-icon-72x72-precomposed.png">
		<link rel="apple-touch-icon-precomposed" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/icons/apple-touch-icon-precomposed.png">
		<!--[if lt IE 9]>
	<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js"></script>
	<![endif]-->
		
		<?php wp_head(); ?>
	</head>
	
<?php 
$layout = $redux_demo['layout-version'];
?>	
<body <?php if($layout == 2){ ?>id="boxed" <?php } ?> <?php body_class(); ?>>
	<?php //do_action( 'foundationpress_after_body' ); ?>
	
	<!--<div class="off-canvas-wrap" data-offcanvas>
	<div class="inner-wrap">-->
	
	<?php //do_action( 'foundationpress_layout_start' ); ?>	
	
	<section id="header">
		<header>
			<?php get_template_part('templates/nav'); ?>
		</header><!-- end header -->
	</section><!--ClassiEra Header End -->

	<?php //get_template_part( 'parts/off-canvas-menu' ); ?>

	<?php //get_template_part( 'parts/top-bar' ); ?>

<section class="container" role="document">
	<?php //do_action( 'foundationpress_after_header' ); ?>
