<?php
/**
 * The template for displaying comments
 *
 * The area of the page that contains both current comments
 * and the comment form.
 *
 * @package WordPress
 * @subpackage Classiera
 * @since Classiera 1.0
 */
?>
<?php

	/*
	Do not delete these lines.
	Prevent access to this file directly
	*/

	defined( 'ABSPATH' ) or die(wp_kses( __( 'Please do not load this page directly. Thanks!', 'classiera' ), $allowed ));	

	if ( post_password_required() ) { ?>	
		<div class="notice">
			<p class="bottom"><?php esc_html_e( 'This post is password protected. Enter the password to view comments.', 'classiera' ); ?></p>
		</div>	
	<?php
		return;
	}
$caticoncolor="";
$category_icon_code ="";
$category_icon="";
$category_icon_color="";
global $allowed;
global $redux_demo;
$classieraHTMLTags = $redux_demo['adpost-html-tags'];	
$classieraProfileURL = $redux_demo['profile'];	
?>
<!--Coments Paste -->
<?php
if ( comments_open() ) :
	if ( (is_page() || is_single()) && ( ! is_home() && ! is_front_page()) ) :
?>
<div class="authorHead">
	<h4><?php comment_form_title( esc_html_e( 'Comments', 'classiera' ), wp_kses(__( 'Leave a Reply to %s', 'classiera' ),$allowed) ); ?></h4>
</div><!--authorHead -->
<div class="loguserComment">
	<p class="cancel-comment-reply"><?php cancel_comment_reply_link(); ?></p>
	<?php if ( get_option( 'comment_registration' ) && ! is_user_logged_in() ) : ?>
	<p><?php printf( __( 'You must be <a href="%s">logged in</a> to post a comment.', 'classiera' ), wp_login_url( get_permalink() ) ); ?></p>
	<?php else : ?>
	
	<form action="<?php echo get_option( 'siteurl' ); ?>/wp-comments-post.php" method="post" id="commentform">
		<div class="addComment rightbtn">
			<?php if ( is_user_logged_in() ) : ?>
			<?php $classieraCurUser = wp_get_current_user();?>
			<p>
			<?php esc_html_e( 'Logged in as', 'classiera' );?>
			<a href="<?php echo $classieraProfileURL; ?>"><?php echo $classieraCurUser->user_login;?></a>&nbsp;
			<a href="<?php echo wp_logout_url( get_permalink() ); ?>" title="<?php wp_kses(__( 'Log out of this account', 'classiera' ), $allowed); ?>"><?php esc_html_e( 'Log out &raquo;', 'classiera' ); ?></a></p>
			<?php else : ?>
			<p>
				<label for="author">
					<?php
						esc_html_e( 'Name', 'classiera' ); if ( $req ) { esc_html_e( ' (required)', 'classiera' ); }
					?>
				</label>
				<input type="text" class="five" name="author" id="author" value="<?php echo esc_attr( $comment_author ); ?>" size="22" tabindex="1" <?php if ( $req ) { echo "aria-required='true'"; } ?>>
			</p>
			<p>
				<label for="email">
					<?php
						esc_html_e( 'Email (will not be published)', 'classiera' ); if ( $req ) { esc_html_e( ' (required)', 'classiera' ); }
					?>
				</label>
				<input type="text" class="five" name="email" id="email" value="<?php echo esc_attr( $comment_author_email ); ?>" size="22" tabindex="2" <?php if ( $req ) { echo "aria-required='true'"; } ?>>
			</p>
			<p>
				<label for="url">
					<?php
						esc_html_e( 'Website', 'classiera' );
					?>
				</label>
				<input type="text" class="five" name="url" id="url" value="<?php echo esc_attr( $comment_author_url ); ?>" size="22" tabindex="3">
			</p>
			<?php endif; ?>
			
			<textarea name="comment" id="comment" tabindex="4" placeholder="<?php esc_html_e( 'Type your comment here...', 'classiera') ?>"></textarea>		
			
			<input name="submit" class="buttonMed round btn" type="submit" id="submit" tabindex="5" value="<?php esc_attr_e( 'Send', 'classiera' ); ?>">
			<?php if($classieraHTMLTags == 1){?>
			<p id="allowed_tags" class="small"><strong><?php esc_html_e( 'XHTML','classiera' ); ?>:</strong> 
				<?php
					esc_html_e( 'You can use these tags:','classiera' );
				?> 
				<code>
					<?php echo allowed_tags(); ?>
				</code>
			</p>
			<?php } ?>
			<?php comment_id_fields(); ?>
			<?php do_action( 'comment_form', $post->ID ); ?>
				<div id="wpComment">
				<?php //comment_form(); ?>
				</div>
		</div>
		
	</form>
<!--Div ID Commetns Function -->
<?php
if ( have_comments() ) :
	if ( (is_page() || is_single()) && ( ! is_home() && ! is_front_page()) ) :
?>
	<div class="comments"><?php


		wp_list_comments(
			array(
				'walker'            => new Foundationpress_Comments(),
				'max_depth'         => '',
				'style'             => 'ol',
				'callback'          => null,
				'end-callback'      => null,
				'type'              => 'all',
				'reply_text'        => esc_html__( 'Reply ', 'classiera' ),
				'page'              => '',
				'per_page'          => '',
				'avatar_size'       => 48,
				'reverse_top_level' => null,
				'reverse_children'  => '',
				'format'            => 'html5',
				'short_ping'        => false,
				'echo'  	    => true,
				'moderation' 	    => esc_html__( 'Your comment is awaiting moderation.', 'classiera' ),
			)
		);

		?>

 	</div>
<?php
	endif;
endif;
?>
<!--Div ID Commetns Function -->		
</div><!--loguserComment-->	
	<?php endif; // If registration required and not logged in. ?>

<!--</div><!--loguserComment -->
<?php
	endif; // If you delete this the sky will fall on your head.
	endif; // If you delete this the sky will fall on your head.
?>
<!--Comments Paste -->