<?php
/**
 * Template name: Profile Page
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiera
 * @since classiera
 */

global $user_ID;
$author = get_user_by( 'slug', get_query_var( 'author_name' ) ); $user_ID = $author->ID;
$user_info = get_userdata($user_ID);
get_header(); 

	global $redux_demo, $maximRange; 
	$max_range = $redux_demo['max_range'];
	if(!empty($max_range)) {
		$maximRange = $max_range;
	} else {
		$maximRange = 1000;
	}
global $redux_demo; 

global $current_user; wp_get_current_user(); $currentUser_ID == $current_user->ID;

$contact_email = get_the_author_meta( 'user_email', $currentUser_ID );
$classieraContactEmailError = $redux_demo['contact-email-error'];
$classieraContactNameError = $redux_demo['contact-name-error'];
$classieraConMsgError = $redux_demo['contact-message-error'];
$classieraContactThankyou = $redux_demo['contact-thankyou-message'];

global $nameError;
global $emailError;
global $commentError;
global $subjectError;
global $humanTestError;
$caticoncolor="";
$category_icon_code ="";
$category_icon="";
$category_icon_color="";

//If the form is submitted
if(isset($_POST['submitted'])) {
	
		//Check to make sure that the name field is not empty
		if(trim($_POST['contactName']) === '') {
			$nameError = $classieraContactNameError;
			$hasError = true;
		} elseif(trim($_POST['contactName']) === 'Name*') {
			$nameError = $classieraContactNameError;
			$hasError = true;
		}	else {
			$name = trim($_POST['contactName']);
		}

		//Check to make sure that the subject field is not empty
		if(trim($_POST['subject']) === '') {
			$subjectError = $classiera_contact_subject_error;
			$hasError = true;
		} elseif(trim($_POST['subject']) === 'Subject*') {
			$subjectError = $classiera_contact_subject_error;
			$hasError = true;
		}	else {
			$subject = trim($_POST['subject']);
		}
		
		//Check to make sure sure that a valid email address is submitted
		if(trim($_POST['email']) === '')  {
			$emailError = $classieraContactEmailError;
			$hasError = true;
		} else if (!eregi("^[A-Z0-9._%-]+@[A-Z0-9._%-]+\.[A-Z]{2,4}$", trim($_POST['email']))) {
			$emailError = $classieraContactEmailError;
			$hasError = true;
		} else {
			$email = trim($_POST['email']);
		}
			
		//Check to make sure comments were entered	
		if(trim($_POST['comments']) === '') {
			$commentError = $classieraConMsgError;
			$hasError = true;
		} else {
			if(function_exists('stripslashes')) {
				$comments = stripslashes(trim($_POST['comments']));
			} else {
				$comments = trim($_POST['comments']);
			}
		}

		//Check to make sure that the human test field is not empty
		if(trim($_POST['humanTest']) != '8') {
			$humanTestError = "Not Human :(";
			$hasError = true;
		} else {

		}
			
		//If there is no error, send the email
		if(!isset($hasError)) {

			$emailTo = $contact_email;
			$subject = $subject;	
			$body = "Name: $name \n\nEmail: $email \n\nMessage: $comments";
			$headers = 'From <'.$emailTo.'>' . "\r\n" . 'Reply-To: ' . $email;
			
			wp_mail($emailTo, $subject, $body, $headers);

			$emailSent = true;

	}
}

?>
<section class="pageHeading">
	<div class="row">
		<h3><?php echo get_the_author_meta('display_name', $user_ID ); ?>'s <?php esc_html_e( 'ADS', 'classiera' ); ?></h3>		
	</div>
</section><!-- End page Heading -->
<section id="advertisement" class="noBorder">
	<div class="row">
		<div class="large-8 medium-12 columns">
			<!-- Ad submit -->
			<section class="adSubmit boxPad">
				<div class="row">
					<div class="large-12 columns">
						<div class="adHeading">
							<i class="fa fa-user"></i>
							<h4><?php esc_html_e( 'About', 'classiera' ); ?>&nbsp<?php echo get_the_author_meta('display_name', $user_ID ); ?> </h4>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="large-12 columns">
						<div class="authorHead">
							<h4><?php echo get_the_author_meta('display_name', $user_ID ); ?></h4>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="large-12 columns">
						<div class="authorBio">
							<h5><?php esc_html_e( 'Biography', 'classiera' ); ?></h5>
						</div>
						<p>
							<?php $author_desc = get_the_author_meta('description', $user_ID); echo $author_desc; ?>
						</p>
						<div class="form-heading">
							<p><?php esc_html_e('About Me', 'classiera') ?></p>
						</div><!-- form-heading -->
						<ul class="aboutMe">
							<li>
								<i class="fa fa-phone"></i>
								<?php the_author_meta('phone', $user_ID); ?>
							</li><!-- End li phone -->
							<li>
								<i class="fa fa-mobile"></i>
								<?php the_author_meta('phone2', $user_ID); ?>
							</li><!-- End li Mobile -->
							<li>
								<i class="fa fa-envelope"></i>
								<a href="mailto:<?php echo get_the_author_meta('user_email', $user_ID); ?>"><?php echo get_the_author_meta('user_email', $user_ID); ?></a>
							</li><!-- End li Email -->
							<li>
								<i class="fa fa-globe"></i>
								<a href="<?php the_author_meta('user_url', $user_ID); ?>"><?php the_author_meta('user_url', $user_ID); ?></a>
							</li><!-- End li Website -->
						</ul><!-- End ul aboutMe -->
						<div class="form-heading">
							<p><?php esc_html_e('Social Profiles', 'classiera') ?></p>
						</div><!-- Social form-heading -->
						<div class="socialShare">
							<ul class="inline-list">
							<?php $userFacebook = $user_info->facebook; 
								if(!empty($userFacebook)){
							?>
								<li><a href="<?php echo $user_info->facebook; ?>"><i class="fa fa-facebook"></i></a></li>
								<?php }?>
								
								<?php $usertwitter = $user_info->twitter; 
								if(!empty($usertwitter)){
							?>
								<li><a href="<?php echo $user_info->twitter; ?>"><i class="fa fa-twitter"></i></a></li>
								<?php }?>
								
								<?php $usergoogleplus = $user_info->googleplus; 
								if(!empty($usergoogleplus)){
							?>
								<li><a href="<?php echo $user_info->googleplus; ?>"><i class="fa fa-google-plus"></i></a></li>
								<?php }?>
								
								<?php $userpinterest = $user_info->pinterest; 
								if(!empty($userpinterest)){
							?>
								<li><a href="<?php echo $user_info->pinterest; ?>"><i class="fa fa-pinterest-p"></i></a></li>
								<?php }?>
								
								<?php $userlinkedin = $user_info->linkedin; 
								if(!empty($userlinkedin)){
							?>
								<li><a href="<?php echo $user_info->linkedin; ?>"><i class="fa fa-linkedin"></i></a></li>
								<?php }?>
								
								<?php $userEmail = $user_info->user_email; 
								if(!empty($userEmail)){
							?>
								<li><a href="mailto:<?php echo $user_info->user_email; ?>"><i class="fa fa-envelope"></i></a></li>
								<?php }?>
								
								<?php $userInsta = $user_info->instagram;?>
								<?php if(!empty($userInsta)){?>
								<li><a href="<?php echo $user_info->instagram; ?>"><i class="fa fa-instagram"></i></a></li>
								<?php }?>
								
							</ul><!-- End inline-list -->
						</div><!-- End socialShare -->
					</div>
				</div><!--End Row-->
				<div class="row">
					<div class="advContent">
						<div class="tabs-content">
							<div class="content active clearfix" id="panel1">
							<?php 
								global $paged, $wp_query, $wp;
								$args = wp_parse_args($wp->matched_query);
								if ( !empty ( $args['paged'] ) && 0 == $paged ) {
									$wp_query->set('paged', $args['paged']);
									$paged = $args['paged'];
								}
								$cat_id = get_cat_ID(single_cat_title('', false));
								$temp = $wp_query;
								$wp_query= null;
								$wp_query = new WP_Query();
								$wp_query->query('post_type=post&posts_per_page=12&paged='.$paged.'&cat='.$cat_id.'&author='.$user_ID);
								$current = -1;
								$current2 = 0;
							?>
							<?php while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; ?>
								<div class="large-6 medium-6 columns advItems end">
									<div class="advItem">
										<?php /*Start Image */
										if ( has_post_thumbnail()) {
												$imageurl = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'classiera-grid');
												$thumb_id = get_post_thumbnail_id($post->id);
												$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
												?>
												<img src="<?php echo $imageurl[0]; ?>" alt="<?php if(empty($alt)){echo "Image";}else{ echo $alt; } ; ?>"/>
												<?php										
											}else{
												?>
												<img src="<?php echo get_template_directory_uri() . '/images/nothumb/nothumb370x300.png' ?>" alt="No Thumb"/>
												<?php
											}
											/*End Image */
											/*Get Category Extra Fields For Price Icon Background */
											$category = get_the_category();
													if ($category[0]->category_parent == 0) {
														$tag = $category[0]->cat_ID;
														$category_icon_code = "";
														$category_icon_color = "";
														$your_image_url = "";
														$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
														if (isset($tag_extra_fields[$tag])) {
															$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
															$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
														}
													}else{
														$tag = $category[0]->category_parent;
														$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
														if (isset($tag_extra_fields[$tag])) {
															$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
															$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
														}
													}
													if(!empty($category_icon_code)) {
														$category_icon = stripslashes($category_icon_code);
													}
													$category_icon_code = "";
													$postCatgory = get_the_category( $post->ID );
											/*Get Category Extra Fields For Price Icon Background */
										?>
										<?php $post_price = get_post_meta($post->ID, 'post_price', true); 
											if(!empty($post_price)){
										?>
										<span class="price" style="background-color:<?php echo $category_icon_color; ?>"><?php echo $post_price; ?></span>
											<?php }?>
										<a class="hover" href="<?php the_permalink(); ?>"></a>
										<div class="info">
											<a href="<?php the_permalink(); ?>">
												<i class="<?php echo $category_icon; ?>" style="background-color:<?php echo $category_icon_color; ?>"></i>
												<span class="title"><?php $theTitle = get_the_title(); $theTitle = (strlen($theTitle) > 25) ? substr($theTitle,0,25).'...' : $theTitle; echo $theTitle; ?></span>
												<span class="cat"><?php esc_html_e( 'Category', 'classiera' ); ?> &nbsp;:&nbsp;<?php echo $postCatgory[0]->name; ?></span>
											</a>
										</div>
									</div><!-- End advItem-->
								</div><!-- End Single Post Entry-->
								<?php endwhile; ?>
								<?php //wp_reset_postdata(); ?>
								<?php //echo infinite($wsp_query); ?>	
							</div><!-- END panel1-->
							<!-- Begin classiera_pagination-->
							<?php get_template_part('pagination'); ?>
							<!-- End classiera_pagination-->
							<?php wp_reset_query(); ?>
						</div><!-- END tabs-content listView-->
					</div><!-- END advContent-->
				</div><!-- END Main Ads Section-->
			</section>
		</div><!-- End large-8 -->
		<div class="large-4 medium-12 columns">
			<section class="sidebar">
				<div class="row">
					<?php get_sidebar('pages'); ?>
				</div>
			</section>
		</div>
	</div>
</section>
<?php get_footer(); ?>