<?php
/**
 * The template part for displaying a message that posts cannot be found
 *
 * Learn more: {@link https://codex.wordpress.org/Template_Hierarchy}
 *
 * @package WordPress
 * @subpackage Classiera
 * @since Classiera 1.0
 */

?>
<?php 
	global $redux_demo;
	$titleBg = $redux_demo['title-bg']['url'];
	$caticoncolor="";
	$category_icon_code ="";
	$category_icon="";
	$category_icon_color="";
?>
<header>
<section class="pageHeading" style="background:url(<?php echo $titleBg; ?>);">
	<div class="row">
		<h3><?php esc_html_e( 'Nothing Found', 'classiera' ); ?></h3>
	</div>
</section>
</header>
<section id="advertisement">
	<div class="row">
		<div class="large-8 medium-12 columns">
			<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

			<p><?php printf( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'classiera' ), admin_url( 'post-new.php' ) ); ?></p>

			<?php elseif ( is_search() ) : ?>

			<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'classiera' ); ?></p>
			<?php get_search_form(); ?>

			<?php else : ?>

			<p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'classiera' ); ?></p>
			<?php get_search_form(); ?>

			<?php endif; ?>
		</div>
		<div class="large-4 medium-12 columns">
			<section class="sidebar">
				<div class="row">
					<?php get_sidebar('pages');?>
				</div><!-- sidebar inner row End-->
			</section><!-- section sidebar-->
		</div><!-- large-4 medium-12 columns End-->
	</div>
</section>