<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    // This is your option name where all the Redux data is stored.
    $opt_name = "redux_demo";

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'redux_demo/opt_name', $opt_name );

    /*
     *
     * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
     *
     */

    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();

    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Classiera Options', 'classiera' ),
        'page_title'           => __( 'Classiera Options', 'classiera' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => 'AIzaSyAr94kq9EE6JV2JkQav-9spfxnzBZtLT_8',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    $args['admin_bar_links'][] = array(
        'id'    => 'redux-docs',
        'href'  => 'http://joinwebs.co.uk/docs/classiera',
        'title' => __( 'Documentation', 'classiera' ),
    );

    // SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
   
    $args['share_icons'][] = array(
        'url'   => 'https://www.facebook.com/joinwebs',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://twitter.com/joinwebs',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://www.linkedin.com/company/joinwebs',
        'title' => 'Find us on LinkedIn',
        'icon'  => 'el el-linkedin'
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( __( 'Welcome To Classiera Classifieds Ads WordPress Theme Options Panel', 'classiera' ), $v );
    } else {
        $args['intro_text'] = __( 'Welcome To Classiera Classifieds Ads WordPress Theme Options Panel', 'classiera' );
    }

    // Add content after the form.
    $args['footer_text'] = __( 'Thanks for using Classiera Options Panel.', 'classiera' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'Theme Information 1', 'classiera' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'classiera' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => __( 'Theme Information 2', 'classiera' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'classiera' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'classiera' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */
	// -> START General Settings 
    Redux::setSection( $opt_name, array(
        'title'            => __( 'General Settings', 'classiera' ),
        'id'               => 'basic-general',
		'icon'             => 'el el-cog',       
        'customizer_width' => '450px',
        'desc'=> __('Classiera General Settings', 'classiera'),
        'fields'           => array(
            array(
			'id'=>'logo',
			'type' => 'media', 
			'url'=> true,
			'title' => __('Logo', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload your logo Recommended image size:150x50', 'classiera'),
			'subtitle' => __('Upload your logo', 'classiera'),
			'default'=>array('url'=>''),
			),
			array(
			'id'=>'favicon',
			'type' => 'media', 
			'url'=> true,
			'title' => __('Favicon', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload your favicon.(Recommended image size:16x16)', 'classiera'),
			'subtitle' => __('Upload your favicon', 'classiera'),
			'default'=>array('url'=>''),
			),
			array(
			'id'=>'layout-version',
			'type' => 'radio',
			'title' => __('Layout', 'classiera'), 
			'subtitle' => __('Layout Version', 'classiera'),
			'desc' => __('Layout Version', 'classiera'),
			'options' => array('1' => 'Wide', '2' => 'Boxed'),//Must provide key => value pairs for radio options
			'default' => '1'
			),
			array(
			'id'=>'title-bg',
			'type' => 'media', 
			'url'=> true,
			'title' => __('Page title Background', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload page title BG.', 'classiera'),
			'subtitle' => __('Page title Background', 'classiera'),
			'default'=>array('url'=>''),
			),
			array(
            'id' => 'registor-style',
            'type' => 'switch',
            'title' => __('Register Page V2', 'classiera'),
            'subtitle' => __('Register Page V2', 'classiera'),
            'default' => 1,
            ),
			array(
				'id' => 'registor-email-verify',
				'type' => 'switch',
				'title' => __('Email Verification on Register', 'classiera'),
				'subtitle' => __('Email Verification', 'classiera'),
				'desc'=> __('If you will turn On This Then User must need to put valid email and then password will be goes to user email inbox. If you will turn OFF this then there is no need for vaild email, User can just set password at front-end.', 'classiera'),
				'default' => 1,
            ),
			array(
				'id' => 'classiera_social_login',
				'type' => 'switch',
				'title' => __('Social Login Area', 'classiera'),
				'subtitle' => __('Social Login On/OFF', 'classiera'),
				'desc'=> __('If you are not using social login and you want to remove message for social login then turn OFF this option', 'classiera'),
				'default' => 1,
            ),
			array(
			'id'=>'login-pagev2-bg',
			'type' => 'media', 
			'url'=> true,
			'title' => __('Login Page V2 Background', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload Login Page V2 BG.', 'classiera'),
			'subtitle' => __('Login Page V2 Background', 'classiera'),
			'default'=>array('url'=>''),
			),
			array(
			'id'=>'nav-style',
			'type' => 'radio',
			'title' => __('Nav Styles', 'classiera'), 
			'subtitle' => __('Nav Styles', 'classiera'),
			'desc' => __('Nav Styles', 'classiera'),
			'options' => array('1' => 'Version 1', '2' => 'Version 2'),//Must provide key => value pairs for radio options
			'default' => '1'
			),
			array(
            'id' => 'nav-sticky',
            'type' => 'switch',
            'title' => __('Navbar Sticky', 'classiera'),
            'subtitle' => __('Navbar Sticky', 'classiera'),
            'default' => 1,
            ),			
			array(
            'id' => 'infinite-scroll',
            'type' => 'switch',
            'title' => __('Infinite Scroll On/OFF', 'classiera'),
			'desc' => __('By default We are using Pagination if you want to use infinite-scroll then turn On This Option', 'classiera'),
            'subtitle' => __('Infinite Scroll', 'classiera'),
            'default' => 2,
            ),
			array(
            'id' => 'backtotop',
            'type' => 'switch',
            'title' => __('Back To Top Button', 'classiera'),
			'desc' => __('If you dont want to use Back To Top Button Then Just Turn OFF This', 'classiera'),
            'subtitle' => __('Turn On/OFF Back To Top', 'classiera'),
            'default' => 1,
            ),
			array(
			'id'=>'error-style',
			'type' => 'radio',
			'title' => __('404 Page Style', 'classiera'), 
			'subtitle' => __('404 Page Style', 'classiera'),
			'desc' => __('404 Page Style', 'classiera'),
			'options' => array('1' => 'Version 1', '2' => 'Version 2'),//Must provide key => value pairs for radio options
			'default' => '1'
			),
			array(
				'id'=>'all-cat-style',
				'type' => 'radio',
				'title' => __('All Categories Page Style', 'classiera'), 
				'subtitle' => __('All Categories Page Style', 'classiera'),
				'desc' => __('Select Style which you want to shown on all categories page', 'classiera'),
				'options' => array('1' => 'Simple Categories', '2' => 'Categoreis With Images'),//Must provide key => value pairs for radio options
				'default' => '1'
			),
			
			array(
			'id'=>'measure-system',
			'type' => 'radio',
			'title' => __('Measurement system', 'classiera'), 
			'subtitle' => __('Measurement system', 'classiera'),
			'desc' => __('Measurement system', 'classiera'),
			'options' => array('1' => 'Miles', '2' => 'Kilometers'),//Must provide key => value pairs for radio options
			'default' => '2'
			),
			array(
			'id'=>'max_range',
			'type' => 'text',
			'title' => __('Maxim Range', 'classiera'),
			'subtitle' => __('Maxim Range', 'classiera'),
			'desc' => __('You can add the max geolocation range default: 1000', 'classiera'),
			'default' => '1000'
			),	
			array(
            'id' => 'map-on-category',
            'type' => 'switch',
            'title' => __('Show MAP on Category', 'classiera'),
            'subtitle' => __('Turn On/OFF MAP on Category Page', 'classiera'),
            'default' => 2,
            ),
			
			array(
            'id' => 'newusernotification',
            'type' => 'switch',
            'title' => __('Email to Admin on Signup New User', 'classiera'),
            'subtitle' => __('Would You like to receive email?', 'classiera'),
			'desc' => __('If You want to receive Email on new user registration Please Turn On This option.', 'classiera'),
            'default' => 2,
            ),
			array(
            'id' => 'custom_location_by_plugin',
            'type' => 'switch',
            'title' => __('Use Location by CSC', 'classiera'),
            'subtitle' => __('Custom Country, State, City', 'classiera'),
			'desc' => __('If you want to use Custom City and States and City then please turn on this option and add you Country, States and city from "CSC" menu.', 'classiera'),
            'default' => 2,
            ),
			array(
				'id' => 'location_country_on',
				'type' => 'switch',
				'title' => __('Locations Country On/OFF', 'classiera'),
				'subtitle' => __('Locations Country On/OFF', 'classiera'),
				'desc' => __('This option will only work when you are not using CSC.', 'classiera'),
				'default' => 1,
            ),	
			array(
				'id' => 'location_states_on',
				'type' => 'switch',
				'title' => __('Locations States On/OFF', 'classiera'),
				'subtitle' => __('Locations States On/OFF', 'classiera'),
				'desc' => __('This option will only work when you are not using CSC.', 'classiera'),
				'default' => 1,
            ),			
			array(
				'id' => 'location_city_on',
				'type' => 'switch',
				'title' => __('Locations City On/OFF', 'classiera'),
				'subtitle' => __('Locations City On/OFF', 'classiera'),
				'desc' => __('This option will only work when you are not using CSC.', 'classiera'),
				'default' => 1,
            ),			
			array(
				'id'=>'free_price_text',
				'type' => 'text',
				'title' => __('Free listing tag', 'classiera'),
				'subtitle' => __('Free listing tag', 'classiera'),
				'desc' => __('Add here the text tag for free listings', 'classiera'),
				'default' => 'Free'
			),
			array(
				'id'=>'tags_limit',
				'type' => 'text',
				'title' => __('Number of tags in tag Cloud widget', 'classiera'),
				'subtitle' => __('Number of tags in tag Cloud widget', 'classiera'),
				'desc' => __('Put here a number. Example "16"', 'classiera'),
				'default' => '15'
			),
			array(
				'id' => 'footer_widgets_area_on',
				'type' => 'switch',
				'title' => __('Footer Widgets Area On/OFF', 'classiera'),
				'subtitle' => __('Footer Widgets Area On/OFF', 'classiera'),
				'desc' => __('If You dont want to use widgets in footer then just turn off.', 'classiera'),
				'default' => 1,
            ),
			array(
				'id'=>'footer_copyright',
				'type' => 'text',
				'title' => __('Footer Copyright Text', 'classiera'),
				'subtitle' => __('Footer Copyright Text', 'classiera'),
				'desc' => __('You can add text and HTML in here.', 'classiera'),
				'default' => 'All copyrights reserved &copy; 2015 - Design &amp; Development by <a href="http://joinwebs.com">Joinwebs'
			),
			 		
           
        )
    ) );
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Home settings', 'classiera' ),
        'id'               => 'basic-home',
		'icon'             => 'el el-home-alt',        
        'customizer_width' => '500px',        
		'desc'=> __('Home settings of Classiera', 'classiera'),
        'fields'           => array(
           
           array(
			'id'=>'home-cat-counter',
			'type' => 'select',
			'title' => __('How many Categories on homepage?', 'classiera'),
			'subtitle' => __('Categories on homepage', 'classiera'),
			'desc' => __('Categories on homepage', 'classiera'),
			'options' => array('4' => '4', '8' => '8', '12' => '12', '16' => '16', '20' => '20', '24' => '24', '28' => '28', '32' => '32'),
			'default' => '8'
			),
		array(
			'id'=>'home-ads-counter',
			'type' => 'select',
			'title' => __('How many Ads on homepage?', 'classiera'),
			'subtitle' => __('Ads on homepage', 'classiera'),
			'desc' => __('Ads on homepage', 'classiera'),
			'options' => array('3' => '3', '6' => '6', '9' => '9', '12' => '12', '15' => '15', '18' => '18'),
			'default' => '6'
			),
		array(
			'id'=>'home-location-counter',
			'type' => 'select',
			'title' => __('How many Locations on homepage?', 'classiera'),
			'subtitle' => __('Locations on homepage', 'classiera'),
			'desc' => __('This will work only with Locations Version 2', 'classiera'),
			'options' => array('3' => '3', '6' => '6', '9' => '9', '12' => '12', '15' => '15', '18' => '18'),
			'default' => '6'
			),	
		
		array(
            'id' => 'home-cat-disable',
            'type' => 'switch',
            'title' => __('Categories on homepage', 'classiera'),
            'subtitle' => __('Categories on homepage', 'classiera'),
            'default' => 1,
            ),
		array(
            'id' => 'home-location-disable',
            'type' => 'switch',
            'title' => __('Locations on homepage', 'classiera'),
            'subtitle' => __('Locations on homepage', 'classiera'),
            'default' => 1,
            ),
			
		array(
            'id' => 'home-callout-disable',
            'type' => 'switch',
            'title' => __('Callout on homepage', 'classiera'),
            'subtitle' => __('Callout on homepage', 'classiera'),
            'default' => 1,
            ),
		array(
            'id' => 'pricing-plan-disable',
            'type' => 'switch',
            'title' => __('Pricing plans on Homepage', 'classiera'),
            'subtitle' => __('Pricing plans on Homepage', 'classiera'),
            'default' => 1,
            ),
		array(
            'id' => 'turnonsearchcat',
            'type' => 'switch',
            'title' => __('Category Dropdown in Search', 'classiera'),
            'subtitle' => __('Turn On/OFF Category Dropdown from Main Search bar', 'classiera'),
            'default' => 1,
            ),
		array(
            'id' => 'turnonsearchloc',
            'type' => 'switch',
            'title' => __('Location Dropdown in Search', 'classiera'),
            'subtitle' => __('Turn On/OFF Location Dropdown from Main Search bar', 'classiera'),
            'default' => 1,
        ),
		array(
            'id' => 'turnonsearchrange',
            'type' => 'switch',
            'title' => __('Range Slider in Search', 'classiera'),
            'subtitle' => __('Turn On/OFF Range Slider from Main Search bar', 'classiera'),
            'default' => 1,
        ),
		
		array(
			'id'=>'home-ads-view',
			'type' => 'select',
			'title' => __('Select Ads view type', 'classiera'),
			'subtitle' => __('Ads view type', 'classiera'),
			'desc' => __('Ads view type', 'classiera'),
			'options' => array('grid' => 'Grid view', 'list' => 'List view'),
			'default' => 'grid'
			),
		array(
			'id'=>'location-shown-by',
			'type' => 'select',
			'title' => __('Select Location Shown by', 'classiera'),
			'subtitle' => __('Location Shown by', 'classiera'),
			'desc' => __('Location Section Shown by City or States or Country?', 'classiera'),
			'options' => array('post_location' => 'Country', 'post_state' => 'States', 'post_city' =>'City'),
			'default' => 'post_city'
			),			
		array(
			'id'=>'locations-sec-title',
			'type' => 'text',
			'title' => __('Locations title', 'classiera'),
			'subtitle' => __('Locations title', 'classiera'),
			'desc' => __('Put here locations title.', 'classiera'),
			'default' => 'Ads Locations'
		),
		array(
			'id'=>'locations-desc',
			'type' => 'textarea',
			'title' => __('Locations title description', 'classiera'),
			'subtitle' => __('Locations title description', 'classiera'),
			'desc' => __('Put here location sub title.', 'classiera'),
			'default' => 'Classiera provided you a ads location section where you can add your desired locations
there is no limit for the locations so do it as you would like to. '
		),
		array(
			'id'=>'plans-title',
			'type' => 'text',
			'title' => __('Plans title', 'classiera'),
			'subtitle' => __('Plans title', 'classiera'),
			'desc' => __('Put here Plans title.', 'classiera'),
			'default' => 'Find a plan that&#44;s right for you'
		),
		array(
			'id'=>'plans-desc',
			'type' => 'textarea',
			'title' => __('Plans title description', 'classiera'),
			'subtitle' => __('Plans title description', 'classiera'),
			'desc' => __('Put here plan sub title.', 'classiera'),
			'default' => 'A advertisement section where we have two types of ads listing one with grids and the other one with list view latest ads, popular ads & random ads also featured ads wil show below.'
		),
		array(
			'id'=>'ad-desc',
			'type' => 'textarea',
			'title' => __('Advertisement title description', 'classiera'),
			'subtitle' => __('Advertisement title description', 'classiera'),
			'desc' => __('Put here Advertisement sub title.', 'classiera'),
			'default' => 'A advertisement section where we have two types of ads listing one with grids and the other one with list view
latest ads, popular ads & random ads also featured ads will show below.. '
		),
		array(
			'id'=>'cat-sec-title',
			'type' => 'text',
			'title' => __('Categories Section Title', 'classiera'),
			'subtitle' => __('Categories Section Title', 'classiera'),
			'desc' => __('Put Categories Section Title here..', 'classiera'),
			'default' => 'Ads categories'
		),
		array(
			'id'=>'cat-sec-desc',
			'type' => 'textarea',
			'title' => __('Categories Section Description', 'classiera'),
			'subtitle' => __('Categories Section Description', 'classiera'),
			'desc' => __('Put Categories Section Description here..', 'classiera'),
			'default' => 'Semper ac dolor vitae accumsan. Cras interdum hendrerit lacinia.Phasellusaccumsan urna vitae molestie interdum. Nam sed placerat libero, non eleifend dolor'
		),		
        )
    ) );
	 Redux::setSection( $opt_name, array(
        'title'            => __( 'Home Page Sections', 'classiera' ),
        'id'               => 'homepagesections',
        'desc'             => __( 'Manage All HomePage Sections!', 'classiera' ),
        'customizer_width' => '400px',
        'icon'             => 'el el-dashboard'
    ) );	
	Redux::setSection( $opt_name, array(
        'title'      => __( 'Static Banner settings', 'classiera' ),
        'id'         => 'StaticBannersettings',
		'icon'             => 'el el-screen',
        'subsection' => true,
        'desc' => __('If You are using Image Slider on you HomePage Then you need to setup from here.)', 'classiera'), 
        'fields'     => array(
			array(
				'id'       => 'classiera_header_bg',
				'type'     => 'background',
				'title'    => __('Header Banner Background', 'classiera'),
				'subtitle' => __('Header Banner Background, color, etc.', 'classiera'),
				'desc'     => __('If you want to use image then dont select color just upload image banner Size: width:1600px and height 733px', 'classiera'),
				'default'  => array(
					'background-color' => '#fff',
					'background-image' => '',
					'background-repeat' => '',
					'background-position' => '',
					'background-size' => '',
					'background-attachment' => '',
				),			 
			),
			array(
				'id'=>'homepage-v2-title',
				'type' => 'text',
				'title' => __('HomePage Header First Heading', 'classiera'),
				'subtitle' => __('HomePage Header First Heading', 'classiera'),
				'desc' => __('Put Header Title Here Note: This Title will work with HomePage V2,V3,V4', 'classiera'),
				'default' => 'WELCOME TO CLASSIERA'
			),			
			array(
				'id'=>'homepage-v2-desc',
				'type' => 'textarea',
				'title' => __('HomePage Header Description', 'classiera'),
				'subtitle' => __('HomePage Header Description', 'classiera'),
				'desc' => __('Put Header Description Here Note: This Title will work with HomePage V2,V3,V4', 'classiera'),
				'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard1500s'
			),
			
			array(
                'id'       => 'classiera_banner_heading_typography',
                'type'     => 'typography',
                'title'    => __( 'Header First Heading Font Settings', 'classiera' ),
                'subtitle' => __( 'Specify the font settings properties.', 'classiera' ),
                'letter-spacing'=> true,
				'google'   => true,
                'default'  => array(
                    'color'       => '#fff',
                    'font-size'   => '60px',
                    'font-family' => 'Raleway,sans-serif',
                    'font-weight' => '700',
                    'line-height' => '60px',
                    'text-align' => '',
                    'letter-spacing' => '',
                ),				
            ),
			array(
                'id'       => 'classiera_banner_desc_typography',
                'type'     => 'typography',
                'title'    => __( 'Header Description Font Settings', 'classiera' ),
                'subtitle' => __( 'Specify the font settings properties.', 'classiera' ),
                'letter-spacing'=> true,
				'google'   => true,
                'default'  => array(
                    'color'       => '#fff',
                    'font-size'   => '24px',
                    'font-family' => 'Raleway,sans-serif',
                    'font-weight' => '400',
                    'line-height' => '24px',
                    'text-align' => '',
                    'letter-spacing' => '',
                ),				
            ),
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'      => __( 'Advantage Section', 'classiera' ),
        'id'         => 'advantage-section',
		'icon'             => 'el el-bulb',
        'subsection' => true,
        'desc' => __('Manage Advantage section on homepage, If you are not using Advantage section then no need to do anything here.', 'classiera'), 
        'fields'     => array(
		array(
            'id' => 'home-adv-disable',
            'type' => 'switch',
            'title' => __('Advantage on Homepage', 'classiera'),
            'subtitle' => __('Advantage on Homepage', 'classiera'),
            'default' => 1,
			),
		array(
			'id'=>'adv-main-title',
			'type' => 'text',
			'title' => __('HomePage Advantage Title', 'classiera'),
			'subtitle' => __('Advantage Title', 'classiera'),
			'desc' => __('Put Advantage Title here...', 'classiera'),
			'default' => 'CLASSIERA ADVANTAGE'
			),
		array(
			'id'=>'adv-main-desc',
			'type' => 'textarea',
			'title' => __('HomePage Advantage Description', 'classiera'),
			'subtitle' => __('Advantage Description', 'classiera'),
			'desc' => __('Put Advantage Description here...', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys'
			),
		array(
			'id'=>'adv1-icon',
			'type' => 'text',
			'title' => __('Advantage First Icon', 'classiera'),
			'subtitle' => __('First Icon', 'classiera'),
			'desc' => __('Put Icon code here..You can get Icon from <a href="https://fortawesome.github.io/Font-Awesome/icons/">Font Awesome</a>', 'classiera'),
			'default' => '<i class="fa fa-book"></i>'
			),
		array(
			'id'=>'adv1-title',
			'type' => 'text',
			'title' => __('Advantage First Title', 'classiera'),
			'subtitle' => __('First Title', 'classiera'),
			'desc' => __('Put Advantage Description here...', 'classiera'),
			'default' => 'Fully Documented'
			),
		array(
			'id'=>'adv1-desc',
			'type' => 'textarea',
			'title' => __('Advantage First Description', 'classiera'),
			'subtitle' => __('First Description', 'classiera'),
			'desc' => __('Put Advantage Title here...', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys'
			),
		array(
			'id'=>'adv2-icon',
			'type' => 'text',
			'title' => __('Advantage Second Icon', 'classiera'),
			'subtitle' => __('Second Icon', 'classiera'),
			'desc' => __('Put Icon code here..You can get Icon from <a href="https://fortawesome.github.io/Font-Awesome/icons/">Font Awesome</a>', 'classiera'),
			'default' => '<i class="fa fa-object-ungroup"></i>'
			),
		array(
			'id'=>'adv2-title',
			'type' => 'text',
			'title' => __('Advantage Second Title', 'classiera'),
			'subtitle' => __('Second Title', 'classiera'),
			'desc' => __('Put Advantage Title here...', 'classiera'),
			'default' => 'Pixel Perfect Design'
			),
		array(
			'id'=>'adv2-desc',
			'type' => 'textarea',
			'title' => __('Advantage Second Description', 'classiera'),
			'subtitle' => __('Second Description', 'classiera'),
			'desc' => __('Put Advantage Description here...', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys'
			),
		array(
			'id'=>'adv3-icon',
			'type' => 'text',
			'title' => __('Advantage Third Icon', 'classiera'),
			'subtitle' => __('Third Icon', 'classiera'),
			'desc' => __('Put Icon code here..(You can get Icon from <a href="https://fortawesome.github.io/Font-Awesome/icons/">Font Awesome</a>', 'classiera'),
			'default' => '<i class="fa fa-magic"></i>'
			),
		array(
			'id'=>'adv3-title',
			'type' => 'text',
			'title' => __('Advantage Third Title', 'classiera'),
			'subtitle' => __('Third Title', 'classiera'),
			'desc' => __('Put Advantage Description here...', 'classiera'),
			'default' => 'High Quality'
			),
		array(
			'id'=>'adv3-desc',
			'type' => 'textarea',
			'title' => __('Advantage Third Description', 'classiera'),
			'subtitle' => __('Third Description', 'classiera'),
			'desc' => __('Put Advantage Title here...', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys'
			),
		array(
			'id'=>'adv4-icon',
			'type' => 'text',
			'title' => __('Advantage Fourth Icon', 'classiera'),
			'subtitle' => __('Fourth Icon', 'classiera'),
			'desc' => __('Put Icon code here..You can get Icon from <a href="https://fortawesome.github.io/Font-Awesome/icons/">Font Awesome</a>', 'classiera'),
			'default' => '<i class="fa fa-cogs"></i>'
			),
		array(
			'id'=>'adv4-title',
			'type' => 'text',
			'title' => __('Advantage Fourth Title', 'classiera'),
			'subtitle' => __('Fourth Title', 'classiera'),
			'desc' => __('Put Advantage Title here...', 'classiera'),
			'default' => 'Completely Customizable'
			),
		array(
			'id'=>'adv4-desc',
			'type' => 'textarea',
			'title' => __('Advantage Fourth Description', 'classiera'),
			'subtitle' => __('Fourth Description', 'classiera'),
			'desc' => __('Put Advantage Description here...', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys'
			),
		array(
			'id'=>'adv5-icon',
			'type' => 'text',
			'title' => __('Advantage Fifth Icon', 'classiera'),
			'subtitle' => __('Fifth Icon', 'classiera'),
			'desc' => __('Put Icon code here..(You can get Icon from <a href="https://fortawesome.github.io/Font-Awesome/icons/">Font Awesome</a>', 'classiera'),
			'default' => '<i class="fa fa-mobile"></i>'
			),
		array(
			'id'=>'adv5-title',
			'type' => 'text',
			'title' => __('Advantage Fifth Title', 'classiera'),
			'subtitle' => __('Fifth Title', 'classiera'),
			'desc' => __('Put Advantage Description here...', 'classiera'),
			'default' => '100% Responsive Layout'
			),
		array(
			'id'=>'adv5-desc',
			'type' => 'textarea',
			'title' => __('Advantage Fifth Description', 'classiera'),
			'subtitle' => __('Fifth Description', 'classiera'),
			'desc' => __('Put Advantage Title here...', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys'
			),
		array(
			'id'=>'adv6-icon',
			'type' => 'text',
			'title' => __('Advantage Sixth Icon', 'classiera'),
			'subtitle' => __('Sixth Icon', 'classiera'),
			'desc' => __('Put Icon code here..You can get Icon from <a href="https://fortawesome.github.io/Font-Awesome/icons/">Font Awesome</a>', 'classiera'),
			'default' => '<i class="fa fa-leaf"></i>'
			),
		array(
			'id'=>'adv6-title',
			'type' => 'text',
			'title' => __('Advantage Sixth Title', 'classiera'),
			'subtitle' => __('Sixth Title', 'classiera'),
			'desc' => __('Put Advantage Title here...', 'classiera'),
			'default' => 'Clean & Modern Design'
			),
		array(
			'id'=>'adv6-desc',
			'type' => 'textarea',
			'title' => __('Advantage Sixth Description', 'classiera'),
			'subtitle' => __('Sixth Description', 'classiera'),
			'desc' => __('Put Advantage Description here...', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys'
			),
		array(
			'id'=>'adv7-icon',
			'type' => 'text',
			'title' => __('Advantage Seventh Icon', 'classiera'),
			'subtitle' => __('Seventh Icon', 'classiera'),
			'desc' => __('Put Icon code here..(You can get Icon from <a href="https://fortawesome.github.io/Font-Awesome/icons/">Font Awesome</a>', 'classiera'),
			'default' => '<i class="fa fa-desktop"></i>'
			),
		array(
			'id'=>'adv7-title',
			'type' => 'text',
			'title' => __('Advantage Seventh Title', 'classiera'),
			'subtitle' => __('Seventh Title', 'classiera'),
			'desc' => __('Put Advantage Title here...', 'classiera'),
			'default' => 'Retina Ready'
			),
		array(
			'id'=>'adv7-desc',
			'type' => 'textarea',
			'title' => __('Advantage Seventh Description', 'classiera'),
			'subtitle' => __('Seventh Description', 'classiera'),
			'desc' => __('Put Advantage Description here...', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys'
			),
		array(
			'id'=>'adv8-icon',
			'type' => 'text',
			'title' => __('Advantage Eighth Icon', 'classiera'),
			'subtitle' => __('Eighth Icon', 'classiera'),
			'desc' => __('Put Icon code here..(You can get Icon from <a href="https://fortawesome.github.io/Font-Awesome/icons/">Font Awesome</a>', 'classiera'),
			'default' => '<i class="fa fa-google"></i>'
			),
		array(
			'id'=>'adv8-title',
			'type' => 'text',
			'title' => __('Advantage Eighth Title', 'classiera'),
			'subtitle' => __('Eighth Title', 'classiera'),
			'desc' => __('Put Advantage Title here...', 'classiera'),
			'default' => 'Free Google Fonts use'
			),
		array(
			'id'=>'adv8-desc',
			'type' => 'textarea',
			'title' => __('Advantage Eighth Description', 'classiera'),
			'subtitle' => __('Eighth Description', 'classiera'),
			'desc' => __('Put Advantage Description here...', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys'
			),
		array(
			'id'=>'adv9-icon',
			'type' => 'text',
			'title' => __('Advantage Ninth Icon', 'classiera'),
			'subtitle' => __('Ninth Icon', 'classiera'),
			'desc' => __('Put Icon code here..You can get Icon from <a href="https://fortawesome.github.io/Font-Awesome/icons/">Font Awesome</a>', 'classiera'),
			'default' => '<i class="fa fa-newspaper-o"></i>'
			),
		array(
			'id'=>'adv9-title',
			'type' => 'text',
			'title' => __('Advantage Ninth Title', 'classiera'),
			'subtitle' => __('Ninth Title', 'classiera'),
			'desc' => __('Put Advantage Title here...', 'classiera'),
			'default' => 'Awesome Layouts'
			),
		array(
			'id'=>'adv9-desc',
			'type' => 'textarea',
			'title' => __('Advantage Ninth Description', 'classiera'),
			'subtitle' => __('Ninth Description', 'classiera'),
			'desc' => __('Put Advantage Description here...', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys'
			),
		
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'      => __( 'Counter Section', 'classiera' ),
        'id'         => 'counter-section',
		'icon'             => 'el el-star',
        'subsection' => true,
        'desc' => __('Manage Counter section on homepage, If you are not using Counter section then no need to do anything here.', 'classiera'), 
        'fields'     => array(
			array(
            'id' => 'homev3-counter-disable',
            'type' => 'switch',
            'title' => __('Counter on Homepage', 'classiera'),
            'subtitle' => __('Counter on Homepage', 'classiera'),
            'default' => 1,
			),
		array(
			'id'=>'homev3-counter-bg',
			'type' => 'media', 
			'url'=> true,
			'title' => __('HomePage Counter BG', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload Counter Background.', 'classiera'),
			'subtitle' => __('Counter BG', 'classiera'),
			'default'=>array('url'=>''),
			),
		array(
			'id'=>'homev3-counter-title',
			'type' => 'text',
			'title' => __('Counter Title', 'classiera'),
			'subtitle' => __('Counter Title', 'classiera'),
			'desc' => __('Put Counter Title here...', 'classiera'),
			'default' => 'Ads Advertisements'
			),
		array(
			'id'=>'homev3-counter-desc',
			'type' => 'textarea',
			'title' => __('Counter Description', 'classiera'),
			'subtitle' => __('Counter Description', 'classiera'),
			'desc' => __('Put Counter Description here...', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys'
			),
		array(
			'id'=>'homev3-counter-ads',
			'type' => 'text',
			'title' => __('Counter Ads Number', 'classiera'),
			'subtitle' => __('Ads Number', 'classiera'),
			'desc' => __('Put Counter Ads Number...', 'classiera'),
			'default' => '2000'
			),
		array(
			'id'=>'homev3-counter-ads-icon',
			'type' => 'text',
			'title' => __('Counter Ads Icon Code', 'classiera'),
			'subtitle' => __('Ads Icon Code', 'classiera'),
			'desc' => __('Put Counter Ads Icon Code...', 'classiera'),
			'default' => '<i class="fa fa-briefcase"></i>'
			),
		array(
			'id'=>'homev3-counter-location',
			'type' => 'text',
			'title' => __('Counter Location Number', 'classiera'),
			'subtitle' => __('Location Number', 'classiera'),
			'desc' => __('Put Counter Location Number...', 'classiera'),
			'default' => '250'
			),
		array(
			'id'=>'homev3-counter-location-icon',
			'type' => 'text',
			'title' => __('Counter Location Icon Code', 'classiera'),
			'subtitle' => __('Location Icon Code', 'classiera'),
			'desc' => __('Put Counter Location Icon Code...', 'classiera'),
			'default' => '<i class="fa fa-map-signs"></i>'
			),
		array(
			'id'=>'homev3-counter-members',
			'type' => 'text',
			'title' => __('Counter Members Number', 'classiera'),
			'subtitle' => __('Members Number', 'classiera'),
			'desc' => __('Put Counter Members Number...', 'classiera'),
			'default' => '250'
			),
		array(
			'id'=>'homev3-counter-members-icon',
			'type' => 'text',
			'title' => __('Counter Members Icon Code', 'classiera'),
			'subtitle' => __('Members Icon Code', 'classiera'),
			'desc' => __('Put Counter Members Icon Code...', 'classiera'),
			'default' => '<i class="fa fa-users"></i>'
			),
		array(
			'id'=>'homev3-counter-customers',
			'type' => 'text',
			'title' => __('Counter Customers Number', 'classiera'),
			'subtitle' => __('Customers Number', 'classiera'),
			'desc' => __('Put Counter Customers Number...', 'classiera'),
			'default' => '250'
			),
		array(
			'id'=>'homev3-counter-customers-icon',
			'type' => 'text',
			'title' => __('Counter Customers Icon Code', 'classiera'),
			'subtitle' => __('Customers Icon Code', 'classiera'),
			'desc' => __('Put Counter Customers Icon Code...', 'classiera'),
			'default' => '<i class="fa fa-thumbs-up"></i>'
			),			
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'      => __( 'Process Section', 'classiera' ),
        'id'         => 'process-section',
		'icon'             => 'el el-asl',
        'subsection' => true,
        'desc' => __('Manage Process section on homepage, If you are not using Process section then no need to do anything here', 'classiera'), 
        'fields'     => array(
		array(
            'id' => 'homev4-process-disable',
            'type' => 'switch',
            'title' => __('Homepage V4 Process Section On/OFF', 'classiera'),
            'subtitle' => __('Process Section', 'classiera'),
            'default' => 1,
			),
		array(
			'id'=>'homev4-process-title',
			'type' => 'text',
			'title' => __('Homepage V4 Process Title ', 'classiera'),
			'subtitle' => __('Process Title', 'classiera'),
			'desc' => __('Put Homepage V4 Process Title', 'classiera'),
			'default' => 'our Process'
			),
		array(
			'id'=>'homev4-process-desc',
			'type' => 'textarea',
			'title' => __('Homepage V4 Process Description ', 'classiera'),
			'subtitle' => __('Process Description', 'classiera'),
			'desc' => __('Put Homepage V4 Process Description', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys'
			),
		array(
			'id'=>'trns-process-idea',
			'type' => 'text',
			'title' => __('Homepage V4 Process First Title ', 'classiera'),
			'subtitle' => __('First Title', 'classiera'),
			'desc' => __('Put Homepage V4 Process First Title', 'classiera'),
			'default' => 'Idea'
			),
		array(
			'id'=>'homev4-process-idea-icon',
			'type' => 'text',
			'title' => __('Homepage V4 Process First Icon Code ', 'classiera'),
			'subtitle' => __('First Icon Code', 'classiera'),
			'desc' => __('Put Homepage V4 Process First Icon Code', 'classiera'),
			'default' => '<i class="fa fa-lightbulb-o"></i>'
			),
		array(
			'id'=>'homev4-process-idea-desc',
			'type' => 'textarea',
			'title' => __('Homepage V4 Process First Icon Description ', 'classiera'),
			'subtitle' => __('First Icon Description', 'classiera'),
			'desc' => __('Put Homepage V4 Process First Icon Description', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum.'
			),
		array(
			'id'=>'trns-process-concept',
			'type' => 'text',
			'title' => __('Homepage V4 Process Second Title ', 'classiera'),
			'subtitle' => __('Process Second Title', 'classiera'),
			'desc' => __('Put Homepage V4 Process Second Title', 'classiera'),
			'default' => 'Concept'
			),
		array(
			'id'=>'homev4-process-concept-icon',
			'type' => 'text',
			'title' => __('Homepage V4 Process Second Icon Code ', 'classiera'),
			'subtitle' => __('Process Second Icon Code', 'classiera'),
			'desc' => __('Put Homepage V4 Process Second Icon Code', 'classiera'),
			'default' => '<i class="fa fa-magic"></i>'
			),
		array(
			'id'=>'homev4-process-concept-desc',
			'type' => 'textarea',
			'title' => __('Homepage V4 Process Second Icon Description ', 'classiera'),
			'subtitle' => __('Process Second Icon Description', 'classiera'),
			'desc' => __('Put Homepage V4 Process Second Icon Description', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum.'
			),
		array(
			'id'=>'trns-process-design',
			'type' => 'text',
			'title' => __('Homepage V4 Process Third Title ', 'classiera'),
			'subtitle' => __('Process Third Title', 'classiera'),
			'desc' => __('Put Homepage V4 Process Third Title', 'classiera'),
			'default' => 'Design'
			),
		array(
			'id'=>'homev4-process-design-icon',
			'type' => 'text',
			'title' => __('Homepage V4 Process Third Icon Code ', 'classiera'),
			'subtitle' => __('Process Third Icon Code', 'classiera'),
			'desc' => __('Put Homepage V4 Process Third Icon Code', 'classiera'),
			'default' => '<i class="fa fa-object-ungroup"></i>'
			),		
		array(
			'id'=>'homev4-process-design-desc',
			'type' => 'textarea',
			'title' => __('Homepage V4 Process Third Description ', 'classiera'),
			'subtitle' => __('Process Third Description', 'classiera'),
			'desc' => __('Put Homepage V4 Process Third Description', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum.'
			),
		array(
			'id'=>'trns-process-deliver',
			'type' => 'textarea',
			'title' => __('Homepage V4 Process Fourth Title ', 'classiera'),
			'subtitle' => __('Process Fourth Title', 'classiera'),
			'desc' => __('Put Homepage V4 Process Fourth Title', 'classiera'),
			'default' => 'Deliver'
			),
		array(
			'id'=>'homev4-process-deliver-icon',
			'type' => 'text',
			'title' => __('Homepage V4 Process Fourth Icon Code ', 'classiera'),
			'subtitle' => __('Process Fourth Icon Code', 'classiera'),
			'desc' => __('Put Homepage V4 Process Fourth Icon Code', 'classiera'),
			'default' => '<i class="fa fa-rocket"></i>'
			),
		array(
			'id'=>'homev4-process-deliver-desc',
			'type' => 'textarea',
			'title' => __('Homepage V4 Process Fourth Description ', 'classiera'),
			'subtitle' => __('Process Fourth Description', 'classiera'),
			'desc' => __('Put Homepage V4 Process Fourth Description', 'classiera'),
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum.'
			),
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'      => __( 'Newsletter Section', 'classiera' ),
        'id'         => 'newsletter-section',
		'icon'             => 'el el-envelope',
        'subsection' => true,
        'desc' => __('Manage Newsletter section on homepage, If you are not using Newsletter section then no need to do anything here', 'classiera'), 
        'fields'     => array(		
			array(
				'id' => 'newsletter-disable',
				'type' => 'switch',
				'title' => __('Newsletter on Homepage', 'classiera'),
				'subtitle' => __('Newsletter on Homepage', 'classiera'),
				'default' => 1,
			),
			array(
				'id'=>'newsletter-bg',
				'type' => 'media', 
				'url'=> true,
				'title' => __('HomePage Newsletter BG', 'classiera'),
				'compiler' => 'true',
				//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'=> __('Upload Header Newsletter.', 'classiera'),
				'subtitle' => __('HomePage Newsletter BG', 'classiera'),
				'default'=>array('url'=>''),
			),	
			array(
				'id'=>'newsletter-title',
				'type' => 'text',
				'title' => __('Newsletter Section Title', 'classiera'),
				'subtitle' => __('Newsletter Section Title', 'classiera'),
				'desc' => __('Put here Newsletter Section Title.', 'classiera'),
				'default' => 'Newsletter'
			),
			array(
				'id'=>'newsletter-desc',
				'type' => 'textarea',
				'title' => __('Newsletter Section Description', 'classiera'),
				'subtitle' => __('Newsletter Section Description', 'classiera'),
				'desc' => __('Put here Newsletter Section Description.', 'classiera'),
				'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys'
			),			
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'      => __( 'Tweets Section', 'classiera' ),
        'id'         => 'tweets-section',
		'icon'             => 'el el-twitter',
        'subsection' => true,
        'desc' => __('Manage Tweets section on homepage, If you are not using Tweets section then no need to do anything here.', 'classiera'), 
        'fields'     => array(
		array(
            'id' => 'homev3-tweets-disable',
            'type' => 'switch',
            'title' => __('Tweets on Homepage', 'classiera'),
            'subtitle' => __('Tweets on Homepage', 'classiera'),
            'default' => 1,
        ),
		array(
			'id'=>'homev3-tweets-bg',
			'type' => 'media', 
			'url'=> true,
			'title' => __('HomePage Tweets BG', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload Tweets Background.', 'classiera'),
			'subtitle' => __('HomePage Tweets BG', 'classiera'),
			'default'=>array('url'=>''),
		),
		array(
			'id'=>'homev3-tweets-title',
			'type' => 'text',
			'title' => __('HomePage Tweets Title', 'classiera'),
			'subtitle' => __('HomePage Tweets Title', 'classiera'),
			'desc' => __('Put Tweets Title Here.', 'classiera'),
			'default' => 'Our recents tweets'
		),			
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'      => __( 'Callout Message', 'classiera' ),
        'id'         => 'basic-callout',
		'icon'             => 'el el-bullhorn',
        'subsection' => true,
        'desc'=> __('Callout Message For Home page', 'classiera'),
        'fields'     => array( 
			array(
			'id'=>'callout-bg',
			'type' => 'media', 
			'url'=> true,
			'title' => __('Callout Background', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload your Image.', 'classiera'),
			'subtitle' => __('Callout Background', 'classiera'),
			'default'=>array('url'=>''),
			),
		array(
			'id'=>'callout-bg-version2',
			'type' => 'media', 
			'url'=> true,
			'title' => __('Callout Small Image', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('This Image will be shown On HomePage v2,v3,v4 Image Size: 435px, 360px', 'classiera'),
			'subtitle' => __('Callout Small Image', 'classiera'),
			'default'=>array('url'=>''),
			),	
		array(
			'id'=>'callout_title',
			'type' => 'text',
			'title' => __(' Callout Title', 'classiera'),
			'desc'=> __('Put here your Callout title', 'classiera'),
			'subtitle' => __('Callout Title', 'classiera'),
			'default'=>'ARE YOU READY',
			),
		array(
			'id'=>'callout_title_second',
			'type' => 'text',
			'title' => __(' Callout second Title', 'classiera'),
			'desc'=> __('Put here your Callout Second title', 'classiera'),
			'subtitle' => __('Callout second Title', 'classiera'),
			'default'=>'FOR THE POSTING YOUR ADS ON <span>&quot;ClassiEra?&quot;</span>',
			),	
		array(
			'id'=>'callout_desc',
			'type' => 'textArea',
			'title' => __(' Callout Description', 'classiera'),
			'desc'=> __('Put here your Callout Description', 'classiera'),
			'subtitle' => __('Callout Description', 'classiera'),
			'default'=>'Semper ac dolor vitae accumsan. Cras interdum hendrerit lacinia.Phasellusaccumsan urna vitae molestie interdum. Nam sed placerat libero, non eleifend dolor..',
			),
		array(
			'id'=>'callout_btn_text',
			'type' => 'text',
			'title' => __(' Callout Button Text', 'classiera'),
			'desc'=> __('Put here your Callout Button Text', 'classiera'),
			'subtitle' => __('Callout Button Text', 'classiera'),
			'default'=>'Get Started ',
			),
		array(
			'id'=>'callout_btn_url',
			'type' => 'text',
			'title' => __(' Callout Button URL', 'classiera'),
			'desc'=> __('Put here your Callout Button URL', 'classiera'),
			'subtitle' => __('Callout Button URL', 'classiera'),
			'validate' => 'url',
			'default'=>'',
			),
		)
    ) );
	// -> START Presentation Fields
    Redux::setSection( $opt_name, array(
        'title' => __( 'Faqs', 'classiera' ),
        'id'    => 'faqs',
		'subsection' => true,
        'desc'  => __( 'Put Faqs for home section, If you are not using FAQS on Your Homepage Then you dont need to do anything here.', 'classiera' ),
        'icon'  => 'el el-question',
		'fields' => array(
			array(
				'id' => 'faqs-on',
				'type' => 'switch',
				'title' => __('Faqs On/OFF', 'classiera'),
				'subtitle' => __('Faqs', 'classiera'),
				'default' => 1,
			),
			array(
			'id'=>'faqs_title',
			'type' => 'text',
			'title' => __(' Faqs Title', 'classiera'),
			'desc'=> __('Put here your Faqs title', 'classiera'),
			'subtitle' => __('Faqs Title', 'classiera'),
			'default'=>'READ OUR FREQUENTLY ASKED QUESTIONS',
			),
			array(
			'id'=>'faqs_desc',
			'type' => 'textarea',
			'title' => __(' Faqs Description', 'classiera'),
			'desc'=> __('Put here your Faqs Description', 'classiera'),
			'subtitle' => __('Faqs Description', 'classiera'),
			'default'=>'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys',
			),
			array(
			'id'=>'faqs_qicon',
			'type' => 'text',
			'title' => __(' Faqs Question Icon', 'classiera'),
			'desc'=> __('Put here your icon code from font-awesome', 'classiera'),
			'subtitle' => __('Faqs Question Icon', 'classiera'),
			'default'=>'<i class="fa fa-question"></i>',
			),
			array(
			'id'=>'faqs_qone',
			'type' => 'text',
			'title' => __(' Faqs Question First', 'classiera'),
			'desc'=> __('Put here your Faqs First Question', 'classiera'),
			'subtitle' => __('Faqs Question First', 'classiera'),
			'default'=>'How do I tap and pay in stores with the?',
			),
			array(
			'id'=>'faqs_qoneanswer',
			'type' => 'textarea',
			'title' => __(' Faqs Question First Answer', 'classiera'),
			'desc'=> __('Put here your Faqs First Question Answer', 'classiera'),
			'subtitle' => __('First Answer', 'classiera'),
			'default'=>'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s when an unknown printer took a galley of type and scrambled it to make a type specimen book.',
			),
			array(
			'id'=>'faqs_qtwo',
			'type' => 'text',
			'title' => __(' Faqs Question Second', 'classiera'),
			'desc'=> __('Put here your Faqs Second Question', 'classiera'),
			'subtitle' => __('Question Second', 'classiera'),
			'default'=>'How do I tap and pay in stores with the?',
			),
			array(
			'id'=>'faqs_qtwoanswer',
			'type' => 'textarea',
			'title' => __(' Faqs Question Second Answer', 'classiera'),
			'desc'=> __('Put here your Faqs Second Question Answer', 'classiera'),
			'subtitle' => __('Second Answer', 'classiera'),
			'default'=>'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s when an unknown printer took a galley of type and scrambled it to make a type specimen book.',
			),
			array(
			'id'=>'faqs_qthree',
			'type' => 'text',
			'title' => __(' Faqs Question Third', 'classiera'),
			'desc'=> __('Put here your Faqs Third Question', 'classiera'),
			'subtitle' => __('Question Third', 'classiera'),
			'default'=>'How do I tap and pay in stores with the?',
			),
			array(
			'id'=>'faqs_qthreeanswer',
			'type' => 'textarea',
			'title' => __(' Faqs Question Third Answer', 'classiera'),
			'desc'=> __('Put here your Faqs Third Question Answer', 'classiera'),
			'subtitle' => __('Third Answer', 'classiera'),
			'default'=>'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s when an unknown printer took a galley of type and scrambled it to make a type specimen book.',
			),
			array(
			'id'=>'faqs_qfour',
			'type' => 'text',
			'title' => __(' Faqs Question Fourth', 'classiera'),
			'desc'=> __('Put here your Faqs Fourth Question', 'classiera'),
			'subtitle' => __('Question Fourth', 'classiera'),
			'default'=>'How do I tap and pay in stores with the?',
			),
			array(
			'id'=>'faqs_qfouranswer',
			'type' => 'textarea',
			'title' => __(' Faqs Question Fourth Answer', 'classiera'),
			'desc'=> __('Put here your Faqs Fourth Question Answer', 'classiera'),
			'subtitle' => __('Fourth Answer', 'classiera'),
			'default'=>'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s when an unknown printer took a galley of type and scrambled it to make a type specimen book.',
			),
			array(
			'id'=>'faqs_qfive',
			'type' => 'text',
			'title' => __(' Faqs Question Fifth', 'classiera'),
			'desc'=> __('Put here your Faqs Fifth Question', 'classiera'),
			'subtitle' => __('Question Fifth', 'classiera'),
			'default'=>'How do I tap and pay in stores with the?',
			),
			array(
			'id'=>'faqs_qfiveanswer',
			'type' => 'textarea',
			'title' => __(' Faqs Question Fifth Answer', 'classiera'),
			'desc'=> __('Put here your Faqs Fifth Question Answer', 'classiera'),
			'subtitle' => __('Fifth Answer', 'classiera'),
			'default'=>'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s when an unknown printer took a galley of type and scrambled it to make a type specimen book.',
			),
			array(
			'id'=>'faqs_qsix',
			'type' => 'text',
			'title' => __(' Faqs Question Sixth', 'classiera'),
			'desc'=> __('Put here your Faqs Sixth Question', 'classiera'),
			'subtitle' => __('Question Sixth', 'classiera'),
			'default'=>'How do I tap and pay in stores with the?',
			),
			array(
			'id'=>'faqs_qsixanswer',
			'type' => 'textarea',
			'title' => __(' Faqs Question Sixth Answer', 'classiera'),
			'desc'=> __('Put here your Faqs Sixth Question Answer', 'classiera'),
			'subtitle' => __('Sixth Answer', 'classiera'),
			'default'=>'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s when an unknown printer took a galley of type and scrambled it to make a type specimen book.',
			),
		)
    ) );
	// -> START Layout Manager
	 Redux::setSection( $opt_name, array(
        'title'            => __( 'Layout Manager', 'classiera' ),
        'id'               => 'layoutmanager',
        'desc'             => __( 'Home Page and Landing Page Manager', 'classiera' ),
        'customizer_width' => '600px',
        'icon'             => 'el el-align-justify'
    ) );
	// -> START Home Layout Manager
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Home Layout Manager', 'classiera' ),
        'id'               => 'homelayoutmanager',
		'subsection' => true,
		'desc'  => __( 'These Settings will work only on HomePage Version 1, If you want to disable any section just drap to Disable section.', 'classiera' ),
        'customizer_width' => '600px',
        'icon'             => 'el el-home-alt',
		'fields'     => array(
			array(
                'id'       => 'opt-homepage-layout',
                'type'     => 'sorter',
                'title'    => 'Homepage Layout Manager',
                'desc'     => 'Organize how you want the layout to appear on the homepage',
                'compiler' => 'true',
                'options'  => array(
                    'disabled' => array(
                        'customads'   => 'Banner ads'
                    ),
                    'enabled'  => array(
                        'banner' => 'LayerSlider/Map',
                        'premiumslider'   => 'Premium Ads Slider',                       
                        'categories'   => 'Categories',
                        'callout'   => 'Callout',
                        'location'   => 'Location',
                        'advertisement'   => 'Advertisement',
                        'packages'   => 'Pricing Plans',
                        'partners'   => 'Partners',
                    ),
                ),
            ),
			array(
                'id'       => 'opt-homepage-layout-v2',
                'type'     => 'sorter',
                'title'    => 'Homepage V2 Layout Manager',
                'desc'     => 'Organize how you want the layout to appear on the homepage V2',
                'compiler' => 'true',
                'options'  => array(
                    'disabled' => array(
						'layerslider' => 'LayerSlider/Map',
                        'customads'   => 'Banner ads'
                    ),
                    'enabled'  => array(
                        'banner' => 'Big Image Slider',						
						'categories'   => 'Categories',
						'advertisement'   => 'Advertisement',
                        'premiumslider'   => 'Premium Ads Slider',
                        'callout'   => 'Callout',
						'packages'   => 'Pricing Plans',
                        'newsletter'   => 'Newsletter', 
                    ),
                ),
            ),
			array(
                'id'       => 'opt-homepage-layout-v3',
                'type'     => 'sorter',
                'title'    => 'Homepage V3 Layout Manager',
                'desc'     => 'Organize how you want the layout to appear on the homepage V3',
                'compiler' => 'true',
                'options'  => array(
                    'disabled' => array(
                        'customads'   => 'Banner ads',
						'layerslider' => 'LayerSlider/Map',
                    ),
                    'enabled'  => array(
                        'banner' => 'Big Slider',
						'categories'   => 'Categories',
						'premiumslider'   => 'Premium Ads Slider',
						'partners'   => 'Partners',
						'advantage'   => 'Advantage',
						'callout'   => 'Callout',
						'advertisement'   => 'Advertisement',
						'counter'   => 'Counter',
						'packages'   => 'Pricing Plans',
						'twitter'   => 'Twitter',                      
                    ),
                ),
            ),
			array(
                'id'       => 'opt-homepage-layout-v4',
                'type'     => 'sorter',
                'title'    => 'Homepage V4 Layout Manager',
                'desc'     => 'Organize how you want the layout to appear on the homepage V4',
                'compiler' => 'true',
                'options'  => array(
                    'disabled' => array(
                        'customads'   => 'Banner ads',
						'layerslider' => 'LayerSlider/Map',
                    ),
                    'enabled'  => array(
                        'banner' => 'Big Slider',
						'categories'   => 'Categories',
						'ourprocess'   => 'Our Process',
						'advertisement'   => 'Advertisement',						
						'premiumslider'   => 'Premium Ads Slider',
						'advantage'   => 'Advantage',
						'callout'   => 'Callout',
						'faqs'   => 'FAQS',
						'partners'   => 'Partners',
						'counter'   => 'Counter',
						'packages'   => 'Pricing Plans',
						'twitter'   => 'Twitter',
                    ),
                ),
            ),
			array(
                'id'       => 'opt-homepage-layout-v5',
                'type'     => 'sorter',
                'title'    => 'Homepage V5 Layout Manager',
                'desc'     => 'Organize how you want the layout to appear on the homepage V5',
                'compiler' => 'true',
                'options'  => array(
                    'disabled' => array(                        
						'banner' => 'Big Slider',
                    ),
                    'enabled'  => array(
                        'layerslider' => 'LayerSlider/Map',
						'premiumslider'   => 'Premium Ads Slider',
						'categories'   => 'Categories',
						'customads'   => 'Banner ads',
						'callout'   => 'Callout',
						'location'   => 'Location',
						'advertisement'   => 'Advertisement',
						'packages'   => 'Pricing Plans',
						'partners'   => 'Partners',
                    ),
                ),
            ),
			array(
                'id'       => 'opt-homepage-layout-v6',
                'type'     => 'sorter',
                'title'    => 'Homepage V6 Layout Manager',
                'desc'     => 'Organize how you want the layout to appear on the homepage V6',
                'compiler' => 'true',
                'options'  => array(
                    'disabled' => array(                        
						'banner' => 'Big Slider',
                    ),
                    'enabled'  => array(
                        'layerslider' => 'LayerSlider/Map',
						'premiumslider'   => 'Premium Ads Slider',
						'categories'   => 'Categories',
						'customads'   => 'Banner ads',
						'callout'   => 'Callout',
						'location'   => 'Location',
						'advertisement'   => 'Advertisement',
						'packages'   => 'Pricing Plans',
						'partners'   => 'Partners',
                    ),
                ),
            ),			
		)
    ) );
	// -> START Landing Page
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Landing Page Manager', 'classiera' ),
        'id'               => 'landingpagemanager',
		'subsection' => true,
		'desc'  => __( 'These Settings will work only Landing Page, Now you can use any section on Landing Page.', 'classiera' ),
        'customizer_width' => '500px',
        'icon'             => 'el el-home-alt',
		'fields'     => array(
			array(
                'id'       => 'opt-homepage-layout-landing',
                'type'     => 'sorter',
                'title'    => 'Landing Page Layout Manager',
                'desc'     => 'Organize how you want the layout to appear on the Landing Page',
                'compiler' => 'true',
                'options'  => array(
                    'disabled' => array(                        
						'banner' => 'Image Slider',
						'categories'   => 'Categories V1',
						'categoriesv2'   => 'Categories V2',
						'categoriesv4'   => 'Categories V4',
						'categoriesv5'   => 'Categories V5',
						'categoriesv6'   => 'Categories V6',
						'advertisement1'   => 'Advertisement',
						'advantage'   => 'Advantage',
						'callout'   => 'Callout',
						'locationv1'   => 'Location V1',
						'locationv3'   => 'Location V3',
						'counter'   => 'Counter',
						'twitter'   => 'Twitter', 
						'packagesv1'   => 'Pricing Plans V1',
						'ourprocess'   => 'Our Process',
						'faqs'   => 'FAQS',
                    ),
                    'enabled'  => array(
                        'layerslider' => 'LayerSlider/Map',
						'premiumslider'   => 'Premium Ads Slider',
						'categoriesv3'   => 'Categories V3',
						'customads'   => 'Banner ads',						
						'calloutv2'   => 'Callout V2',						
						'locationv2'   => 'Location V2',						
						'advertisement'   => 'Advertisement',						
						'packagesv2'   => 'Pricing Plans V2',
						'newsletter'   => 'Newsletter',
						'partners'   => 'Partners',
                    ),
                ),
            ),
		)
    ) );
	// -> START Ads Manager
	 Redux::setSection( $opt_name, array(
        'title'            => __( 'Ads Manager', 'classiera' ),
        'id'               => 'adsmanager',
        'desc'             => __( 'Manage Premium Ads and Regular Ads', 'classiera' ),
        'customizer_width' => '600px',
        'icon'             => 'el el-signal'
    ) );
	// -> START Editors
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Premium Ads', 'classiera' ),
        'id'               => 'premiumads',
		'subsection' => true,
        'customizer_width' => '500px',
        'icon'             => 'el el-usd',
		'fields'     => array(
			array(
				'id'=>'premium-sec-title',
				'type' => 'text',
				'title' => __('Premium Section Title', 'classiera'),
				'subtitle' => __('Premium Section Title', 'classiera'),
				'desc' => __('Put here Premium Section Title.', 'classiera'),
				'default' => 'PREMIUM ADVERTISEMENT'
			),
			array(
				'id'=>'premium-sec-desc',
				'type' => 'textarea',
				'title' => __('Premium Section Description', 'classiera'),
				'subtitle' => __('Premium Section Description', 'classiera'),
				'desc' => __('Put here Premium Section Description.', 'classiera'),
				'default' => 'Semper ac dolor vitae accumsan. Cras interdum hendrerit lacinia.Phasellusaccumsan urna vitae molestie interdum. Nam sed placerat libero, non eleifend dolor.'
			),
			array(
				'id' => 'featured-options-on',
				'type' => 'switch',
				'title' => __('Premium Ads slider', 'classiera'),
				'subtitle' => __('Ads slider', 'classiera'),
				'default' => 1,
            ),
			array(
				'id' => 'featured-caton',
				'type' => 'switch',
				'title' => __('Featured Category On/OFF', 'classiera'),
				'subtitle' => __('Ads Shown From Featured Category.', 'classiera'),
				'desc' => __('If You dont want to use Featured Category then Turn OFF This Options', 'classiera'),
				'default' => 2,
            ),
			array(
				'id' => 'featured-ads-cat',
				'type' => 'select',
				'data' => 'category',
				'title' => __('Featured Category', 'classiera'),
				'subtitle' => __('Featured Category', 'classiera'), 
				'desc' => __('If You dont want to use Paid Ads then Just select a Category from here and All Ads from this category will be shown at Premium Slider Place.', 'classiera'),
            ),
			array(
				'id' => 'featured-related-cat',
				'type' => 'switch',
				'title' => __('Premium Ads Related to category', 'classiera'),
				'subtitle' => __('Premium Ads Related to category?', 'classiera'),
				'desc' => __('By default we have shown all premium ads on all places including category page, but if you want to show premium ads only from current category which you are visiting then please turn on this option. If you are going to turn on this then please make sure you are not using Featured Category from above option.', 'classiera'),
				'default' => 2,
            ),
			array(
				'id'=>'premiumadsview',
				'type' => 'select',
				'title' => __('Select Premium Ads Type', 'classiera'),
				'subtitle' => __('Premium Ads view type', 'classiera'),
				'desc' => __('Select Premium Ads View Type, Slider or Grid', 'classiera'),
				'options' => array('grid' => 'Grid view', 'slider' => 'Carousel Slider'),
				'default' => 'slider'
			),
			array(
				'id'=>'premium-ads-counter',
				'type' => 'select',
				'title' => __('How many Premium Ads on homepage?', 'classiera'),
				'subtitle' => __('Premium Ads on homepage', 'classiera'),
				'desc' => __('This Option will work when you have select Grid View For Premium Ads Section', 'classiera'),
				'options' => array('3' => '3', '6' => '6', '9' => '9', '12' => '12', '15' => '15', '18' => '18', '21' => '21', '24' => '24', '27' => '27', '30' => '30'),
				'default' => '9'
			),
			array(
				'id'=>'premium-ads-limit',
				'type' => 'text',
				'title' => __('How May Image for Premium Ads?', 'classiera'),
				'subtitle' => __('Premium Ads Image Limit', 'classiera'),
				'desc' => __('Put a Value for Premium Ads , How May Images you want to allow to Paid users?. Example "3"', 'classiera'),
				'default' => '3'
			),
		)
    ) );
	// -> START Editors
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Regulars Ads', 'classiera' ),
        'id'               => 'regularadsposting',
		'subsection' => true,
        'customizer_width' => '500px',
        'icon'             => 'el el-usd',
		'fields'     => array(
			array(
				'id' => 'regular-ads',
				'type' => 'switch',
				'title' => __('Regular ad posting On/OFF', 'classiera'),
				'subtitle' => __('Regular ad posting On/OFF', 'classiera'),
				'default' => 1,
            ),
			array(
				'id'=>'ad_expiry',
				'type' => 'select',
				'title' => __('Regular Ads Expiry', 'classiera'), 
				'subtitle' => __('Regular Ads Expiry', 'classiera'),
				'desc' => __('Regular Ads Expiry', 'classiera'),
				'options' => array('7' => 'One week', '30' => 'One Month', '60' => 'Two Months', '90' => 'Three Months', '120' => 'Four Months', '150' => 'Five Months', '180' => 'Six Month', '365' => 'One Year', '36500' => 'Life Time'),//Must provide key => value pairs for radio options
				'default' => '36500'
			),
			array(
				'id'=>'regular-ads-limit',
				'type' => 'text',
				'title' => __('How May Image for Regular Ads?', 'classiera'),
				'subtitle' => __('Regular Ads Image Limit', 'classiera'),
				'desc' => __('Put a Value for Regulars Ads , How May Images you want to allow to regular users? Example "2"', 'classiera'),
				'default' => '2'
			),
			array(
				'id' => 'regular-ads-posting-limit',
				'type' => 'switch',
				'title' => __('Regular Ads Post Limit', 'classiera'),
				'subtitle' => __('Turn ON/OFF Limit for Regular Ads.', 'classiera'),
				'desc' => __('If You want to Put Limit for free Ads Posting then You must need to Turn On This Option.', 'classiera'),
				'default' => 2,
            ),
			array(
				'id'=>'regular-ads-user-limit',
				'type' => 'text',
				'title' => __('How May Free Ads User Can Post?', 'classiera'),
				'subtitle' => __('Regular Ads Limit', 'classiera'),
				'desc' => __('Put a Value for Regulars Ads , How May Free Ads you want to allow to regular users? Example "2"', 'classiera'),
				'default' => '2'
			),
		)
    ) );
	// -> START Editors
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Post Ads', 'classiera' ),
        'id'               => 'postads',
        'customizer_width' => '500px',
        'icon'             => 'el el-pencil',
		'desc'  => __( 'Some Settings Which With work on Post New Ads Page', 'classiera' ),
		'fields'     => array(
			array(
				'id' => 'related-ads-on',
				'type' => 'switch',
				'title' => __('Related Ads On Single Post', 'classiera'),
				'subtitle' => __('Related Ads On Single Post', 'classiera'),
				'default' => 1,
            ),
			array(
				'id'=>'classiera_related_ads_count',
				'type' => 'text',
				'title' => __('Related Ads Count', 'classiera'),
				'subtitle' => __('Put a value', 'classiera'),
				'desc' => __('How many related ads you want to shown on single post page.', 'classiera'),
				'default' => '6'
			),
			array(
				'id' => 'post-options-on',
				'type' => 'switch',
				'title' => __('Post moderation', 'classiera'),
				'subtitle' => __('Post moderation', 'classiera'),
				'default' => 1,
           ),
		   array(
				'id' => 'post-options-edit-on',
				'type' => 'switch',
				'title' => __('Post moderation On every edit post', 'classiera'),
				'subtitle' => __('Post moderation On every edit post', 'classiera'),
				'default' => 1,
           ),
		   array(
				'id' => 'author-msg-box-off',
				'type' => 'switch',
				'title' => __('Author Message Box On/OFF', 'classiera'),
				'subtitle' => __('Author Message box on ad detail page', 'classiera'),
				'default' => 1,
            ),			
			array(
				'id' => 'regularpriceon',
				'type' => 'switch',
				'title' => __('Regular Price Tab on Post New Ads', 'classiera'),
				'subtitle' => __('Regular Price Tab on Post New Ads', 'classiera'),
				'default' => 1,
            ),
			array(
				'id' => 'classiera_sale_price_off',
				'type' => 'switch',
				'title' => __('Price section', 'classiera'),
				'subtitle' => __('Price Tab on Post New Ads', 'classiera'),
				'desc' => __('If you want to hide price section completly then please turn off this option.', 'classiera'),
				'default' => 1,
            ),
			array(
				'id' => 'phoneon',
				'type' => 'switch',
				'title' => __('Asking Phone Number on Post New Ads', 'classiera'),
				'subtitle' => __('If you dont want to ask phone number then just Turn OFF this.', 'classiera'),
				'default' => 1,
            ),
			array(
				'id' => 'google-lat-long',
				'type' => 'switch',
				'title' => __('Latitude and Longitude', 'classiera'),
				'subtitle' => __('Turn On/OFF Latitude and Longitude from Ads Post', 'classiera'),
				'desc' => __('If You dont want user put Latitude and Longitude while posting ads then just turn OFF this option.', 'classiera'),
				'default' => 1,
            ),
			array(
				'id' => 'google-map-adpost',
				'type' => 'switch',
				'title' => __('Google MAP on Post Ads', 'classiera'),
				'subtitle' => __('Turn On/OFF Google MAP from Ads Post', 'classiera'),
				'desc' => __('If You want to hide Google MAP from Submit Ads Page And Single Ads Page Then Turn OFF this Option.', 'classiera'),
				'default' => 1,
            ),
			array(
				'id' => 'classiera_video_postads',
				'type' => 'switch',
				'title' => __('Video Box on Post Ads', 'classiera'),
				'subtitle' => __('Turn On/OFF Video Box on Post Ads', 'classiera'),
				'desc' => __('If you dont want to allow users to add video iframe or link in ads then just turn off this option', 'classiera'),
				'default' => 1,
            ),
			array(
				'id' => 'adpost-condition',
				'type' => 'switch',
				'title' => __('Item Condition', 'classiera'),
				'subtitle' => __('Turn On/OFF Item Condition from Ads Post', 'classiera'),
				'desc' => __('If You dont want to use Item Condition at Submit Page Then Turn OFF this Option.', 'classiera'),
				'default' => 1,
            ),
			array(
				'id' => 'adpost-html-tags',
				'type' => 'switch',
				'title' => __('Comment XHTML', 'classiera'),
				'subtitle' => __('Turn On/OFF Comment XHTML', 'classiera'),
				'desc' => __('If You dont want to show XHTML tags in comments section Turn OFF this Option.', 'classiera'),
				'default' => 1,
            ),
			array(
				'id'=>'classierapostcurrency',
				'type' => 'text',
				'title' => __('Currency Tag', 'classiera'),
				'subtitle' => __('Currency Tag', 'classiera'),
				'desc' => __('Put Your Own Currecny Tag, If you will not put then user can put his own tag while posting.', 'classiera'),
				'default' => ''
			),
		
		)
    ) );
    // -> START Editors
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Pages', 'classiera' ),
        'id'               => 'pages',
        'customizer_width' => '500px',
        'icon'             => 'el-icon-website',
		'fields'     => array(
			array(
			'id'=>'login',
			'type' => 'text',
			'title' => __('Login Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Login Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),
			array(
			'id'=>'register',
			'type' => 'text',
			'title' => __('Register Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Register Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),
		array(
			'id'=>'profile',
			'type' => 'text',
			'title' => __('Profile Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Profile Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),	

		array(
			'id'=>'edit',
			'type' => 'text',
			'title' => __('Edit Profile Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Edit Profile Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),	


		array(
			'id'=>'new_post',
			'type' => 'text',
			'title' => __('New Ad Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('New Ad Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'edit_post',
			'type' => 'text',
			'title' => __('Edit Ad Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Edit Ad Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'featured_plans',
			'type' => 'text',
			'title' => __('Featured Plans Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Featured Plans Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),
		array(
			'id'=>'all-cat-page-link',
			'type' => 'text',
			'title' => __('All Categories Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('All Categories Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),
		array(
			'id'=>'all-ads-page-link',
			'type' => 'text',
			'title' => __('All Ads Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('All Ads Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),
		array(
			'id'=>'all-ads',
			'type' => 'text',
			'title' => __('Single User All Ads', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Single User Account Page All Ads URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),
		array(
			'id'=>'all-favourite',
			'type' => 'text',
			'title' => __('Single User All Favourite', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Single User Account Page All Favourite Ads URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),
		array(
			'id'=>'reset',
			'type' => 'text',
			'title' => __('Reset Password Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Reset Password Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),
			array(
			'id'=>'termsandcondition',
			'type' => 'text',
			'title' => __('Terms And Conditions URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('This Link will be shown at registration page', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),
		)
    ) );
    // -> START Color Selection
    Redux::setSection( $opt_name, array(
        'title' => __( 'Color Selection', 'classiera' ),
        'id'    => 'color',
        'desc'  => __( 'Color Selection', 'classiera' ),
        'icon'  => 'el el-brush',
		'fields' => array(
			array(
			'id'       => 'color-primary',
	        'type'     => 'color',
	        'title'    => __('Primary Color', 'classiera'), 
	        'subtitle' => __('Pick a Primary Color default: #e96969.', 'classiera'),
	        'default'  => '#e96969',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'color-secondary',
	        'type'     => 'color',
	        'title'    => __('Secondary Color', 'classiera'), 
	        'subtitle' => __('Pick a Secondary Color default: #303030.', 'classiera'),
	        'default'  => '#303030',
	        'validate' => 'color',
	        'transparent' => false,
			),	

		array(
			'id'       => 'topbar-buttonicon-color',
	        'type'     => 'color',
	        'title'    => __('Top Bar Icon & Buttons Color', 'classiera'), 
	        'subtitle' => __('Pick a color for buttons default: #393939.', 'classiera'),
			'desc' => __('Nav Version 1 Topbar Social Icon And Button Colors.Note: For Background we are using Secondary Color', 'classiera'),
	        'default'  => '#393939',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'topbar-icon-text-color',
	        'type'     => 'color',
	        'title'    => __('Top Bar Icon & Buttons Text Color', 'classiera'), 
	        'subtitle' => __('Pick a color for buttons. default: #ffffff.', 'classiera'),			
	        'default'  => '#ffffff',
	        'validate' => 'color',
	        'transparent' => false,
			),	
		array(
			'id'       => 'homepage-search-input',
	        'type'     => 'color',
	        'title'    => __('HomePage V1 Search Input BG', 'classiera'), 
	        'subtitle' => __('Pick a color for HomePage Search Input BG default: #393939.', 'classiera'),'default'  => '#393939',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'button-main-color',
	        'type'     => 'color',
	        'title'    => __('Button Colors', 'classiera'), 
	        'subtitle' => __('Pick a color for Buttons default: #444444.', 'classiera'),
			'default'  => '#444444',
	        'validate' => 'color',
	        'transparent' => false,
			),	
		array(
			'id'       => 'plan-one-color',
	        'type'     => 'color',
	        'title'    => __('First Pricing Plan Color', 'classiera'), 
	        'subtitle' => __('Pick a color First Pricing Plan on HomePage default: #e96969.', 'classiera'),
	        'default'  => '#e96969',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'plan-two-color',
	        'type'     => 'color',
	        'title'    => __('Second Pricing Plan Color', 'classiera'), 
	        'subtitle' => __('Pick a color Second Pricing Plan on HomePage default: #77c04b.', 'classiera'),
	        'default'  => '#77c04b',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'plan-three-color',
	        'type'     => 'color',
	        'title'    => __('Third Pricing Plan Color', 'classiera'), 
	        'subtitle' => __('Pick a color Third Pricing Plan on HomePage default: #3396d1.', 'classiera'),
	        'default'  => '#3396d1',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'footer-color',
	        'type'     => 'color',
	        'title'    => __('Footer Color', 'classiera'), 
	        'subtitle' => __('Pick a color for Footer default: #303030.', 'classiera'),
	        'default'  => '#303030',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'fooer-text-color',
	        'type'     => 'color',
	        'title'    => __('Footer Text Color', 'classiera'), 
	        'subtitle' => __('Pick a color for Footer text default: #cccccc.', 'classiera'),
	        'default'  => '#cccccc',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'fooer-heading-color',
	        'type'     => 'color',
	        'title'    => __('Footer Heading Text Color', 'classiera'), 
	        'subtitle' => __('Pick a color for Footer text default: #ffffff.', 'classiera'),
	        'default'  => '#ffffff',
	        'validate' => 'color',
	        'transparent' => false,
			),	
		array(
			'id'       => 'fooer-bottom-color',
	        'type'     => 'color',
	        'title'    => __('Footer Bottom Color', 'classiera'), 
	        'subtitle' => __('Pick a color for Footer Bottom default: #393939.', 'classiera'),
	        'default'  => '#393939',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'fooer-bottom-text-color',
	        'type'     => 'color',
	        'title'    => __('Footer Bottom Text Color', 'classiera'), 
	        'subtitle' => __('Pick a color for Footer Bottom text default: #ffffff.', 'classiera'),
	        'default'  => '#ffffff',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'fooer-bottom-icon-color',
	        'type'     => 'color',
	        'title'    => __('Footer Bottom Icon BG Color', 'classiera'), 
	        'subtitle' => __('Pick a color for Footer Bottom Icon Background default: #444444.', 'classiera'),
	        'default'  => '#444444',
	        'validate' => 'color',
	        'transparent' => false,
			),			
		)
    ) );

    // -> START Design Fields
    Redux::setSection( $opt_name, array(
        'title' => __( 'Social Links', 'classiera' ),
        'id'    => 'social-links',
        'desc'  => __( 'Put Social Links', 'classiera' ),
        'icon'  => 'el el-glasses',
		'fields' => array(
			array(
			'id'=>'facebook-link',
			'type' => 'text',
			'title' => __('Facebook Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Facebook Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'twitter-link',
			'type' => 'text',
			'title' => __('Twitter Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Twitter Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'dribbble-link',
			'type' => 'text',
			'title' => __('Dribbble Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Dribbble Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'flickr-link',
			'type' => 'text',
			'title' => __('Flickr Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Flickr Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'github-link',
			'type' => 'text',
			'title' => __('Github Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Github Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'pinterest-link',
			'type' => 'text',
			'title' => __('Pinterest Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Pinterest Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'youtube-link',
			'type' => 'text',
			'title' => __('Youtube Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Youtube Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'google-plus-link',
			'type' => 'text',
			'title' => __('Google+ Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Google+ Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'linkedin-link',
			'type' => 'text',
			'title' => __('LinkedIn Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('LinkedIn Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'instagram-link',
			'type' => 'text',
			'title' => __('Instagram Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Instagram Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'vimeo-link',
			'type' => 'text',
			'title' => __('Vimeo Page URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Vimeo Page URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),
		
		)
    ) );


    // -> START Media Uploads
    Redux::setSection( $opt_name, array(
        'title' => __( 'Advertisement', 'classiera' ),
        'id'    => 'advertisement',
        'desc'  => __( 'Advertisement Section, If you want to use image ads then please upload banner image and put website URL, but if you want to use google ads then images ads option must need to be empty.', 'classiera' ),
        'icon'  => 'el el-picture',
		'fields' => array(
			array(
				'id'=>'home_ad1',
				'type' => 'media', 
				'url'=> true,
				'title' => __('Home Page Image Ads', 'classiera'),
				'compiler' => 'true',
				//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'=> __('Upload your Ad Image.', 'classiera'),
				'subtitle' => __('Ad Image', 'classiera'),
				'default'=>array('url'=>''),
			),
			array(
				'id'=>'home_ad1_url',
				'type' => 'text',
				'title' => __('Home Page Image URL', 'classiera'),
				'subtitle' => __('link URL', 'classiera'),
				'desc' => __('You can add URL here so when user will click on that image then user will goes to that link.', 'classiera'),
				'default' => '',
				'validate' => 'url',
			),
			array(
				'id'=>'home_html_ad',
				'type' => 'textarea',
				'title' => __('HTML Ads Or Google Ads', 'classiera'),
				'subtitle' => __('HTML ads for HomePage', 'classiera'),
				'desc' => __('Put your HTML or Google Ads Code here.', 'classiera'),
				'default' => ''
			),		
			array(
				'id'=>'home_ad2',
				'type' => 'media', 
				'url'=> true,
				'title' => __('Single Post Page Ad img', 'classiera'),
				'compiler' => 'true',
				//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'=> __('Upload your Ad Image.', 'classiera'),
				'subtitle' => __('Single Post Page Ad img', 'classiera'),
				'default'=>array('url'=>''),
			),
			array(
				'id'=>'home_ad2_url',
				'type' => 'text',
				'title' => __('Single Post Ad link URL', 'classiera'),
				'subtitle' => __('Single Post Ad link URL', 'classiera'),
				'desc' => __('You can add URL here so when user will click on that image then user will goes to that link.', 'classiera'),
				'default' => '',
				'validate' => 'url',
			),
			array(
				'id'=>'home_html_ad2',
				'type' => 'textarea',
				'title' => __('HTML Ads Or Google Ads for Single Post', 'classiera'),
				'subtitle' => __('Google ads', 'classiera'),
				'desc' => __('Put your HTML or Google Ads Code here.', 'classiera'),
				'default' => ''
			),		
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'      => __( 'Other Ads', 'classiera' ),
        'id'         => 'advertisement-other',
		'desc'  => __( 'If you want to use image ads then please upload banner image and put website URL, but if you want to use google ads then images ads option must need to be empty.', 'classiera' ),
		'icon'  => 'el el-picture',
        'subsection' => true,
        'fields'     => array(         
			array(
				'id'=>'post_ad',
				'type' => 'media', 
				'url'=> true,
				'title' => __(' Location & category page Ad', 'classiera'),
				'compiler' => 'true',
				//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'=> __('Upload your Ad Image.', 'classiera'),
				'subtitle' => __('Upload your Ad Image', 'classiera'),
				'default'=>array('url'=>''),
			),
			array(
				'id'=>'post_ad_url',
				'type' => 'text',
				'title' => __('Location & category page Ad link URL', 'classiera'),
				'subtitle' => __('Ad link URL', 'classiera'),
				'desc' => __('You can add URL.', 'classiera'),
				'default' => '',
				'validate' => 'url',
			),
			array(
				'id'=>'post_ad_code_html',
				'type' => 'textarea',
				'title' => __('HTML or Google ads (Location & category page)', 'classiera'),
				'subtitle' => __('Google ads', 'classiera'),
				'desc' => __('Put your HTML or Google Ads Code here.', 'classiera'),
				'default' => ''
			),
        )
    ) );
    // -> START Switch & Button Set
    Redux::setSection( $opt_name, array(
        'title' => __( 'Partners', 'classiera' ),
        'id'    => 'partners',
        'desc'  => __( 'Upload Partners Logos', 'classiera' ),
        'icon'  => 'el el-group',
		'fields' => array(
			array(
            'id' => 'partners-on',
            'type' => 'switch',
            'title' => __('Partners On/OFF', 'classiera'),
            'subtitle' => __('Partners', 'classiera'),
            'default' => 1,
        ),
		array(
			'id'=>'partner1',
			'type' => 'media', 
			'url'=> true,
			'title' => __('Partner One', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload your logo.', 'classiera'),
			'subtitle' => __('Upload your logo', 'classiera'),
			'default'=>array('url'=>''),
			),
		array(
			'id'=>'partner1-url',
			'type' => 'text',
			'title' => __('Partner One URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Partner One URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),
		array(
			'id'=>'partner2',
			'type' => 'media', 
			'url'=> true,
			'title' => __('Partner two', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload your logo.', 'classiera'),
			'subtitle' => __('Upload your logo', 'classiera'),
			'default'=>array('url'=>''),
			),
		array(
			'id'=>'partner2-url',
			'type' => 'text',
			'title' => __('Partner two URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Partner two URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),	
		array(
			'id'=>'partner3',
			'type' => 'media', 
			'url'=> true,
			'title' => __('Partner three', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload your logo.', 'classiera'),
			'subtitle' => __('Upload your logo', 'classiera'),
			'default'=>array('url'=>''),
			),
		array(
			'id'=>'partner3-url',
			'type' => 'text',
			'title' => __('Partner three URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Partner three URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),
		array(
			'id'=>'partner4',
			'type' => 'media', 
			'url'=> true,
			'title' => __('Partner four', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload your logo.', 'classiera'),
			'subtitle' => __('Upload your logo', 'classiera'),
			'default'=>array('url'=>''),
			),
		array(
			'id'=>'partner4-url',
			'type' => 'text',
			'title' => __('Partner four URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Partner four URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),	
		array(
			'id'=>'partner5',
			'type' => 'media', 
			'url'=> true,
			'title' => __('Partner five', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload your logo.', 'classiera'),
			'subtitle' => __('Upload your logo', 'classiera'),
			'default'=>array('url'=>''),
			),
		array(
			'id'=>'partner5-url',
			'type' => 'text',
			'title' => __('Partner five URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Partner five URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),	
		array(
			'id'=>'partner6',
			'type' => 'media', 
			'url'=> true,
			'title' => __('Partner six', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload your logo.', 'classiera'),
			'subtitle' => __('Upload your logo', 'classiera'),
			'default'=>array('url'=>''),
			),
		array(
			'id'=>'partner6-url',
			'type' => 'text',
			'title' => __('Partner six URL', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Partner six URL', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),
		)
    ) );


    // -> START Select Fields
    Redux::setSection( $opt_name, array(
        'title' => __( 'Translate', 'classiera' ),
        'id'    => 'translate',
        'icon'  => 'el el-refresh',
		'fields' => array(
			array(
			'id'=>'trns-btn-previous',
			'type' => 'text',
			'title' => __('Previous Button', 'classiera'),
			'subtitle' => __('Translate Text', 'classiera'),
			'desc' => __('Replace Previous button text.', 'classiera'),
			'default' => 'Previous'
			),
		array(
			'id'=>'trns-btn-next',
			'type' => 'text',
			'title' => __('Next Button', 'classiera'),
			'subtitle' => __('Translate Text', 'classiera'),
			'desc' => __('Replace Next button text.', 'classiera'),
			'default' => 'Next'
			),
		array(
			'id'=>'trns-btn-viewall',
			'type' => 'text',
			'title' => __('View All Button', 'classiera'),
			'subtitle' => __('Translate Text', 'classiera'),
			'desc' => __('Replace View All button text.', 'classiera'),
			'default' => 'View All'
			),
		array(
			'id'=>'trns-cat-viewall-btn',
			'type' => 'text',
			'title' => __('View All Categories', 'classiera'),
			'subtitle' => __('Translate Text', 'classiera'),
			'desc' => __('Replace View All Categoreis button text.', 'classiera'),
			'default' => 'View All Categories'
			),	
		array(
			'id'=>'trns-cara-cat',
			'type' => 'text',
			'title' => __('Category Text', 'classiera'),
			'subtitle' => __('Translate Text', 'classiera'),
			'desc' => __('Replace Category.', 'classiera'),
			'default' => 'Category'
			),
		array(
			'id'=>'trns_skeywords',
			'type' => 'text',
			'title' => __('Keywords', 'classiera'),
			'subtitle' => __('Translate Text', 'classiera'),
			'desc' => __('Replace Keywords.', 'classiera'),
			'default' => 'Keywords'
			),
		array(
			'id'=>'trns-counter-ads-item',
			'type' => 'text',
			'title' => __('ADS Items', 'classiera'),
			'subtitle' => __('Translate Text', 'classiera'),
			'desc' => __('Replace ADS Items.', 'classiera'),
			'default' => 'ADS Items'
			),
		array(
			'id'=>'trns-counter-locations',
			'type' => 'text',
			'title' => __('Locations', 'classiera'),
			'subtitle' => __('Translate Text', 'classiera'),
			'desc' => __('Replace Locations.', 'classiera'),
			'default' => 'Locations'
			),
		array(
			'id'=>'trns-counter-members',
			'type' => 'text',
			'title' => __('Reguler Members', 'classiera'),
			'subtitle' => __('Translate Text', 'classiera'),
			'desc' => __('Replace Reguler Members.', 'classiera'),
			'default' => 'Reguler Members'
			),	
		array(
			'id'=>'trns-counter-customers',
			'type' => 'text',
			'title' => __('Happy Customers', 'classiera'),
			'subtitle' => __('Translate Text', 'classiera'),
			'desc' => __('Replace Happy Customers.', 'classiera'),
			'default' => 'Happy Customers'
			),
		array(
			'id'=>'trns_purchase_now',
			'type' => 'text',
			'title' => __('Purchase Now', 'classiera'),
			'subtitle' => __('Translate Text', 'classiera'),
			'desc' => __('Replace Purchase Now.', 'classiera'),
			'default' => 'Purchase Now'
			),
		array(
			'id'=>'trns_new_post_posted',
			'type' => 'text',
			'title' => __('New Post Posted', 'classiera'),
			'subtitle' => __('Translate Text', 'classiera'),
			'desc' => __('Replace New Post Has been Posted', 'classiera'),
			'default' => 'New Post Has been Posted'
			),
		array(
			'id'=>'trns_welcome_user_title',
			'type' => 'text',
			'title' => __('Welcome Email Title', 'classiera'),
			'subtitle' => __('Translate Text', 'classiera'),
			'desc' => __('Replace Welcome Text', 'classiera'),
			'default' => 'Welcome To Classiera'
			),
		array(
			'id'=>'trns_listing_published',
			'type' => 'text',
			'title' => __('Published Post Notification', 'classiera'),
			'subtitle' => __('Translate Text', 'classiera'),
			'desc' => __('Replace Your Listing has been published', 'classiera'),
			'default' => 'Your Listing has been published!'
			)	
		)
    ) );

    // -> START Slider / Spinner
    Redux::setSection( $opt_name, array(
        'title' => __( 'Twitter Api', 'classiera' ),
        'id'    => 'slider_spinner',
        'desc'  => __( 'Put Twitter Api info', 'classiera' ),
        'icon'  => 'el-icon-twitter',
		'fields' => array(
			array(
			'id'=>'twitter_user_name',
			'type' => 'text',
			'title' => __('Twitter User', 'classiera'),
			'subtitle' => __('Twitter User', 'classiera'),
			'desc' => __('Put Your twitter Username', 'classiera'),
			'default' => 'joinwebs'
			),
			array(
			'id'=>'tweets-show-page',
			'type' => 'text',
			'title' => __('Show Post', 'classiera'),
			'subtitle' => __('Show Post on HomePage', 'classiera'),
			'desc' => __('How Much Post you want to show on HomePage', 'classiera'),
			'default' => '5'
			),
			array(
			'id'=>'consumer_key',
			'type' => 'text',
			'title' => __('Consumer Key', 'classiera'),
			'subtitle' => __('Consumer Key', 'classiera'),
			'desc' => __('Consumer Key', 'classiera'),
			'default' => ''
			),

		array(
			'id'=>'consumer_secret',
			'type' => 'text',
			'title' => __('Consumer Secret', 'classiera'),
			'subtitle' => __('Consumer Secret', 'classiera'),
			'desc' => __('Consumer Secret', 'classiera'),
			'default' => ''
			),

		array(
			'id'=>'access_token',
			'type' => 'text',
			'title' => __('User Access Token', 'classiera'),
			'subtitle' => __('User Access Token', 'classiera'),
			'desc' => __('User Access Token', 'classiera'),
			'default' => ''
			),

		array(
			'id'=>'access_token_secret',
			'type' => 'text',
			'title' => __('User Access Token Secret', 'classiera'),
			'subtitle' => __('User Access Token Secret', 'classiera'),
			'desc' => __('User Access Token Secret', 'classiera'),
			'default' => ''
			),
		)
    ) );
	// -> START Fonts
    Redux::setSection( $opt_name, array(
        'title'  => __( 'Google MAP', 'classiera' ),
        'id'     => 'google-map',
        'desc' => __('Put your Google MAP Info here', 'classiera'),
        'icon'   => 'el el-googleplus',
        'fields' => array( 
			array(
				'id'=>'google_id',
				'type' => 'text',
				'title' => __('Google Analytics Domain ID', 'classiera'),
				'subtitle' => __('Google Analytics Domain ID', 'classiera'),
				'desc' => __('Get analytics on your site. Enter Google Analytics Domain ID ex: UA-123456-1', 'classiera'),
				'default' => ''
			),
			array(
				'id'=>'classiera_google_api',
				'type' => 'text',
				'title' => __('Google API Key', 'classiera'),
				'subtitle' => __('Google API Key', 'classiera'),
				'desc' => __('Put Google API Key here to run Google MAP. If you dont know how to get API key Please Visit  <a href="http://www.tthemes.com/get-google-api-key/" target="_blank">Google API Key</a>', 'classiera'),
				'default' => ''
			),
			array(
				'id'=>'map-style',
				'type' => 'textarea',
				'title' => __('Map Styles', 'classiera'), 
				'subtitle' => __('Check <a href="http://snazzymaps.com/" target="_blank">snazzymaps.com</a> for a list of nice google map styles.', 'classiera'),
				'desc' => __('Ad here your google map style.', 'classiera'),
				'validate' => 'html_custom',
				'default' => '',
				'allowed_html' => array(
					'a' => array(
						'href' => array(),
						'title' => array()
					),
					'br' => array(),
					'em' => array(),
					'strong' => array()
					)
			),
			array(
				'id'=>'classiera_map_post_count',
				'type' => 'text',
				'title' => __('How Many Posts MAP', 'classiera'),
				'subtitle' => __('Posts Icons on MAP', 'classiera'),
				'desc' => __('How many posts you want to shown on MAP when you are using MAP on your HomePage, This will work only on homepage', 'classiera'),
				'default' => '10'
			),
			array(
				'id'=>'classiera_map_post_type',
				'type' => 'radio',
				'title' => __('Post Type on MAP', 'classiera'), 
				'subtitle' => __('All or Featured', 'classiera'),
				'desc' => __('If you will select featured then only Premium/Featured Posts will be shown at MAP', 'classiera'),
				'options' => array('regular' => 'All Posts', 'premium' => 'Featured/Premium'),//Must provide key => value pairs for radio options
				'default' => 'regular'
			),
		)
    ) );
    // -> START Fonts
    Redux::setSection( $opt_name, array(
        'title'  => __( 'Fonts', 'classiera' ),
        'id'     => 'Fonts',
        'desc' => __('Select Fonts for your Website', 'classiera'),
        'icon'   => 'el el-font',
        'fields' => array(           
            array(
            'id' => 'heading1-font',
            'type' => 'typography',
            'title' => __('H1 Font', 'classiera'),
            'subtitle' => __('Specify the headings font properties.', 'classiera'),
            'google' => true,
            'output' => array('h1, h1 a, h1 span'),
            'default' => array(
                'color' => '#444444',
                'font-size' => '38.5px',
                'font-family' => 'Raleway',
                'font-weight' => '700',
                'line-height' => '40px',
                ),
         	),

		array(
            'id' => 'heading2-font',
            'type' => 'typography',
            'title' => __('H2 Font', 'classiera'),
            'subtitle' => __('Specify the headings font properties.', 'classiera'),
            'google' => true,
            'output' => array('h2, h2 a, h2 span'),
            'default' => array(
                'color' => '#444444',
                'font-size' => '32px',
                'font-family' => 'Raleway',
                'font-weight' => '700',
                'line-height' => '40px',
                ),
         	),

		array(
            'id' => 'heading3-font',
            'type' => 'typography',
            'title' => __('H3 Font', 'classiera'),
            'subtitle' => __('Specify the headings font properties.', 'classiera'),
            'google' => true,
            'output' => array('h3, h3 a, h3 span'),
            'default' => array(
                'color' => '#444444',
                'font-size' => '18px',
                'font-family' => 'Raleway',
                'font-weight' => '700',
                'line-height' => '40px',
                ),
         	),

		array(
            'id' => 'heading4-font',
            'type' => 'typography',
            'title' => __('H4 Font', 'classiera'),
            'subtitle' => __('Specify the headings font properties.', 'classiera'),
            'google' => true,
            'output' => array('h4, h4 a, h4 span'),
            'default' => array(
				'color' => '#444',
                'font-size' => '18px',
                'font-family' => 'Raleway',
                'font-weight' => '700',
                'line-height' => '40px',
                ),
         	),

		array(
            'id' => 'heading5-font',
            'type' => 'typography',
            'title' => __('H5 Font', 'classiera'),
            'subtitle' => __('Specify the headings font properties.', 'classiera'),
            'google' => true,
            'output' => array('h5, h5 a, h5 span'),
            'default' => array(
                'color' => '#444444',
                'font-size' => '14px',
                'font-family' => 'Raleway',
                'font-weight' => '300',
                'line-height' => '40px',
                ),
         	),

		array(
            'id' => 'heading6-font',
            'type' => 'typography',
            'title' => __('H6 Font', 'classiera'),
            'subtitle' => __('Specify the headings font properties.', 'classiera'),
            'google' => true,
            'output' => array('h6, h6 a, h6 span'),
            'default' => array(
                'color' => '#444444',
                'font-size' => '11.9px',
                'font-family' => 'Raleway',
                'font-weight' => '300',
                'line-height' => '40px',
                ),
         	),

		array(
            'id' => 'body-font',
            'type' => 'typography',
            'title' => __('Body Font', 'classiera'),
            'subtitle' => __('Specify the body font properties.', 'classiera'),
            'google' => true,
            'output' => array('.ad-detail-half-box .ad-detail-info,span.ad-page-price,html, body, div, applet, object, iframe p, blockquote, a, abbr, acronym, address, big, cite, del, dfn, em, img, ins, kbd, q, s, samp, small, strike, strong, sub, sup, tt, var, b, u, i, center, dl, dt, dd, ol, ul, li, fieldset, form, label, legend, table, caption, tbody, tfoot, thead, tr, th, td, article, aside, canvas, details, embed, figure, figcaption, footer, header, hgroup, menu, nav, output, ruby, section, summary, time, mark, audio, video'),
            'default' => array(
                'color' => '#797979',
                'font-size' => '14px',
                'font-family' => 'Roboto',
                'font-weight' => 'Normal',
                'line-height' => '24px',
                ),
         	),
		array(
            'id' => 'a-heading-font',
            'type' => 'typography',
            'title' => __('Anchor heading Font', 'classiera'),
            'subtitle' => __('Specify the Anchor heading font properties.', 'classiera'),
            'google' => true,
            'output' => array('.ad-detail-info .description,.post-title a,.three-tabs li a'),
            'default' => array(
                'color' => '#444',
                'font-size' => '14px',
                'font-family' => 'Raleway',
                'font-weight' => 'Normal',
                'line-height' => '24px',
                ),
         	),
        )
    ) );

    // -> Coming Soon Page
    Redux::setSection( $opt_name, array(
        'title' => __( 'Coming Soon Page', 'classiera' ),
        'id'    => 'coming-soon',
        'desc'  => __( 'Coming Soon Page Settings', 'classiera' ),
        'icon'  => 'el el-magic',
        'fields' => array(
			array(
			'id'=>'coming-soon-logo',
			'type' => 'media', 
			'url'=> true,
			'title' => __('Coming Soon logo', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload Coming Soon template logo.', 'classiera'),
			'subtitle' => __('Upload Coming Soon template logo', 'classiera'),
			'default'=>array('url'=>''),
			),
			array(
			'id'=>'coming-soon-bg',
			'type' => 'media', 
			'url'=> true,
			'title' => __('Coming Soon BG', 'classiera'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload Coming Soon template Background.', 'classiera'),
			'subtitle' => __('Coming Soon BG', 'classiera'),
			'default'=>array('url'=>''),
			),
			array(
			'id'=>'coming-soon-txt',
			'type' => 'textarea',
			'title' => __('Coming Soon Text', 'classiera'),
			'subtitle' => __('Coming Soon Text', 'classiera'),
			'desc' => __('Coming Soon Text', 'classiera'),
			'default' => 'Well be here soon with our new awesome site'
			),
			array(
			'id'=>'coming-trns-days',
			'type' => 'text',
			'title' => __('Replace Days text', 'classiera'),
			'subtitle' => __('Days text', 'classiera'),
			'desc' => __('Days text', 'classiera'),
			'default' => 'Days'
			),
			array(
			'id'=>'coming-trns-hours',
			'type' => 'text',
			'title' => __('Replace Hours text', 'classiera'),
			'subtitle' => __('Hours text', 'classiera'),
			'desc' => __('Hours text', 'classiera'),
			'default' => 'Hours'
			),
			array(
			'id'=>'coming-trns-minutes',
			'type' => 'text',
			'title' => __('Replace Minutes text', 'classiera'),
			'subtitle' => __('Minutes text', 'classiera'),
			'desc' => __('Minutes text', 'classiera'),
			'default' => 'Minutes'
			),
			array(
			'id'=>'coming-trns-seconds',
			'type' => 'text',
			'title' => __('Replace Seconds text', 'classiera'),
			'subtitle' => __('Seconds text', 'classiera'),
			'desc' => __('Seconds text', 'classiera'),
			'default' => 'Seconds'
			),			
			array(
			'id'=>'coming-month',
			'type' => 'select',
			'title' => __('Month', 'classiera'), 
			'subtitle' => __('Select Month.', 'classiera'),
			'options' => array('january'=>'January', 'february'=>'February', 'march'=>'March', 'april'=>'April', 'may'=>'May', 'june'=>'June', 'july'=>'July', 'august'=>'August', 'september'=>'September', 'october'=>'October', 'november'=>'November', 'december'=>'December'),
			'default' => 'march',
			),
			array(
			'id'=>'coming-days',
			'type' => 'select',
			'title' => __('Days', 'classiera'), 
			'subtitle' => __('Select Days.', 'classiera'),
			'options' => array('1'=>'1', '2'=>'2', '3'=>'3', '4'=>'4', '5'=>'5', '6'=>'6', '7'=>'7', '8'=>'8', '9'=>'9', '10'=>'10', '11'=>'11', '12'=>'12', '13'=>'13', '14'=>'14', '15'=>'15', '16'=>'16', '17'=>'17', '18'=>'18', '19'=>'19', '20'=>'20', '21'=>'21', '22'=>'22', '23'=>'23', '24'=>'24', '25'=>'25', '26'=>'26', '27'=>'27', '28'=>'28', '29'=>'29', '30'=>'30', '31'=>'31'),
			'default' => '10',
			),
			array(
			'id'=>'coming-year',
			'type' => 'text',
			'title' => __('Years', 'classiera'),
			'subtitle' => __('Put Years Example: 2016.', 'classiera'),
			'desc' => __('Years', 'classiera'),			
			'default' => '2016'
			),
			array(
			'id'=>'coming-copyright',
			'type' => 'text',
			'title' => __('Copyright Text', 'classiera'),
			'subtitle' => __('Copyright Text for Coming Soon Page.', 'classiera'),
			'desc' => __('Copyright Text', 'classiera'),			
			'default' => 'Copyright &copy; 2015 Classiera'
			),
       )
    ) );

 

    Redux::setSection( $opt_name, array(
        'title' => __( 'Contact Page', 'classiera' ),
        'icon'  => 'el el-envelope',
        'id'    => 'contact-page',
        'desc'  => __( 'Contact Page Settings', 'classiera' ),        
        'fields' => array(
			array(
				'id' => 'contact-map',
				'type' => 'switch',
				'title' => __('Map On Contact Page', 'classiera'),
				'subtitle' => __('Turn Map On/OFF from Contact Page', 'classiera'),
				'default' => 1,
			),
			array(
			'id'=>'contact-email',
			'type' => 'text',
			'title' => __('Your email address', 'classiera'),
			'subtitle' => __('This must be an email address.', 'classiera'),
			'desc' => __('Your email address', 'classiera'),
			'validate' => 'email',
			'default' => ''
			),

		array(
			'id'=>'contact-email-error',
			'type' => 'text',
			'title' => __('Email error message', 'classiera'),
			'subtitle' => __('Email error message', 'classiera'),
			'desc' => __('Email error message', 'classiera'),
			'default' => 'You entered an invalid email.'
			),

		array(
			'id'=>'contact-name-error',
			'type' => 'text',
			'title' => __('Name error message', 'classiera'),
			'subtitle' => __('Name error message', 'classiera'),
			'desc' => __('Name error message', 'classiera'),
			'default' => 'You forgot to enter your name.'
			),

		array(
			'id'=>'contact-message-error',
			'type' => 'text',
			'title' => __('Message error', 'classiera'),
			'subtitle' => __('Message error', 'classiera'),
			'desc' => __('Message error', 'classiera'),
			'default' => 'You forgot to enter your message.'
			),

		array(
			'id'=>'contact-thankyou-message',
			'type' => 'text',
			'title' => __('Thank you message', 'classiera'),
			'subtitle' => __('Thank you message', 'classiera'),
			'desc' => __('Thank you message', 'classiera'),
			'default' => 'Thank you! We will get back to you as soon as possible.'
			),

		array(
			'id'=>'contact-latitude',
			'type' => 'text',
			'title' => __('Latitude', 'classiera'),
			'subtitle' => __('Latitude', 'classiera'),
			'desc' => __('Latitude', 'classiera'),
			'default' => '31.516370'
			),

		array(
			'id'=>'contact-longitude',
			'type' => 'text',
			'title' => __('Longitude', 'classiera'),
			'subtitle' => __('Longitude', 'classiera'),
			'desc' => __('Longitude', 'classiera'),
			'default' => '74.258727'
			),

		array(
			'id'=>'contact-zoom',
			'type' => 'text',
			'title' => __('Zoom level', 'classiera'),
			'subtitle' => __('Zoom level', 'classiera'),
			'desc' => __('Zoom level', 'classiera'),
			'default' => '16'
			),
		array(
			'id'=>'contact-description',
			'type' => 'textarea',
			'title' => __('Contact Page Small Description', 'classiera'),
			'subtitle' => __('Small Description', 'classiera'),
			'desc' => __('Small Description', 'classiera'),
			'default' => 'Semper ac dolor vitae accumsan. Cras interdum hendrerit lacinia.Phasellusaccumsan urna vitae molestie interdum. Nam sed placerat libero, non eleifend dolor.'
			),	
		array(
			'id'=>'contact-address',
			'type' => 'text',
			'title' => __('Contact Page Address', 'classiera'),
			'subtitle' => __('Contact Page Address', 'classiera'),
			'desc' => __('Contact Page Address', 'classiera'),
			'default' => 'Our business address is 1063 Freelon Street San Francisco, CA 95108'
			),	
		array(
			'id'=>'contact-phone',
			'type' => 'text',
			'title' => __('Contact Page Phone', 'classiera'),
			'subtitle' => __('Contact Page Phone', 'classiera'),
			'desc' => __('Contact Page Phone', 'classiera'),
			'default' => '021.343.7575'
			),	
		array(
			'id'=>'contact-phone2',
			'type' => 'text',
			'title' => __('Contact Page Phone Second', 'classiera'),
			'subtitle' => __('Contact Page Phone Second', 'classiera'),
			'desc' => __('Contact Page Phone Second', 'classiera'),
			'default' => '021.343.7576'
			),
		)
    ) );
	//Start PayPal Settings
	Redux::setSection( $opt_name, array(
        'title' => __( 'Paypal Settings', 'classiera' ),
        'icon'  => 'el el-path',
        'id'    => 'paypal-settings',
        'desc'  => __( 'If you are using your live PayPal Account then you must need to select "Live-Production"', 'classiera' ),        
        'fields' => array(
			array(
			'id'=>'paypal_api_environment',
			'type' => 'radio',
			'title' => __('PayPal environment', 'classiera'), 
			'subtitle' => __('PayPal environment', 'classiera'),
			'desc' => __('PayPal environment', 'classiera'),
			'options' => array('1' => 'Sandbox - Testing', '2' => 'Live - Production'),//Must provide key => value pairs for radio options
			'default' => '1'
			),
		
		array(
			'id'=>'paypal_api_username',
			'type' => 'text',
			'title' => __('API Username required', 'classiera'),
			'subtitle' => __('API Username', 'classiera'),
			'desc' => __('API Username', 'classiera'),
			'default' => ''
			),	

		array(
			'id'=>'paypal_api_password',
			'type' => 'text',
			'title' => __('API Password required', 'classiera'),
			'subtitle' => __('API Password', 'classiera'),
			'desc' => __('API Password', 'classiera'),
			'default' => ''
			),

		array(
			'id'=>'paypal_api_signature',
			'type' => 'text',
			'title' => __('API Signature required', 'classiera'),
			'subtitle' => __('API Signature ', 'classiera'),
			'desc' => __('API Signature ', 'classiera'),
			'default' => ''
			),

		array(
			'id'=>'paypal_success',
			'type' => 'text',
			'title' => __('Thank you page - after successful payment', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Thank you page', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'paypal_fail',
			'type' => 'text',
			'title' => __('Thank you page - after failed payment', 'classiera'),
			'subtitle' => __('This must be an URL.', 'classiera'),
			'desc' => __('Thank you page', 'classiera'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'currency_code',
			'type' => 'select',
			'title' => __('Currency', 'classiera'), 
			'subtitle' => __('Select your currency.', 'classiera'),
			'options' => array('AUD'=>'Australian Dollar', 'BRL'=>'Brazilian Real', 'CAD'=>'Canadian Dollar', 'CZK'=>'Czech Koruna', 'DKK'=>'Danish Krone', 'EUR'=>'Euro', 'HKD'=>'Hong Kong Dollar', 'HUF'=>'Hungarian Forint', 'ILS'=>'Israeli New Sheqel', 'JPY'=>'Japanese Yen', 'MXN'=>'Mexican Peso', 'NOK'=>'Norwegian Krone', 'NZD'=>'New Zealand Dollar', 'PHP'=>'Philippine Peso', 'PLN'=>'Polish Zloty', 'GBP'=>'Pound Sterling', 'SEK'=>'Swedish Krona', 'SGD'=>'Singapore Dollar', 'CHF'=>'Swiss Franc', 'USD'=>'U.S. Dollar', 'THB'=>'Thai Baht'),
			'default' => 'USD',
			),
		)
    ) );



    if ( file_exists( dirname( __FILE__ ) . '/../README.md' ) ) {
        $section = array(
            'icon'   => 'el el-list-alt',
            'title'  => __( 'Documentation', 'classiera' ),
            'fields' => array(
                array(
                    'id'       => '17',
                    'type'     => 'raw',
                    'markdown' => true,
                    'content_path' => dirname( __FILE__ ) . '/../README.md', // FULL PATH, not relative please
                    //'content' => 'Raw content here',
                ),
            ),
        );
        Redux::setSection( $opt_name, $section );
    }
    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /*
    *
    * --> Action hook examples
    *
    */

    // If Redux is running as a plugin, this will remove the demo notice and links
    add_action( 'redux/loaded', 'remove_demo' );

    // Function to test the compiler hook and demo CSS output.
    // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
    //add_filter('redux/options/' . $opt_name . '/compiler', 'compiler_action', 10, 3);

    // Change the arguments after they've been declared, but before the panel is created
    //add_filter('redux/options/' . $opt_name . '/classiera', 'change_arguments' );

    // Change the default value of a field after it's been set, but before it's been useds
    //add_filter('redux/options/' . $opt_name . '/defaults', 'change_defaults' );

    // Dynamically add a section. Can be also used to modify sections/fields
    //add_filter('redux/options/' . $opt_name . '/sections', 'dynamic_section');

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $return['error'] = $field;
                $field['msg']    = 'your custom error message';
            }

            if ( $warning == true ) {
                $return['warning'] = $field;
                $field['msg']      = 'your custom warning message';
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'classiera' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'classiera' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }