<!-- Ad Locations -->
<?php 
	global $redux_demo;	
	$locationTitle = $redux_demo['locations-sec-title'];
	$locationDesc = $redux_demo['locations-desc'];
	/*Get Locations Data Start */
	$locationTemplate = $wpdb->get_results("SELECT `post_id` FROM $wpdb->postmeta WHERE `meta_key` ='_wp_page_template' AND `meta_value` = 'template-locations.php' ", ARRAY_A);
	$locationTemplatePermalink ="";
	if(!empty($locationTemplate)){
		$locationTemplatePermalink = get_permalink($locationTemplate[0]['post_id']);
	}
	global $wp_rewrite;
	if ($wp_rewrite->permalink_structure == ''){
		//we are using ?page_id
		$locationURL = $locationTemplatePermalink."&location=";
	}else{
		//we are using permalinks
		$locationURL = $locationTemplatePermalink."?location=";
	}
	$locDefIMG = get_template_directory_uri().'/images/location.jpg';
?>
<section id="adLocations">
    <div class="row">
        <div class="mainHeading">
            <div class="large-7 medium-8 large-centered medium-centered columns">
                <h2><?php echo $locationTitle; ?></h2>
                <p><span class="line"><i class="fa fa-circle"></i></span></p>
                <p><?php echo $locationDesc; ?></p>
            </div>
        </div>
    </div>
	<?php 
		$currentLocation = 0;		
		$locationCounter = $redux_demo['home-location-counter'];		
		$locations = get_terms( array(
				'taxonomy' => 'location',
				'hide_empty' => false,
				'number'=> $locationCounter,
				'empty'=> 1
			) );
	?>
    <div class="row locations">
		<?php 
			foreach ($locations as $location) {
				if(!empty($location)){					
				$tag = $location->term_id;
				$term_meta = get_option( "taxonomy_term_$tag" );
				//print_r($location);
		?>
        <div class="large-4 medium-6 columns end">
            <div class="location-img">
                <img src="<?php  if (isset($term_meta["eralocation_id"])){ echo $term_meta["eralocation_id"];}else{ echo $locDefIMG; } ?>" alt="locations">
                <a class="text-center" href="<?php echo $locationURL; ?><?php echo wp_kses_post($location->name); ?>">  
                    <span class="location-details">
                        <span class="loc-title">
							<?php echo wp_kses_post($location->name); ?>
						</span>
                        <span class="ads-in-loc"><?php echo wp_kses_post($location->count); ?>
							<?php esc_html_e( 'Ads Available', 'classiera' ); ?>
						</span>
                    </span>
                </a>
            </div>
        </div>
		<?php 
				}
				$currentLocation++;
			}
		?>
		<?php wp_reset_query(); ?>        
    </div>
</section>
<!-- End Ad Locations -->