<?php
/**
 * Template Name: Contact
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that other
 * 'pages' on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage classiera
 * @since classiera 1.0
 */

global $redux_demo; 
$contactMAP = $redux_demo['contact-map'];
$contact_email = $redux_demo['contact-email'];
$classieraContactEmailError = $redux_demo['contact-email-error'];
$classieraContactNameError = $redux_demo['contact-name-error'];
$classieraConMsgError = $redux_demo['contact-message-error'];
$classieraContactThankyou = $redux_demo['contact-thankyou-message'];

$classieraContactLatitude = $redux_demo['contact-latitude'];
$classieraContactLongitude = $redux_demo['contact-longitude'];
$ClassieraContactZoomLevel = $redux_demo['contact-zoom'];
$contactDesc = $redux_demo['contact-description'];
$contactAddress = $redux_demo['contact-address'];
$contactPhone = $redux_demo['contact-phone'];
$contactPhone2 = $redux_demo['contact-phone2'];
$caticoncolor="";
$category_icon_code ="";
$category_icon="";
$category_icon_color="";


global $nameError;
global $emailError;
global $commentError;
global $subjectError;
global $humanTestError;

//If the form is submitted
if(isset($_POST['submitted'])) {
	
		//Check to make sure that the name field is not empty
		if(trim($_POST['contactName']) === '') {
			$nameError = $classieraContactNameError;
			$hasError = true;
		} elseif(trim($_POST['contactName']) === 'Name*') {
			$nameError = $classieraContactNameError;
			$hasError = true;
		}	else {
			$name = trim($_POST['contactName']);
		}

		//Check to make sure that the subject field is not empty
		if(trim($_POST['subject']) === '') {
			$subjectError = $classiera_contact_subject_error;
			$hasError = true;
		} elseif(trim($_POST['subject']) === 'Subject*') {
			$subjectError = $classiera_contact_subject_error;
			$hasError = true;
		}	else {
			$subject = trim($_POST['subject']);
		}
		
		//Check to make sure sure that a valid email address is submitted
		if(trim($_POST['email']) === '')  {
			$emailError = $classieraContactEmailError;
			$hasError = true;
		} else if (!preg_match("/^[A-Z0-9._%-]+@[A-Z0-9._%-]+\.[A-Z]{2,4}$/i", trim($_POST['email']))) {
			$emailError = $classieraContactEmailError;
			$hasError = true;
		} else {
			$email = trim($_POST['email']);
		}
			
		//Check to make sure comments were entered	
		if(trim($_POST['comments']) === '') {
			$commentError = $classieraConMsgError;
			$hasError = true;
		} else {
			if(function_exists('stripslashes')) {
				$comments = stripslashes(trim($_POST['comments']));
			} else {
				$comments = trim($_POST['comments']);
			}
		}

		//Check to make sure that the human test field is not empty
		$classieraCheckAnswer = $_POST['humanAnswer'];
		if(trim($_POST['humanTest']) != $classieraCheckAnswer) {
			$humanTestError = esc_html__('Not Human', 'classiera');
			$hasError = true;
		} else {

		}
			
		//If there is no error, send the email
		if(!isset($hasError)) {

			$emailTo = $contact_email;
			$subject = $subject;	
			$body = "Nume: $name \n\nEmail: $email \n\nComments: $comments";
			$headers = 'From website <'.$emailTo.'>' . "\r\n" . 'Reply-To: ' . $email;
			
			wp_mail($emailTo, $subject, $body, $headers);

			$emailSent = true;

	}
}

get_header(); ?>
<?php 
	$page = get_page($post->ID);
	$current_page_id = $page->ID;
?>
<?php $page_custom_title = get_post_meta($current_page_id, 'page_custom_title', true); ?>
<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
<?php $titleBg = $redux_demo['title-bg']['url']; ?>	
<section class="pageHeading" style="background:url(<?php echo $titleBg; ?>);">
    <div class="row">
        <h3><?php the_title(); ?></h3>
		<p><?php echo $page_custom_title; ?></p>
    </div>
</section><!-- End page Heading -->
<?php //the_content(); ?>

<!-- advertisement -->
<section id="advertisement" class="removeMargin noBorder">
	<div class="row">
		<div class="large-12 columns">
		<?php if($contactMAP == 1){?>
			<div id="map" class="contactMap">
				<div id="classiera-main-map"></div>
					<script type="text/javascript">
						var mapDiv,
							map,
							infobox;
						jQuery(document).ready(function($) {

							mapDiv = $("#classiera-main-map");
							mapDiv.height(500).gmap3({
								map: {
									options: {
										"center":[<?php echo $classieraContactLatitude; ?>,<?php echo $classieraContactLongitude; ?>],
										"zoom": <?php echo $ClassieraContactZoomLevel; ?>
										,"draggable": true
										,"mapTypeControl": true
										,"mapTypeId": google.maps.MapTypeId.ROADMAP
										,"scrollwheel": false
										,"panControl": true
										,"rotateControl": false
										,"scaleControl": true
										,"streetViewControl": true
										,"zoomControl": true
										<?php global $redux_demo; $map_style = $redux_demo['map-style']; if(!empty($map_style)) { ?>,"styles": <?php echo $map_style; ?> <?php } ?>
									}
								}
								,marker: {
									latLng: [<?php echo $classieraContactLatitude; ?>,<?php echo $classieraContactLongitude; ?>]
								}
							});

							map = mapDiv.gmap3("get");

							if (Modernizr.touch){
								map.setOptions({ draggable : false });
								var draggableClass = 'inactive';
								var draggableTitle = "Activate map";
								var draggableButton = $('<div class="draggable-toggle-button '+draggableClass+'">'+draggableTitle+'</div>').appendTo(mapDiv);
								draggableButton.click(function () {
									if($(this).hasClass('active')){
										$(this).removeClass('active').addClass('inactive').text("Activate map");
										map.setOptions({ draggable : false });
									} else {
										$(this).removeClass('inactive').addClass('active').text("Deactivate map");
										map.setOptions({ draggable : true });
									}
								});
							}

						});
					</script>
				
			</div>
		<?php }?>
			<div class="row">
				<div class="large-8 medium-8 columns">
					<!-- author Message -->
					<section class="authorMsg">
						<div class="authorHead">
                            <h4><?php esc_html_e('Contact Form', 'classiera') ?></h4>
                        </div>
						<div class="thanku">
							<?php if(isset($emailSent) && $emailSent == true) { ?>			
							<h5><?php echo $classieraContactThankyou ?></h5>
							<?php } else { ?>
							
							<?php if($nameError != '') { ?>							
							<h5><?php echo $nameError;?></h5> 
							<?php } ?>
							
							<?php if($emailError != '') { ?>							
							<h5><?php echo $emailError;?></h5>							
							<?php } ?>

							<?php if($subjectError != '') { ?>							
							<h5><?php echo $subjectError;?></h5> 							
							<?php } ?>
							
							<?php if($commentError != '') { ?>							
							<h5><?php echo $commentError;?></h5>							
							<?php } ?>

							<?php if($humanTestError != '') { ?>							
							<h5><?php echo $humanTestError;?></h5>							
							<?php } ?>
						</div>
						<div class="authorForm">
							<form name="contactForm" action="<?php the_permalink(); ?>" id="contact-form" method="post" class="contactform" >
								<div class="row">
									<div class="large-6 medium-6 columns">
										<div class="inner-addon left-addon">
											<i class="icon fa fa-user"></i>
											<input type="text" placeholder="<?php esc_html_e( 'Full name', 'classiera' ); ?>"  name="contactName" id="contactName" class="input-textarea half" />
										</div>
									</div>
									<div class="large-6 medium-6 columns">
										<div class="inner-addon left-addon">
											<i class="icon fa fa-envelope"></i>
											<input type="text" placeholder="<?php esc_html_e( 'Your Email', 'classiera' ); ?>" name="email" id="email" class="input-textarea half" />
										</div>
									</div>
									<div class="large-12 columns">
										<div class="inner-addon left-addon">
											<i class="icon fa fa-book"></i>
											<input type="text" placeholder="<?php esc_html_e( 'Subjest', 'classiera' ); ?>" name="subject" id="subject"  class="input-textarea" />
										</div>
									</div>
									<div class="large-12 columns">
										<div class="inner-addon left-addon">
											<textarea name="comments" id="commentsText" cols="8" rows="5" placeholder="<?php esc_html_e('Type Your Message here..', 'classiera' ); ?>"></textarea>
										</div>
									</div>
									<?php 
										$classieraFirstNumber = rand(1,9);
										$classieraLastNumber = rand(1,9);
										$classieraNumberAnswer = $classieraFirstNumber + $classieraLastNumber;
									?>
									<div class="large-6 medium-6 columns">
										<div class="inner-addon left-addon">
											<p>
											<?php esc_html_e('Human test. Please input the result of', 'classiera'); ?>
											<?php echo $classieraFirstNumber ?>&nbsp; + <?php echo $classieraLastNumber ?>
											</p>
										</div>
									</div>
									<div class="large-6 medium-6 columns">
										<div class="inner-addon left-addon">
											<i class="icon fa fa-pencil"></i>
											<input type="text" placeholder="<?php esc_html_e('Your Answer', 'classiera'); ?>" name="humanTest" id="humanTest" class="input-textarea half" />
											<input type="hidden" name="humanAnswer" id="humanAnswer" value="<?php echo $classieraNumberAnswer; ?>" />
										</div>
									</div>
									<div class="large-12 columns">
										<div class="inner-addon left-addon">
											<button class="button round btnfull input-submit" type="submit" value="submit" name="submitted"><?php esc_html_e('Send Message','classiera'); ?></button>											
										</div>
									</div>
								</div>
							</form>
						</div>
						<?php } ?>
					</section><!-- End author Message -->
				</div><!-- End Contact Div -->
				<div class="large-4 medium-4 columns">
					<div class="authorHead">
                        <h4><?php esc_html_e('Contact Info', 'classiera'); ?></h4>
                    </div>
					<div class="row">
                        <div class="large-12 columns">
                            <div class="contactText">
                                <p><?php echo $contactDesc; ?></p>
                            </div>
                        </div>
                    </div>
					<div class="row">
						<div class="large-12 columns">
						<?php if(!empty($contactAddress)){ ?>
                            <div class="row">
                                <div class="textContent clearfix">
                                    <div class="large-1 medium-1 columns">
                                        <i class="fa fa-map-marker"></i>
                                    </div>
                                    <div class="large-11 medium-11 columns">
                                        <h4><?php esc_html_e('Office Address', 'classiera'); ?></h4>
                                        <p><?php echo $contactAddress; ?></p>
                                    </div>
                                </div>
                            </div>
						<?php }?>
						<?php if(!empty($contact_email)){ ?>
                            <div class="row">
                                <div class="textContent clearfix">
                                    <div class="large-1 medium-1 columns">
                                        <i class="fa fa-envelope"></i>
                                    </div>
                                    <div class="large-11 medium-11 columns">
                                        <h4><?php esc_html_e('Email', 'classiera'); ?></h4>
                                        <p><?php echo $contact_email; ?></p>                                        
                                    </div>
                                </div>
                            </div>
						<?php }?>
						<?php if(!empty($contactPhone)){ ?>
                            <div class="row">
                                <div class="textContent clearfix">
                                    <div class="large-1 medium-1 columns">
                                        <i class="fa fa-phone"></i>
                                    </div>
                                    <div class="large-11 medium-11 columns">
                                        <h4><?php esc_html_e('Phone', 'classiera'); ?></h4>
                                        <p><?php echo $contactPhone; ?></p> 
										<p><?php echo $contactPhone2; ?></p>
                                    </div>
                                </div>
                            </div>
						<?php }?>	
                        </div><!--End Col-->						
					</div><!--End Row -->
				</div>
			</div>
		</div>
	</div>
</section>
<?php endwhile; endif; ?>
<!-- Company Section Start-->
<?php 
global $redux_demo; 
$classieraCompany = $redux_demo['partners-on'];
if($classieraCompany == 1){
	get_template_part('templates/company');
} ?>
<!-- Company Section End-->	
<?php get_footer(); ?>