<?php
/**
 * Template name: Edit Profile
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiera
 * @since classiera 1.0
 */

if ( !is_user_logged_in() ) { 

	global $redux_demo; 
	$login = $redux_demo['login'];
	wp_redirect( $login ); exit;

}



global $user_ID, $user_identity, $user_level;
global $redux_demo;
$caticoncolor="";
$category_icon_code ="";
$category_icon="";
$category_icon_color="";
$profile = $redux_demo['profile'];


if ($user_ID) {

	if($_POST) 

	{
		
		$message =  esc_html__( 'Your profile updated successfully.', 'classiera' );

		$first = $wpdb->escape($_POST['first_name']);

		$last = $wpdb->escape($_POST['last_name']);

		$email = $wpdb->escape($_POST['email']);

		$user_url = $wpdb->escape($_POST['website']);

		$user_phone = $wpdb->escape($_POST['phone']);
		
		$user_phone2 = $wpdb->escape($_POST['phone2']);
		$facebook = $wpdb->escape($_POST['facebook']);
		$twitter = $wpdb->escape($_POST['twitter']);
		$googleplus = $wpdb->escape($_POST['google-plus']);
		$linkedin = $wpdb->escape($_POST['linkedin']);
		$pinterest = $wpdb->escape($_POST['pinterest']);
		$instagram = $wpdb->escape($_POST['instagram']);

		$user_address = $wpdb->escape($_POST['address']);

		$description = $wpdb->escape($_POST['desc']);

		$password = $wpdb->escape($_POST['pwd']);

		$confirm_password = $wpdb->escape($_POST['confirm']);

		
		$your_image_url = $wpdb->escape($_POST['your_author_image_url']);

		update_user_meta( $user_ID, 'first_name', $first );

		update_user_meta( $user_ID, 'last_name', $last );

		update_user_meta( $user_ID, 'phone', $user_phone );
		update_user_meta( $user_ID, 'phone2', $user_phone2 );
		
		update_user_meta( $user_ID, 'facebook', $facebook );
		update_user_meta( $user_ID, 'twitter', $twitter );
		update_user_meta( $user_ID, 'googleplus', $googleplus );
		update_user_meta( $user_ID, 'linkedin', $linkedin );
		update_user_meta( $user_ID, 'pinterest', $pinterest );
		update_user_meta( $user_ID, 'instagram', $instagram );

		update_user_meta( $user_ID, 'address', $user_address );

		update_user_meta( $user_ID, 'description', $description );

		wp_update_user( array ('ID' => $user_ID, 'user_url' => $user_url) );
		
		if(!empty($your_image_url )){
		update_user_meta( $user_ID, 'classify_author_avatar_url', $your_image_url );
		}

		if(isset($email)) {

			if (preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/", $email)){ 

				wp_update_user( array ('ID' => $user_ID, 'user_email' => $email) ) ;

			}

			else { $message = esc_html__( 'Please Enter a Valid Email.', 'classiera' ); }

		}

		if($password) {

			if (strlen($password) < 5 || strlen($password) > 25) {
				$message =  esc_html__( 'Password must be 5 to 25 characters in length.', 'classiera' );
				}

			//elseif( $password == $confirm_password ) {
			$confirmPWD = $_POST['confirm'];
			$confirmPWD2 = $_POST['confirm2'];
			if(isset($confirmPWD) && $confirmPWD != $confirmPWD2) {

				$message =  esc_html__( 'Password Mismatch', 'classiera' );

			} elseif ( isset($confirmPWD) && !empty($password) ) {

				$update = wp_set_password( $confirmPWD, $user_ID );				
				$message =  esc_html__( 'Your profile updated successfully.', 'classiera' );

			}

		}

				

	}

}

get_header();

$profile = $redux_demo['profile'];
 ?>
<?php 
	$page = get_page($post->ID);
	$current_page_id = $page->ID;
?>
<?php $page_custom_title = get_post_meta($current_page_id, 'page_custom_title', true); ?> 
	
	<?php //while ( have_posts() ) : the_post(); ?>
<?php $titleBg = $redux_demo['title-bg']['url']; ?>		
<section class="pageHeading" style="background:url(<?php echo $titleBg; ?>);">
	<div class="row">
		<h3><?php the_title(); ?></h3>
		<p><?php echo $page_custom_title; ?></p>
	</div>
</section><!-- End page Heading -->
<!-- Advertisement Start-->
<section id="advertisement">
	<div class="row">
		<div class="large-8 medium-12 columns">
			<section class="adSubmit boxPad">
				<div class="adHeading">
					<i class="fa fa-gears"></i>
					<h4><?php esc_html_e( 'Profile Settings', 'classiera' ); ?></h4>
				</div>
				<div class="authorForm">
					<form class="form-item" action="" id="primaryPostForm" method="POST" enctype="multipart/form-data">
						<div class="row">
							<div class="large-12 columns">
								<div class="avatar boxPad">
									<div class="row">
										<div class="large-3 columns">
											<div class="uploadImage">
												<?php 
												require_once get_template_directory() . '/inc/BFI_Thumb.php';
												$author_avatar_url = get_user_meta($user_ID, "classify_author_avatar_url", true);
												if(!empty($author_avatar_url)) {
													$params = array( 'width' => 130, 'height' => 130, 'crop' => true );
													echo "<img class='author-avatar' src='" . bfi_thumb( "$author_avatar_url", $params ) . "' alt='' />";
												}else{
												?>
												<?php $avatar_url = classiera_get_avatar_url ( get_the_author_meta('user_email', $user_ID), $size = '130' ); ?>
												<img class="author-avatar" src="<?php echo $avatar_url; ?>" alt="" />
												<?php } ?>											
											</div>
										</div><!-- Autor Image Div End-->
										<div class="large-9 columns">
											<label for="file-upload" class="button round custom-file-upload removeMargin upload-author-image">
												<i class="fa fa-camera"></i> <?php esc_html_e( 'Upload Image', 'classiera' ); ?>
											</label>
											<input id="file-upload" class="removeMargin" type="file"/>
											<p><?php esc_html_e( 'Update your avatar manually,If the not set the default Gravatar will be the same as your login email/user account.', 'classiera' ); ?></p>
										</div><!-- Upload div End-->
									</div>		
								</div>
							</div>
						</div><!-- Upload Image Row-->
						<div class="row">
							<div class="large-12 medium-12 columns">
								<div class="form-heading">
									<p><?php esc_html_e( 'About Me', 'classiera' ); ?></p>
								</div>
							</div><!-- End About Me-->
							<?php if ($user_ID) {
								$user_info = get_userdata($user_ID);
								?>
							<?php if($_POST) { ?>
								<div class="large-12 medium-12 columns">
									<h4 class="success"><?php echo $message; ?></h4>
									<p><a class="button round" href="<?php echo $profile; ?>"><?php esc_html_e( 'View Profile', 'classiera' ); ?></a></p>									
								</div>	
							<?php } ?>	
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<input type="text" id="contactName" name="first_name" placeholder="<?php esc_html_e( 'First Name', 'classiera' ); ?>" class="text input-textarea half" value="<?php echo $user_info->first_name; ?>" />
								</div>
							</div><!-- End First Name-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<input type="text" id="contactName" name="last_name" placeholder="<?php esc_html_e( 'Last Name', 'classiera' ); ?>" class="text input-textarea half" value="<?php echo $user_info->last_name; ?>"/>
								</div>
							</div><!-- End Last Name-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<input class="criteria-image-url" id="your_image_url" type="text" size="36" name="your_author_image_url" style="display: none;" value="" />
								</div>
							</div><!-- End Upload Image-->
							<div class="large-12 medium-12 columns">
								<div class="inner-addon left-addon">
									<textarea name="desc" id="video" class="text" placeholder="<?php esc_html_e( 'About', 'classiera' ); ?>" rows="10"><?php echo $user_info->description; ?></textarea>
								</div>
							</div><!-- End Description Area-->
							<div class="large-12 medium-12 columns">
								<div class="form-heading">
									<p><?php esc_html_e( 'Contact Details', 'classiera' ); ?></p>
								</div>
							</div><!-- End Contact Details Heading-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-phone"></i>
									<input type="text" id="phone" name="phone" placeholder="<?php esc_html_e( 'Your Phone No', 'classiera' ); ?>" class="text input-textarea half" value="<?php echo $user_info->phone; ?>" />
								</div>
							</div><!-- End Phone Number-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-mobile"></i>
									<input type="text" id="phone2" name="phone2" placeholder="<?php esc_html_e( 'Your Phone No', 'classiera' ); ?>" class="text input-textarea half" value="<?php echo $user_info->phone2; ?>" /> 
								</div>
							</div><!-- End Second Phone Number-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-envelope"></i>
									<input type="text" id="email" name="email" placeholder="<?php esc_html_e( 'Your Email', 'classiera' ); ?>" class="text input-textarea half" value="<?php echo $user_info->user_email; ?>" />
								</div>
							</div><!-- End Email-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-globe"></i>
									<input type="text" id="website" name="website" placeholder="<?php esc_html_e( 'Your Website', 'classiera' ); ?>" class="text input-textarea half" value="<?php echo $user_info->user_url; ?>"/>
								</div>
							</div><!-- End Website-->
							<div class="large-12 medium-12 columns">
								<div class="form-heading">
									<p><?php esc_html_e( 'Social Media', 'classiera' ); ?></p>
								</div>
							</div><!-- End Social Media Heading-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-facebook"></i>
									<input type="text" id="facebook" name="facebook" placeholder="<?php esc_html_e( 'Facebook URL', 'classiera' ); ?>" class="text input-textarea half" value="<?php echo $user_info->facebook; ?>"/>
								</div>
							</div><!-- End Facebook URL-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-twitter"></i>
									<input type="text" id="twitter" name="twitter" placeholder="<?php esc_html_e( 'Twitter URL', 'classiera' ); ?>" class="text input-textarea half" value="<?php echo $user_info->twitter; ?>"/>
								</div>
							</div><!-- End twitter URL-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-google-plus"></i>
									<input type="text" id="google-plus" name="google-plus" placeholder="<?php esc_html_e( 'Google Plus URL', 'classiera' ); ?>" class="text input-textarea half" value="<?php echo $user_info->googleplus; ?>"/>
								</div>
							</div><!-- End Google plus URL-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-linkedin"></i>
									<input type="text" id="linkedin" name="linkedin" placeholder="<?php esc_html_e( 'Linkedin URL', 'classiera' ); ?>" class="text input-textarea half" value="<?php echo $user_info->linkedin; ?>"/>
								</div>
							</div><!-- End Linkedin URL-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-pinterest"></i>
									<input type="text" id="pinterest" name="pinterest" placeholder="<?php esc_html_e( 'Pinterest URL', 'classiera' ); ?>" class="text input-textarea half" value="<?php echo $user_info->pinterest; ?>"/>
								</div>
							</div><!-- End pinterest URL-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-instagram"></i>
									<input type="text" id="instagram" name="instagram" placeholder="<?php esc_html_e( 'Instagram URL', 'classiera' ); ?>" class="text input-textarea half" value="<?php echo $user_info->instagram; ?>"/>
								</div>
							</div><!-- End Instagram URL-->
							<div class="large-12 medium-12 columns">
								<div class="form-heading">
									<p><?php esc_html_e( 'Password Update', 'classiera' ); ?></p>
								</div>
							</div><!-- End Password Update Heading-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-instagram"></i>
									<input type="password" id="password" name="pwd" placeholder="<?php esc_html_e( 'type current password', 'classiera' ); ?>" class="text input-textarea half" maxlength="25" />
								</div>
							</div><!-- End type current password-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-instagram"></i>
									<input type="password" id="password" name="confirm" placeholder="<?php esc_html_e( 'type new password', 'classiera' ); ?>" class="text input-textarea half" maxlength="25" />
								</div>
							</div><!-- End type new password-->
							<div class="large-12 medium-12 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-instagram"></i>
									<input type="password" id="password" name="confirm2" placeholder="<?php esc_html_e( 're-type new password', 'classiera' ); ?>" class="text input-textarea half" maxlength="25" />
								</div>
							</div><!-- End re-type new password-->
							<p class="help-block"><?php esc_html_e('If you would like to change the password type a new one. Otherwise leave this blank.', 'classiera') ?></p>
							<div class="large-12 medium-12 columns">
								<?php wp_nonce_field('post_nonce', 'post_nonce_field'); ?>
								<input type="hidden" name="submitted" id="submitted" value="true" />
								<button class="button btnfull form-submit" id="edit-submit" name="op" value="Publish Ad" type="submit"><?php esc_html_e('Update Now', 'classiera') ?></button>
							</div>
							<?php }else{
								$redirect_to = home_url()."/login";//change this to your custom login url
								wp_safe_redirect($redirect_to);
							} ?>							
						</div><!-- Details Row-->
					</form>
				</div><!-- AuthorForm End-->
			</section>
		</div><!-- End Large 8 Content Area-->
		<!-- Sidebar Area Start -->
		<div class="large-4 medium-12 columns">
			<section class="sidebar">
				<div class="row">
					<div class="large-12 medium-6 columns medium-centered">
						<div class="widgetBox">
							<div class="widgetTitle">
								<i class="fa fa-user"></i>
								<h4><?php esc_html_e("ACCOUNT OVERVIEW", 'classiera') ?></h4>
							</div><!-- End widgetTitle -->
							<div class="widgetContent">
							<?php $profile = $redux_demo['profile']; ?>
							<?php require_once get_template_directory() . '/inc/BFI_Thumb.php'; ?>
								<div class="authorAccount">
									<div class="large-7 medium-8 large-centered medium-centered small-centered columns">
										<div class="widgetAuthorImg">
											<?php $author_avatar_url = get_user_meta($user_ID, "classify_author_avatar_url", true); 
											if(!empty($author_avatar_url)) {
												$params = array( 'width' => 120, 'height' => 120, 'crop' => true );
												echo "<img class='author-avatar' src='" . bfi_thumb( "$author_avatar_url", $params ) . "' alt='' />";
											}else{
												$avatar_url = classiera_get_avatar_url ( get_the_author_meta('user_email', $user_ID), $size = '150' );?>
												<img class="avatar" src="<?php echo $avatar_url; ?>" alt="" /><?php
											}
											?>
											<h5><?php echo $user_identity; ?></h5>
											<?php 
												$role = $current_user->roles;
												$classieraRole = $role[0];
											?>
											<p><?php classieraRoleTrns($classieraRole); ?> </p>
										</div><!-- End widgetAuthorImg -->
									</div><!-- End large-7 -->
									<ul class="authorList clearfix">
									<?php 
									global $redux_demo; 
									$allads = $redux_demo['all-ads'];
									$allFavourite = $redux_demo['all-favourite'];
									$newPostAds = $redux_demo['new_post'];
									?>
										<li>
											<a href="<?php echo $profile; ?>">
												<i class="fa fa-user"></i>
												<?php esc_html_e("About Me", 'classiera') ?>												
											</a>
                                        </li>
										<li>
											<a href="<?php echo $allads; ?>">
												<i class="fa fa-briefcase"></i>
												<?php esc_html_e("My Ads", 'classiera') ?>
												<span><?php echo count_user_posts($user_ID);?></span>
											</a>
                                        </li>
										<li>										
											<a href="<?php echo $allFavourite; ?>">
												<i class="fa fa-heart"></i>
												<?php esc_html_e("Favourites", 'classiera') ?>
												<span>
													<?php 
													global $current_user;
													wp_get_current_user();
													$user_id = $current_user->ID;
													$myarray = classiera_authors_all_favorite($user_id);
													if(!empty($myarray)){
														$args = array(
														   'post_type' => 'post',
														   'post__in'      => $myarray
														);
													$wp_query = new WP_Query( $args );
													$current = -1;
													$current2 = 0;
													while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; 
													//echo $current2;
													endwhile;
													echo $current2;
													}else{
														echo "0";
													}
													?>
												</span>
											</a>
										</li>
										<li>
											<a href="<?php echo $edit; ?>">
												<i class="fa fa-gears"></i>
												<?php esc_html_e("Profile Settings", 'classiera') ?>
											</a>
										</li>
										<li>
											<a href="<?php echo wp_logout_url(get_option('siteurl')); ?>">
												<i class="fa fa-sign-out"></i>
												<?php esc_html_e("Logout", 'classiera') ?>
											</a>
										</li>
										<li>
											<a href="<?php echo $newPostAds; ?>" class="button"><?php esc_html_e("POST NEW AD", 'classiera') ?></a>
											
										</li>
									</ul><!-- End UL authorList -->
								</div><!-- End authorAccount -->
							</div><!-- End widgetContent -->
						</div><!-- End widgetBox -->
					</div><!-- End large-12 -->
					<?php get_sidebar('pages'); ?>
				</div>
			</section>
		</div>
		<!-- Sidebar Area End-->
	</div>
</section>
<!-- Advertisement End-->
<?php //endwhile; ?>
<script>
	var image_custom_uploader;
	var $thisItem = '';

	jQuery(document).on('click','.upload-author-image', function(e) {
		e.preventDefault();

		$thisItem = jQuery(this);
		$form = jQuery('#primaryPostForm');

		//If the uploader object has already been created, reopen the dialog
		if (image_custom_uploader) {
			image_custom_uploader.open();
			return;
		}

		//Extend the wp.media object
		image_custom_uploader = wp.media.frames.file_frame = wp.media({
			title: 'Choose Image',
			button: {
				text: 'Choose Image'
			},
			multiple: false
		});

		//When a file is selected, grab the URL and set it as the text field's value
		image_custom_uploader.on('select', function() {
			attachment = image_custom_uploader.state().get('selection').first().toJSON();
			var url = '';
			url = attachment['url'];
			var attachId = '';
			attachId = attachment['id'];
			$thisItem.parent().parent().find( "img.author-avatar" ).attr({
				src: url
			});
		  $form.parent().parent().find( ".criteria-image-url" ).attr({
				value: url
			});
			$form.parent().parent().find( ".criteria-image-id" ).attr({
				value: attachId
			});
		});

		//Open the uploader dialog
		image_custom_uploader.open();
	});

	jQuery(document).on('click','.delete-author-image', function(e) {
		jQuery(this).parent().parent().find( ".criteria-image-url" ).attr({
		   value: ''
		});
		jQuery(this).parent().parent().find( "img.author-avatar" ).attr({
			 src: ''
		});
	});
</script>
<?php get_footer(); ?>