<?php
/**
 * The template for displaying archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each one. For example, tag.php (Tag archives),
 * category.php (Category archives), author.php (Author archives), etc.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage FoundationPress
 * @since FoundationPress 1.0
 */

get_header(); 
$trns_skeywords = $redux_demo['trns_skeywords'];
$classieraMAPonCategory = $redux_demo['map-on-category'];

	global $redux_demo, $maximRange; 
	$max_range = $redux_demo['max_range'];
	if(!empty($max_range)) {
		$maximRange = $max_range;
	} else {
		$maximRange = 1000;
	}
$titleBg = $redux_demo['title-bg']['url'];
$caticoncolor="";
$category_icon_code ="";
$category_icon="";
$category_icon_color="";
$your_image_url = "";

?>
<section class="pageHeading removeMargin smallMarg" style="background:url(<?php echo $titleBg; ?>);">
	<div class="row">
		<h3>
		<?php
		global $paged, $wp_query, $wp;
		$args = wp_parse_args($wp->matched_query);
		if ( !empty ( $args['paged'] ) && 0 == $paged ) {
			$wp_query->set('paged', $args['paged']);
			$paged = $args['paged'];
		}
			if ( is_day() ) :
				printf( __( 'Daily Archives: %s', 'classiera' ), get_the_date() );
				$archive_year  = get_the_date('Y'); 
				$archive_month = get_the_date('m'); 
				$archive_day   = get_the_date('d');
				global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post');
				global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'post_type' => 'post', 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
				global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post', 'orderby' => 'title');
			
			elseif ( is_month() ) :
				printf( __( 'Monthly Archives: %s', 'classiera' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'classiera' ) ) );
				$archive_year  = get_the_date('Y'); 
				$archive_month = get_the_date('m');
				global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post');
				global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'post_type' => 'post', 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
				global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post', 'orderby' => 'title');
			
			elseif ( is_year() ) :
				printf( __( 'Yearly Archives: %s', 'classiera' ), get_the_date( _x( 'Y', 'yearly archives date format', 'classiera' ) ) );
				$archive_year  = get_the_date('Y'); 
				global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC');
				global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
				global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC', 'orderby' => 'title');
			
			elseif ( is_tag() ) :
				printf( __( single_tag_title('Tag:', 'classiera') ) );
				global $wp_query;
				$tag = $wp_query->get_queried_object();
				$current_tag = $tag->term_id;

				global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC');
				global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
				global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC', 'orderby' => 'title');
				
			else :
				esc_html_e( 'Archives', 'classiera' );
			endif;	
		?>
		</h3>		
	</div>
</section><!-- End page Heading -->

<!--Section MAP Start -->
<?php if($classieraMAPonCategory == 1){?>
<section id="big-map">
		<div class="mainSearch">
		<div id="classiera-main-map"></div>

		<script type="text/javascript">
		var mapDiv,
			map,
			infobox;
		jQuery(document).ready(function($) {

			mapDiv = $("#classiera-main-map");
			mapDiv.height(650).gmap3({
				map: {
					options: {
						"draggable": true
						,"mapTypeControl": true
						,"mapTypeId": google.maps.MapTypeId.ROADMAP
						,"scrollwheel": false
						,"panControl": true
						,"rotateControl": false
						,"scaleControl": true
						,"streetViewControl": true
						,"zoomControl": true
						<?php global $redux_demo; $map_style = $redux_demo['map-style']; if(!empty($map_style)) { ?>,"styles": <?php echo $map_style; ?> <?php } ?>
					}
				}
				,marker: {
					values: [

					<?php

						$wp_query= null;

						$wp_query = new WP_Query();

						$wp_query->query('post_type=post&posts_per_page=-1');

						


						while ($wp_query->have_posts()) : $wp_query->the_post(); 

						$post_latitude = get_post_meta($post->ID, 'post_latitude', true);
						$post_longitude = get_post_meta($post->ID, 'post_longitude', true);

						$theTitle = get_the_title(); 

						$post_price = get_post_meta($post->ID, 'post_price', true);


						$category = get_the_category();

						$tag = $category[0]->cat_ID;						

							$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
							if (isset($tag_extra_fields[$tag])) {
								$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
								$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
								$your_image_url = $tag_extra_fields[$tag]['your_image_url'];
							}

						if (empty($category_icon_code) || empty($category_icon_color) || empty($your_image_url)) {

							$tag = $category[0]->category_parent;

							$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
							if (isset($tag_extra_fields[$tag])) {
								if (empty($category_icon_code)){
									$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
								}
								if (empty($category_icon_color)){
									$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
								}
								if (empty($your_image_url)){
									$your_image_url = $tag_extra_fields[$tag]['your_image_url'];
								}
							}

						}
						if(!empty($category_icon_code)) {

							$category_icon = stripslashes($category_icon_code);

					     }
						if(!empty($your_image_url)) {

					    	$iconPath = $your_image_url;

					    } else {

					    	$iconPath = get_template_directory_uri() .'/images/icon-services.png';

					    }

						if(!empty($post_latitude)) {?>

							 	{
							 		
									<?php require_once get_template_directory() . '/inc/BFI_Thumb.php'; ?>
									<?php 
									$imageurl = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'classiera-grid');
									$thumb_id = get_post_thumbnail_id($post->id);
									$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
									?>

									latLng: [<?php echo $post_latitude; ?>,<?php echo $post_longitude; ?>],
									options: {
										icon: "<?php echo $iconPath; ?>",
										shadow: "<?php echo get_template_directory_uri() ?>/images/shadow.png",
									},
									data: '<section id="advertisement" class="removePad removeMargin noBorder"><div class="row"><div class="advContent"><div class="tabs-content removeMargin"><div class="large-10 medium-12 columns advItems end removeMargin"><div class="advItem"> <div class="advItem-img" id="AdvMapImg"><img src="<?php echo $imageurl[0]; ?>" alt="<?php if(empty($alt)){echo "Image";}else{ echo $alt; } ; ?>" /></div><span class="price" style="background-color:<?php echo $category_icon_color; ?>"><?php echo $post_price; ?></span><a class="hover" href="<?php the_permalink(); ?>"></a><div class="info"><a href="<?php the_permalink(); ?>"><i class="<?php echo $category_icon_code; ?>" style="background-color:<?php echo $category_icon_color; ?>"></i><span class="title"><?php echo $theTitle; ?></span><span class="cat">category &nbsp;:&nbsp;<?php echo $postCatgory[0]->name; ?><span></a></div></div></div></div><div class="close" style="background-color:<?php echo $category_icon_color; ?>"></div></div></div></section>'
								}
							,

					<?php } endwhile; ?>	

					<?php wp_reset_query(); ?>
						
					],
					options:{
						draggable: false
					},
					
					events: {
						click: function(marker, event, context){
							map.panTo(marker.getPosition());

							var ibOptions = {
							    pixelOffset: new google.maps.Size(-125, -88),
							    alignBottom: true
							};

							infobox.setOptions(ibOptions)

							infobox.setContent(context.data);
							infobox.open(map,marker);

							// if map is small
							var iWidth = 370;
							var iHeight = 370;
							if((mapDiv.width() / 2) < iWidth ){
								var offsetX = iWidth - (mapDiv.width() / 2);
								map.panBy(offsetX,0);
							}
							if((mapDiv.height() / 2) < iHeight ){
								var offsetY = -(iHeight - (mapDiv.height() / 2));
								map.panBy(0,offsetY);
							}

						}
					}
				}
				 		 	},"autofit");

			map = mapDiv.gmap3("get");
		    infobox = new InfoBox({
		    	pixelOffset: new google.maps.Size(-50, -65),
		    	closeBoxURL: '',
		    	enableEventPropagation: true
		    });
		    mapDiv.delegate('.infoBox .close','click',function () {
		    	infobox.close();
		    });

		    if (Modernizr.touch){
		    	map.setOptions({ draggable : false });
		        var draggableClass = 'inactive';
		        var draggableTitle = "Activate map";
		        var draggableButton = $('<div class="draggable-toggle-button '+draggableClass+'">'+draggableTitle+'</div>').appendTo(mapDiv);
		        draggableButton.click(function () {
		        	if($(this).hasClass('active')){
		        		$(this).removeClass('active').addClass('inactive').text("Activate map");
		        		map.setOptions({ draggable : false });
		        	} else {
		        		$(this).removeClass('inactive').addClass('active').text("Deactivate map");
		        		map.setOptions({ draggable : true });
		        	}
		        });
		    }

		jQuery( "#advance-search-slider" ).slider({
		      	range: "min",
		      	value: 500,
		      	min: 1,
		      	max: <?php echo $maximRange; ?>,
		      	slide: function( event, ui ) {
		       		jQuery( "#geo-radius" ).val( ui.value );
		       		jQuery( "#geo-radius-search" ).val( ui.value );

		       		jQuery( ".geo-location-switch" ).removeClass("off");
		      	 	jQuery( ".geo-location-switch" ).addClass("on");
		      	 	jQuery( "#geo-location" ).val("on");

		       		mapDiv.gmap3({
						getgeoloc:{
							callback : function(latLng){
								if (latLng){
									jQuery('#geo-search-lat').val(latLng.lat());
									jQuery('#geo-search-lng').val(latLng.lng());
								}
							}
						}
					});

		      	}
		    });
		    jQuery( "#geo-radius" ).val( jQuery( "#advance-search-slider" ).slider( "value" ) );
		    jQuery( "#geo-radius-search" ).val( jQuery( "#advance-search-slider" ).slider( "value" ) );

		    jQuery('.geo-location-button .fa').click(function()
			{
				
				if(jQuery('.geo-location-switch').hasClass('off'))
			    {
			        jQuery( ".geo-location-switch" ).removeClass("off");
				    jQuery( ".geo-location-switch" ).addClass("on");
				    jQuery( "#geo-location" ).val("on");

				    mapDiv.gmap3({
						getgeoloc:{
							callback : function(latLng){
								if (latLng){
									jQuery('#geo-search-lat').val(latLng.lat());
									jQuery('#geo-search-lng').val(latLng.lng());
								}
							}
						}
					});

			    } else {
			    	jQuery( ".geo-location-switch" ).removeClass("on");
				    jQuery( ".geo-location-switch" ).addClass("off");
				    jQuery( "#geo-location" ).val("off");
			    }
		           
		    });

		});
		</script>

		<?php 

			global $redux_demo; 			

		?>
	

		<!--Search Section Start -->
		<div class="advanceSearch">
			<div class="advSearchBtn"><!--Search bar hide Show Button -->
				<div class="row">
					<a id="searchbtn" href="#">
						<i class="fa fa-search"></i>
						<span><?php esc_html_e( 'Advance Search', 'classiera' ); ?></span>
						<i class="fa fa-caret-down"></i>
					</a>
				</div>
			</div><!--END Search bar hide Show Button -->
			<div class="advSeachBar"><!--AdvSeachBar Start -->
				<div class="row"><!--row Start -->
					<form action="<?php echo home_url(); ?>" method="get" id="views-exposed-form-search-view-other-ads-page" accept-charset="UTF-8">
						<input placeholder="<?php esc_html_e( 'Enter keyword...', 'classiera' ); ?>" type="text" id="edit-search-api-views-fulltext" name="s" value="" size="30" maxlength="128" class="form-text">
						<input type="hidden" id="hidden-keyword" name="s" value="all" size="30" maxlength="128" class="form-text">
						<!--Select Category-->
						<select id="edit-field-category" name="category_name" class="form-select">
							<option value="All" selected="selected"><?php esc_html_e( 'Category...', 'classiera' ); ?></option>
							<?php
							$args = array(
								'hierarchical' => '0',
								'hide_empty' => '0'
							);
							$categories = get_categories($args);
							foreach ($categories as $cat) {
								if ($cat->category_parent == 0) { 
									$catID = $cat->cat_ID;
									?>
									<option value="<?php echo $cat->slug; ?>"><?php echo $cat->cat_name; ?></option>
									<?php 
									$args2 = array(
										'hide_empty' => '0',
										'parent' => $catID
									);
									$categories = get_categories($args2);
									foreach ($categories as $cat) { ?>
									<option value="<?php echo $cat->slug; ?>">- <?php echo $cat->cat_name; ?></option>
									<?php } ?>
								<?php } else { ?>
								<?php }
							} ?>

						</select>
						<!--Select Category -->
						<!--Choose Location-->
						<select id="edit-ad-location" name="post_location" class="form-select">
							<option value="All" selected="selected"><?php esc_html_e( 'Location...', 'classiera' ); ?></option>
							<?php
							$args_location = array( 'posts_per_page' => -1 );
							$lastposts = get_posts( $args_location );
							$all_post_location = array();
							foreach( $lastposts as $post ) {
								$all_post_location[] = get_post_meta( $post->ID, 'post_location', true );
							}
							$directors = array_unique($all_post_location);
							foreach ($directors as $director) { ?>
								<option value="<?php echo $director; ?>"><?php echo $director; ?></option>
							<?php }?>
							<?php wp_reset_query(); ?>
						</select>
						<!--End Choose Location -->
						<!--Range Slider --->
						<div class="range"> 
							<div class="range-slider round" data-slider data-options="display_selector: #sliderOutput3;">
							  <span class="range-slider-handle" role="slider" aria-valuenow="50" aria-valuemin="1" aria-valuemax="1000">
								 <span class="range-slider-out" id="sliderOutput3"></span>
							  </span>
							  <span class="range-slider-active-segment"></span>
							</div>
						</div>
						
						<input type="text" name="geo-location" id="geo-location" value="off" data-default-value="off">
						<input type="text" name="geo-radius-search" id="geo-radius-search" value="500" data-default-value="500">
						<input type="text" name="geo-search-lat" id="geo-search-lat" value="0" data-default-value="0">
						<input type="text" name="geo-search-lng" id="geo-search-lng" value="0" data-default-value="0">
						<!--End Range Slider -->
						<button class="btn btn-primary form-submit submit" id="edit-submit-search-view" name="search" value="Search" type="submit">
                                <span><?php esc_html_e( 'Search Now', 'classiera' ); ?></span>
                                <i class="fa fa-search"></i>
                        </button>
					</form>
				</div><!--row END -->
			</div><!--AdvSeachBar END -->
		</div>
		<!--END Search Section -->


		</div>
	</section>
<?php }else{
	?>
	<script type="text/javascript">
	jQuery(document).ready(function($) {

	jQuery( "#advance-search-slider" ).slider({
			range: "min",
			value: 500,
			min: 1,
			max: <?php echo $maximRange; ?>,
			slide: function( event, ui ) {
				jQuery( "#geo-radius" ).val( ui.value );
				jQuery( "#geo-radius-search" ).val( ui.value );

				jQuery( ".geo-location-switch" ).removeClass("off");
				jQuery( ".geo-location-switch" ).addClass("on");
				jQuery( "#geo-location" ).val("on");

				

			}
		});
		});
	</script>
	<section class="withoutslider archivepage">
		<div class="mainSearch">
			<!--Search Section Start -->
			<div class="advanceSearch">			
				<div class="advSeachBar"><!--AdvSeachBar Start -->
					<div class="row"><!--row Start -->
						<form action="<?php echo home_url(); ?>" method="get" id="views-exposed-form-search-view-other-ads-page" accept-charset="UTF-8">
							<input placeholder="<?php esc_html_e( 'Enter keyword...', 'classiera' ); ?>" type="text" id="edit-search-api-views-fulltext" name="s" value="" size="30" maxlength="128" class="form-text classieraSearchAJax">
							<span class="load-gif"><img src="<?php echo get_template_directory_uri().'/images/load.gif' ?>" alt="classiera loader"></span>
							<ul class="classieraAjaxResult"></ul>						
							<!--Select Category-->
							<?php $turnonsearchcat = $redux_demo['turnonsearchcat']; ?>
							<?php if($turnonsearchcat == 1){?>
							<select id="edit-field-category" name="category_name" class="form-select homeCategory" data-placeholder="<?php esc_html_e('Select Category..', 'classiera'); ?>">
								<option value="All"></option>
								<?php
								$args = array(
									'hierarchical' => '0',
									'hide_empty' => '0'
								);
								$categories = get_categories($args);
								foreach ($categories as $cat) {
									if ($cat->category_parent == 0) { 
										$catID = $cat->cat_ID;
										?>
										<option value="<?php echo $cat->slug; ?>"><?php echo $cat->cat_name; ?></option>
										<?php 
										$args2 = array(
											'hide_empty' => '0',
											'parent' => $catID
										);
										$categories = get_categories($args2);
										foreach ($categories as $cat) { ?>
										<option value="<?php echo $cat->slug; ?>">- <?php echo $cat->cat_name; ?></option>
										<?php } ?>
									<?php } else { ?>
									<?php }
								} ?>

							</select>
							<?php } ?>
							<!--Select Category -->
							<!--Choose Location-->
							<?php $turnonsearchloc = $redux_demo['turnonsearchloc']; ?>
							<?php if($turnonsearchloc == 1){?>
							<select id="edit-ad-location" name="post_location" class="form-select homeCategory" data-placeholder="<?php esc_html_e('Select Location', 'classiera'); ?>">
								<option value="All"></option>
								<?php
								$args_location = array( 'posts_per_page' => -1 );
								$lastposts = get_posts( $args_location );
								$all_post_location = array();
								foreach( $lastposts as $post ) {
									$all_post_location[] = get_post_meta( $post->ID, 'post_location', true );
								}
								$directors = array_unique($all_post_location);
								foreach ($directors as $director) { ?>
									<option value="<?php echo $director; ?>"><?php echo $director; ?></option>
								<?php }?>
								<?php wp_reset_query(); ?>
							</select>
							<?php } ?>
							<!--End Choose Location -->
							<!--Range Slider --->
							<?php $turnonsearchrange = $redux_demo['turnonsearchrange']; ?>
							<?php if($turnonsearchrange == 1){?>
							<div class="range"> 
								<div class="range-slider round" data-slider data-options="display_selector: #sliderOutput3;">
								  <span class="range-slider-handle" role="slider" aria-valuenow="50" aria-valuemin="1" aria-valuemax="1000">
									 <span class="range-slider-out" id="sliderOutput3"></span>
								  </span>
								  <span class="range-slider-active-segment"></span>
								</div>
							</div>
							<?php } ?>
							<input type="text" name="geo-location" id="geo-location" value="off" data-default-value="off">
							<input type="text" name="geo-radius-search" id="geo-radius-search" value="500" data-default-value="500">
							<input type="text" name="geo-search-lat" id="geo-search-lat" value="0" data-default-value="0">
							<input type="text" name="geo-search-lng" id="geo-search-lng" value="0" data-default-value="0">
							<!--End Range Slider -->
							<button class="btn btn-primary form-submit submit" id="edit-submit-search-view" name="search" value="Search" type="submit">
									<span><?php esc_html_e( 'Search Now', 'classiera' ); ?></span>
									<i class="fa fa-search"></i>
							</button>
						</form>
					</div><!--row END -->
				</div><!--AdvSeachBar END -->
			</div>
			<!--END Search Section -->
		<div>	
	</section>
	<script>
	jQuery(document).ready(function(){
		jQuery(".homeCategory").chosen();	
	});
	</script>
	<?php
	} ?>	
<!--Section MAP END -->

<!-- Premium Advertisement -->
<?php 
	global $redux_demo;
	$featured_ads_option = $redux_demo['featured-options-on'];
	$premiumSECtitle = $redux_demo['premium-sec-title'];
	$premiumSECdesc = $redux_demo['premium-sec-desc'];
	if($featured_ads_option == 1) { 
?>
<section id="premiumAdv">
<?php 
global $paged, $wp_query, $wp;
$args = wp_parse_args($wp->matched_query);
	if ( !empty ( $args['paged'] ) && 0 == $paged ) {
		$wp_query->set('paged', $args['paged']);
		$paged = $args['paged'];
	}
	if ( is_day() ) :
		$archive_year  = get_the_date('Y');
		$archive_month = get_the_date('m');
		$archive_day   = get_the_date('d');
		
		global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post');
	
	elseif ( is_month() ) :
		$archive_year  = get_the_date('Y'); 
		$archive_month = get_the_date('m');
		
		global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post');
		
	elseif ( is_year() ) :

		$archive_year  = get_the_date('Y');
		global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC');
		
	elseif ( is_tag() ) :
		global $wp_query;
		$tag = $wp_query->get_queried_object();
		$current_tag = $tag->term_id;
		global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC');
		
	else :
	endif;

?>
	<div class="row">
		<div class="mainHeading">
			<div class="large-7 medium-8 large-centered medium-centered columns">
				<h2><?php echo $premiumSECtitle;?></h2>
				<p><span class="line"><i class="fa fa-circle"></i></span></p>
				<p><?php echo $premiumSECdesc;?></p>
			</div>
		</div><!--End mainHeading-->
	</div><!--End Heading row-->
	<div class="customNavigation">
		<div class="row">
			<div class="medium-4 medium-centered columns">
			<?php 
				$previous = $redux_demo['trns-btn-previous'];
				$next = $redux_demo['trns-btn-next'];
				$caraCategory = $redux_demo['trns-cara-cat'];
			?>
				<div class="navText">
					<a class="prev"><i class="fa fa-angle-left"></i></a>
					<span><?php echo $previous;?></span>
					<span><?php echo $next;?></span>
					<a class="next"><i class="fa fa-angle-right"></i></a>
				</div>
			</div>
		</div>
	</div><!--End customNavigation-->
		<!--Start Premium Carousel-->
	<div id="owl-demo" class="owl-carousel">
			<?php 
				$cat_id = get_cat_ID(single_cat_title('', false)); 				
				$wp_query= null;
				$wp_query = new WP_Query();
				$wp_query->query($args);				
				$current = -1;
				
			?>
			<?php while ($wp_query->have_posts()) : $wp_query->the_post();
				$featuredMeta = get_post_meta($post->ID, 'featured_post', true);
				if($featuredCatOn == 1){
					$featured_post = "1";
				}else{
					$featured_post = "0";
				}
				$post_price_plan_activation_date = get_post_meta($post->ID, 'post_price_plan_activation_date', true);
				$post_price_plan_expiration_date = get_post_meta($post->ID, 'post_price_plan_expiration_date', true);
				$post_price_plan_expiration_date_noarmal = get_post_meta($post->ID, 'post_price_plan_expiration_date_normal', true);
				$todayDate = strtotime(date('m/d/Y h:i:s'));
				$expireDate = $post_price_plan_expiration_date;
				if(!empty($post_price_plan_activation_date) && $featuredMeta == 1) {
					if(($todayDate < $expireDate) or $post_price_plan_expiration_date == 0) {
						$featured_post = "1";
					}
				}elseif($featuredMeta == 1){
					$featured_post = "1";
				}
			
			?>
			<?php if($featured_post == "1") {
					$current++;
			?>
			<div class="item">
				<div class="carousel">
				<?php
					$postTiti= get_the_title();
					if ( has_post_thumbnail()) {
						$premiumAimage = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'large');
						$thumbImg = get_the_post_thumbnail($post->ID, '270x220');						
						
						echo $thumbImg;
					}else{
						?>
						<img src="<?php echo get_template_directory_uri() . '/images/nothumb/nothumbpslider.png' ?>" alt="No Thumb"/>
						<?php
					}					
				?>
				<?php
					$post_price = get_post_meta($post->ID, 'post_price', true);
					if(!empty($post_price)){								
					?>
						<span class="price"><?php echo $post_price; ?></span>
					<?php } ?>
					<div class="hover">
						<?php 
							$category = get_the_category();
							if ($category[0]->category_parent == 0) {
								$tag = $category[0]->cat_ID;
								$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
								if (isset($tag_extra_fields[$tag])) {
									$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
									$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
								}
							}else{
								$tag = $category[0]->category_parent;
								$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
								if (isset($tag_extra_fields[$tag])) {
									$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
									$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
								}
							}
							if(!empty($category_icon_code)) {
								$catIcon = stripslashes($category_icon_code);
							}
							$category_icon_code = "";
							$postCatgory = get_the_category( $post->ID );
						?>
						<a href="<?php the_permalink(); ?>">						
							<span class="info">
								<i class="<?php echo $catIcon; ?>" style="background-color:<?php echo $category_icon_color; ?>"></i>
								<span class="title"><?php echo $postTiti; ?></span>
								<small><?php echo $caraCategory; ?> :
								<?php echo $postCatgory[0]->name; ?></small>
							</span>
						</a>
					</div>
				</div>
				
			</div>
	<?php }?>
			<?php endwhile; ?>
			<?php wp_reset_query(); ?>			
	</div><!--End Premium Carousel-->
</section><!--End premiumAdv-->
<!-- End Premium Advertisement -->	
<?php } ?>
		<?php 
			global $current_view_type;
			global $permalink_type;
			global $redux_demo;
			$ad_desc = $redux_demo['ad-desc'];
			$category_icon_code = "";
			$category_icon_color = "";
			$your_image_url = "";
			$category_icon="";
			$caticoncolor="";
			$Viewswitch = $redux_demo['home-ads-view'];
if($Viewswitch == 'list'){			
		?>
<!-- Advertisement Section Start -->
<section id="advertisement">
	<div class="row">
		<div class="mainHeading">
			<div class="large-7 medium-8 large-centered medium-centered columns">
				<h2><?php esc_html_e( 'ADVERTISEMENTS', 'classiera' ); ?></h2>
				<p><span class="line"><i class="fa fa-circle"></i></span></p>
				<?php if(!empty($ad_desc)){ ?>
				<p><?php echo $ad_desc; ?></p>
				<?php } ?>
			</div>
		</div>
	</div><!-- END Heading Row-->	
	<div class="row">
		<div class="advContent">
			<div class="tabs-content listView clearfix">
				<div class="content active" id="panel1">
				<?php 
					global $paged, $wp_query, $wp;
					$args = wp_parse_args($wp->matched_query);
					if ( !empty ( $args['paged'] ) && 0 == $paged ) {
						$wp_query->set('paged', $args['paged']);
						$paged = $args['paged'];
					}
					if ( is_day() ) :
						$archive_year  = get_the_date('Y'); 
						$archive_month = get_the_date('m'); 
						$archive_day   = get_the_date('d');
						global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post');
						global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'post_type' => 'post', 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
						global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post', 'orderby' => 'title');
						
					elseif ( is_month() ) :	
						$archive_year  = get_the_date('Y'); 
						$archive_month = get_the_date('m');
						global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post');
						global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'post_type' => 'post', 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
						global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post', 'orderby' => 'title');
					
					elseif ( is_year() ) :
						$archive_year  = get_the_date('Y'); 
						global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC');
						global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
						global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC', 'orderby' => 'title');
					
					elseif ( is_tag() ) :
						global $wp_query;
						$tag = $wp_query->get_queried_object();
						$current_tag = $tag->term_id;
						global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC');
						global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
						global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC', 'orderby' => 'title');
						
					else :
					endif;					
				?>
				<?php
					$wp_query= null;
					$wp_query = new WP_Query();
					$wp_query->query($args);
					$current = -1;
					$current2 = 0;

				?>
				<?php while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; ?>
					<div class="large-12 medium-12 columns advItems end">
						<?php 
						/*Get Category Extra Fields For Price Icon Background */
							$category = get_the_category();
								if ($category[0]->category_parent == 0) {
									$tag = $category[0]->cat_ID;
									$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
									if (isset($tag_extra_fields[$tag])) {
										$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
										$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
									}
								}else{
									$tag = $category[0]->category_parent;
									$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
									if (isset($tag_extra_fields[$tag])) {
										$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
										$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
									}
								}
								if(!empty($category_icon_code)) {
									$category_icon = stripslashes($category_icon_code);
								}
								$category_icon_code = "";
								$postCatgory = get_the_category( $post->ID );
								$post_price = get_post_meta($post->ID, 'post_price', true);
								$comments_count = wp_count_comments( $post->ID  );
								$approvedComment = $comments_count->approved;
						/*Get Category Extra Fields For Price Icon Background */
						?>
						<article class="listAdv">
							<div class="row">
								<div class="large-3 medium-4 column">
									<div class="list-img">
										<?php if(!empty($post_price)){ ?>
										<span class="listPrice" style="background-color:<?php echo $category_icon_color; ?>"><?php echo $post_price; ?></span>
										<?php }?>
										<?php /*Start Image */
										if ( has_post_thumbnail()) {
											$imageurl = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'classiera-list');
											$thumb_id = get_post_thumbnail_id($post->id);
											$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
											?>
											<div class="advList-img">
												<img src="<?php echo $imageurl[0]; ?>" alt="<?php if(empty($alt)){echo "Image";}else{ echo $alt; } ; ?>"/>
											</div>
											<?php										
										}else{
											?>
											<div class="advList-img">
												<img src="<?php echo get_template_directory_uri() . '/images/nothumb/nothumb270x250.png' ?>" alt="No Thumb"/>
											</div>
											<?php 
										}
										
									/*End Image */?>
										<div class="listcomment">
											<span><?php echo $approvedComment; ?></span>
											<i class="fa fa-comments"></i>
											<span><?php echo classiera_get_post_views($post->ID); ?></span>
											<i class="fa fa-eye"></i>
										</div>	<!-- End listcomment-->
									</div>
								</div><!-- End large-3 medium-4 column-->
								<div class="large-9 medium-8 column">
									<div class="listAdv-desc">
										<div class="row collapse">
											<div class="large-6 medium-7 columns">
												<div class="listAdv-desc-header">
													<div class="icon">
														<i class="<?php echo $category_icon; ?>" style="background-color:<?php echo $category_icon_color; ?>"></i>
														<h4><a href="<?php the_permalink(); ?>"><?php $theTitle = get_the_title(); $theTitle = (strlen($theTitle) > 25) ? substr($theTitle,0,25).'...' : $theTitle; echo $theTitle; ?></a></h4>
														<span><?php esc_html_e( 'Category', 'classiera' ); ?> &nbsp;:&nbsp;<?php echo $postCatgory[0]->name; ?></span>
													</div>
												</div>
											</div><!-- large-9-->
											<div class="large-6 medium-5 column">
											<?php if(function_exists('the_ratings')) { ?>
												<div class="rating">
													<?php the_ratings(); ?>
												</div>
											<?php } ?>	
											</div><!-- large-3-->
										</div><!-- listAdv First Row-->
										<div class="row collapse">
											<div class="large-12 columns">
												<div class="listAdv-desc-detail">
													<?php echo substr(get_the_excerpt(), 0,260); ?>
												</div>
											</div>
										</div><!-- listAdv second Row-->
										<div class="row collapse">
											<div class="listAdv-tags clearfix">
												<div class="large-6 medium-7 columns">
													<div class="listTags">
														<i class="fa fa-tags"></i>
														<span><?php esc_html_e('Tags', 'classiera'); ?>:</span>
														<?php the_tags('','',''); ?>
													</div><!-- listTags-->
												</div><!-- large-6-->
												<div class="large-6 medium-5 columns">
													<div class="listReadMore">
														<a href="<?php the_permalink(); ?>">
														<?php esc_html_e( 'Read More', 'classiera' ); ?>
														</a>
													</div>
												</div><!-- large-6 medium-5-->
											</div><!-- listAdv-tags-->
										</div><!-- listAdv third Row-->
									</div><!-- listAdv-desc-->
								</div><!-- large-9 medium-8 column-->
							</div><!-- End Article Main Row-->
						</article>
					</div><!-- END large-12-->
					<?php endwhile; ?>
					<?php get_template_part('pagination'); ?>
					<?php wp_reset_query(); ?>	
				</div><!-- END panel1-->				
			</div><!-- END tabs-content listView-->
		</div><!-- END advContent-->
	</div><!-- END Main Ads Section-->	
</section>
<?php }else{ ?>
<!-- Advertisement Section Start -->
<section id="advertisement">
	<div class="row">
		<div class="mainHeading">
			<div class="large-7 medium-8 large-centered medium-centered columns">
				<h2><?php esc_html_e( 'ADVERTISEMENTS', 'classiera' ); ?></h2>
				<p><span class="line"><i class="fa fa-circle"></i></span></p>
				<?php if(!empty($ad_desc)){ ?>
				<p><?php echo $ad_desc; ?></p>
				<?php } ?>
			</div>
		</div>
	</div><!-- END Heading Row-->	
	<div class="row">
		<div class="advContent"> 
			<div class="tabs-content">
				<div class="content active" id="panel1">
				<?php 
					global $paged, $wp_query, $wp;
					$args = wp_parse_args($wp->matched_query);
					if ( !empty ( $args['paged'] ) && 0 == $paged ) {
						$wp_query->set('paged', $args['paged']);
						$paged = $args['paged'];
					}
					if ( is_day() ) :
						$archive_year  = get_the_date('Y'); 
						$archive_month = get_the_date('m'); 
						$archive_day   = get_the_date('d');
						global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post');
						global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'post_type' => 'post', 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
						global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post', 'orderby' => 'title');
						
					elseif ( is_month() ) :	
						$archive_year  = get_the_date('Y'); 
						$archive_month = get_the_date('m');
						global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post');
						global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'post_type' => 'post', 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
						global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post', 'orderby' => 'title');
					
					elseif ( is_year() ) :
						$archive_year  = get_the_date('Y'); 
						global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC');
						global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
						global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC', 'orderby' => 'title');
					
					elseif ( is_tag() ) :
						global $wp_query;
						$tag = $wp_query->get_queried_object();
						$current_tag = $tag->term_id;
						global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC');
						global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
						global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC', 'orderby' => 'title');
						
					else :
					endif;					
				?>
				<?php
					$wp_query= null;
					$wp_query = new WP_Query();
					$wp_query->query($args);
					$current = -1;
					$current2 = 0;

				?>
				<?php while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; ?>
					<div class="large-4 medium-6 columns advItems end">
						<div class="advItem"> 
							<?php 
							if ( has_post_thumbnail()) {
								$imageurl = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'classiera-grid');
								$thumb_id = get_post_thumbnail_id($post->id);
								$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
								?>
								<div class="advItem-img">
									<img src="<?php echo $imageurl[0]; ?>" alt="<?php if(empty($alt)){echo "Image";}else{ echo $alt; } ; ?>"/>
								</div>
								<?php										
							}else{
								?>
								<div class="advItem-img">
									<img src="<?php echo get_template_directory_uri() . '/images/nothumb/nothumb370x300.png' ?>" alt="No Thumb"/>
								</div>
								<?php
							}
								/*Get Category Extra Fields For Price Icon Background */
								$category = get_the_category();
									if ($category[0]->category_parent == 0) {
										$tag = $category[0]->cat_ID;
										$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
										if (isset($tag_extra_fields[$tag])) {
											$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
											$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
										}
									}else{
										$tag = $category[0]->category_parent;
										$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
										if (isset($tag_extra_fields[$tag])) {
											$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
											$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
										}
									}
									if(!empty($category_icon_code)) {
										$category_icon = stripslashes($category_icon_code);
									}
									$category_icon_code = "";
								/*Get Category Extra Fields For Price Icon Background */
							$post_price = get_post_meta($post->ID, 'post_price', true);
							if(!empty($post_price)){
							?>
							<span class="price" style="background-color:<?php echo $category_icon_color; ?>"><?php echo $post_price; ?></span>
							<?php }?>
							<a class="hover" href="<?php the_permalink(); ?>"></a>
							<div class="info">
								<a href="<?php the_permalink(); ?>">
								<?php 
									$postCatgory = get_the_category( $post->ID );
									//echo $postCatgory[0]->name;
								?>
									<i class="<?php echo $category_icon; ?>" style="background-color:<?php echo $category_icon_color; ?>"></i>
									<span class="title"><?php $theTitle = get_the_title(); $theTitle = (strlen($theTitle) > 25) ? substr($theTitle,0,25).'...' : $theTitle; echo $theTitle; ?></span>
									<span class="cat"><?php esc_html_e( 'Category', 'classiera' ); ?> &nbsp;:&nbsp;<?php echo $postCatgory[0]->name; ?></span>
								</a>
							</div>
						</div>
					</div>
					<?php endwhile; ?>
					<?php get_template_part('pagination'); ?>
					<?php wp_reset_query(); ?>	
				</div>
			</div>
		</div>
	</div><!-- END Main Ads Section-->	

</section>
<!-- END Advertisement Section-->
<?php }?>
<?php get_footer(); ?>
