<?php
/**
 * WordPress Bootstrap Pagination
 */
function classiera_pagination( $args = array() ) {
    
    $defaults = array(
        'range'           => 4,
        'custom_query'    => FALSE,
        'previous_string' => '<i class="icon-left fas fa-chevron-left"></i>&nbsp;'.__( 'Previous', 'classiera' ),
        'next_string'     => __( 'Next', 'classiera' ).'<i class="icon-right fas fa-chevron-right"></i>',
        'before_output'   => '<div class="classiera-pagination"><nav aria-label="Page navigation"><ul class="pagination">',
        'after_output'    => '</ul></nav></div>'
    );
    
    $args = wp_parse_args( 
        $args, 
        apply_filters( 'wp_bootstrap_pagination_defaults', $defaults )
    );
    
    $args['range'] = (int) $args['range'] - 1;
    if ( !$args['custom_query'] ){
        $args['custom_query'] = $GLOBALS['wp_query'];
	}
    $count = (int) $args['custom_query']->max_num_pages;
    $page  = intval( get_query_var( 'paged' ) );
    $ceil  = ceil( $args['range'] / 2 );
    
    if ( $count <= 1 ){
        return FALSE;
    }
    if ( !$page ){
        $page = 1;
    }
    if ( $count > $args['range'] ) {
        if ( $page <= $args['range'] ) {
            $min = 1;
            $max = $args['range'] + 1;
        } elseif ( $page >= ($count - $ceil) ) {
            $min = $count - $args['range'];
            $max = $count;
        } elseif ( $page >= $args['range'] && $page < ($count - $ceil) ) {
            $min = $page - $ceil;
            $max = $page + $ceil;
        }
    } else {
        $min = 1;
        $max = $count;
    }
    
    $echo = '';
    $previous = intval($page) - 1;
    $previous = esc_attr( get_pagenum_link($previous) );
    
    $firstpage = esc_attr( get_pagenum_link(1) );
    
    if ( $previous && (1 != $page) ){
        $echo .= '<li><a href="' . $previous . '" title="' . __( 'previous', 'classiera') . '">' . $args['previous_string'] . '</a></li>';
    }
    if ( !empty($min) && !empty($max) ) {
        for( $i = $min; $i <= $max; $i++ ) {
            if ($page == $i) {                
				$echo .= '<li class="active"><span class="active">' . $i . '</span></li>';
            } else {
                $echo .= sprintf( '<li><a href="%s">%d</a></li>', esc_attr( get_pagenum_link($i) ), $i );
            }
        }
    }
    
    $next = intval($page) + 1;
    $next = esc_attr( get_pagenum_link($next) );
    if ($next && ($count != $page) ){
        $echo .= '<li><a href="' . $next . '" title="' . __( 'next', 'classiera') . '">' . $args['next_string'] . '</a></li>';
    }
    $lastpage = esc_attr( get_pagenum_link($count) );   
    if ( isset($echo) ){
        echo wp_kses_post($args['before_output']) . $echo . $args['after_output'];
	}
}