<?php
if(is_single() || is_page()){
if(!function_exists('pacz_theme_comments')){
function pacz_theme_comments( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment; ?>
	<li <?php comment_class(empty( $args['has_children'] ) ? '' : 'parent-comment') ?> id="li-comment-<?php comment_ID() ?>">
		<div class="pacz-single-comment clearfix" id="comment-<?php comment_ID(); ?>">
			<div class="gravatar">
				<div class="author-img">
									<?php require_once PACZ_THEME_PLUGINS_CONFIG . "/image-cropping.php"; ?>
									<?php 
									if(class_exists('alsp_plugin')){
										global $comment_ID;
										$author_email = get_comment_author_email($comment_ID);
										$author = get_user_by('email', $author_email);
										$authorID1 = $author->ID;
										$author_img_url = get_user_meta($authorID1, "pacz_author_avatar_url", true); 

										if(!empty($author_img_url)) {

											$params = array( 'width' => 120, 'height' => 120, 'crop' => true );

											echo "<img src='" . bfi_thumb( "$author_img_url", $params ) . "' alt='' />";

										} else { 
											
											echo get_avatar( $comment, $size='120', $default='' ); 

										}
									}else{
										echo get_avatar( $comment, $size='120', $default='' ); 
									} ?>
								</div>
			</div>
			<div class="comment-meta-main">
				<div class="comment-meta">
						<?php printf( '<span class="comment-author">%s</span>', get_comment_author_link() ); ?>	
						<?php edit_comment_link( '', '', '' ) ?>
						<time class="comment-time"><?php echo get_comment_time('F jS, Y h:i A'); ?></time>
				</div>
				<span class="comment-reply">
						<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'], 'reply_text' => esc_html__('reply', 'classiadspro') ) ) ) ?>
				</span>
				<div class="clearboth"></div>
				<div class="comment-content">

						<?php comment_text() ?>

	<?php if ( $comment->comment_approved == '0' ) : ?>
						<span class="unapproved"><?php esc_html_e( 'Your comment is awaiting moderation.', 'classiadspro' );?></span>
	<?php endif; ?>
					
				</div>
			</div>
		       
		</div>		
<?php
}


function pacz_list_pings( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
?>

<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>"> 
		<div id="comment-<?php comment_ID(); ?>" class="comment-wrap comments-pings">

			<div class="comment-content">

				<div class="comment-meta">

					<?php printf( '<span class="comment_author"><b>%s</b></span>', get_comment_author_link() ) ?>

				</div>
				<div class="comment-data">
					<?php comment_text() ?>

								<time class="comment-time"><?php echo get_comment_time('F jS, Y h:i A'); ?></time>
<?php if ( $comment->comment_approved == '0' ) : ?>
					<span class="unapproved"><?php esc_html__('Your comment is awaiting moderation.', 'classiadspro'); ?></span>
<?php endif; ?>
				</div>
                <div class="clearboth"></div>
	</div>





<?php } ?>

<section id="comments">
<?php if ( post_password_required() ) : ?>
	<p class="nopassword"><?php esc_html_e( 'This post is password protected. Enter the password to view any comments.', 'classiadspro' );?></p>
</section><!-- #comments -->
<?php
return;
endif;

if ( have_comments() ) : ?>
	<div class="single-post-fancy-title"><h5><?php printf( _n( 'Comments', 'Showing %s comments', get_comments_number(), 'classiadspro' ),
	number_format_i18n( get_comments_number() )); ?></h5></div>
	<ul class="pacz-commentlist">
		<?php
wp_list_comments( 'callback=pacz_theme_comments&type=comment' );
?>
	</ul>





<?php
if ( have_comments() ) : ?>
<?php if ( ! empty( $comments_by_type['pings'] ) ) : ?>
<div class="single-post-fancy-title"><span><?php esc_html_e( 'pingbacks / trackbacks', 'classiadspro' ); ?></span></div>

<ul class="pacz-commentlist">
<?php wp_list_comments( 'callback=pacz_list_pings&type=pings' ); ?>
</ul>
<?php endif; endif; ?>

<?php else :
	if ( ! comments_open() ) :
		endif;
	endif;
?>

 <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
	<nav class="comments-navigation">
		<div class="comments-previous"><?php previous_comments_link(); ?></div>
		<div class="comments-next"><?php next_comments_link(); ?></div>
	</nav>
<?php endif;?>

	<?php if ( comments_open() ) : ?>
<div class="inner-content">
	<?php
	
		$fields =  array(
			'author'=> '<div class="comment-form-name comment-form-row"><i class="pacz-icon-user"></i><input type="text" name="author" class="text-input" id="author" tabindex="54" placeholder="'.esc_html__('FULL NAME', 'classiadspro').'"  /></div>',
			'email' => '<div class="comment-form-email comment-form-row"><i class="pacz-icon-envelope-o"></i><input type="text" name="email" class="text-input" id="email" tabindex="56" placeholder="'.esc_html__('EMAIL ADDRESS', 'classiadspro').'" /></div>',
			'url' 	=> '<div class="comment-form-website comment-form-row"><i class="pacz-icon-globe"></i><input type="text" name="url" class="text-input" id="url" tabindex="57" placeholder="'.esc_html__('WEBSITE', 'classiadspro').'" /></div>',
		);

		//Comment Form Args
        $comments_args = array(
			'fields' => $fields,
			'title_reply'=>'<div class="single-post-fancy-title"><h5>'.esc_html__('Leave a Comment', 'classiadspro').'</h5></div>',
			'comment_field' => '<div class="comment-textarea"><textarea placeholder="'.esc_html__('Your Comment', 'classiadspro').'" class="textarea" name="comment" rows="8" id="comment" tabindex="58"></textarea></div>',
			'comment_notes_before' => '',
			'comment_notes_after' => '',
			'label_submit' => esc_html__('Post Comment','classiadspro')
		);
		comment_form($comments_args); 
	?>
</div>
<?php endif; ?>


</section>
<?php } } ?>