<?php if ($listing->level->images_number): ?>
<?php
$img_width = 100; 
$img_height = 100; 
?>
<script>
	var images_number = <?php echo $listing->level->images_number; ?>;

	(function($) {
		"use strict";

		$(function() {
			$("#images_wrapper").on('click', '.delete_item', function() {
				$(this).parent().remove();
	
				if (images_number > $("#images_wrapper .alsp-attached-item").length)
					$("#alsp-upload-functions").show();
			});
		});
	})(jQuery);
</script>

<div id="alsp-upload-wrapper">
<div id="alsp-upload-wrapper-inner">
	<h3>
		<?php _e('Listing images', 'ALSP'); ?>
	</h3>
	<label><?php _e('Upload images one by one or select multiple images from library then hit save. Max Images Allowed : ', 'ALSP'); ?><?php echo $listing->level->images_number ?></label>
	<div id="images_wrapper">
	<?php foreach ($listing->images AS $attachment_id=>$attachment): ?>
		<?php $src = wp_get_attachment_image_src($attachment_id, 'full'); ?>
		<?php $src_full = wp_get_attachment_image_src($attachment_id, 'full'); ?>
		<div class="alsp-attached-item">
			<input type="hidden" name="attached_image_id[]" value="<?php echo $attachment_id; ?>" />
			<div class="alsp-img-div-border" style="width: <?php echo $img_width; ?>px; height: <?php echo $img_height; ?>px">
				<a href="<?php echo $src_full[0]; ?>" data-lightbox="listing_images"><img src="<?php echo $src[0]; ?>" style="max-width: 100px; max-height: 100px" /></a>
				<?php if ($listing->level->logo_enabled): ?>
					<span class="image-metas">
						<label><input type="radio" name="attached_image_as_logo" value="<?php echo $attachment_id; ?>" <?php checked($listing->logo_image, $attachment_id); ?>><span class="radio-check-item"></span></label>
					</span>
				<?php endif; ?>
			</div>
			<div class="alsp-delete-attached-item delete_item"><i class="pacz-icon-close"></i></div>
		</div>
	<?php endforeach; ?>
	</div>
	<?php //} ?>
	<div class="clear_float"></div>

	<?php if (current_user_can('upload_files')): ?>
	<script>
		(function($) {
			"use strict";
		
			$(function() {
				$('#upload_image').click(function(event) {
					event.preventDefault();
			
					var frame = wp.media({
			            title : '<?php echo esc_js(sprintf(__('Upload image (%d maximum)', 'ALSP'), $listing->level->images_number)); ?>',
			            multiple : true,
			            library : { type : 'image'},
			            button : { text : '<?php echo esc_html__('Insert', 'ALSP'); ?>' },
			        });
					frame.on( 'select', function() {
					    var selection = frame.state().get('selection');
					    selection.each(function(attachment) {
					    	attachment = attachment.toJSON();
							if (images_number <= $("#images_wrapper .alsp-attached-item").length)
								jQuery("#alsp-upload-functions").hide();
							else {
								alsp_ajax_loader_show();
	
								if (typeof attachment.sizes.thumbnail != 'undefined')
									var attachment_url = attachment.sizes.thumbnail.url;
								else
									var attachment_url = attachment.sizes.full.url;
								var attachment_url_full = attachment.sizes.full.url;
								var attachment_id = attachment.id;
								// modified: please use span instead of div 
								$('<span class="alsp-attached-item"><input type="hidden" name="attached_image_id[]" value="' + attachment_id + '" /><span class="alsp-img-div-border" style="width: <?php echo $img_width; ?>px; height: <?php echo $img_height; ?>px"><a href="' + attachment_url_full + '" data-lightbox="listing_images"><img src="' + attachment_url + '" style="max-width: <?php echo $img_width; ?>px; max-height: <?php echo $img_height; ?>px" /></a><?php if ($listing->level->logo_enabled): ?><span class="image-metas"><label><input type="radio" name="attached_image_as_logo" value="' + attachment_id + '"><span class="radio-check-item"></span></label><?php endif; ?></span></span><span class="alsp-delete-attached-item delete_item"><i class="pacz-icon-close"></i></span><input type="hidden" name="attached_image_title[]" class="form-control" value="" size="37" placeholder="<?php esc_attr_e('optional image title', 'ALSP'); ?>" /></span>').appendTo("#images_wrapper");

								$.post(
									alsp_js_objects.ajaxurl,
									{'action': 'alsp_upload_media_image', 'attachment_id': attachment_id, 'post_id': <?php echo $listing->post->ID; ?>, '_wpnonce': '<?php echo wp_create_nonce('upload_images'); ?>'},
									function (response_from_the_action_function){
										alsp_ajax_loader_hide();
									}
								);
							}
						});
					});
					frame.open();
				});
			});
		})(jQuery);
	</script>
	<div id="alsp-upload-functions" class="" <?php if (count($listing->images) >= $listing->level->images_number): ?>style="display: none;"<?php endif; ?>>
		<div class="alsp-upload-option">
			<input
				type="button"
				id="upload_image"
				class="btn submit-page-buton"
				value="<?php esc_attr_e('Upload image', 'ALSP'); ?>" />
		</div>
	</div>
	<?php else: ?>
	<script>
		(function($) {
			"use strict";
	
			window.addImageDiv = function(data) {
				var attachment_url = data.uploaded_file;
				var attachment_id = data.attachment_id;
				// modified: please use span instead of div 
				$('<span class="alsp-attached-item"><span class="alsp-delete-attached-item delete_item" title="<?php esc_attr_e('remove image', 'ALSP'); ?>"></span><input type="hidden" name="attached_image_id[]" value="' + attachment_id + '" /><span class="alsp-img-div-border" style="width: <?php echo $img_width; ?>px; height: <?php echo $img_height; ?>px"><span class="alsp-img-div-helper"></span><img src="' + attachment_url + '" style="max-width: <?php echo $img_width; ?>px; max-height: <?php echo $img_height; ?>px" /></span><input type="text" name="attached_image_title[]" class="form-control" size="37" /><?php if ($listing->level->logo_enabled): ?><label><input type="radio" name="attached_image_as_logo" value="' + attachment_id + '" checked=""> <?php echo esc_js('set this image as logo', 'ALSP'); ?></label><?php endif; ?></span>').appendTo("#images_wrapper");
		
				if (images_number <= jQuery("#images_wrapper .alsp-attached-item").length)
					$("#alsp-upload-functions").hide();
			}
		})(jQuery);
	</script>
	<div id="alsp-upload-functions" class="" <?php if (count($listing->images) >= $listing->level->images_number): ?>style="display: none;"<?php endif; ?>>
		<div class="alsp-upload-option">
			<input id="browse_file" name="browse_file" type="file" size="45" />
		</div>
		<div class="alsp-upload-option">
			<label><input type="checkbox" id="crop_image" value="1" /> <?php _e('Crop thumbnail to exact dimensions (normally thumbnails are proportional)', 'ALSP'); ?></label>
		</div>
		<div class="alsp-upload-option">
			<input
				type="button"
				class="btn btn-primary"
				onclick="return alsp_ajaxImageFileUploadToGallery(
					'browse_file',
					addImageDiv,
					jQuery('#crop_image').is(':checked'),
					'<?php echo admin_url('admin-ajax.php?action=alsp_upload_image&post_id='.$listing->post->ID.'&_wpnonce='.wp_create_nonce('upload_images')); ?>',
					'<?php echo esc_js(__('Choose image to upload first!', 'ALSP')); ?>'
				);"
				value="<?php esc_attr_e('Upload image', 'ALSP'); ?>" />
		</div>
	</div>
	<?php endif; ?>
</div>
</div>
<?php endif; ?>


<?php if ($listing->level->videos_number): ?>
<script>
	var videos_number = <?php echo $listing->level->videos_number; ?>;

	(function($) {
		"use strict";

		$(function() {
			$(document).on("click", "#videos_wrapper .delete_item", function() {
				$(this).parent().remove();
	
				if (videos_number > $("#videos_wrapper .alsp-attached-item").length)
					$("#attach_videos_functions").show();
			});
		});
	})(jQuery);
</script>

<div id="videos_attach_wrapper">
<div id="videos_attach_wrapper-inner">
	<h3>
		<?php _e('Listing videos', 'ALSP'); ?>
	</h3>
	
	<div id="videos_wrapper">
	<?php foreach ($listing->videos AS $video): ?>
		<div class="alsp-attached-item">
			<div class="alsp-delete-attached-item delete_item" title="<?php esc_attr_e('remove video', 'ALSP'); ?>"></div>
			<input type="hidden" name="attached_video_id[]" value="<?php esc_attr_e($video['id']); ?>" />
			<div class="alsp-img-div-border" style="width: 120px; height: 90px">
				<?php if (strlen($video['id']) == 11): ?>
					<span class="alsp-img-div-helper"></span><img src="http://i.ytimg.com/vi/<?php echo $video['id']; ?>/default.jpg" style="max-width: 120px; max-height: 90px" />
				<?php elseif (strlen($video['id']) == 9): ?>
				<?php
					$data = file_get_contents("http://vimeo.com/api/v2/video/" . $video['id'] . ".json");
					$data = json_decode($data);
					$image_url = $data[0]->thumbnail_medium;
    			?>
					<span class="alsp-img-div-helper"></span><img src="<?php echo $image_url; ?>" style="max-width: 120px; max-height: 90px" />
				<?php endif; ?>
			</div>
		</div>
	<?php endforeach; ?>
	</div>
	<div class="clear_float"></div>

	<script>
		(function($) {
			"use strict";
		
			window.attachVideo = function() {
				if ($("#attach_video_input").val()) {
					var regExp_youtube = /^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/;
					var regExp_vimeo = /https?:\/\/(?:www\.|player\.)?vimeo.com\/(?:channels\/(?:\w+\/)?|groups\/([^\/]*)\/videos\/|album\/(\d+)\/video\/|video\/|)(\d+)(?:$|\/|\?)/;
					var matches_youtube = $("#attach_video_input").val().match(regExp_youtube);
					var matches_vimeo = $("#attach_video_input").val().match(regExp_vimeo);
					if (matches_youtube && matches_youtube[2].length == 11) {
						var video_id = matches_youtube[2];
						var image_url = 'http://i.ytimg.com/vi/'+video_id+'/0.jpg';
						$('<div class="alsp-attached-item"><div class="alsp-delete-attached-item delete_item" title="<?php esc_attr_e('remove video', 'ALSP'); ?>"></div><input type="hidden" name="attached_video_id[]" value="' + video_id + '" /><div class="alsp-img-div-border" style="width: 120px; height: 90px"><span class="alsp-img-div-helper"></span><img src="' + image_url + '" style="max-width: 120px; max-height: 90px" /></div></div>').appendTo("#videos_wrapper");

						if (videos_number <= $("#videos_wrapper .alsp-attached-item").length)
							$("#attach_videos_functions").hide();
					} else if (matches_vimeo && (matches_vimeo[3].length == 8 || matches_vimeo[3].length == 9)) {
						var video_id = matches_vimeo[3];
						var url = "//vimeo.com/api/v2/video/" + video_id + ".json?callback=showVimeoThumb";
					    var script = document.createElement('script');
					    script.src = url;
					    $("#attach_videos_functions").before(script);
					} else
						alert("<?php esc_attr_e('Wrong URL or this video is unavailable', 'ALSP'); ?>");
				}
			};

			window.showVimeoThumb = function(data){
				var video_id = data[0].id;
			    var image_url = data[0].thumbnail_medium;
				$('<div class="alsp-attached-item"><div class="alsp-delete-attached-item delete_item" title="<?php esc_attr_e('remove video', 'ALSP'); ?>"></div><input type="hidden" name="attached_video_id[]" value="' + video_id + '" /><div class="alsp-img-div-border" style="width: 120px; height: 90px"><span class="alsp-img-div-helper"></span><img src="' + image_url + '" style="max-width: 120px; max-height: 90px" /></div></div>').appendTo("#videos_wrapper");

				if (videos_number <= $("#videos_wrapper .alsp-attached-item").length)
					$("#attach_videos_functions").hide();
			};
		})(jQuery);
	</script>
	<div id="attach_videos_functions" class="" <?php if (count($listing->videos) >= $listing->level->videos_number): ?>style="display: none;"<?php endif; ?>>
		<div class="alsp-upload-option">
			<label><?php _e('Enter full YouTube video link', 'ALSP'); ?></label>
		</div>
		<div class="alsp-upload-option">
			<input type="text" id="attach_video_input" class="form-control" style="width: 100%" />
		</div>
		<div class="alsp-upload-option">
			<input
				type="button"
				class="btn btn-primary"
				onclick="return attachVideo(); "
				value="<?php esc_attr_e('Attach video', 'ALSP'); ?>" />
		</div>
	</div>
</div>
</div>
<?php endif; ?>