<?php 

function alsp_install_directory() {
	global $wpdb;
	$collate = '';

		if ( $wpdb->has_cap( 'collation' ) ) {
			$collate = $wpdb->get_charset_collate();
		}
	if (!get_option('alsp_installed_directory')) {
		$wpdb->query("CREATE TABLE IF NOT EXISTS {$wpdb->alsp_content_fields_groups} (
					`id` int(11) NOT NULL AUTO_INCREMENT,
					`name` varchar(255) NOT NULL,
					`on_tab` tinyint(1) NOT NULL DEFAULT '0',
					`hide_anonymous` tinyint(1) NOT NULL DEFAULT '0',
					PRIMARY KEY (`id`)
					) $collate ;");
		if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_content_fields_groups} WHERE name = 'Contact Information'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_content_fields_groups} (`name`, `on_tab`, `hide_anonymous`) VALUES ('Contact Information', 0, 0)");

		$wpdb->query("CREATE TABLE IF NOT EXISTS {$wpdb->alsp_content_fields} (
					`id` int(11) NOT NULL AUTO_INCREMENT,
					`is_core_field` tinyint(1) NOT NULL DEFAULT '0',
					`order_num` tinyint(1) NOT NULL,
					`name` varchar(255) NOT NULL,
					`slug` varchar(255) NOT NULL,
					`description` text NOT NULL,
					`fieldwidth` varchar(255) NOT NULL,
					`fieldwidth_archive` varchar(255) NOT NULL,
					`type` varchar(255) NOT NULL,
					`icon_image` varchar(255) NOT NULL,
					`is_required` tinyint(1) NOT NULL DEFAULT '0',
					`is_configuration_page` tinyint(1) NOT NULL DEFAULT '0',
					`is_search_configuration_page` tinyint(1) NOT NULL DEFAULT '0',
					`is_ordered` tinyint(1) NOT NULL DEFAULT '0',
					`is_hide_name` tinyint(1) NOT NULL DEFAULT '0',
					`on_exerpt_page` tinyint(1) NOT NULL DEFAULT '0',
					`on_listing_page` tinyint(1) NOT NULL DEFAULT '0',
					`on_search_form` tinyint(1) NOT NULL DEFAULT '0',
					`on_search_form_archive` tinyint(1) NOT NULL DEFAULT '0',
					`on_search_form_widget` tinyint(1) NOT NULL DEFAULT '0',
					`on_map` tinyint(1) NOT NULL DEFAULT '0',
					`advanced_search_form` tinyint(1) NOT NULL,
					`advanced_archive_search_form` tinyint(1) NOT NULL,
					`advanced_widget_search_form` tinyint(1) NOT NULL,
					`categories` text NOT NULL,
					`options` text NOT NULL,
					`search_options` text NOT NULL,
					`group_id` int(11) NOT NULL DEFAULT '0',
					PRIMARY KEY (`id`),
					KEY `group_id` (`group_id`)
					) $collate;");
		if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_content_fields} WHERE slug = 'summary'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_content_fields} (`is_core_field`, `order_num`, `name`, `slug`, `description`, `type`, `icon_image`, `is_required`, `is_configuration_page`, `is_search_configuration_page`, `is_ordered`, `is_hide_name`, `on_exerpt_page`, `on_listing_page`, `on_search_form`, `on_map`, `on_search_form_archive`, `on_search_form_widget`, `advanced_search_form`, `advanced_archive_search_form`, `advanced_widget_search_form`, `categories`, `options`, `search_options`, `group_id`) VALUES(1, 1, 'Summary', 'summary', '', 'excerpt', '', 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, '', '', '', '0');");
		if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_content_fields} WHERE slug = 'address'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_content_fields} (`is_core_field`, `order_num`, `name`, `slug`, `description`, `type`, `icon_image`, `is_required`, `is_configuration_page`, `is_search_configuration_page`, `is_ordered`, `is_hide_name`, `on_exerpt_page`, `on_listing_page`, `on_search_form`, `on_map`, `on_search_form_archive`, `on_search_form_widget`, `advanced_search_form`, `advanced_archive_search_form`, `advanced_widget_search_form`, `categories`, `options`, `search_options`, `group_id`) VALUES(1, 2, 'Address', 'address', '', 'address', 'fa-map-marker', 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', '', '', '0');");
		if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_content_fields} WHERE slug = 'content'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_content_fields} (`is_core_field`, `order_num`, `name`, `slug`, `description`, `type`, `icon_image`, `is_required`, `is_configuration_page`, `is_search_configuration_page`, `is_ordered`, `is_hide_name`, `on_exerpt_page`, `on_listing_page`, `on_search_form`, `on_map`, `on_search_form_archive`, `on_search_form_widget`, `advanced_search_form`, `advanced_archive_search_form`, `advanced_widget_search_form`, `categories`, `options`, `search_options`, `group_id`) VALUES(1, 3, 'Description', 'content', '', 'content', '', 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, '', '', '', '0');");
		if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_content_fields} WHERE slug = 'categories_list'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_content_fields} (`is_core_field`, `order_num`, `name`, `slug`, `description`, `type`, `icon_image`, `is_required`, `is_configuration_page`, `is_search_configuration_page`, `is_ordered`, `is_hide_name`, `on_exerpt_page`, `on_listing_page`, `on_search_form`, `on_map`, `on_search_form_archive`, `on_search_form_widget`, `advanced_search_form`, `advanced_archive_search_form`, `advanced_widget_search_form`, `categories`, `options`, `search_options`, `group_id`) VALUES(1, 4, 'Categories', 'categories_list', '', 'categories', '', 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', '', '', '0');");
		if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_content_fields} WHERE slug = 'listing_tags'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_content_fields} (`is_core_field`, `order_num`, `name`, `slug`, `description`, `type`, `icon_image`, `is_required`, `is_configuration_page`, `is_search_configuration_page`, `is_ordered`, `is_hide_name`, `on_exerpt_page`, `on_listing_page`, `on_search_form`, `on_map`, `on_search_form_archive`, `on_search_form_widget`, `advanced_search_form`, `advanced_archive_search_form`, `advanced_widget_search_form`, `categories`, `options`, `search_options`, `group_id`) VALUES(1, 5, 'Listing Tags', 'listing_tags', '', 'tags', '', 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', '', '', '0');");
		if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_content_fields} WHERE slug = 'phone'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_content_fields} (`is_core_field`, `order_num`, `name`, `slug`, `description`, `type`, `icon_image`, `is_required`, `is_configuration_page`, `is_search_configuration_page`, `is_ordered`, `is_hide_name`, `on_exerpt_page`, `on_listing_page`, `on_search_form`, `on_map`, `on_search_form_archive`, `on_search_form_widget`, `advanced_search_form`, `advanced_archive_search_form`, `advanced_widget_search_form`, `categories`, `options`, `search_options`, `group_id`) VALUES(0, 6, 'Phone', 'phone', '', 'string', 'fa-phone', 0, 1, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, '', 'a:2:{s:10:\"max_length\";s:2:\"25\";s:5:\"regex\";s:0:\"\";}', '', '1');");
		if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_content_fields} WHERE slug = 'website'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_content_fields} (`is_core_field`, `order_num`, `name`, `slug`, `description`, `type`, `icon_image`, `is_required`, `is_configuration_page`, `is_search_configuration_page`, `is_ordered`, `is_hide_name`, `on_exerpt_page`, `on_listing_page`, `on_search_form`, `on_map`, `on_search_form_archive`, `on_search_form_widget`, `advanced_search_form`, `advanced_archive_search_form`, `advanced_widget_search_form`, `categories`, `options`, `search_options`, `group_id`) VALUES(0, 7, 'Website', 'website', '', 'website', 'fa-globe', 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, '', 'a:5:{s:8:\"is_blank\";i:1;s:11:\"is_nofollow\";i:1;s:13:\"use_link_text\";i:1;s:17:\"default_link_text\";s:13:\"view our site\";s:21:\"use_default_link_text\";i:0;}', '', '1');");
		if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_content_fields} WHERE slug = 'email'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_content_fields} (`is_core_field`, `order_num`, `name`, `slug`, `description`, `type`, `icon_image`, `is_required`, `is_configuration_page`, `is_search_configuration_page`, `is_ordered`, `is_hide_name`, `on_exerpt_page`, `on_listing_page`, `on_search_form`, `on_search_form_archive`, `on_search_form_widget`, `on_map`, `advanced_search_form`, `advanced_archive_search_form`, `advanced_widget_search_form`, `categories`, `options`, `search_options`, `group_id`) VALUES(1, 8, 'Email', 'email', '', 'email', 'fa-envelope-o', 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, '', '', '', '1');");
		if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_content_fields} WHERE slug = 'price'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_content_fields} (`is_core_field`, `order_num`, `name`, `slug`, `description`, `type`, `icon_image`, `is_required`, `is_configuration_page`, `is_search_configuration_page`, `is_ordered`, `is_hide_name`, `on_exerpt_page`, `on_listing_page`, `on_search_form`, `on_search_form_archive`, `on_search_form_widget`, `on_map`, `advanced_search_form`, `advanced_archive_search_form`, `advanced_widget_search_form`, `categories`, `options`, `search_options`, `group_id`) VALUES(0, 2, 'Price', 'price', '', 'price', '', 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, '', '', '', '1');");
		$wpdb->query("CREATE TABLE IF NOT EXISTS {$wpdb->alsp_levels} (
					`id` int(11) NOT NULL AUTO_INCREMENT,
					`order_num` tinyint(1) NOT NULL,
					`name` varchar(255) NOT NULL,
					`description` text NOT NULL,
					`active_interval` tinyint(1) NOT NULL,
					`active_period` varchar(255) NOT NULL,
					`eternal_active_period` tinyint(1) NOT NULL DEFAULT '1',
					`raiseup_enabled` tinyint(1) NOT NULL,
					`sticky` tinyint(1) NOT NULL,
					`featured` tinyint(1) NOT NULL,
					`nofollow` tinyint(1) NOT NULL DEFAULT '0',
					`featured_level` tinyint(1) NOT NULL DEFAULT '0',
					`listings_own_page` tinyint(1) NOT NULL DEFAULT '1',
					`categories_number` tinyint(1) NOT NULL,
					`unlimited_categories` tinyint(1) NOT NULL,
					`locations_number` tinyint(1) NOT NULL,
					`google_map` tinyint(1) NOT NULL,
					`google_map_markers` tinyint(1) NOT NULL,
					`logo_enabled` tinyint(1) NOT NULL,
					`images_number` tinyint(1) NOT NULL,
					`videos_number` tinyint(1) NOT NULL,
					`categories` text NOT NULL,
					`locations` text NOT NULL,
					`content_fields` text NOT NULL,
					`upgrade_meta` text NOT NULL,
					PRIMARY KEY (`id`),
					KEY `order_num` (`order_num`)
					) $collate ;");
		
		if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_levels} WHERE name = 'Standard'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_levels} (`order_num`, `name`, `description`, `active_interval`, `active_period`, `eternal_active_period`, `raiseup_enabled`, `sticky`, `featured`, `nofollow`, `featured_level`, `listings_own_page`, `categories_number`, `unlimited_categories`, `locations_number`, `google_map`, `google_map_markers`, `logo_enabled`, `images_number`, `videos_number`, `categories`, `locations`, `content_fields`, `upgrade_meta`) VALUES (1, 'Standard', '', 0, '', 1, 1, 0, 0, 0, 1, 0, 1, 3, 1, 1, 1, 6, 3, '', '', '', '', '')");

		$wpdb->query("CREATE TABLE IF NOT EXISTS {$wpdb->alsp_levels_relationships} (
					`id` int(11) NOT NULL AUTO_INCREMENT,
					`post_id` int(11) NOT NULL,
					`level_id` int(11) NOT NULL,
					PRIMARY KEY (`id`),
					UNIQUE KEY `post_id` (`post_id`,`level_id`)
					) $collate ;");

		$wpdb->query("CREATE TABLE IF NOT EXISTS {$wpdb->alsp_locations_levels} (
					`id` int(11) NOT NULL AUTO_INCREMENT,
					`name` varchar(255) NOT NULL,
					`in_widget` tinyint(1) NOT NULL,
					`in_address_line` tinyint(1) NOT NULL,
					PRIMARY KEY (`id`),
					KEY `in_select_widget` (`in_widget`,`in_address_line`)
					) $collate ;");
	
		if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_locations_levels} WHERE name = 'Country'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_locations_levels} (`name`, `in_widget`, `in_address_line`) VALUES ('Country', 1, 1);");
		if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_locations_levels} WHERE name = 'State'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_locations_levels} (`name`, `in_widget`, `in_address_line`) VALUES ('State', 1, 1);");
		if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_locations_levels} WHERE name = 'City'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_locations_levels} (`name`, `in_widget`, `in_address_line`) VALUES ('City', 1, 1);");

		$wpdb->query("CREATE TABLE IF NOT EXISTS {$wpdb->alsp_locations_relationships} (
					`id` int(11) NOT NULL AUTO_INCREMENT,
					`post_id` int(11) NOT NULL,
					`location_id` int(11) NOT NULL,
					`address_line_1` varchar(255) NOT NULL,
					`address_line_2` varchar(255) NOT NULL,
					`zip_or_postal_index` varchar(25) NOT NULL,
					`additional_info` text NOT NULL,
					`manual_coords` tinyint(1) NOT NULL,
					`map_coords_1` float(10,6) NOT NULL,
					`map_coords_2` float(10,6) NOT NULL,
					`map_icon_file` varchar(255) NOT NULL,
					PRIMARY KEY (`id`),
					KEY `location_id` (`location_id`),
					KEY `post_id` (`post_id`)
					) $collate ;");
	
		if (!is_array(get_terms(ALSP_LOCATIONS_TAX)) || !count(get_terms(ALSP_LOCATIONS_TAX))) {
			if (($parent_term = wp_insert_term('USA', ALSP_LOCATIONS_TAX)) && !is_a($parent_term, 'WP_Error')) {
				wp_insert_term('Alabama', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Alaska', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Arkansas', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Arizona', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('California', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Colorado', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Connecticut', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Delaware', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('District of Columbia', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Florida', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Georgia', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Hawaii', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Idaho', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Illinois', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Indiana', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Iowa', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Kansas', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Kentucky', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Louisiana', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Maine', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Maryland', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Massachusetts', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Michigan', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Minnesota', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Mississippi', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Missouri', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Montana', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Nebraska', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Nevada', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('New Hampshire', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('New Jersey', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('New Mexico', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('New York', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('North Carolina', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('North Dakota', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Ohio', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Oklahoma', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Oregon', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Pennsylvania', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Rhode Island', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('South Carolina', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('South Dakota', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Tennessee', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Texas', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Utah', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Vermont', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Virginia', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Washington state', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('West Virginina', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Wisconsin', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
				wp_insert_term('Wyoming', ALSP_LOCATIONS_TAX, array('parent' => $parent_term['term_id']));
			}
		}
	
		/*add_option('alsp_category_slug', 'web-category');
		add_option('alsp_tag_slug', 'web-tag');
		add_option('alsp_enable_recaptcha');
		add_option('alsp_recaptcha_public_key');
		add_option('alsp_recaptcha_private_key');
		add_option('alsp_show_categories_index', 1);
		add_option('alsp_show_category_count', 1);
		add_option('alsp_listings_number_index', 6);
		add_option('alsp_listings_number_excerpt', 6);
		add_option('alsp_map_on_index', 1);
		add_option('alsp_map_on_excerpt', 1);
		add_option('alsp_directory_title', 'ALSP Listing');
		add_option('alsp_categories_nesting_level', 1);
		add_option('alsp_show_directions', 1);
		add_option('alsp_send_expiration_notification_days', 1);
		add_option('alsp_preexpiration_notification', 'Your listing "[listing]" will expiry in [days] days.');
		add_option('alsp_expiration_notification', 'Your listing "[listing]" had expired. You can renew it here [link]');
		add_option('alsp_show_what_search', 1);
		add_option('alsp_show_where_search', 1);
		add_option('alsp_listings_on_index', 1);
		add_option('alsp_listing_contact_form', 1);
		add_option('alsp_favourites_list', 1);
		add_option('alsp_print_button', 1);
		add_option('alsp_pdf_button', 1);
		add_option('alsp_default_map_zoom', 11);
		add_option('alsp_categories_icons');
		add_option('alsp_change_expiration_date', 0);
		add_option('alsp_categories_columns', 2);
		add_option('alsp_map_style', 'default');
		add_option('alsp_main_search', 1);
		add_option('alsp_hide_comments_number_on_index', 0);
		add_option('alsp_hide_listings_creation_date', 1);
		add_option('alsp_hide_author_link', 1);
		add_option('alsp_enable_radius_search_cycle', 0);
		add_option('alsp_enable_clusters', 0);
		add_option('alsp_show_location_count_in_search', 1);
		add_option('alsp_color_scheme', 'default');
		add_option('alsp_images_lightbox', 1);
		add_option('alsp_listing_contact_form_7', '');
		add_option('alsp_show_keywords_search', 1);
		add_option('alsp_show_locations_search', 1);
		add_option('alsp_show_address_search', 1);
		add_option('alsp_subcategories_items', 0);
		add_option('alsp_default_geocoding_location', '');
		add_option('alsp_show_orderby_links', 1);
		add_option('alsp_orderby_date', 1);
		add_option('alsp_orderby_title', 1);
		add_option('alsp_default_orderby', 'post_date');
		add_option('alsp_default_order', 'DESC');
		add_option('alsp_notinclude_jqueryui_css', 0);
		add_option('alsp_logo_animation_effect', 6);
		add_option('alsp_views_switcher', 1);
		add_option('alsp_views_switcher_default', 'list');
		add_option('alsp_views_switcher_grid_columns', 2);
		add_option('alsp_show_category_count_in_search', 1);
		add_option('alsp_miles_kilometers_in_search', 'miles');
		add_option('alsp_radius_search_min', 0);
		add_option('alsp_radius_search_max', 10);
		add_option('alsp_show_categories_search', 1);
		add_option('alsp_show_radius_search', 1);
		add_option('alsp_radius_search_default', 0);
		add_option('alsp_orderby_distance', 1);
		add_option('alsp_compare_palettes', 0);
		add_option('alsp_links_color', '#2393ba');
		add_option('alsp_links_hover_color', '#2a6496');
		add_option('alsp_button_1_color', '#2393ba');
		add_option('alsp_button_2_color', '#1f82a5');
		add_option('alsp_button_text_color', '#FFFFFF');
		add_option('alsp_search_1_color', '#bafefe');
		add_option('alsp_search_2_color', '#47c6c6');
		add_option('alsp_search_text_color', '#FFFFFF');
		add_option('alsp_categories_1_color', '#CEE6F3');
		add_option('alsp_categories_2_color', '#DEEEF7');
		add_option('alsp_categories_text_color', '#2393ba');
		add_option('alsp_locations_1_color', '#CEE6F3');
		add_option('alsp_locations_2_color', '#DEEEF7');
		add_option('alsp_locations_text_color', '#2393ba');
		add_option('alsp_primary_color', '#2393ba');
		add_option('alsp_featured_color', '#e1ffff');
		add_option('alsp_listings_bottom_margin', 40);
		add_option('alsp_listing_title_font', 25);
		add_option('alsp_default_map_height', 450);
		add_option('alsp_jquery_ui_schemas', 'redmond');
		add_option('alsp_addresses_order', array("line_1", "comma1", "line_2", "comma2", "location", "space1", "zip"));
		add_option('alsp_orderby_exclude_null', 0);
		add_option('alsp_map_marker_width', 48);
		add_option('alsp_map_marker_height', 48);
		add_option('alsp_map_marker_anchor_x', 24);
		add_option('alsp_map_marker_anchor_y', 48);
		add_option('alsp_map_infowindow_width', 350);
		add_option('alsp_map_infowindow_offset', 50);
		add_option('alsp_map_infowindow_logo_width', 110);
		add_option('alsp_enable_nologo', 1);
		add_option('alsp_nologo_url', ALSP_URL . 'resources/images/nologo.png');
		add_option('alsp_excerpt_length', 25);
		add_option('alsp_cropped_content_as_excerpt', 1);
		add_option('alsp_strip_excerpt', 1);
		add_option('alsp_orderby_sticky_featured', 0);
		add_option('alsp_button_gradient', 0);
		add_option('alsp_enable_description', 1);
		add_option('alsp_enable_excerpt', 1);
		add_option('alsp_share_buttons_style', 'arbenta');
		add_option('alsp_share_buttons', array());
		add_option('alsp_share_counter', 0);
		add_option('alsp_share_buttons_place', 'title');
		add_option('alsp_share_buttons_width', 40);
		add_option('alsp_100_single_logo_width', 1);
		add_option('alsp_single_logo_width', 270);
		add_option('alsp_enable_address_line_1', 1);
		add_option('alsp_enable_address_line_2', 1);
		add_option('alsp_enable_postal_index', 1);
		add_option('alsp_enable_additional_info', 1);
		add_option('alsp_enable_manual_coords', 1);
		add_option('alsp_big_slide_bg_mode', 'cover');
		add_option('alsp_exclude_logo_from_listing', 0);
		add_option('alsp_enable_lighbox_gallery', 1);
		add_option('alsp_directions_functionality', 'builtin');
		add_option('alsp_address_autocomplete', 1);
		add_option('alsp_address_geocode', 1);
		add_option('alsp_listings_comments_mode', 'wp_settings');
		add_option('alsp_listings_tabs_order', array("addresses-tab", "comments-tab", "videos-tab", "contact-tab"));
		add_option('alsp_listing_slug', 'business-listing');
		add_option('alsp_location_slug', 'business-place');
		add_option('alsp_permalinks_structure', 'postname');
		add_option('alsp_google_api_key', '');
		add_option('alsp_google_api_key_server', '');
		add_option('alsp_locations_1_color', '#CEE6F3');
		add_option('alsp_locations_2_color', '#DEEEF7');
		add_option('alsp_locations_text_color', '#2393ba');
		add_option('alsp_show_locations_index', 0);
		add_option('alsp_locations_nesting_level', 1);
		add_option('alsp_locations_columns', 2);
		add_option('alsp_sublocations_items', 0);
		add_option('alsp_show_location_count', 1);
		add_option('alsp_locations_icons');
		add_option('alsp_enable_breadcrumbs', 1);
		add_option('alsp_hide_home_link_breadcrumb', 0);
		add_option('alsp_breadcrumbs_mode', 'title');
		add_option('alsp_auto_slides_gallery', 0);
		add_option('alsp_auto_slides_gallery_delay', 3000);
		add_option('alsp_ajax_load', 1);
		add_option('alsp_ajax_initial_load', 0);
		add_option('alsp_show_more_button', 1);
		add_option('alsp_map_markers_type', 'icons');
		add_option('alsp_default_marker_color', '#2393ba');
		add_option('alsp_default_marker_icon', '');
		add_option('alsp_search_on_map', 0);
		add_option('alsp_enable_stats', 1);
		add_option('alsp_enable_draw_panel', 0);
		add_option('alsp_custom_contact_email', 0);*/
		add_option('alsp_installed_directory', true);
		add_option('alsp_installed_directory_version', ALSP_VERSION);
		add_option('alsp_levels_upgrade_fix', 'fixed');
	} elseif (get_option('alsp_installed_directory_version') != ALSP_VERSION) {
		$old_version = get_option('alsp_installed_directory_version');
		
		//if (version_compare( $old_version, ALSP_VERSION, '<' ) ) {
		if ($old_version == '1.13.5') {
			if(isset($_POST['alsp_db_update'])){
				upgrade_to_1_13_6();
				upgrade_to_1_13_9();
				upgrade_to_1_14_4();
				update_option('alsp_installed_directory_version', ALSP_VERSION);
			}
			?>
			<div class="alsp-notice notice notice-error">
				<p><?php echo esc_html__('Listing', 'ALSP'); ?> <?php echo ALSP_VERSION ?> <?php echo esc_html__(' Required Database Upgrade, please click below to update database.', 'ALSP'); ?></p>
				<div class="">
					<form method="post" enctype="multipart/form-data">
						<button id="alsp_db_update" class="update_submit" type="submit" name="alsp_db_update"><?php echo esc_html__('Update', 'ALSP'); ?></button>
					</form>
				</div>
			</div>
			<?php
		}elseif(is_admin() && $old_version == '1.13.6' || $old_version == '1.13.7' || $old_version == '1.13.8'){
			if(isset($_POST['alsp_db_update'])){
				upgrade_to_1_13_9();
				upgrade_to_1_14_4();
				update_option('alsp_installed_directory_version', ALSP_VERSION);
			}
			?>
			<div class="alsp-notice notice notice-error">
				<p><?php echo esc_html__('Listing', 'ALSP'); ?> <?php echo ALSP_VERSION ?> <?php echo esc_html__(' Required Database Upgrade, please click below to update database.', 'ALSP'); ?></p>
				<div class="">
					<form method="post" enctype="multipart/form-data">
						<button id="alsp_db_update" class="update_submit" type="submit" name="alsp_db_update"><?php echo esc_html__('Update', 'ALSP'); ?></button>
					</form>
				</div>
			</div>
			<?php
		}elseif(is_admin() && $old_version == '1.13.9' || $old_version == '1.14' || $old_version == '1.14.1' ||  $old_version == '1.14.2' ||  $old_version == '1.14.3'){
			if(isset($_POST['alsp_db_update'])){
				upgrade_to_1_14_4();
				update_option('alsp_installed_directory_version', ALSP_VERSION);
			}
			?>
			<div class="alsp-notice notice notice-error">
				<p><?php echo esc_html__('Listing', 'ALSP'); ?> <?php echo ALSP_VERSION ?> <?php echo esc_html__(' Required Database Upgrade, please click below to update database.', 'ALSP'); ?></p>
				<div class="">
					<form method="post" enctype="multipart/form-data">
						<button id="alsp_db_update" class="update_submit" type="submit" name="alsp_db_update"><?php echo esc_html__('Update', 'ALSP'); ?></button>
					</form>
				</div>
			</div>
			<?php
		}else{
			update_option('alsp_installed_directory_version', ALSP_VERSION);
		}
		if (is_admin() &&  version_compare( get_option('alsp_installed_directory_version'), ALSP_VERSION, '==' ) ) {
			?>
					<div class="notice notice-success is-dismissible">
						<p><?php echo esc_html__(' Database updated successfully', 'ALSP'); ?></p>
					</div>
					<?php
		}

		//alsp_save_dynamic_css();
		
		
	}
	
	global $alsp_instance;
	$alsp_instance->loadClasses();
}

function alsp_levels_upgrade_fix(){
	if(get_option('alsp_installed_directory_version') != '1.13.5'){
			if(isset($_POST['alsp_db_update_level'])){
				
				upgrade_to_1_13_6();
				update_option('alsp_levels_upgrade_fix', 'fixed');
			}
			?>
			<div class="alsp-notice notice notice-warning is-dismissible">
				<p><?php echo esc_html__(' if listing levels not working please update database, Click Working fine button  if listing levels are working fine ', 'ALSP'); ?>></p>
				<div class="">
					<form method="post" enctype="multipart/form-data">
						<button id="alsp_db_update_level" class="update_submit" type="submit" name="alsp_db_update_level"><?php echo esc_html__('Fix', 'ALSP'); ?></button>
					</form>
				</div>
			</div>
			<?php 
	} 
}

function upgrade_to_1_0_6() {
	add_option('alsp_show_what_search', 1);
	add_option('alsp_show_where_search', 1);
}

function upgrade_to_1_0_7() {
	add_option('alsp-content_width', 60);
}

function upgrade_to_1_1_0() {
	delete_option('alsp_is_home_page');
	delete_option('alsp-content_width');
}

function upgrade_to_1_1_2() {
	add_option('alsp_listings_on_index', 1);
	add_option('alsp_listing_contact_form', 1);
}

function upgrade_to_1_1_4() {
	add_option('alsp_favourites_list', 1);
	add_option('alsp_print_button', 1);
	add_option('alsp_pdf_button', 1);
}

function upgrade_to_1_1_5() {
	add_option('alsp_default_map_zoom', 11);
}

function upgrade_to_1_1_7() {
	add_option('alsp_categories_icons');
}

function upgrade_to_1_2_0() {
	add_option('alsp_change_expiration_date', 0);
}

function upgrade_to_1_3_0() {
	add_option('alsp_categories_columns', 2);
	add_option('alsp_map_style', 'default');
}

function upgrade_to_1_3_2() {
	add_option('alsp_main_search', 1);
	add_option('alsp_hide_comments_number_on_index', 0);
	add_option('alsp_hide_listings_creation_date', 1);
}

function upgrade_to_1_4_0() {
	global $wpdb;

	$wpdb->query("ALTER TABLE {$wpdb->alsp_content_fields} ADD `on_map` TINYINT( 1 ) NOT NULL AFTER `on_search_form`");

	add_option('alsp_enable_radius_search_cycle', 0);
	add_option('alsp_enable_clusters', 0);
	add_option('alsp_show_location_count_in_search', 1);
}

function upgrade_to_1_4_2() {
	add_option('alsp_color_scheme', 'default');
}

function upgrade_to_1_5_0() {
	add_option('alsp_images_lightbox', 1);
}

function upgrade_to_1_5_4() {
	add_option('alsp_listing_contact_form_7', '');
}

function upgrade_to_1_5_5() {
	if (($widgets_array = get_option('widget_alsp_search_widget')) && is_array($widgets_array)) {
		foreach ($widgets_array AS &$widget) {
			if (isset($widget['title'])) {
				$widget['visibility'] = 1;
				$widget['search_visibility'] = 1;
			}
		}
		update_option('widget_alsp_search_widget', $widgets_array);
	}

	if (($widgets_array = get_option('widget_alsp_categories_widget')) && is_array($widgets_array)) {
		foreach ($widgets_array AS &$widget) {
			if (isset($widget['title']))
				$widget['visibility'] = 1;
		}
		update_option('widget_alsp_categories_widget', $widgets_array);
	}

	if (($widgets_array = get_option('widget_alsp_listings_widget')) && is_array($widgets_array)) {
		foreach ($widgets_array AS &$widget) {
			if (isset($widget['title']))
				$widget['visibility'] = 1;
		}
		update_option('widget_alsp_listings_widget', $widgets_array);
	}
	
	if (($widgets_array = get_option('widget_alsp_social_widget')) && is_array($widgets_array)) {
		foreach ($widgets_array AS &$widget) {
			if (isset($widget['title']))
				$widget['visibility'] = 1;
		}
		update_option('widget_alsp_social_widget', $widgets_array);
	}
}

function upgrade_to_1_5_7() {
	add_option('alsp_show_keywords_search', 1);
	add_option('alsp_show_locations_search', 1);
	add_option('alsp_show_address_search', 1);

	add_option('alsp_subcategories_items', 0);
	
	if (($widgets_array = get_option('widget_alsp_categories_widget')) && is_array($widgets_array)) {
		foreach ($widgets_array AS &$widget) {
			if (isset($widget['title']))
				$widget['subcats'] = 0;
		}
		update_option('widget_alsp_categories_widget', $widgets_array);
	}
}

function upgrade_to_1_5_8() {
	add_option('alsp_default_geocoding_location', '');
	add_option('alsp_show_orderby_links', 1);
	add_option('alsp_orderby_date', 1);
	add_option('alsp_orderby_title', 1);
	add_option('alsp_default_orderby', 'post_date');
	add_option('alsp_default_order', 'DESC');
}

function upgrade_to_1_6_0() {
	global $wpdb;
	
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} ADD `upgrade_meta` TEXT NOT NULL"); 
}

function upgrade_to_1_6_2() {
	$args = array(
		'post_type' => ALSP_POST_TYPE,
		'post_status' => 'any',
		'nopaging' => true
	);
	$query = new WP_Query($args);
	while ($query->have_posts()) {
		$query->the_post();

		$listing = new alsp_listing;
		$listing->loadListingFromPost(get_post());

		if ($listing->logo_image)
			update_post_meta($listing->post->ID, '_thumbnail_id', $listing->logo_image);
	}
	// this is reset is really required after the loop ends
	wp_reset_postdata();

	global $alsp_instance, $wpdb;
	foreach ($alsp_instance->content_fields->content_fields_array AS $content_field) {
		if ($content_field->type == 'select' || $content_field->type == 'checkbox' || $content_field->type == 'radio') {
			foreach ($content_field->selection_items AS $key=>$item)
				$wpdb->update($wpdb->postmeta, array('meta_value' => $key), array('meta_key' => '_content_field_' . $content_field->id, 'meta_value' => $item));
		}
	}
	
	add_option('alsp_enable_automatic_translations', 0);
}

function upgrade_to_1_7_0() {
	if (get_option('alsp_miles_kilometers_in_search', null) === null) {
		add_option('alsp_show_category_count_in_search', 1);
		add_option('alsp_miles_kilometers_in_search', 'miles');
		add_option('alsp_radius_search_min', 0);
		add_option('alsp_radius_search_max', 10);
		add_option('alsp_show_categories_search', 1);
		add_option('alsp_show_radius_search', 1);
		add_option('alsp_radius_search_default', 0);
		add_option('alsp_orderby_distance', 1);
	}
}

function upgrade_to_1_8_0() {
	global $wpdb;

	add_option('alsp_compare_palettes', 0);
	add_option('alsp_links_color', '#2393ba');
	add_option('alsp_links_hover_color', '#2a6496');
	add_option('alsp_button_1_color', '#2393ba');
	add_option('alsp_button_2_color', '#1f82a5');
	add_option('alsp_button_text_color', '#FFFFFF');
	add_option('alsp_search_1_color', '#bafefe');
	add_option('alsp_search_2_color', '#47c6c6');
	add_option('alsp_search_text_color', '#FFFFFF');
	add_option('alsp_categories_1_color', '#CEE6F3');
	add_option('alsp_categories_2_color', '#DEEEF7');
	add_option('alsp_categories_text_color', '#2393ba');
	add_option('alsp_primary_color', '#2393ba');
	add_option('alsp_featured_color', '#e1ffff');
	add_option('alsp_listings_bottom_margin', 40);
	add_option('alsp_listing_title_font', 25);
	add_option('alsp_default_map_height', 450);
	add_option('alsp_jquery_ui_schemas', 'redmond');
	add_option('alsp_addresses_order', array("line_1", "comma1", "line_2", "comma2", "location", "space1", "zip"));
	add_option('alsp_orderby_exclude_null', 0);
	delete_option('alsp_images_on_tab');
	delete_option('alsp_listings_own_page');

	add_option('alsp_enable_nologo', 1);
	add_option('alsp_nologo_url', ALSP_RESOURCES_URL . 'images/nologo.png');

	add_option('alsp_map_marker_width', 48);
	add_option('alsp_map_marker_height', 48);
	add_option('alsp_map_marker_anchor_x', 24);
	add_option('alsp_map_marker_anchor_y', 48);
	add_option('alsp_map_infowindow_width', 350);
	add_option('alsp_map_infowindow_offset', 50);
	add_option('alsp_map_infowindow_logo_width', 110);
	
	add_option('alsp_excerpt_length', 25);
	add_option('alsp_cropped_content_as_excerpt', 1);
	add_option('alsp_strip_excerpt', 1);

	$wpdb->query("ALTER TABLE {$wpdb->alsp_locations_relationships} ADD `additional_info` TEXT NOT NULL AFTER `zip_or_postal_index`");
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} ADD `content_fields` TEXT NOT NULL AFTER `categories`");
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} ADD `nofollow` TINYINT( 1 ) NOT NULL DEFAULT '0' AFTER `featured`");
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} ADD `listings_own_page` TINYINT( 1 ) NOT NULL DEFAULT '1' AFTER `nofollow`");
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} DROP `logo_size`");

	$levels_row = $wpdb->get_row("SELECT * FROM {$wpdb->alsp_levels}");
	if (!isset($levels_row->upgrade_meta))
		$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} ADD `upgrade_meta` TEXT NOT NULL");

	$wpdb->query("UPDATE {$wpdb->alsp_content_fields} SET `is_search_configuration_page`=1 WHERE `type` IN ('select','checkbox','radio')");
	
	alsp_renewMapIcons();
}
function alsp_renewMapIcons() {
	$old_folders = scandir(ALSP_MAP_ICONS_PATH . 'icons');
	$old_files = array();
	foreach ($old_folders AS $old_folder) {
		if ($old_folder != '.' && $old_folder != '..' && $old_folder != '_new') {
			$old_folders_files = scandir(ALSP_MAP_ICONS_PATH . 'icons/'.$old_folder);
			foreach ($old_folders_files AS $file) {
				if ($file != '.' && $file != '..') {
					$old_files[$old_folder][] = $file;
				}
			}
				
		}
	}

	$new_files = scandir(ALSP_MAP_ICONS_PATH . 'icons/_new');
	unset($new_files[array_search('.', $new_files)]);
	unset($new_files[array_search('..', $new_files)]);

	$result = array();
	foreach ($old_files AS $old_folder_name=>$old_folder) {
		foreach ($old_folder AS $old_file) {
			$found = false;
			foreach ($new_files AS $new_file) {
				if (strtolower($old_file) == strtolower($new_file)) {
					$result[] = array('old' => $old_folder_name.'/'.$old_file, 'new' => '_new/'.$new_file);
					$found = true;
					continue 2;
				}
			}
			if (!$found)
				$result[] = array('old' => $old_folder_name.'/'.$old_file, 'new' => '_new/'.$new_files[array_rand($new_files)]);
		}
	}

	global $wpdb;
	foreach ($result AS $rewrite)
		$wpdb->update($wpdb->alsp_locations_relationships, array('map_icon_file' => $rewrite['new']), array('map_icon_file' => $rewrite['old']));

	add_option('alsp_map_markers_update_backup', $result);
}

function upgrade_to_1_8_1() {
	add_option('alsp_orderby_sticky_featured', 0);
}

function upgrade_to_1_8_2() {
	add_option('alsp_button_gradient', 0);
}

function upgrade_to_1_8_3() {
	global $wpdb;
	if ( $wpdb->has_cap( 'collation' ) ) {
			$collate = $wpdb->get_charset_collate();
		}
	$wpdb->query("ALTER TABLE {$wpdb->alsp_content_fields} ADD `group_id` INT NOT NULL DEFAULT '0', ADD INDEX ( `group_id` )");
	$wpdb->query("CREATE TABLE IF NOT EXISTS {$wpdb->alsp_content_fields_groups} (
					`id` int(11) NOT NULL AUTO_INCREMENT,
					`name` varchar(255) NOT NULL,
					`on_tab` tinyint(1) NOT NULL DEFAULT '0',
					`hide_anonymous` tinyint(1) NOT NULL DEFAULT '0',
					PRIMARY KEY (`id`)
					) $collate ;");
	
	add_option('alsp_enable_description', 1);
	add_option('alsp_enable_excerpt', 1);

	add_option('alsp_share_buttons_style', 'arbenta');
	add_option('alsp_share_buttons', array());
	add_option('alsp_share_counter', 0);
	add_option('alsp_share_buttons_place', 'title');
	add_option('alsp_share_buttons_width', 40);

	add_option('alsp_100_single_logo_width', 1);
	add_option('alsp_single_logo_width', 270);
}

function upgrade_to_1_8_4() {
	add_option('alsp_notinclude_jqueryui_css', 0);
	add_option('alsp_views_switcher', 1);
	add_option('alsp_views_switcher_default', 'list');
	add_option('alsp_views_switcher_grid_columns', 2);
}

function upgrade_to_1_8_6() {
	add_option('alsp_enable_address_line_1', 1);
	add_option('alsp_enable_address_line_2', 1);
	add_option('alsp_enable_postal_index', 1);
	add_option('alsp_enable_additional_info', 1);
	add_option('alsp_enable_manual_coords', 1);

	add_option('alsp_big_slide_bg_mode', 'cover');
}

function upgrade_to_1_9_0() {
	global $wpdb;

	add_option('alsp_directions_functionality', 'builtin');
	add_option('alsp_address_autocomplete', 1);
	add_option('alsp_address_geocode', 1);
	add_option('alsp_listings_comments_mode', 'wp_settings');
	add_option('alsp_listings_tabs_order', array("addresses-tab", "comments-tab", "videos-tab", "contact-tab"));

	add_option('alsp_listing_slug', 'business-listing');
	add_option('alsp_location_slug', 'business-place');
	add_option('alsp_permalinks_structure', 'postname');

	add_option('alsp_google_api_key', '');
	
	add_option('alsp_locations_1_color', '#CEE6F3');
	add_option('alsp_locations_2_color', '#DEEEF7');
	add_option('alsp_locations_text_color', '#2393ba');

	add_option('alsp_show_locations_index', 0);
	add_option('alsp_locations_nesting_level', 1);
	add_option('alsp_locations_columns', 2);
	add_option('alsp_sublocations_items', 0);
	add_option('alsp_show_location_count', 1);
	
	add_option('alsp_locations_icons');
	
	if (($widgets_array = get_option('widget_alsp_categories_widget')) && is_array($widgets_array)) {
		foreach ($widgets_array AS &$widget) {
			if (isset($widget['title']))
				$widget['parent'] = 0;
		}
		update_option('widget_alsp_categories_widget', $widgets_array);
	}
	
	$wpdb->query("UPDATE {$wpdb->alsp_content_fields} SET `is_configuration_page`=1 WHERE `type`='hours'");

	add_option('alsp_enable_breadcrumbs', 1);
	add_option('alsp_hide_home_link_breadcrumb', 0);
	add_option('alsp_breadcrumbs_mode', 'title');
}

function upgrade_to_1_9_1() {
	
}

function upgrade_to_1_9_5() {
	global $wpdb;

	add_option('alsp_google_api_key', get_option('alsp_google_maps_api_key'));

	add_option('alsp_enable_lighbox_gallery', 1);
	
	$wpdb->query("UPDATE {$wpdb->alsp_content_fields} SET `is_configuration_page`=1 WHERE `type`='string' OR `type`='textarea'");
}

function upgrade_to_1_9_6() {
	add_option('alsp_exclude_logo_from_listing', 0);
}

function upgrade_to_1_9_9() {
	add_option('alsp_auto_slides_gallery', 0);
	add_option('alsp_auto_slides_gallery_delay', 3000);
}

function upgrade_to_1_10_0() {
	add_option('alsp_ajax_load', 1);
	add_option('alsp_ajax_initial_load', 0);
	add_option('alsp_show_more_button', 1);
}

function upgrade_to_1_11_0() {
	add_option('alsp_map_markers_type', 'images');
	add_option('alsp_default_marker_color', '#2393ba');
	add_option('alsp_default_marker_icon', '');
	add_option('alsp_search_on_map', 0);
}

function upgrade_to_1_11_3() {
	add_option('alsp_enable_stats', 1);

	// these settings were missed in standard installation of previous version
	add_option('alsp_map_marker_width', 48);
	add_option('alsp_map_marker_height', 48);
	add_option('alsp_map_marker_anchor_x', 24);
	add_option('alsp_map_marker_anchor_y', 48);
}

function upgrade_to_1_11_4() {
	add_option('alsp_google_api_key_server', '');
}

function upgrade_to_1_11_5() {
	global $wpdb;

	$wpdb->query("UPDATE {$wpdb->alsp_content_fields} SET `slug`='categories_list' WHERE `slug`='categories'");
}

function upgrade_to_1_11_6() {
	if (($widgets_array = get_option('widget_alsp_search_widget')) && is_array($widgets_array)) {
		foreach ($widgets_array AS &$widget) {
			if (isset($widget['title'])) {
				$widget['uid'] = '';
			}
		}
		update_option('widget_alsp_search_widget', $widgets_array);
	}
	
	add_option('alsp_hide_author_link', 1);
	
	add_option('alsp_enable_full_screen', 1);
	add_option('alsp_enable_wheel_zoom', 1);
	add_option('alsp_enable_dragging_touchscreens', 1);
	add_option('alsp_center_map_onclick', 0);
	add_option('alsp_hide_search_on_map_mobile', 0);
}

function upgrade_to_1_11_7() {
	add_option('alsp_map_language_from_wpml', 0);
}

function upgrade_to_1_12_0() {
	add_option('alsp_enable_draw_panel', 0);
}
function upgrade_to_1_12_1() {
	global $wpdb;
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} ADD `featured_level` TINYINT( 1 ) NOT NULL DEFAULT '0' AFTER `logo_enabled`");
}
function upgrade_to_1_13_1() {
	add_option('alsp_custom_contact_email', 0);
	global $wpdb;
	
	//$wpdb->query("ALTER TABLE {$wpdb->alsp_content_fields} (`is_core_field`, `order_num`, `name`, `slug`, `description`, `type`, `icon_image`, `is_required`, `is_configuration_page`, `is_search_configuration_page`, `is_ordered`, `is_hide_name`, `on_exerpt_page`, `on_listing_page`, `on_search_form`, `on_map`, `advanced_search_form`, `categories`, `options`, `search_options`, `group_id`) VALUES(1, 2, 'Price', 'price', '', 'price', '', 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, '', '', '', '1');");
	if (!$wpdb->get_var("SELECT id FROM {$wpdb->alsp_content_fields} WHERE slug = 'price'"))
			$wpdb->query("INSERT INTO {$wpdb->alsp_content_fields} (`is_core_field`, `order_num`, `name`, `slug`, `description`, `type`, `icon_image`, `is_required`, `is_configuration_page`, `is_search_configuration_page`, `is_ordered`, `is_hide_name`, `on_exerpt_page`, `on_listing_page`, `on_search_form`, `on_map`, `advanced_search_form`, `categories`, `options`, `search_options`, `group_id`) VALUES(0, 2, 'Price', 'price', '', 'price', '', 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, '', '', '', '1');");
	if ($wpdb->get_var("SELECT id FROM {$wpdb->alsp_content_fields} WHERE slug = 'price'"))
		$wpdb->query("UPDATE {$wpdb->alsp_content_fields} SET `is_core_field`=0 WHERE `slug`='price' ");	
}
function upgrade_to_1_13_4() {
	add_option('listing_view_style', null);
		
}
function upgrade_to_1_13_5() {
	global $wpdb;
	//if ( $wpdb->has_cap( 'collation' ) ) {
			$collate = $wpdb->get_charset_collate();
	//	}
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} CONVERT TO CHARACTER SET $collate; ");
	$wpdb->query("ALTER TABLE {$wpdb->alsp_content_fields} CONVERT TO CHARACTER SET utf8mb4");	
	$wpdb->query("ALTER TABLE {$wpdb->alsp_content_fields_groups} CONVERT TO CHARACTER SET utf8mb4");	
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels_relationships} CONVERT TO CHARACTER SET $collate; ");	
	$wpdb->query("ALTER TABLE {$wpdb->alsp_locations_levels} CONVERT TO CHARACTER SET utf8mb4");
	$wpdb->query("ALTER TABLE {$wpdb->alsp_locations_relationships} CONVERT TO CHARACTER SET utf8mb4");
}
function upgrade_to_1_13_6() {
	add_option('alsp_hide_views_counter', 1);
	
	global $alsp_instance, $wpdb;
	
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} ADD `active_interval` tinyint(1) NOT NULL AFTER `description`");
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} ADD `active_period` varchar(255) NOT NULL AFTER `active_interval`");
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} ADD `eternal_active_period` tinyint(1) NOT NULL AFTER `active_period`");
	
	$array = $wpdb->get_results("SELECT * FROM {$wpdb->alsp_levels} ORDER BY order_num", ARRAY_A);
	foreach ($array AS $row) {
		$id = alsp_getValue($row, 'id');
		$active_years = alsp_getValue($row, 'active_years');
		$active_months = alsp_getValue($row, 'active_months');
		$active_days = alsp_getValue($row, 'active_days');
		
		$interval = '';
		$period = '';
		$eternal = 1;
		if ($active_years || $active_months || $active_days) {
			$eternal = 0;

			if ($active_years) {
				$interval = ($active_years > 6) ? 6: $active_years;
				$period = 'year';
			} elseif ($active_months) {
				$interval = ($active_months > 6) ? 6: $active_months;
				$period = 'month';
			} elseif ($active_days) {
				if ($active_days == 7) {
					$interval = 1;
					$period = 'week';
				} else {
					$interval = ($active_days > 6) ? 6: $active_days;
					$period = 'day';
				}
			}
		}

		$wpdb->query("UPDATE {$wpdb->alsp_levels} SET `active_interval`='{$interval}', `active_period`='{$period}', `eternal_active_period`='{$eternal}' WHERE `id`={$id}");
	}
	
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} DROP `active_years`");
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} DROP `active_months`");
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} DROP `active_days`");
	
	$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} ADD `locations` TEXT NOT NULL AFTER `categories`");
	$locations_field = $wpdb->get_results("SHOW COLUMNS FROM {$wpdb->alsp_levels} LIKE 'locations'", ARRAY_A);
	if (empty($locations_field)) {
		$wpdb->query("ALTER TABLE {$wpdb->alsp_levels} ADD `locations` TEXT NOT NULL AFTER `categories`");
	}
	
}
function upgrade_to_1_13_9() {
	global $alsp_instance, $wpdb, $alspReduxFramework;

$wpdb->query("ALTER TABLE {$wpdb->alsp_content_fields} ADD `on_search_form_archive` tinyint(1) NOT NULL AFTER `on_map`");
$wpdb->query("ALTER TABLE {$wpdb->alsp_content_fields} ADD `on_search_form_widget` tinyint(1) NOT NULL AFTER `on_search_form_archive`");

if(get_option('alsp_fsubmit_addon')){
	$payment_addon = 'alsp_buitin_payment';
}else{
	$payment_addon = 'alsp_woo_payment';
}


Redux::setOption('alsp_admin_settings', 'alsp_payments_addon', $payment_addon);
Redux::setOption('alsp_admin_settings', 'alsp_woocommerce_frontend_links', get_option('alsp_woocommerce_frontend_links'));
Redux::setOption('alsp_admin_settings', 'alsp_woocommerce_mode', get_option('alsp_woocommerce_mode'));
Redux::setOption('alsp_admin_settings','alsp_payments_currency', get_option('alsp_payments_currency'));
Redux::setOption('alsp_admin_settings', 'alsp_payments_symbol_code', get_option('alsp_payments_symbol_code'));
Redux::setOption('alsp_admin_settings', 'alsp_payments_symbol_position', get_option('alsp_payments_symbol_position'));
Redux::setOption('alsp_admin_settings','alsp_payments_decimal_separator', get_option('alsp_payments_decimal_separator'));
Redux::setOption('alsp_admin_settings','alsp_hide_decimals', get_option('alsp_hide_decimals'));
Redux::setOption('alsp_admin_settings','alsp_payments_thousands_separator', get_option('alsp_payments_thousands_separator'));
Redux::setOption('alsp_admin_settings','alsp_enable_taxes', get_option('alsp_enable_taxes'));
Redux::setOption('alsp_admin_settings','alsp_taxes_info', get_option('alsp_taxes_info'));
Redux::setOption('alsp_admin_settings','alsp_tax_name', get_option('alsp_tax_name'));
Redux::setOption('alsp_admin_settings','alsp_tax_rate', get_option('alsp_tax_rate'));
Redux::setOption('alsp_admin_settings','alsp_taxes_mode', get_option('alsp_taxes_mode'));
Redux::setOption('alsp_admin_settings','alsp_allow_bank', get_option('alsp_allow_bank'));
Redux::setOption('alsp_admin_settings','alsp_bank_info', get_option('alsp_bank_info'));
Redux::setOption('alsp_admin_settings','alsp_paypal_email', get_option('alsp_paypal_email'));
Redux::setOption('alsp_admin_settings','alsp_paypal_single', get_option('alsp_paypal_single'));
Redux::setOption('alsp_admin_settings','alsp_paypal_subscriptions', get_option('alsp_paypal_subscriptions'));
Redux::setOption('alsp_admin_settings','alsp_paypal_test', get_option('alsp_paypal_test'));
Redux::setOption('alsp_admin_settings','alsp_stripe_test_secret', get_option('alsp_stripe_test_secret'));
Redux::setOption('alsp_admin_settings','alsp_stripe_test_public', get_option('alsp_stripe_test_public'));
Redux::setOption('alsp_admin_settings','alsp_stripe_live_secret', get_option('alsp_stripe_live_secret'));
Redux::setOption('alsp_admin_settings','alsp_stripe_live_public', get_option('alsp_stripe_live_public'));
Redux::setOption('alsp_admin_settings','alsp_stripe_test', get_option('alsp_stripe_test'));
Redux::setOption('alsp_admin_settings','alsp_payments_free_for_admins', get_option('alsp_payments_free_for_admins'));

Redux::setOption('alsp_admin_settings', 'alsp_ratings_addon', get_option('alsp_ratings_addon'));

Redux::setOption('alsp_admin_settings', 'alsp_ajax_load', get_option('alsp_ajax_load'));
Redux::setOption('alsp_admin_settings', 'alsp_ajax_initial_load', get_option('alsp_ajax_initial_load'));
Redux::setOption('alsp_admin_settings', 'alsp_show_more_button', get_option('alsp_show_more_button'));

Redux::setOption('alsp_admin_settings', alsp_get_wpml_dependent_option_name('alsp_directory_title'), alsp_get_wpml_dependent_option('alsp_directory_title'));
Redux::setOption('alsp_admin_settings','alsp_listing_slug', get_option('alsp_listing_slug'));
Redux::setOption('alsp_admin_settings','alsp_category_slug', get_option('alsp_category_slug'));
Redux::setOption('alsp_admin_settings','alsp_location_slug', get_option('alsp_location_slug'));
Redux::setOption('alsp_admin_settings','alsp_tag_slug', get_option('alsp_tag_slug'));
Redux::setOption('alsp_admin_settings','alsp_permalinks_structure', get_option('alsp_permalinks_structure'));


Redux::setOption('alsp_admin_settings','alsp_fsubmit_addon', get_option('alsp_fsubmit_addon'));
Redux::setOption('alsp_admin_settings','alsp_fsubmit_login_mode', get_option('alsp_fsubmit_login_mode'));
Redux::setOption('alsp_admin_settings','alsp_fsubmit_default_status', get_option('alsp_fsubmit_default_status'));
Redux::setOption('alsp_admin_settings','alsp_fsubmit_edit_status', get_option('alsp_fsubmit_edit_status'));
Redux::setOption('alsp_admin_settings','alsp_fsubmit_button', get_option('alsp_fsubmit_button'));
Redux::setOption('alsp_admin_settings','restrict_non_admin', get_option('restrict_non_admin'));
Redux::setOption('alsp_admin_settings','alsp_hide_admin_bar', get_option('alsp_hide_admin_bar'));
Redux::setOption('alsp_admin_settings','alsp_allow_edit_profile', get_option('alsp_allow_edit_profile'));
Redux::setOption('alsp_admin_settings','alsp_enable_tags', get_option('alsp_enable_tags'));
Redux::setOption('alsp_admin_settings', alsp_get_wpml_dependent_option_name('alsp_submit_login_page'), alsp_get_wpml_dependent_option('alsp_submit_login_page'));
Redux::setOption('alsp_admin_settings', alsp_get_wpml_dependent_option_name('alsp_tospage'), alsp_get_wpml_dependent_option('alsp_tospage'));
Redux::setOption('alsp_admin_settings', alsp_get_wpml_dependent_option_name('alsp_dashboard_login_page'), alsp_get_wpml_dependent_option('alsp_dashboard_login_page'));
Redux::setOption('alsp_admin_settings','alsp_claim_functionality', get_option('alsp_claim_functionality'));
Redux::setOption('alsp_admin_settings','alsp_claim_approval', get_option('alsp_claim_approval'));
Redux::setOption('alsp_admin_settings','alsp_after_claim', get_option('alsp_after_claim'));
Redux::setOption('alsp_admin_settings','alsp_hide_claim_contact_form', get_option('alsp_hide_claim_contact_form'));
Redux::setOption('alsp_admin_settings','alsp_hide_claim_metabox', get_option('alsp_hide_claim_metabox'));

Redux::setOption('alsp_admin_settings','frontend_panel_user_type', 1);
Redux::setOption('alsp_admin_settings','frontend_panel_user_email', 1);
Redux::setOption('alsp_admin_settings','frontend_panel_user_phone', 1);
Redux::setOption('alsp_admin_settings','frontend_panel_user_address', 1);
Redux::setOption('alsp_admin_settings','frontend_panel_user_website', 1);
Redux::setOption('alsp_admin_settings','frontend_panel_social_links', 1);
Redux::setOption('alsp_admin_settings','alsp_favourites_list', get_option('alsp_favourites_list'));
Redux::setOption('alsp_admin_settings','author_profile_view', 1);

Redux::setOption('alsp_admin_settings', 'alsp_listings_on_index', get_option('alsp_listings_on_index'));
Redux::setOption('alsp_admin_settings', 'user_panel_logo', get_option('user_panel_logo'));
Redux::setOption('alsp_admin_settings', 'alsp_listing_post_style', get_option('alsp_listing_post_style'));
Redux::setOption('alsp_admin_settings', 'alsp_listing_listview_post_style', get_option('alsp_listing_listview_post_style'));
Redux::setOption('alsp_admin_settings', 'alsp_single_listing_style', get_option('alsp_single_listing_style'));
Redux::setOption('alsp_admin_settings', 'view_switther_panel_style', '1');
Redux::setOption('alsp_admin_settings', 'alsp_listings_number_index', get_option('alsp_listings_number_index'));
Redux::setOption('alsp_admin_settings', 'alsp_listings_number_excerpt', get_option('alsp_listings_number_excerpt'));
Redux::setOption('alsp_admin_settings','alsp_grid_padding', 15);
Redux::setOption('alsp_admin_settings','alsp_grid_margin_bottom', 30);
Redux::setOption('alsp_admin_settings','alsp_listing_bidding', 1);
Redux::setOption('alsp_admin_settings','alsp_listing_contact', 1);
Redux::setOption('alsp_admin_settings', 'alsp_listing_contact_form', get_option('alsp_listing_contact_form'));
Redux::setOption('alsp_admin_settings', 'alsp_custom_contact_email', get_option('alsp_custom_contact_email'));
Redux::setOption('alsp_admin_settings', alsp_get_wpml_dependent_option_name('alsp_listing_contact_form_7'), alsp_get_wpml_dependent_option('alsp_listing_contact_form_7'));
Redux::setOption('alsp_admin_settings', 'alsp_print_button', get_option('alsp_print_button'));
Redux::setOption('alsp_admin_settings', 'alsp_pdf_button', get_option('alsp_pdf_button'));
Redux::setOption('alsp_admin_settings', 'alsp_change_expiration_date', get_option('alsp_change_expiration_date'));
Redux::setOption('alsp_admin_settings', 'alsp_hide_comments_number_on_index', get_option('alsp_hide_comments_number_on_index'));
Redux::setOption('alsp_admin_settings', 'alsp_listings_comments_mode', get_option('alsp_listings_comments_mode'));
Redux::setOption('alsp_admin_settings', 'map_on_single_listing_tab', get_option('map_on_single_listing_tab'));
//Redux::setOption('alsp_admin_settings', 'alsp-listings-tabs-order', get_option('alsp_listings_tabs_order'));
Redux::setOption('alsp_admin_settings', 'alsp_enable_stats', get_option('alsp_enable_stats'));

Redux::setOption('alsp_admin_settings','alsp_share_buttons_style', get_option('alsp_share_buttons_style'));
Redux::setOption('alsp_admin_settings','alsp_share_counter', get_option('alsp_share_counter'));
Redux::setOption('alsp_admin_settings','alsp_share_buttons_place', get_option('alsp_share_buttons_place'));
Redux::setOption('alsp_admin_settings','alsp_share_buttons_width', get_option('alsp_share_buttons_width'));

Redux::setOption('alsp_admin_settings','alsp_enable_breadcrumbs', get_option('alsp_enable_breadcrumbs'));
Redux::setOption('alsp_admin_settings','alsp_hide_home_link_breadcrumb', get_option('alsp_hide_home_link_breadcrumb'));
Redux::setOption('alsp_admin_settings','alsp_breadcrumbs_mode', get_option('alsp_breadcrumbs_mode'));

Redux::setOption('alsp_admin_settings','single_listing_other_ads_byuser', get_option('single_listing_other_ads_byuser'));
Redux::setOption('alsp_admin_settings','single_listing_othoradd_limit', get_option('single_listing_othoradd_limit'));
Redux::setOption('alsp_admin_settings','single_listing_otherads_viewshitcher', get_option('single_listing_otherads_viewshitcher'));
Redux::setOption('alsp_admin_settings','hide_ordering_single_listing_otherads', get_option('hide_ordering_single_listing_otherads'));
Redux::setOption('alsp_admin_settings','single_listing_otherads_gridview_col', get_option('single_listing_otherads_gridview_col'));
Redux::setOption('alsp_admin_settings','single_listing_otherads_view_type', get_option('single_listing_otherads_view_type'));

Redux::setOption('alsp_admin_settings','alsp_enable_lighbox_gallery', get_option('alsp_enable_lighbox_gallery'));
Redux::setOption('alsp_admin_settings','alsp_enable_nologo', get_option('alsp_enable_nologo'));
Redux::setOption('alsp_admin_settings','alsp_nologo_url', get_option('alsp_nologo_url'));
Redux::setOption('alsp_admin_settings','alsp_100_single_logo_width', get_option('alsp_100_single_logo_width'));
Redux::setOption('alsp_admin_settings','alsp_single_logo_width', get_option('alsp_single_logo_width'));
Redux::setOption('alsp_admin_settings','alsp_single_logo_height', get_option('alsp_single_logo_height'));
Redux::setOption('alsp_admin_settings','alsp_logo_width', get_option('alsp_logo_width'));
Redux::setOption('alsp_admin_settings','alsp_logo_height', get_option('alsp_logo_height'));
Redux::setOption('alsp_admin_settings','alsp_logo_width_listview', get_option('alsp_logo_width_listview'));
Redux::setOption('alsp_admin_settings','alsp_logo_height_listview', get_option('alsp_logo_height_listview'));
Redux::setOption('alsp_admin_settings','alsp_big_slide_bg_mode', get_option('alsp_big_slide_bg_mode'));

Redux::setOption('alsp_admin_settings','alsp_enable_description', get_option('alsp_enable_description'));
Redux::setOption('alsp_admin_settings','alsp_enable_summary', get_option('alsp_enable_summary'));
Redux::setOption('alsp_admin_settings','alsp_excerpt_length', get_option('alsp_excerpt_length'));
Redux::setOption('alsp_admin_settings','max_title_length', get_option('max_title_length'));
Redux::setOption('alsp_admin_settings','alsp_cropped_content_as_excerpt', get_option('alsp_cropped_content_as_excerpt'));
Redux::setOption('alsp_admin_settings','alsp_strip_excerpt', get_option('alsp_strip_excerpt'));

Redux::setOption('alsp_admin_settings','alsp_views_switcher', get_option('alsp_views_switcher'));
Redux::setOption('alsp_admin_settings','alsp_views_switcher_default', get_option('alsp_views_switcher_default'));
Redux::setOption('alsp_admin_settings','alsp_views_switcher_grid_columns', get_option('alsp_views_switcher_grid_columns'));

Redux::setOption('alsp_admin_settings','alsp_categories_style', get_option('alsp_categories_style'));
Redux::setOption('alsp_admin_settings','cat_icon_type', get_option('cat_icon_type'));
Redux::setOption('alsp_admin_settings','alsp_show_categories_index', get_option('alsp_show_categories_index'));
Redux::setOption('alsp_admin_settings','alsp_categories_nesting_level', get_option('alsp_categories_nesting_level'));
Redux::setOption('alsp_admin_settings','alsp_categories_columns', get_option('alsp_categories_columns'));
Redux::setOption('alsp_admin_settings','alsp_subcategories_items', get_option('alsp_subcategories_items'));
Redux::setOption('alsp_admin_settings','alsp_show_category_count', get_option('alsp_show_category_count'));

Redux::setOption('alsp_admin_settings','alsp_show_locations_index', get_option('alsp_show_locations_index'));
Redux::setOption('alsp_admin_settings','alsp_locations_nesting_level', get_option('alsp_locations_nesting_level'));
Redux::setOption('alsp_admin_settings','alsp_locations_columns', get_option('alsp_locations_columns'));
Redux::setOption('alsp_admin_settings','alsp_sublocations_items', get_option('alsp_sublocations_items'));
Redux::setOption('alsp_admin_settings','alsp_show_location_count', get_option('alsp_show_location_count'));

Redux::setOption('alsp_admin_settings','alsp_show_orderby_links', get_option('alsp_show_orderby_links'));
Redux::setOption('alsp_admin_settings','alsp_orderby_date', get_option('alsp_orderby_date'));
Redux::setOption('alsp_admin_settings','alsp_orderby_title', get_option('alsp_orderby_title'));
Redux::setOption('alsp_admin_settings','alsp_orderby_distance', get_option('alsp_orderby_distance'));
Redux::setOption('alsp_admin_settings','alsp_default_orderby', get_option('alsp_default_orderby'));
Redux::setOption('alsp_admin_settings','alsp_orderby_exclude_null', get_option('alsp_orderby_exclude_null'));
Redux::setOption('alsp_admin_settings','alsp_orderby_sticky_featured', get_option('alsp_orderby_sticky_featured'));

Redux::setOption('alsp_admin_settings','alsp_pricing_plan_style', get_option('alsp_pricing_plan_style'));

Redux::setOption('alsp_admin_settings','search-form-style', get_option('search-form-style'));
Redux::setOption('alsp_admin_settings','alsp_search_style3_mtop', get_option('alsp_search_style3_mtop'));
Redux::setOption('alsp_admin_settings','alsp_search_style3_shadow', get_option('alsp_search_style3_shadow'));
Redux::setOption('alsp_admin_settings','keyword_field_width', get_option('keyword_field_width'));
Redux::setOption('alsp_admin_settings','category_field_width', get_option('category_field_width'));
Redux::setOption('alsp_admin_settings','location_field_width', get_option('location_field_width'));
Redux::setOption('alsp_admin_settings','address_field_width', get_option('address_field_width'));
Redux::setOption('alsp_admin_settings','radius_field_width', get_option('radius_field_width'));
Redux::setOption('alsp_admin_settings','button_field_width', get_option('button_field_width'));
Redux::setOption('alsp_admin_settings','gap_in_fields', get_option('gap_in_fields'));
Redux::setOption('alsp_admin_settings','alsp_main_search', get_option('alsp_main_search'));
Redux::setOption('alsp_admin_settings','advanced_search_opean_on_archive', 1);
Redux::setOption('alsp_admin_settings','advanced_open_widget', 1);
Redux::setOption('alsp_admin_settings','alsp_show_what_search', get_option('alsp_show_what_search'));
Redux::setOption('alsp_admin_settings','alsp_show_where_search', get_option('alsp_show_where_search'));
Redux::setOption('alsp_admin_settings','alsp_show_keywords_search', get_option('alsp_show_keywords_search'));
Redux::setOption('alsp_admin_settings','alsp_show_locations_search', get_option('alsp_show_locations_search'));
Redux::setOption('alsp_admin_settings','alsp_show_address_search', get_option('alsp_show_address_search'));
Redux::setOption('alsp_admin_settings','alsp_show_location_count_in_search', get_option('alsp_show_location_count_in_search'));
Redux::setOption('alsp_admin_settings','alsp_show_categories_search', get_option('alsp_show_categories_search'));
Redux::setOption('alsp_admin_settings','alsp_show_category_count_in_search', get_option('alsp_show_category_count_in_search'));
Redux::setOption('alsp_admin_settings','alsp_show_radius_search', get_option('alsp_show_radius_search'));
Redux::setOption('alsp_admin_settings','alsp_radius_search_min', get_option('alsp_radius_search_min'));
Redux::setOption('alsp_admin_settings','alsp_radius_search_max', get_option('alsp_radius_search_max'));
Redux::setOption('alsp_admin_settings','alsp_radius_search_default', get_option('alsp_radius_search_default'));

Redux::setOption('alsp_admin_settings','alsp_google_api_key', get_option('alsp_google_api_key'));
Redux::setOption('alsp_admin_settings','alsp_google_api_key_server', get_option('alsp_google_api_key_server'));
Redux::setOption('alsp_admin_settings','alsp_map_on_index', get_option('alsp_map_on_index'));
Redux::setOption('alsp_admin_settings','alsp_map_on_excerpt', get_option('alsp_map_on_excerpt'));
Redux::setOption('alsp_admin_settings','alsp_address_autocomplete_code', 0);
Redux::setOption('alsp_admin_settings','alsp_show_directions', get_option('alsp_show_directions'));
Redux::setOption('alsp_admin_settings','alsp_directions_functionality', get_option('alsp_directions_functionality'));
Redux::setOption('alsp_admin_settings','alsp_default_map_zoom', get_option('alsp_default_map_zoom'));
Redux::setOption('alsp_admin_settings','alsp_default_map_height', get_option('alsp_default_map_height'));
Redux::setOption('alsp_admin_settings','alsp_map_style', get_option('alsp_map_style'));
Redux::setOption('alsp_admin_settings','alsp_enable_radius_search_cycle', get_option('alsp_enable_radius_search_cycle'));
Redux::setOption('alsp_admin_settings','alsp_enable_clusters', get_option('alsp_enable_clusters'));

Redux::setOption('alsp_admin_settings','alsp_enable_draw_panel', get_option('alsp_enable_draw_panel'));
Redux::setOption('alsp_admin_settings','alsp_enable_full_screen', get_option('alsp_enable_full_screen'));
Redux::setOption('alsp_admin_settings','alsp_enable_wheel_zoom', get_option('alsp_enable_wheel_zoom'));
Redux::setOption('alsp_admin_settings','alsp_enable_dragging_touchscreens', get_option('alsp_enable_dragging_touchscreens'));
Redux::setOption('alsp_admin_settings','alsp_center_map_onclick', get_option('alsp_center_map_onclick'));

Redux::setOption('alsp_admin_settings','alsp_default_geocoding_location', get_option('alsp_default_geocoding_location'));
Redux::setOption('alsp_admin_settings','alsp_enable_address_line_1', get_option('alsp_enable_address_line_1'));
Redux::setOption('alsp_admin_settings','alsp_enable_address_line_2', get_option('alsp_enable_address_line_2'));
Redux::setOption('alsp_admin_settings','alsp_enable_postal_index', get_option('alsp_enable_postal_index'));
Redux::setOption('alsp_admin_settings','alsp_enable_additional_info', get_option('alsp_enable_additional_info'));
Redux::setOption('alsp_admin_settings','alsp_enable_manual_coords', get_option('alsp_enable_manual_coords'));
Redux::setOption('alsp_admin_settings','alsp_address_autocomplete', get_option('alsp_address_autocomplete'));
Redux::setOption('alsp_admin_settings','alsp_address_geocode', get_option('alsp_address_geocode'));

Redux::setOption('alsp_admin_settings','alsp_map_markers_type', get_option('alsp_map_markers_type'));
Redux::setOption('alsp_admin_settings','alsp_default_marker_icon', 'pacz-icon-map-marker');
Redux::setOption('alsp_admin_settings','alsp_default_marker_color', get_option('alsp_default_marker_color'));
Redux::setOption('alsp_admin_settings','alsp_map_marker_width', get_option('alsp_map_marker_width'));
Redux::setOption('alsp_admin_settings','alsp_map_marker_height', get_option('alsp_map_marker_height'));
Redux::setOption('alsp_admin_settings','alsp_map_marker_anchor_x', get_option('alsp_map_marker_anchor_x'));
Redux::setOption('alsp_admin_settings','alsp_map_marker_anchor_y', get_option('alsp_map_marker_anchor_y'));
Redux::setOption('alsp_admin_settings','alsp_map_infowindow_width', get_option('alsp_map_infowindow_width'));
Redux::setOption('alsp_admin_settings','alsp_map_infowindow_offset', get_option('alsp_map_infowindow_offset'));
Redux::setOption('alsp_admin_settings','alsp_map_infowindow_logo_width', get_option('alsp_map_infowindow_logo_width'));

Redux::setOption('alsp_admin_settings','alsp_send_expiration_notification_days', get_option('alsp_send_expiration_notification_days'));
Redux::setOption('alsp_admin_settings','alsp_admin_notifications_email', get_option('alsp_admin_notifications_email'));
Redux::setOption('alsp_admin_settings','alsp_preexpiration_notification', get_option('alsp_preexpiration_notification'));
Redux::setOption('alsp_admin_settings','alsp_expiration_notification', get_option('alsp_expiration_notification'));
Redux::setOption('alsp_admin_settings','alsp_newuser_notification', get_option('alsp_newuser_notification'));
Redux::setOption('alsp_admin_settings','alsp_newlisting_admin_notification', get_option('alsp_newlisting_admin_notification'));
Redux::setOption('alsp_admin_settings','alsp_approval_notification', get_option('alsp_approval_notification'));
Redux::setOption('alsp_admin_settings','alsp_claim_notification', get_option('alsp_claim_notification'));
Redux::setOption('alsp_admin_settings','alsp_claim_approval_notification', get_option('alsp_claim_approval_notification'));
Redux::setOption('alsp_admin_settings','alsp_claim_decline_notification', get_option('alsp_claim_decline_notification'));

Redux::setOption('alsp_admin_settings','alsp_enable_recaptcha', get_option('alsp_enable_recaptcha'));
Redux::setOption('alsp_admin_settings','alsp_recaptcha_public_key', get_option('alsp_recaptcha_public_key'));
Redux::setOption('alsp_admin_settings','alsp_recaptcha_private_key', get_option('alsp_recaptcha_private_key'));

Redux::setOption('alsp_admin_settings','alsp_listing_title_font', get_option('alsp_listing_title_font'));


}
function upgrade_to_1_14_4() {
	global $wpdb;
	$wpdb->query("ALTER TABLE {$wpdb->alsp_content_fields} ADD `fieldwidth_archive` varchar(255) NOT NULL AFTER `fieldwidth`");
	$wpdb->query("ALTER TABLE {$wpdb->alsp_content_fields} ADD `advanced_archive_search_form` tinyint(1) NOT NULL AFTER `advanced_search_form`");
	$wpdb->query("ALTER TABLE {$wpdb->alsp_content_fields} ADD `advanced_widget_search_form` tinyint(1) NOT NULL AFTER `advanced_archive_search_form`");
}
?>