<?php 

class alsp_content_field_select extends alsp_content_field {
	public $selection_items = array();

	protected $can_be_ordered = false;
	protected $is_configuration_page = true;
	protected $is_search_configuration_page = true;
	protected $can_be_searched = true;
	
	public function isNotEmpty($listing) {
		if ($this->value)
			return true;
		else
			return false;
	}
	
	public function __construct() {
		// adapted for WPML
		add_action('init', array($this, 'content_fields_options_into_strings'));
	}

	public function configure() {
		global $wpdb, $alsp_instance;

		wp_enqueue_script('jquery-ui-sortable');

		if (alsp_getValue($_POST, 'submit') && wp_verify_nonce($_POST['alsp_configure_content_fields_nonce'], ALSP_PATH)) {
			$validation = new alsp_form_validation();
			$validation->set_rules('selection_items[]', __('Selection items', 'ALSP'), 'required');
			if ($validation->run()) {
				$result = $validation->result_array();
				if ($wpdb->update($wpdb->alsp_content_fields, array('options' => serialize(array('selection_items' => $result['selection_items[]']))), array('id' => $this->id), null, array('%d')))
					alsp_addMessage(__('Field configuration was updated successfully!', 'ALSP'));
				
				$alsp_instance->content_fields_manager->showContentFieldsTable();
			} else {
				$this->selection_items = $validation->result_array('selection_items[]');
				alsp_addMessage($validation->error_string(), 'error');

				alsp_renderTemplate('content_fields/fields/select_configuration.tpl.php', array('content_field' => $this));
			}
		} else
			alsp_renderTemplate('content_fields/fields/select_configuration.tpl.php', array('content_field' => $this));
	}
	
	public function buildOptions() {
		if (isset($this->options['selection_items']))
			$this->selection_items = $this->options['selection_items'];
	}
	
	public function renderInput() {
		alsp_renderTemplate('content_fields/fields/select_input.tpl.php', array('content_field' => $this));
	}
	
	public function validateValues(&$errors, $data) {
		$field_index = 'alsp-field-input-' . $this->id;

		$validation = new alsp_form_validation();
		$rules = '';
		if ($this->canBeRequired() && $this->is_required)
			$rules .= '|required';
		$validation->set_rules($field_index, $this->name, $rules);
		if (!$validation->run())
			$errors[] = $validation->error_string();
		elseif ($selected_item = $validation->result_array($field_index)) {
			if (!in_array($selected_item, array_keys($this->selection_items)))
				$errors[] = sprintf(__("This selection option index \"%d\" doesn't exist", 'ALSP'), $selected_item);

			return $selected_item;
		}
	}
	
	public function saveValue($post_id, $validation_results) {
		return update_post_meta($post_id, '_content_field_' . $this->id, $validation_results);
	}
	
	public function loadValue($post_id) {
		$this->value = get_post_meta($post_id, '_content_field_' . $this->id, true);
		
		$this->value = apply_filters('alsp_content_field_load', $this->value, $this, $post_id);
		return $this->value;
	}
	
	public function renderOutput($listing = null) {
		alsp_renderTemplate('content_fields/fields/select_radio_output.tpl.php', array('content_field' => $this, 'listing' => $listing));
	}

	public function validateCsvValues($value, &$errors) {
		if ($value)
			if (!in_array($value, $this->selection_items))
				$errors[] = sprintf(__("This selection option \"%s\" doesn't exist", 'ALSP'), $value);
			else
				return array_search($value, $this->selection_items);
		else 
			return '';
	}
	
	public function renderOutputForMap($location, $listing) {
		return $this->value;
	}

	// adapted for WPML
	public function content_fields_options_into_strings() {
		global $sitepress;

		if (function_exists('wpml_object_id_filter') && $sitepress) {
			if (function_exists('icl_register_string'))
				foreach ($this->selection_items AS $key=>&$item) {
					icl_register_string('ALSP Listing', 'The option #' . $key . ' of content field #' . $this->id, $item);
					$item = icl_t('ALSP Listing', 'The option #' . $key . ' of content field #' . $this->id, $item);
				}
		}
	}
}
?>