<?php

if(!class_exists('WP_List_Table'))
{
    require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}
// this is for 
if(!class_exists( 'WP_Http' ))
{
    require_once(ABSPATH . WPINC. '/class-http.php');
}
//
class Di_Report_Abuse
{
    var $options;
    var $proto = 'http';
    var $recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
    // Default values, used if option is not found
    var $defaults;
    // Editable texts
    var $text_options;
    var $post;
    // Import old reports generated by plugin v0.2 (used once)
    function import_old()
    {
        global $wpdb;
        if (get_option('wp_report_post_import_v0') == '1') { return false; }
        $sql = $wpdb->prepare("SELECT *, UNIX_TIMESTAMP(`dt`) AS ts FROM {$wpdb->prefix}reported_posts LEFT JOIN {$wpdb->posts} ON {$wpdb->prefix}reported_posts.post_id={$wpdb->posts}.ID", 1);
        $reports = $wpdb->get_results($sql, ARRAY_A);
        foreach ($reports as $row)
        {
            if ($row['ID'])
            {
                $data = array
                (
                    'user_id'   => $row['user_id'], 
                    'email'     => $row['user_email'], 
                    'name'      => $row['user_name'], 
                    'msg'       => $row['message'], 
                    'post_id'   => $row['post_id'],
                    'timestamp' => $row['ts'] 
                );
                $rep = get_post_meta($row['post_id'], '_wp_report_post', true);
                if (is_array($rep))
                {
                    $exist = false;
                    foreach ($rep as $rrow)
                    {
                        if ($rrow['email'] == $data['email'])
                        {
                            $exist = true;
                        }
                    }
                    if (!$exist)
                    {
                        $rep[] = $data;
                    }
                }
                else
                {
                    $rep[] = $data;
                }
                update_post_meta($row['post_id'], '_wp_report_post', $rep);
            }
        }
        update_option('wp_report_post_import_v0', '1');
        return true;
    }
    //
    function enqueue_scripts()
    {
        wp_enqueue_style('wp-report-post', plugins_url( '/css/style.css', __file__ ), false);
        wp_enqueue_style('remodal', plugins_url( '/lib/remodal/remodal.css', __file__ ), false);
        wp_enqueue_script('remodal', plugins_url( '/lib/remodal/remodal.js', __file__ ), array('jquery'));
        if ($this->get_option('use_captcha') == '1')
        {
            wp_enqueue_script('recaptcha', $this->proto. '://www.google.com/recaptcha/api.js');
        }
    }
    // Returns true if user is not logged in; If require_login is false, always returns false
    function not_logged_in()
    {
        if ($this->get_option('require_login', $this->defaults['require_login']) == '0')
        {
            return false;
        }
        return !is_user_logged_in();
    }
    // Frontend footer scripts
    function footer_scripts()
    {
        $report_post_name_val = '';
        $report_post_email_val = '';
		$report_post_type_val = '';
        if (is_user_logged_in())
        {
            $user = wp_get_current_user();
            $report_post_name_val = ' value="'. esc_attr($user->display_name). '" readonly="readonly"';
			//$report_post_type_val = ' value="'. esc_attr($user->display_name). '" readonly="readonly"';
            $report_post_email_val = ' value="'. esc_attr($user->user_email). '" readonly="readonly"';
        }
?>
<div class="remodal" data-remodal-id="report-post" role="dialog" aria-labelledby="report-post-modal-title" aria-describedby="report-post-modal-desc">
    <a data-remodal-action="close" class="remodal-close" aria-label="<?php _e('Close', 'ALSP'); ?>"></a>
    <div>
        <h2 id="report-post-modal-title"><?php echo esc_html__('Report This Ad', 'ALSP'); ?></h2>
        <p id="report-post-modal-desc">
<?php if ($this->not_logged_in())
{
?>
            <?php echo $this->get_option(sprintf('text_require_login', wp_login_url()), sprintf($this->defaults['text_require_login'], wp_login_url())); ?>
<?php
}
else
{
?>
            &laquo;<b><span id="report-post-title">&nbsp;</span></b>&raquo;
            <?php } ?>
        </p>
        <?php if (!$this->not_logged_in()) { ?>
        <p id="report-post-modal-msg">&nbsp;</p>
        <form class="report-post-form" id="report-post-form">
            <input type="hidden" name="subaction" value="report-post" />
            <input type="hidden" name="report_post_id" id="report-post-id" value="0" />
            <div class="report-post-half-left">
                <p><?php echo esc_html__('Name', 'ALSP'); ?></p>
                <input class="report-post-control" id="report_post_name" name="report_post_name"<?php echo $report_post_name_val; ?> />
            </div>
            <div class="report-post-half-right">
                <p><?php echo esc_html__('Email', 'ALSP'); ?></p>
                <input class="report-post-control" id="report_post_email" name="report_post_email"<?php echo $report_post_email_val; ?> />
            </div>
            <div style="clear: both;"></div>
			<div>
                <p><?php echo esc_html__('Why are you Reporting?', 'ALSP'); ?></p>
					<label>
						<input type="radio" name="report_post_reason" id="report_post_reason" class="report-post-control" value="<?php echo esc_html__('This is illegal/fraudulent', 'ALSP');  ?>" />
						<?php echo esc_html__('This is illegal/fraudulent', 'ALSP');  ?>
						<span class="radio-check-item"></span>
					</label>
					<label>
						<input type="radio" name="report_post_reason" id="report_post_reason" class="report-post-control" value="<?php echo esc_html__('This ad is spam', 'ALSP');  ?>" />
						<span class="radio-check-item"></span>
						<?php echo esc_html__('This ad is spam', 'ALSP');  ?>
					</label>
					<label>
						<input type="radio" name="report_post_reason" id="report_post_reason" class="report-post-control" value="<?php echo esc_html__('This ad is a duplicate', 'ALSP');  ?>" />
						<span class="radio-check-item"></span>
						<?php echo esc_html__('This ad is a duplicate', 'ALSP');  ?>
					</label>
					<label>
						<input type="radio" name="report_post_reason" id="report_post_reason" class="report-post-control" value="<?php echo esc_html__('This ad is in the wrong category', 'ALSP');  ?>" />
						<span class="radio-check-item"></span>
						<?php echo esc_html__('This ad is in the wrong category', 'ALSP');  ?>
					</label>
					<label>
						<input type="radio" name="report_post_reason" id="report_post_reason" class="report-post-control" value="<?php echo esc_html__('The ad goes against posting rules', 'ALSP');  ?>" />
						<span class="radio-check-item"></span>
						<?php echo esc_html__('The ad goes against posting rules', 'ALSP');  ?>
					</label>
				
				
            </div>
            <div>
                <p><?php echo esc_html__('Provide More Detail', 'ALSP'); ?></p>
                <textarea class="report-post-control" rows="5" id="report_post_msg" name="report_post_msg"></textarea>
            </div>
            <div class="report-post-half-left">
<?php
if ($this->get_option('use_captcha') == '1')
{
echo '<p>', $this->get_option('text_verification_code'), '</p>'."\n";
echo '<div class="g-recaptcha" data-sitekey="', esc_attr($this->get_option('recaptcha_sitekey')), '"></div>'."\n";
}
?>
            </div>
            <div class="report-post-half-right">
<?php
if ($this->get_option('show_ip_to_client') == '1')
{
    if ($this->get_option('use_captcha') == '1')
    {
?>
            <p>&nbsp;</p>
            <h1 class="report-post-ip"><?php echo $this->get_option('text_your_ip'); ?> <?php echo $this->get_user_ip(); ?></h1>
<?php
    }
    else
    {
?>
            <p class="report-post-ip"><?php echo $this->get_option('text_your_ip'); ?> <?php echo $this->get_user_ip(); ?></p>
<?php
    }
}
?>
            </div>
            <div style="clear: both;"></div>
        </form>
        <?php } ?>
    </div>
    <?php if (!$this->not_logged_in()) { ?>
    <div id="report-post-buttons">
        <br />
        <a data-remodal-action="cancel" class="remodal-cancel"><?php echo esc_html__('Cancel', 'ALSP'); ?></a>
        <a id="report-post-submit" class="remodal-confirm"><?php echo esc_html__('Report', 'ALSP'); ?></a>
    </div>
    <?php } ?>
</div>

<script type="text/javascript">
jQuery(document).ready(function($)
{
    window.REMODAL_GLOBALS =
    {
        NAMESPACE: 'report-post',
        DEFAULTS:
        {
            hashTracking: false,
            closeOnConfirm: false
        }
    }
    // add after
<?php
    if ($this->get_option('add_what', $this->defaults['add_what_option']) != '')
    {
?>
    var report_post_link = '<a href="#" class="report-post-<?php echo $this->get_option('add_what', $this->defaults['add_what_option']); ?>"><?php echo esc_js($this->get_option('text_report_link', $this->defaults['text_report_link'])); ?></a>';
    $('<?php echo esc_js($this->get_option('add_after', $this->defaults['add_after_option'])); ?>').after(report_post_link);
<?php
    }
?>
    var _remodal = $('[data-remodal-id=report-post]').remodal({modifier: 'with-red-theme', hashTracking: false, closeOnConfirm: false});
    $(document).on('opened', '.remodal', function ()
    {
        $('#report-post-buttons').slideDown(1000);
        $('#report-post-form').slideDown(1000, function()
        {
            if ($('#report_post_name').val()=='')
            {
                $('#report_post_name').focus();
            }
            else
            {
                $('#report_post_msg').focus();
            }
        });
    });
    $('#report-post-submit').click(function(e)
    {
        e.preventDefault();
        $('#report-post-modal-desc').css('display', 'block');
        $('#report-post-modal-msg').css('display', 'none');
        $('.report-post-control').removeClass('report-post-control-error');
        //_remodal.close();
        $.post('<?php echo admin_url('admin-ajax.php'); ?>?action=wp_report_post', $('#report-post-form').serialize(), function(data)
        {
            if (data.errmsg)
            {
                $('#report-post-modal-desc').css('display', 'none');
                $('#report-post-modal-msg').css('display', 'block');
                $('#report-post-modal-msg').html(data.errmsg);                
                $('#report-post-modal-msg').addClass('report-post-error');
                $('#report-post-modal-msg').removeClass('report-post-success');
                if (data.field)
                {
                    $('#'+data.field).addClass('report-post-control-error');
                    $('#'+data.field).focus();
                }
                else
                {
                    $('#report_post_msg').focus();
                }
            }
            if (data.msg)
            {
                $('#report-post-modal-desc').css('display', 'none');
                $('#report-post-modal-msg').css('display', 'block');
                $('#report-post-modal-msg').html(data.msg);                
                $('#report-post-modal-msg').removeClass('report-post-error');
                $('#report-post-modal-msg').addClass('report-post-success');
                $('#report_post_msg').val('');
                $('#report-post-form').slideUp(1000);
                $('#report-post-buttons').slideUp(1000);
            }
        }, 'json');

    });
    $('.report-post-link,.report-post-button,.report-post-custom-link,.report-post-custom-button').click(function(e)
    {
        e.preventDefault();
        $('#report-post-modal-desc').css('display', 'block');
        $('#report-post-modal-msg').css('display', 'none');
        $('.report-post-control').removeClass('report-post-control-error');
        var post_id=0;
        if ($(this).attr('post-id') != undefined)
        {
            post_id = parseInt($(this).attr('post-id')); 
        }
        else
        {
            var article_id = $(this).closest('article').attr('id');
            if (article_id != undefined)
            {
                var post_id = parseInt(article_id.replace( /^\D+/g, ''));

            }
        }
        $('#report-post-id').val(post_id);
        $.post('<?php echo admin_url('admin-ajax.php'); ?>?action=wp_report_post', {subaction: 'get-post', post_id: post_id}, function(data)
        {
            $('#report-post-title').html(data.post_title);
            _remodal.open();
        }, 'json');
    });
});
</script>
<?php
    }
    //
    function admin_menu()
    {
        add_submenu_page( 'classiads_settings',__('Report Abused', 'ALSP'), __('Report Abused', 'ALSP'), 'edit_others_posts', 'di-report-abused', array($this, 'reported_posts'), 'dashicons-megaphone' );
        //add_submenu_page('alsp_settings', __('Report Options', 'ALSP'), __('Rport Options', 'ALSP'), 'edit_others_posts', 'wp-report-post-options', array($this, 'options_page'));
    }
    // Display reported posts
    function reported_posts()
    {
        $this->import_old();
        $reports = new WP_Report_Post_List();
        $reports->options = $this->options;
        $reports->defaults = $this->defaults;
        $reports->prepare_items();
?>
<div class="wrap">
    <h2>Reported Posts</h2>
    <form id="reports-filter" method="get">
        <input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
        <?php $reports->display(); ?>
    </form>
</div>
<?php
    }
    // Select
    function select($name, $options, $value)
    {
        echo '<select name="', $name, '">';
        foreach ($options as $key=>$val)
        {
            $sel = ($key == $value) ? ' selected="selected"' : '';
            echo '<option value="', esc_attr($key), '"', $sel, '>', esc_html($val), '</option>';
        }
        echo '</select>';
    }
    // Input
    function input($name, $value, $type='text', $class='')
    {
        echo '<input type="', esc_attr($type), '" name="', esc_attr($name), '" id="', esc_attr($name), '" value="', esc_attr($value), '"', ($class!='') ? ' class="'. esc_attr($class). '"' : '', ' />';
    }
    // Textarea
    function textarea($name, $value, $rows='5', $class='')
    {
        echo '<textarea name="', esc_attr($name), '" id="', esc_attr($name), '" rows="', esc_attr($rows), '"', ($class!='') ? ' class="'. esc_attr($class). '"' : '', '>', esc_html($value), '</textarea>';
    }
    // Checkbox
    function checkbox($name, $value)
    {
        $checked = ($value == '1') ? ' checked="checked"' : '';
        echo '<input type="checkbox" name="', esc_attr($name), '" id="', esc_attr($name), '" value="1"', $checked, ' />';
    }
    // Get plugin option (if none found, taken from $this->defaults)
    function get_option($name, $default='')
    {
        if ($default == '') $default = $this->defaults[$name];
        return (isset($this->options[$name])) ? $this->options[$name] : $default;
    }
    //
    function set_option($name, $value)
    {
        $this->options[$name] = $value;
    }
    // Update plugin options
    function update_options()
    {
        return update_option('wp_report_post_options', $this->options);
    }
    // Display options page
    function options_page()
    {
        if ($_POST)
        {
            foreach ($_POST as $key=>$value)
            {
                $this->options[$key] = stripslashes($value);
            }
            $this->options['require_login'] = (!isset($_POST['require_login'])) ? '0' : '1';
            $this->options['use_captcha'] = (!isset($_POST['use_captcha'])) ? '0' : '1';
            $this->options['show_ip_to_client'] = (!isset($_POST['show_ip_to_client'])) ? '0' : '1';
            $this->options['email_notification'] = (!isset($_POST['email_notification'])) ? '0' : '1';
            $this->update_options();
        }
    ?>
<div class="wrap">
    <form method="post" id="report-post-options">
    <h2><?php _e('WP Report Post Options', 'ALSP'); ?></h2>
    <h2 class="wp-report-post-options-section"><?php _e('Integration', 'ALSP'); ?></h2>
    <table class="form-table wp-report-post-options-table">
        <tr>
            <th scope="row"><?php _e('Automatically add', 'ALSP'); ?></th>
            <td><?php $this->select('add_what', $this->defaults['add_what_options'], $this->get_option('add_what')); ?><span>&nbsp;&nbsp;<?php _e('(Select Nothing if you want to add link or button manually - in template file)', 'ALSP'); ?></span>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e('Add after element', 'ALSP'); ?></th>
            <td><?php $this->input('add_after', $this->get_option('add_after')); ?></td>
        </tr>
        <tr>
            <th scope="row"><?php _e('Message Min Length', 'ALSP'); ?></th>
            <td><?php $this->input('msg_min_length', $this->get_option('msg_min_length')); ?></td>
        </tr>
        <tr>
            <th scope="row"><?php _e('Date / Time format', 'ALSP'); ?></th>
            <td><?php $this->select('date_format', $this->defaults['date_format_options'], $this->get_option('date_format')); ?></td>
        </tr>
        <tr>
            <th scope="row">&nbsp;</th>
            <td><label for="require_login"><?php $this->checkbox('require_login', $this->get_option('require_login')); ?> <?php _e('Require user to be logged in to report', 'ALSP'); ?></label></td>
        </tr>
<?php
/* Wordpress will handle it automatically - if no CURL, it will use fopen() :-)
if (!function_exists('curl_init'))
{
?>
        <tr>
            <th scope="row">&nbsp;</th>
            <td><p class="report-post-error">WARNING! You need PHP Curl extension installed and running on your server to use reCaptcha!</p></td>
        </tr>
<?php
}
*/
?>
    </table>
    <h2 class="wp-report-post-options-section"><?php _e('Antispam', 'ALSP'); ?></h2>
    <table class="form-table wp-report-post-options-table">
        <tr>
            <th scope="row">&nbsp;</th>
            <td><label for="use_captcha"><?php $this->checkbox('use_captcha', $this->get_option('use_captcha')); ?> <?php _e('Use reCaptcha (you need both site-key and secret-key that you can obtain for free <a href="https://www.google.com/recaptcha/admin" target="_blank">here</a>)', 'ALSP'); ?></label></td>
        </tr>
        <tr>
            <th scope="row"><?php _e('reCaptcha Site Key', 'ALSP'); ?></th>
            <td><?php $this->input('recaptcha_sitekey', $this->get_option('recaptcha_sitekey')); ?></td>
        </tr>
        <tr>
            <th scope="row"><?php _e('reCaptcha Secret Key'); ?></th>
            <td><?php $this->input('recaptcha_secret', $this->get_option('recaptcha_secret')); ?></td>
        </tr>
        <tr>
            <th scope="row">&nbsp;</th>
            <td><label for="show_ip_to_client"><?php $this->checkbox('show_ip_to_client', $this->get_option('show_ip_to_client')); ?> <?php _e('Show IP to client that is reporting (otherwise to Admin only)', 'ALSP'); ?></label></td>
        </tr>
        <tr>
            <th scope="row"><?php _e('IP Whois URL:', 'ALSP'); ?></th>
            <td><?php $this->input('whois_url', $this->get_option('whois_url')); ?></td>
        </tr>        
    </table>
    <h2 class="wp-report-post-options-section"><?php _e('Email Notification', 'ALSP'); ?></h2>
    <table class="form-table wp-report-post-options-table">
        <tr>
            <th scope="row">&nbsp;</th>
            <td><label for="require_login"><?php $this->checkbox('email_notification', $this->get_option('email_notification')); ?> <?php _e('Send email notification when somebody reports a post or page', 'ALSP'); ?></label></td>
        </tr>
        <tr>
            <th scope="row"><?php _e('Send Notification to', 'ALSP'); ?></th>
            <td><?php $this->input('email_address', $this->get_option('email_address')); ?></td>
        </tr>
        <tr>
            <th scope="row"><?php _e('Email Subject', 'ALSP'); ?></th>
            <td><?php $this->input('email_subject', $this->get_option('email_subject')); ?></td>
        </tr>
        <tr>
            <th scope="row"><?php _e('Email Body', 'ALSP'); ?></th>
            <td><?php $this->textarea('email_body', $this->get_option('email_body'), 8); ?>
                <p><b><?php _e('Variables:', 'ALSP'); ?> </b>[post_title], [post_id], [name], [email], [ip], [message], [date], [time], [permalink]</p>
            </td>
        </tr>
    </table>
    <h2 class="wp-report-post-options-section"><?php _e('Texts', 'ALSP'); ?></h2>
    <table class="form-table wp-report-post-options-table">
<?php
    foreach ($this->text_options as $key => $value)
    {
?>
        <tr>
            <th scope="row"><?php echo $value; ?></th>
            <td><?php $this->input($key, $this->get_option($key, $this->defaults[$key])); ?></td>
        </tr>
<?php
    }
    ?>
    </table>
    <p class="submit">
    <input type="submit" class="button-primary" value="<?php _e('Save Options', 'ALSP'); ?>" />
    </p>
    </form>
</div>
    <?php
    }
    // Returns current user IP
    function get_user_ip()
    {
        foreach (array('HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR') as $key)
        {
            if (array_key_exists($key, $_SERVER) === true)
            {
                foreach (array_map('trim', explode(',', $_SERVER[$key])) as $ip)
                {
                    if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false)
                    {
                        return $ip;
                    }
                }
            }
        }
        return $_SERVER['REMOTE_ADDR'];
    }
    // Sends email notification (if feature is checked in Options)
    function email_notification()
    {
        if ($this->get_option('email_notification') != '1')
        {
            return false;
        }
        $args = array(
            '[post_title]' => $this->post['post_title'],
            '[email]'      => $this->post['report_post_email'],
            '[name]'       => $this->post['report_post_name'],
			'[reason]'       => $this->post['report_post_reason'],
            '[post_id]'    => $this->post['report_post_id'],
            '[date]'       => date(get_option('date_format'), current_time('timestamp')),
            '[time]'       => date(get_option('time_format'), current_time('timestamp')),
            '[ip]'         => $this->get_user_ip(),
            '[message]'    => $this->post['report_post_msg'],
            '[permalink]'  => get_post_permalink($this->post['report_post_id'])
        );
        $subject = $this->get_option('email_subject');
        $body = $this->get_option('email_body');
        $email = ($this->get_option('email_address') != '') ? $this->get_option('email_address') : get_option('admin_email'); 
        foreach ($args as $key => $value)
        {
            $body = str_replace($key, $value, $body);
        }
        return wp_mail($email, $subject, $body);
    }
    // AJAX functions
    function wp_report_post()
    {
        global $wpdb;
        $this->post = $_POST;
        $json = array('errmsg'=>'', 'msg'=>'');
        if ($_POST['subaction'] == 'unpublish-post' && current_user_can('edit_others_posts'))
        {
            $post = get_post($_POST['post_id']);
            $json['post_id'] = 0;
            if ($post)
            {
                $new_status = ($post->post_status == 'publish') ? 'draft' : 'publish';
                $args = array(
                    'ID' => $_POST['post_id'],
                    'post_status' => $new_status
                );
                ob_start();
                $json['post_id'] = wp_update_post($args);
                $json['post_status'] = ucwords($new_status);
                $json['post_action'] = ($new_status == 'publish') ? 'Unpublish' : 'Publish';
                ob_end_clean();
            }
            echo json_encode($json);
            die();
        }
        //
        if ($_POST['subaction'] == 'report-post')
        {
            $post = get_post($_POST['report_post_id']);
            if (!$post)
            {
                echo json_encode(array('errmsg'=>$this->get_option('text_post_doesnt_exist', $this->defaults['text_post_doesnt_exist']), 'field'=>''));
                die();
            }
            $json['post'] = $post;
            $this->post['post_title'] = $post->post_title;
            if (!filter_var($_POST['report_post_email'], FILTER_VALIDATE_EMAIL) === false)
            {
                //
            }
            else
            {
                echo json_encode(array('errmsg'=>$this->get_option('text_email_invalid', $this->defaults['text_email_invalid']), 'field'=>'report_post_email'));
                die();
            }
            if (strlen($_POST['report_post_name']) < 2)
            {
                echo json_encode(array('errmsg'=>$this->get_option('text_name_invalid'), 'field'=>'report_post_name'));
                die();
            }
            if (strlen($_POST['report_post_msg']) < $this->get_option('msg_min_length'))
            {
                echo json_encode(array('errmsg'=>$this->get_option('text_msg_invalid'), 'field'=>'report_post_msg'));
                die();
            }
            if ($this->get_option('use_captcha') == '1')
            {
                $response = wp_remote_post
                (
                    $this->recaptcha_url, array
                    (
                        'method' => 'POST',
        	            'blocking' => true,
                        'body' => array
                        (
                            'response' => $_POST['g-recaptcha-response'],
                            'secret'   => $this->get_option('recaptcha_secret'),
                            'remoteip' => $this->get_user_ip()
                        ),
                    )
                );
                $tmp = (array)@json_decode($response['body']);
                $success = intval($tmp['success']);
                if ($success !== 1)
                {
                    echo json_encode(array('errmsg'=>$this->get_option('text_captcha_invalid'), 'field'=>''));
                    die();
                }
            }
            $data = array
            (
                'user_id'   => get_current_user_id(),
                'user_ip'   => $this->get_user_ip(), 
                'email'     => $_POST['report_post_email'], 
                'name'      => $_POST['report_post_name'], 
				'reason'      => $_POST['report_post_reason'], 
                'msg'       => $_POST['report_post_msg'], 
                'post_id'   => $_POST['report_post_id'],
                'timestamp' => current_time('timestamp') 
            );
            $reports = get_post_meta($_POST['report_post_id'], '_wp_report_post', true);
            if (is_array($reports))
            {
                foreach ($reports as $report)
                {
                    if ($report['email'] == $_POST['report_post_email'])
                    {
                        echo json_encode(array('errmsg'=>$this->get_option('text_already_reported', $this->defaults['text_already_reported']), 'field'=>'report_post_msg'));
                        die();
                    }
                }
                $reports[] = $data;
            }
            else
            {
                $reports = array();
                $reports[] = $data;
            }
            $meta_id = update_post_meta($_POST['report_post_id'], '_wp_report_post', $reports);
            if ($meta_id)
            {
                $this->email_notification();
                echo json_encode(array('msg'=>$this->get_option('text_success'), 'field'=>'', 'meta_id'=>$meta_id, 'reports'=>$reports));
                die();
            }
            else
            {
                echo json_encode(array('errmsg'=>$this->get_option('text_error'), 'field'=>''));
                die();
            }
        }
        if ($_POST['subaction'] == 'get-post')
        {
            $post_id = intval($_POST['post_id']);
            $post = get_post($post_id);
            $json['post_title'] = $post->post_title;
            $json['post'] = $post;
        }
        $json['errmsg'] = '';
        echo json_encode($json);
        die();
    }
    // Admin footer scripts
    function admin_footer_scripts()
    {
?>
<div class="remodal" data-remodal-id="remodal-confirm" role="dialog" aria-labelledby="remodal-confirm-modal-title" aria-describedby="remodal-confirm-modal-desc">
    <a data-remodal-action="close" class="remodal-close" aria-label="<?php _e('Close', 'ALSP'); ?>"></a>
    <div>
        <h2 id="remodal-confirm-modal-title">&nbsp;</h2>
        <p id="remodal-confirm-modal-desc">&nbsp;</p>
    </div>
<br />
<a data-remodal-action="cancel" class="remodal-cancel"><?php _e('Cancel', 'ALSP'); ?></a>
<a id="remodal-confirm-submit" href="#" class="remodal-confirm"><?php _e('Confirm', 'ALSP'); ?></a>
</div>
<script>
var _remodal_confirm;
function getQueryParams(qs)
{
    qs = qs.split('+').join(' ');

    var params = {},
        tokens,
        re = /[?&]?([^=]+)=([^&]*)/g;

    while (tokens = re.exec(qs)) {
        params[decodeURIComponent(tokens[1])] = decodeURIComponent(tokens[2]);
    }

    return params;
}
var query = getQueryParams(document.location.search);
//
function remodal_confirm(title, desc, confirm_link)
{
    jQuery(function($)
    {
        $('#remodal-confirm-modal-title').html(title);
        $('#remodal-confirm-modal-desc').html(desc);
        $('#remodal-confirm-submit').attr('href', confirm_link);
        _remodal_confirm.open();
    });
}
//
jQuery(document).ready(function($)
{
    _remodal_confirm = $('[data-remodal-id=remodal-confirm]').remodal({modifier: 'with-red-theme', hashTracking: false, closeOnConfirm: false});
    $('.report-post-unpublish-link').click(function(e)
    {
        var post_id = $(this).attr('post-id');
        $.post(ajaxurl + '?action=wp_report_post', {subaction: 'unpublish-post', post_id: post_id}, function(data)
        {
            var $tr = $('#post-status-'+data.post_id).closest('tr');
            $('#post-status-'+data.post_id).html(data.post_status);
            $tr.addClass('highlighted');
            setTimeout(function()
            {
                $tr.removeClass('highlighted');
            }, 5000);
            $('#unpublish-'+data.post_id).html(data.post_action);
        }, 'json');
        e.preventDefault();
    });
    $('.remodal-confirm-link').click(function(e)
    {
        var href = $(this).attr('href');
        var the_title = $(this).attr('post-title');
        var post_action = $(this).attr('post-action');
        remodal_confirm(post_action+' <?php _e('Posts', 'ALSP'); ?>', '<?php _e('Are you sure you want to', 'ALSP'); ?> '+post_action+' <?php _e('the post titled', 'ALSP'); ?> &laquo;'+the_title+'&raquo;?', href);
        e.preventDefault();
    });
    $('.report-user-row').click(function(e)
    {
        $div = $(this).next().next().next();
        if ($div.css('display') == 'none')
        {
            $div.slideDown();
        }
        else
        {
            $div.slideUp();            
        }
        e.preventDefault();
    });
    $('.report-user-hide-link').click(function(e)
    {
        $(this).parent().slideUp();
        e.preventDefault();
    });
});
</script>
<?php
    }
    //
    function __construct()
    {
        $this->defaults = array
        (
            'whois_url'             => 'http://whois.domaintools.com/[ip]',
            'email_notification'    => '1',
            'email_address'         => '',
            'email_subject'         => __('[WP Report Post] Somebody reported a post!', 'ALSP'),
            'email_body'            => __("Hey, Admin!\nSomebody has just reported a post.\nTitle: [post_title]\nLink: [permalink]\nPost ID: [post_id]\nReporter Name: [name]\nReporter Email: [email]\nReporter IP: [ip]\nMessage: [message]\n--\nSincerely, WP Report Post Plugin", 'ALSP'),
            'msg_min_length'        => '16',
            'use_captcha'           => '0',
            'show_ip_to_client'     => '0',
            'recaptcha_sitekey'     => '',
            'recaptcha_secret'      => '',
            'date_format'           => 'human',
            'date_format_options'   => array('human' => __('Human (e.g 5 minutes ago)', 'ALSP'), 'date' => __('Date / Time', 'ALSP')),
            'require_login'         => '0',
            'add_what_options'      => array(''=>__('Nothing', 'ALSP'), 'link'=>__('Link', 'ALSP'), 'button'=>__('Button', 'ALSP')),
            'add_what_option'       => 'link',
            'add_after_option'      => 'span.byline',
            'text_report_post'      => __('Report Post', 'ALSP'),
            'text_report_link'      => __('Report Post', 'ALSP'),
            'text_your_name'        => __('Your Name:', 'ALSP'),
            'text_your_email'       => __('Your Email:', 'ALSP'),
            'text_your_msg'         => __('Please tell us why do you think this post is inappropriate and shouldn\'t be there:', 'ALSP'),
            'text_cancel'           => __('Cancel', 'ALSP'),
            'text_submit'           => __('Report', 'ALSP'),
            'text_post_doesnt_exist'=> __('Specified Post does not exist', 'ALSP'),
            'text_email_invalid'    => __('Please provide a valid email address', 'ALSP'),
            'text_name_invalid'     => __('Please enter your name', 'ALSP'),
            'text_msg_invalid'      => __('Please describe why do you think this post is inappropriate', 'ALSP'),
            'text_already_reported' => __('You have already reported this post', 'ALSP'),
            'text_success'          => __('You have successfully reported inappropriate post', 'ALSP'),
            'text_error'            => __('Error submitting report', 'ALSP'),
            'text_require_login'    => __('Please <a href="%s">log in</a> to report posts', 'ALSP'),
            'text_verification_code'=> __('Verification Code:', 'ALSP'),
            'text_your_ip'          => __('Your IP:', 'ALSP'),
            'text_captcha_invalid'  => __('Invalid verification code', 'ALSP') 
        );
        $this->text_options = array
        (
            'text_report_link'      => __('Link Text', 'ALSP'),
            'text_report_post'      => __('Modal Form Title', 'ALSP'),
            'text_your_name'        => __('Your Name:', 'ALSP'),
            'text_your_email'       => __('Your Email:', 'ALSP'),
            'text_your_msg'         => __('Your Message:', 'ALSP'),
            'text_cancel'           => __('Cancel button', 'ALSP'),
            'text_submit'           => __('Submit button', 'ALSP'),
            'text_post_doesnt_exist'=> __('Invalid Post', 'ALSP'),
            'text_email_invalid'    => __('Invalid Email', 'ALSP'),
            'text_name_invalid'     => __('Invalid Name', 'ALSP'),
            'text_msg_invalid'      => __('Invalid Message', 'ALSP'),
            'text_already_reported' => __('Already reported', 'ALSP'),
            'text_success'          => __('Successfully reported', 'ALSP'),
            'text_error'            => __('Error reporting', 'ALSP'),
            'text_verification_code'=> __('Text for Captcha', 'ALSP'),
            'text_your_ip'          => __('Your IP: text', 'ALSP'),
            'text_captcha_invalid'  => __('Invalid Captcha', 'ALSP')
        );
        $this->proto = is_ssl() ? 'https' : 'http';
        $this->options = maybe_unserialize(get_option('wp_report_post_options'));
        add_action('init', array($this, 'enqueue_scripts'));
        add_action('wp_print_footer_scripts', array($this, 'footer_scripts'));
        add_action('admin_menu', array($this, 'admin_menu'));
        add_action('wp_ajax_wp_report_post', array($this, 'wp_report_post'));
        add_action('wp_ajax_nopriv_wp_report_post', array($this, 'wp_report_post'));
        add_action('admin_print_footer_scripts', array($this, 'admin_footer_scripts'));
    }
}

// Reported posts list
class WP_Report_Post_List extends WP_List_Table
{
    var $options, $defaults;
    function __construct()
    {
        global $status, $page;
        parent::__construct( array(
            'singular'  => 'reported_posts',
            'plural'    => 'reported_post',
            'ajax'      => false
        ) );
    }
    //
    function time_elapsed_string($ptime)
    {
        $etime = current_time('timestamp') - $ptime;
        if ($etime < 1)
        {
            return 'just now';
        }
        $a = array
        (
            365 * 24 * 60 * 60  =>  __('year', 'ALSP'),
             30 * 24 * 60 * 60  =>  __('month', 'ALSP'),
                  24 * 60 * 60  =>  __('day', 'ALSP'),
                       60 * 60  =>  __('hour', 'ALSP'),
                            60  =>  __('minute', 'ALSP'),
                             1  =>  __('second', 'ALSP')
        );
        $a_plural = array
        (
            __('year', 'ALSP')   => __('years', 'ALSP'),
            __('month', 'ALSP')  => __('months', 'ALSP'),
            __('day', 'ALSP')    => __('days', 'ALSP'),
            __('hour', 'ALSP')   => __('hours', 'ALSP'),
            __('minute', 'ALSP') => __('minutes', 'ALSP'),
            __('second', 'ALSP') => __('seconds', 'ALSP')
        );
        foreach ($a as $secs => $str)
        {
            $d = $etime / $secs;
            if ($d >= 1)
            {
                $r = round($d);
                return $r . ' ' . ($r > 1 ? $a_plural[$str] : $str) . __(' ago', 'ALSP');
            }
        }
    }
    //
    function format_timestamp($ts)
    {
        $date_format = isset($this->options['date_format']) ? $this->options['date_format'] : $this->defaults['date_format'];
        if ($date_format == 'human')
        {
            return $this->time_elapsed_string($ts);
        }
        return date(get_option('date_format'). ', '. get_option('time_format'), intval($ts));
    }
    //
    function format_reports($reports)
    {
        $rep = maybe_unserialize($reports);
        if (is_array($rep))
        {
            $html = '';
            foreach ($rep as $row)
            {
                $html .= '<a href="#" title="'. __('Click to view report', 'ALSP'). '" class="report-user-row">'. esc_html($row['name']). '</a>';
				$html .= '<span> ('. $this->format_timestamp($row['timestamp']). ')</span>';
                $html .= '<br /><div class="report-user-hidden">';
				if ($row['user_ip'])
                {
                    $whois = str_replace('[ip]', urlencode($row['user_ip']), $this->options['whois_url']);
                    $html .= ' <a href="'. $whois. '" target="_blank">'. esc_html('IP', 'ALSP').':'. esc_html($row['user_ip']). '</a>';
                }
				$html .= '<br />'.esc_html__('Email ID', 'ALSP').':'. esc_html($row['email']);
				$html .= '<br />'. esc_html('Reason', 'ALSP').':'.esc_html($row['reason']);
				$html .= '<br />'. esc_html('Message', 'ALSP').':'.esc_html($row['msg']);
                $html .= ' <a href="#" class="report-user-hide-link">'. __('Hide', 'ALSP'). '</a>';
                $html .= '</div>';
            }
            return $html;
        }
        else
        {
            return __('Error', 'ALSP');
        }
    }
    //
    function column_default($item, $column_name)
    {
        switch($column_name)
        {
            case 'post_id':
            case 'post_date': return mysql2date(get_option('date_format'), $item['post_date']) . '<br />'. mysql2date(get_option('time_format'), $item['post_date']); break;
            case 'post_author': 
                $user = get_userdata($item['post_author']);
                return sprintf('%s &lt;%s&gt;', $user->display_name, $user->user_email);
                break;
            case 'post_title':
                return sprintf('<a href="%s" title="View post in new tab" target="_blank">%s</a>', get_post_permalink($item['post_id']), $item['post_title']);
                break;
            case 'meta_value':
                return $this->format_reports($item[$column_name]);
                break;
            case 'post_status':
                return '<span id="post-status-'. $item['post_id']. '">'. ucwords($item['post_status']). '</span>';
            default:
                return $item[$column_name];
        }
    }
    //
    function column_post_title($item)
    {
        $new_status = ($item['post_status'] == 'publish') ? __('Unpublish', 'ALSP') : __('Publish', 'ALSP');
        $actions = array(
            'view'      => sprintf('<a href="%s" title="%s" target="_blank">View</a>', get_post_permalink($item['post_id']), __('View post in new tab', 'ALSP')),
            'edit'      => sprintf('<a href="%s">%s</a>', get_edit_post_link($item['post_id']), __('Edit', 'ALSP')),
            'delete'    => sprintf('<a class="remodal-confirm-link" href="?page=%s&action=%s&post_id=%d" post-action="Delete" post-title="%s">%s</a>',$_REQUEST['page'], 'delete', $item['post_id'], esc_attr($item['post_title']), __('Delete', 'ALSP')),
            'unpublish' => sprintf('<a href="#" class="report-post-unpublish-link" post-id="%d" id="unpublish-%d">%s</a>', $item['post_id'], $item['post_id'], $new_status),
            'delete_rep'=> sprintf('<a class="remodal-confirm-link" href="?page=%s&action=%s&post_id=%d" post-action="%s" post-title="%s">%s</a>',$_REQUEST['page'], 'delete_rep', $item['post_id'], __('Delete Reports', 'ALSP'), esc_attr($item['post_title']), __('Delete Reports', 'ALSP')),
        );
        return sprintf('%1$s %2$s',
            /*$1%s*/ sprintf('<a href="%s" title="%s" target="_blank">%s</a>', get_post_permalink($item['post_id']), __('View post in new tab', 'ALSP'), $item['post_title']),
            /*$2%s*/ $this->row_actions($actions)
        );
    }
    //
    function column_cb($item)
    {
        return sprintf(
            '<input type="checkbox" name="%1$s[]" value="%2$s" />',
            /*$1%s*/ 'post_id',
            /*$2%s*/ $item['post_id']
        );
    }
    //
    function get_columns()
    {
        $columns = array(
            'cb'         => '<input type="checkbox" />',
            'post_title' => __('Post Title', 'ALSP'),
            'post_date'  => __('Post Date', 'ALSP'),
            'post_author'=> __('Post Author', 'ALSP'),
            'post_status'=> __('Post Status', 'ALSP'),
            'meta_value' => __('Reports', 'ALSP')
        );
        return $columns;
    }
    //
    function get_sortable_columns()
    {
        $sortable_columns = array(
            'post_date'   => array('post_date', true),
            'post_title'  => array('post_title', false),
            'post_author' => array('post_author', false),
            'post_status' => array('post_status', false),
            'meta_value'  => array('meta_value', false)
        );
        return $sortable_columns;
    }
    //
    function get_bulk_actions()
    {
        $actions = array(
            'delete'    => __('Delete', 'ALSP'),
            'unpublish' => __('Unpublish', 'ALSP'),
            'publish'   => __('Publish', 'ALSP'),
            'delete_rep'=> __('Delete Reports', 'ALSP')
        );
        return $actions;
    }
    //
    function process_bulk_action()
    {
        if (current_user_can('edit_others_posts'))
        {
            if (is_array($_GET['post_id']))
            {
                $ids = $_GET['post_id'];
            }
            else
            {
                $ids = array($_GET['post_id']);
            }
            foreach ($ids as $id)
            {
                if ('delete'===$this->current_action())
                {
                    // trash it!
                    wp_delete_post($id);
                }
                if ('unpublish' === $this->current_action())
                {
                    $args = array(
                        'ID' => $id,
                        'post_status' => 'draft'
                    );
                    ob_start();
                    wp_update_post($args);
                    ob_end_clean();
                }
                if ('publish' === $this->current_action())
                {
                    $args = array(
                        'ID' => $id,
                        'post_status' => 'publish'
                    );
                    ob_start();
                    wp_update_post($args);
                    ob_end_clean();
                }
                if ('delete_rep' === $this->current_action())
                {
                    delete_post_meta($id, '_wp_report_post');
                }
            }
        }
    }
    //
    function prepare_items()
    {
        global $wpdb;
        $per_page = 25;
        $columns = $this->get_columns();
        $hidden = array();
        $sortable = $this->get_sortable_columns();
        $this->_column_headers = array($columns, $hidden, $sortable);
        $this->process_bulk_action();
        $orderby = esc_sql( isset($_GET['orderby']) ? $_GET['orderby'] : 'post_id' );
        $order = esc_sql( isset($_GET['order']) ? $_GET['order'] : 'desc' );
        $current_page = $this->get_pagenum();
        $start = ($current_page-1) * $per_page;
        $args = array(
            'posts_per_page' => 5,
            'offset' =>0
        );
        $sql_count = $wpdb->prepare("SELECT COUNT(*) FROM {$wpdb->postmeta} LEFT JOIN {$wpdb->posts} ON {$wpdb->postmeta}.post_id={$wpdb->posts}.ID WHERE meta_key='_wp_report_post'", 1);
        $sql = $wpdb->prepare("SELECT * FROM {$wpdb->postmeta} LEFT JOIN {$wpdb->posts} ON {$wpdb->postmeta}.post_id={$wpdb->posts}.ID WHERE meta_key='_wp_report_post' ORDER BY {$orderby} {$order} LIMIT %d,%d", $start, $per_page);
        //echo $sql, '<hr>';
        $data = $wpdb->get_results($sql, ARRAY_A);
        $total_items = $wpdb->get_var($sql_count);
        $this->items = $data;
        $this->set_pagination_args( array
        (
            'total_items' => $total_items,
            'per_page'    => $per_page,
            'total_pages' => ceil($total_items/$per_page)
        ) );
    }
}

$_Di_Report_Abuse = new Di_Report_Abuse;
?>