<?php

class alsp_authorize extends alsp_payment_gateway
{
	public $api_login_id;
	public $transaction_id;

    /**
	 * Initialize the Stripe gateway
	 *
	 * @param none
	 * @return void
	 */
	public function __construct() {
        parent::__construct();
		
		global $ALSP_ADIMN_SETTINGS;
        $this->api_login_id = $ALSP_ADIMN_SETTINGS['alsp_authorize_live_loginid'];
        $this->transaction_id = $ALSP_ADIMN_SETTINGS['alsp_authorize_live_transactionid'];
        
        if ($ALSP_ADIMN_SETTINGS['alsp_authorize_test'])
        	$this->enableTestMode();
	}

    /**
     * Enables the test mode
     *
     * @param none
     * @return none
     */
    public function enableTestMode() {
		global $ALSP_ADIMN_SETTINGS;
        $this->api_login_id = $ALSP_ADIMN_SETTINGS['alsp_authorize_test_loginid'];
        $this->transaction_id = $ALSP_ADIMN_SETTINGS['alsp_authorize_test_transactionid'];
    }
    
    public function name() {
    	return __('Authorize', 'ALSP');
    }

    public function description() {
    	return __('One time payment by Authorize.net. After successful transaction listing will become active and raised up.', 'ALSP');
    }
    
    public function buy_button() {
    	return '<img src="' . ALSP_PAYMENTS_RESOURCES_URL . 'images/stripe.png" />';
    }
    
    public function submitPayment($invoice) {
		global $ALSP_ADIMN_SETTINGS;
    	include_once ALSP_PAYMENTS_PATH . 'classes/gateways/authorize/AuthorizeNet.php';


	define("AUTHORIZENET_API_LOGIN_ID", $this->api_login_id);
    define("AUTHORIZENET_TRANSACTION_KEY", $this->transaction_id);
    define("AUTHORIZENET_SANDBOX", true);
    $auth = new AuthorizeNetAIM;
    $auth->amount = 10;
	$auth->card_num = '3700000000000027';
	$auth->exp_date = '0515';
	//$auth->customer_id = $customer->id;
    // Use eCheck:
    
    // Set multiple line items:
    //$auth->addLineItem('item1', 'Golf tees', 'Blue tees', '2', '5.00', 'N');
    //$auth->addLineItem('item2', 'Golf shirt', 'XL', '1', '40.00', 'N');
    
    // Set Invoice Number:
    $auth->invoice_num = time();
    
    // Set a Merchant Defined Field:
	$auth->setCustomField("currency", $ALSP_ADIMN_SETTINGS['alsp_payments_currency']);
    //$auth->setCustomField("customer_id", $customer->id);
    
    // Authorize Only:
    $response  = $auth->authorizeOnly();
	var_dump($response).'</br>';
    if ($response->approved) {
        //$auth_code = $response->transaction_id;
       // echo $auth_code.'</br>';
        // Now capture:
        //$capture = new AuthorizeNetAIM;
        //$capture_response = $capture->priorAuthCapture($auth_code);
       // foreach ($capture_response as $key => $value){
			//echo '<strong>'.$key.'</strong> '.$value.'</br>';
		//}
        // Now void:
       // $void = new AuthorizeNetAIM;
       // $void_response = $void->void($capture_response->transaction_id);
		
       // foreach ($void_response as $key => $value){
			//echo '<strong>'.$key.'</strong> '.$value.'</br>';
		//}
		if (alsp_create_transaction(
				$this->name(),
				$invoice->post->ID,
				'Completed',
				//$auth->id,
				$auth->amount/100,
				0,
				$auth->currency,
				1,
				$auth
		)) {
			if ($invoice->item_object->complete()) {
				$invoice->setStatus('paid');
				$transaction_data = array();
				$keys = $key();
				foreach ($keys AS $k)
					if (is_string($auth->offsetGet($k)))
						$transaction_data[] = $k . ' = ' . esc_attr($auth->offsetGet($k));
				$invoice->logMessage(sprintf(__('Payment successfully completed. Transaction data: %s', 'ALSP'), implode('; ', $transaction_data)));
			}
		}
		$output = json_encode(array('type'=>'message', 'text' => ' Thank you for your email'));
		die($output);
    }else{
		$output = json_encode(array('type'=>'error', 'text' => 'Could not send mail! Please check your PHP mail configuration.'));
		die($output);
	}
	//If mail couldn't be sent output error. Check your PHP email configuration (if it ever happens)
		
	
	}
}
