<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post, $product;

$attachment_ids = $product->get_gallery_image_ids();
?>
<div class="images">
	<div class="product-big-slider">
		<?php
			if ( has_post_thumbnail() ) {
				
			foreach ($attachment_ids as $attachment_id){
				$large_image_url = wp_get_attachment_image_src( $attachment_id, 'large' );
				if ( ! empty( $large_image_url[0] ) ) {
					echo '<div class="item">';
					echo '<img src="'.esc_url( $large_image_url[0] ).'" alt="'.get_the_title().'" title="'.get_the_title().'" width="'.$large_image_url[1].'" height="'.$large_image_url[2].'" />'; 
					echo '</div>';
				}
			}
		}
			
		?>
	</div>
	<div class="product-nav-slider">
		<?php
			if ( has_post_thumbnail() ) {
				
			foreach ($attachment_ids as $attachment_id){
				$large_image_url = wp_get_attachment_image_src( $attachment_id, 'large' );
				if ( ! empty( $large_image_url[0] ) ) {
					echo '<div class="item">';
						echo classiads_images($large_image_url[0],170,170,false);
					echo '</div>';
				}
			}
		}
			
		?>
	</div>
</div>
