<?php
global $post,$redux_demo,$current_user,$user_ID,$nameError,$emailError,$commentError,$subjectError,$humanTestError;
$contact_email = get_the_author_meta('user_email');
$ad_author_name = get_the_author_meta('user_login');

//If the form is submitted
if( isset( $_POST['submitted'] ) ) {
	
	//Check to make sure that the name field is not empty
	if(trim($_POST['contactName']) === '') {
		$nameError = $wpcrown_contact_name_error;
		$hasError = true;
	} elseif(trim($_POST['contactName']) === 'Name*') {
		$nameError = $wpcrown_contact_name_error;
		$hasError = true;
	}	else {
		$sender_name = trim($_POST['contactName']);
	}

	$mposttitle = $_POST['mposttitle'];
	$mposturl = $_POST['mposturl'];
	
	//Check to make sure that the subject field is not empty
	if(trim($_POST['subject']) == '') {
		$subjectError = $wpcrown_contact_subject_error;
		$hasError = true;
	} elseif(trim($_POST['subject']) == 'Subject*') {
		$subjectError = $wpcrown_contact_subject_error;
		$hasError = true;
	}	else {
		$email_title = trim($_POST['subject']);
	}
	
	//Check to make sure sure that a valid email address is submitted
	if(trim($_POST['email']) === '')  {
		$emailError = $wpcrown_contact_email_error;
		$hasError = true;
	} else if (!preg_match('/[a-z||0-9]@[a-z||0-9].[a-z]/', trim($_POST['email']))) {
		$emailError = $wpcrown_contact_email_error;
		$hasError = true;
	} else {
		$sender_email = trim($_POST['email']);
	}
		
	//Check to make sure comments were entered	
	if(trim($_POST['comments']) === '') {
		$commentError = $wpcrown_contact_message_error;
		$hasError = true;
	} else {
		if(function_exists('stripslashes')) {
			$sender_message = stripslashes(trim($_POST['comments']));
		} else {
			$sender_message = trim($_POST['comments']);
		}
	}
	$humancheck = $_POST['humanTests'];
	//Check to make sure that the human test field is not empty
	if(trim($_POST['humanTest']) != $humancheck) {
		$humanTestError = __( 'Not Human', 'classiads' ).':( ';
		$hasError = true;
	} else {

	}
	//If there is no error, send the email
	if( !isset( $hasError ) ) {	
	
		$email_to = $contact_email;			
		$ad_link = get_permalink($post->ID);	
		if( function_exists('classiads_email_leave_reply_to_author') ){
			
			classiads_email_leave_reply_to_author($email_title,$sender_email,$email_to,$ad_author_name,$sender_message,$ad_link,$sender_name);
			
		}

	}
}

$author_message_box_on = $redux_demo['author-msg-box-off'];
$ad_review_box = $redux_demo['ad-review-box'];
$ad_comment_box = $redux_demo['ad-comment-box'];
$login_link = $redux_demo['login'];
$get_review_count = get_review_count($post->ID);
$get_comment_count = get_ads_comment_count($post->ID);
$userid = $current_user->ID;
$username = $current_user->user_login;
$user_email = $current_user->user_email;
$user_have_reiew = classiads_user_review_on_post($post->ID,$userid );

?>

<div class="single-ads-tabs">
	<!-- Nav tabs -->
	<ul class="nav nav-tabs" role="tablist">
		<?php if( $ad_comment_box == 1 ){ ?>
		<li role="presentation" class="active">
			<a href="#comments" aria-controls="comments" role="tab" data-toggle="tab">
				<?php echo esc_attr($get_comment_count); ?> 
				<?php esc_html_e(' COMMENTS','classiads'); ?> 
			</a>
		</li>
		<?php } ?>
		<?php if( $ad_review_box == 1 ){ ?>
		<?php
			$argss = array(
			'post_type'	=>'reviews',
			'posts_per_page'	=>-1,
			'meta_query' => array(
				array(
					'key'     => 'ad_id',
					'value'   => array( $post->ID ),
					'compare' => 'IN',
				),
			),
			'order'     => 'ASC',
			);
			
		$the_query = new WP_Query( $argss ); 
		$reviewscount = $the_query->post_count;
		?>
		
		<li role="presentation">
			<a href="#reviews" aria-controls="reviews" role="tab" data-toggle="tab">
				<?php echo esc_attr($reviewscount); ?> 
				<?php esc_html_e(' REVIEWS','classiads'); ?> 
			</a>
		</li>
		<?php } ?>
		<?php if( $author_message_box_on == 1 ){ ?>
		<li role="presentation">
			<a href="#ctauthor" aria-controls="ctauthor" role="tab" data-toggle="tab">
				<?php esc_html_e('LEAVE REPLY TO AUTHOR','classiads'); ?>
			</a>
		</li>
		<?php } ?>
	</ul>

	<!-- Tab panes -->
	<div class="tab-content">
		<?php if( $ad_comment_box == 1 ){ ?>
		<div role="tabpanel" class="tab-pane active" id="comments">
			<?php if( !is_user_logged_in() ){ ?>
			<p class="margin-top-10">
				<?php esc_html_e('You must have to login first to add a comment or review so please click here ','classiads'); ?>
				<a href="<?php echo esc_url($login_link); ?>" class="underlink-link">
					<?php esc_html_e('LOGIN NOW','classiads'); ?>
				</a>
			</p>
			<?php }else{ ?>
			<div class="col-xs-12 margin-top-20"></div>
			<?php } ?>
			<div id="ad-comments">
					<?php 
						$file ='';
						$separate_comments ='';
					?>
					<?php comments_template( $file, $separate_comments ); ?>
			</div>	
		</div>
		<?php } ?>
		<?php if( $ad_review_box == 1 ){ ?>
		<div role="tabpanel" class="tab-pane" id="reviews">
			<?php if( !is_user_logged_in() ){ ?>
			<p class="margin-top-10">
				<?php esc_html_e('You must have to login first to add a comment or review so please click here ','classiads'); ?>
				<a href="<?php echo esc_url($login_link); ?>" class="underlink-link">
					<?php esc_html_e('LOGIN NOW','classiads'); ?>
				</a>
			</p>
			<?php }else{ ?>
			<div class="col-xs-12 margin-top-20"></div>
			<?php } ?>
			<div class="comments-boxes clearfix">
				<div class="existing-reviews comments-inner-loop-contianer">
					<?php
						$argss = array(
						'post_type'	=>'reviews',
						'posts_per_page'	=>-1,
						'meta_query' => array(
							array(
								'key'     => 'ad_id',
								'value'   => array( $post->ID ),
								'compare' => 'IN',
							),
						),
						'order'     => 'ASC',
						);
						
						$the_query = new WP_Query( $argss ); ?>

					<?php if ( $the_query->have_posts() ) : ?>
						<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
							<div class="comment-box">
								<div class="comment-box-thumb">
									<img alt="" src="http://1.gravatar.com/avatar/1aedb8d9dc4751e229a335e371db8058?s=94&amp;d=mm&amp;r=g" srcset="http://1.gravatar.com/avatar/1aedb8d9dc4751e229a335e371db8058?s=188&amp;d=mm&amp;r=g 2x" class="avatar avatar-94 photo" height="94" width="94">
								</div>
								
								<div class="comment-box-des">
									<div class="comment-box-des-upper-rw">
										<div class="comment-meta">
											<div class="comment-author"><?php the_author(); ?></div>
											<div class="comment-title"><?php echo get_the_title(); ?></div>
											<div class="comment-time"><?php the_time('F j, Y g:i a'); ?></div>
											<div class="comment-rating">
											<?php
												$rrating = get_post_meta(get_the_ID(), 'select_rating', true);
												if(!empty($rrating)){
													$n=5;
													while($rrating > 0){
														echo '<i class="fa fa-star" aria-hidden="true"></i>';
														$rrating--;
														$n--;
													}
													while($n > 0){
														echo '<i class="fa fa-star-o" aria-hidden="true"></i>';
														$n--;
													}
													
												}
											?>
											</div>
										</div>
									</div>
									<p><?php echo get_post_meta(get_the_ID(), 'review_description', true); ?></p>
								</div>
							</div>
						<?php endwhile; ?>
						<?php wp_reset_postdata(); ?>
					<?php else : ?>
					<?php endif; ?>
					
				</div>
			</div>
			<div class="review-form-container">
				<?php if( is_user_logged_in() && $user_have_reiew != 1 ){ ?>
				
					<form action="" method="post" id="reviewform" class="review-form row" novalidate="">
						<div class="col-xs-12">
							<h5 class="margin-top-0 margin-bottom-20">
								<?php esc_html_e('WRITE A REVIEW','classiads'); ?>
							</h5>
							<div class="h3-seprator"></div>
						</div>
						<p class="comment-review-name col-sm-6 col-xs-12">
							<input id="review-name" class="form-control" name="review-name" placeholder="<?php esc_html_e('Name','classiads'); ?>" type="text" value="" size="30" tabindex="2" aria-required="true">
							<input id="review-username-id" class="form-control" name="review-username-id" type="hidden" value="<?php echo esc_attr($userid); ?>" >
							<input id="review-username" class="form-control" name="review-username" type="hidden" value="<?php echo esc_attr($username); ?>">
						</p>
						<p class="comment-form-review-email col-sm-6 col-xs-12">
							<input id="review-email" class="form-control" name="review-email" placeholder="<?php esc_html_e('Email Address','classiads'); ?>" type="text" value="<?php echo esc_attr($user_email); ?>" size="30" tabindex="2" aria-required="true">
						</p>
						<p class="comment-form-review-comment col-xs-12">
							<textarea class="form-control review-comment" id="review-comment" name="review-comment" placeholder="<?php esc_html_e('Write a review here','classiads'); ?>" cols="45" rows="8" aria-required="true" required="required"></textarea>
						</p>	
						<p class="col-sm-8 col-xs-12 rtl-right">
							<label class="humantest">
							<?php 
							
								 $intnum =	rand(1,9) ;
								 $lastnum =	rand(1,9) ;
								 $totalnum = $intnum  +  $lastnum ; 
							?>
							<?php _e("Human Test: Find the X &nbsp; &nbsp; ", "classiads");
								echo $intnum ; ?> + <?php echo $lastnum ; ?> =
							</label>
							<input type="text" placeholder="<?php _e( 'Your answer', 'classiads' ); ?>" name="humanTest" id="humanTest" value="" class="form-control review-humantest" />	
							<input type="hidden" name="humanTests" id="humanTests" value="<?php echo $totalnum; ?>" class="input-textarea half" />
						</p>
						<p class="col-sm-4 col-xs-12 text-right review-now">
						
							<label class="f-bold"><?php esc_html_e('Rate Now:','classiads'); ?></label>
							<span class="stars">
								<input class="cl-review-star cl-review-star-5" id="cl-review-star-5" type="radio" name="star" value="5"/>
								<label class="cl-review-star cl-review-star-5" for="cl-review-star-5"></label>
								<input class="cl-review-star cl-review-star-4" id="cl-review-star-4" type="radio" name="star" value="4"/>
								<label class="cl-review-star cl-review-star-4" for="cl-review-star-4"></label>
								<input class="cl-review-star cl-review-star-3" id="cl-review-star-3" type="radio" name="star" value="3"/>
								<label class="cl-review-star cl-review-star-3" for="cl-review-star-3"></label>
								<input class="cl-review-star cl-review-star-2" id="cl-review-star-2" type="radio" name="star" value="2"/>
								<label class="cl-review-star cl-review-star-2" for="cl-review-star-2"></label>
								<input class="cl-review-star cl-review-star-1" id="cl-review-star-1" type="radio" name="star" value="1" />
								<label class="cl-review-star cl-review-star-1" for="cl-review-star-1"></label>
							</span>
							
						</p>
						<p class="form-submit col-xs-12">
						
							<button name="submit" type="submit" id="submit" class="submit review-submit" value="" data-review="review-new" data-commentid=""><?php esc_html_e('Submit Review','classiads'); ?></button>
							<input type="hidden" name="comment_post_ID" value="<?php echo esc_attr($post->ID); ?>" id="comment_post_ID">
							<input type="hidden" name="comment_parent" id="comment_parent" value="0">
							<input type="hidden" name="cl-type" id="cl-type" value="review">
							
							
						</p>
						<div class="col-xs-12 form-notice">
						</div> 				
					</form>
				
				<?php } ?>
			</div>
		</div>
		<?php } ?>
		<?php if($author_message_box_on == 1){ ?>
		<div role="tabpanel" class="tab-pane" id="ctauthor">
			<div class="full author-form full-single">
				<div id="contact-ad-owner-v2">

					<?php if(isset($emailSent) && $emailSent == true) { ?>

						<div class="full">
							<h5><?php echo $wpcrown_contact_thankyou ?></h5> 
						</div>

					<?php } else { ?>

					<?php if($nameError != '') { ?>
						<div class="full">
							<h5><?php echo $nameError;?></h5> 
						</div>										
					<?php } ?>
													
					<?php if($emailError != '') { ?>
						<div class="full">
							<h5><?php echo $emailError;?></h5>
						</div>
					<?php } ?>

					<?php if($subjectError != '') { ?>
						<div class="full">
							<h5><?php echo $subjectError;?></h5>  
						</div>
					<?php } ?>
													
					<?php if($commentError != '') { ?>
						<div class="full">
							<h5><?php echo $commentError;?></h5>
						</div>
					<?php } ?>

					<?php if($humanTestError != '') { ?>
						<div class="full">
							<h5><?php echo $humanTestError;?></h5>
						</div>
					<?php } ?>

					<form name="contactForm" action="<?php the_permalink(); ?>" id="contact-form" method="post" class="contactform row" >
						<div class="col-xs-12 margin-top-40">
							<h5 class="margin-top-0 margin-bottom-20">
								<?php esc_html_e('LEAVE REPLY TO AUTHOR','classiads'); ?>
							</h5>
							<div class="h3-seprator"></div>
						</div>
						<div class="col-sm-6 col-xs-12">							
							<input type="hidden" name="mposttitle" id="mposttitle" class="form-control" value="<?php the_title(); ?>" />
							<input type="hidden" name="mposturl" id="mposturl" class="form-control" value="<?php the_permalink(); ?>"  />
							<input type="text" placeholder="<?php esc_html_e( 'Full Name', 'classiads' ); ?>" name="contactName" id="contactName" class="form-control" />
						</div>	
						<div class="col-sm-6 col-xs-12">
							<input type="text" placeholder="<?php esc_html_e( 'Email', 'classiads' ); ?>" name="email" id="email" class="form-control" />
						</div>	
						<div class="col-md-12 col-xs-12">
							<input type="text" placeholder="<?php esc_html_e( 'Subject', 'classiads' ); ?>" name="subject" id="subject" class="form-control" />
						</div>	
						<div class="col-md-12 col-xs-12">
							<textarea class="form-control" placeholder="<?php esc_html_e( 'Write your message here...', 'classiads' ); ?>" name="comments" id="commentsText" cols="8" rows="5" ></textarea>
						</div>	
						<div class="col-sm-6 col-xs-12 rtl-right">
							<p class="humantest">
								<?php 
									$intnum =	rand(1,9) ;
									$lastnum =	rand(1,9) ;
									$totalnum = $intnum  +  $lastnum ; 
								?>
								<?php esc_html_e("Human Test: Find the X &nbsp; &nbsp; ", "classiads");
									echo $intnum ; ?> + <?php echo $lastnum ; ?> =
							</p>
						</div>
						<div class="col-sm-6 col-xs-12">
							<input type="text" placeholder="<?php esc_html_e( 'Your answer', 'classiads' ); ?>" name="humanTest" id="humanTest" value="" class="form-control" />	
							<input type="hidden" name="humanTests" id="humanTests" value="<?php echo $totalnum; ?>" class="input-textarea half" />
						</div>	
						<div class="col-md-12 col-xs-12">
							<input name="submitted" type="submit" value="<?php esc_html_e( 'Send Message', 'classiads' ); ?>" class="input-submit" />	
						</div>	
					</form>

					<?php } ?>

				</div>
			</div>
		<?php } ?>
		</div>
	</div>
</div>	
