<?php
global $post,$redux_demo,$current_user,$user_ID,$category_icon,$your_image_url,$category_icon_color; 



$post_latitude = get_post_meta($post->ID, 'post_latitude', true);
$post_longitude = get_post_meta($post->ID, 'post_longitude', true);
$post_address = get_post_meta($post->ID, 'post_address', true);
$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
$post_price = get_post_meta($post->ID, 'post_price', true);

?>
<div class="single-map clearfix margin-bottom-30">
	<?php if(!empty($post_latitude)) { ?>
	<div id="single-page-map">			    	
		<div id="single-page-main-map" ></div>
	<div id="ad-address">
		<span>
			<i class="fa fa-map-marker"></i>
			<?php echo esc_attr($post_address); ?>
		</span>
	</div>
	</div>
	<script>
		function singlePostMap() {
			
			
				var map_latitude = <?php echo esc_attr($post_latitude); ?>,
				map_longitude = <?php echo esc_attr($post_longitude); ?>, 
				s_name = "<?php echo get_the_title(); ?>", 
				s_PostThumbnail = "<?php echo esc_url($image[0]); ?>", 
				s_PostPrice = "<?php echo classiads_price($post_price); ?>", 
				s_CatIcon = '<?php echo wp_kses_post($category_icon); ?>', 
				s_Icon = '<?php echo esc_url($your_image_url); ?>', 
				s_CatBg = "<?php echo esc_attr($category_icon_color); ?>"; 
				
		 var locations =  [{'latlng':[map_latitude,map_longitude],name:s_name,PostThumbnail: s_PostThumbnail,PostPrice : s_PostPrice, icon: s_Icon, CatIcon : s_CatIcon, CatBg : s_CatBg},];
			var map = new google.maps.Map(document.getElementById('single-page-main-map'), {
				zoom: 5,
				center: {lat: <?php echo esc_attr($post_latitude); ?>, lng: <?php echo esc_attr($post_longitude); ?>},
				scrollwheel: false,
			});
			
			//Creates a infowindow object.
			infoWnd = new google.maps.InfoWindow();

			// Add some markers to the map.
			// Note: The code uses the JavaScript Array.prototype.map() method to
			// create an array of markers based on a given "locations" array.
			// The map() method here has nothing to do with the Google Maps API.
			var markers = locations.map(function(location, i) {
				latlng = new google.maps.LatLng(location.latlng[0], location.latlng[1]);
				  var marker = new google.maps.Marker({
					position: latlng,
					icon : location.icon
				  });
				  
				  var name = location.name,
					  PostThumbnail = location.PostThumbnail,
					  PostPrice = location.PostPrice,
					  CatBg = location.CatBg,
					  CatIcon = location.CatIcon;
				  //The infoWindow is opened when the sidebar button is clicked
				  google.maps.event.addListener(marker, "click", function(){
					infoWnd.setContent('<div class="marker-holder map-box-style-1"><div class="marker-content"><div class="marker-image"><img src="'+ PostThumbnail +'"></div><div class="marker-info-holder"><div class="marker-info-price">'+ PostPrice +'</div><div class="marker-info"><div class="marker-info-title"><a href="#">'+ name +'</a></div><div class="marker-icon-box"><div class="category-icon-box" style="background-color:'+ CatBg +'">'+ CatIcon +'</div></div></div></div></div></div>');
					infoWnd.open(map, marker);
				  });
				  
				//createMarkerButton(marker,name);
				return marker;
			});

			// Add a marker clusterer to manage the markers.
			var markerCluster = new MarkerClusterer(map, markers,
				{imagePath: 'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/m'});
		}

		jQuery(window).load( function (){
			
			singlePostMap();
			
		});
	</script>
	<?php } ?>
</div>