<?php
/**
 *
 * @package WordPress
 * @subpackage classiads
 * @since classiads 1.2.2
 * @updated classiads 4.0
 */
global $user_ID, $user_identity, $user_level,$redux_demo,$wpdb;
$current_user = wp_get_current_user();
$profile = $redux_demo['profile'];

if(isset($_POST['submitted']) && isset($_POST['post_nonce_field']) && wp_verify_nonce($_POST['post_nonce_field'], 'post_nonce')) {

	$message = esc_html__('Your profile updated successfully.','classiads');
	$first = sanitize_text_field($_POST['first_name']);
	$last = sanitize_text_field($_POST['last_name']);
	$email = sanitize_email($_POST['email']);
	$user_url = esc_url($_POST['website']);
	$user_phone = esc_attr($_POST['phone']);
	$user_facebook = esc_url($_POST['facebook']);
	$user_google = esc_url($_POST['google']);
	$user_twitter = esc_url($_POST['twitter']);
	$user_linkedin = esc_url($_POST['linkedin']);
	$user_instagram = esc_url($_POST['instagram']);
	$user_address = esc_attr($_POST['address']);
	$description = esc_attr($_POST['desc']);
	$password = esc_attr($_POST['pwd']);
	$confirm_password = esc_attr($_POST['confirm']);
	$disable_phone = esc_attr($_POST['disable_phone']);
	cs_user_avatar();
	update_user_meta( $user_ID, 'first_name', $first );
	update_user_meta( $user_ID, 'last_name', $last );
	update_user_meta( $user_ID, 'phone', $user_phone );
	update_user_meta( $user_ID, 'facebook', $user_facebook );
	update_user_meta( $user_ID, 'google', $user_google );
	update_user_meta( $user_ID, 'twitter', $user_twitter );
	update_user_meta( $user_ID, 'linkedin', $user_linkedin );
	update_user_meta( $user_ID, 'instagram', $user_instagram );
	update_user_meta( $user_ID, 'address', $user_address );
	update_user_meta( $user_ID, 'description', $description );
	update_user_meta( $user_ID, 'disable_phone', $disable_phone );
	wp_update_user( array ('ID' => $user_ID, 'user_url' => $user_url) );
	if(isset($email)) {
		if (preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/", $email)){
			wp_update_user( array ('ID' => $user_ID, 'user_email' => $email) ) ;
		}
		else { $message = esc_html__('Please enter a valid email id.','classiads'); }
	}
	if($password) {
		if (strlen($password) < 5 || strlen($password) > 15) {
			$message = esc_html__('Password must be 5 to 15 characters in length.','classiads');
		}
		elseif(isset($password) && $password != $confirm_password) {
			$message = esc_html__('Password Mismatch','classiads');
		} elseif ( isset($password) && !empty($password) ) {

			$update = wp_set_password( $password, $user_ID );

			$message = esc_html__('Your profile updated successfully.','classiads');

		}
	}
}


get_header(); ?>

	<?php while ( have_posts() ) : the_post(); ?>
    <section class="ads-main-page">
		<div class="ad-title">
			<div class="container">
				<div class="row">
					<div class="col-md-12 col-xs-12">
						<ul id="breadcrumbs" class="rel-ls-none rel-ls-inline">
							<li class="item-home">
								<a class="bread-link bread-home" href="<?php site_url(); ?>" title="<?php esc_html_e(" Home", 'classiads') ?>">
								<?php esc_html_e(" Home", 'classiads') ?>
								</a>
							</li>
							<li class="separator separator-home"> 
								<i class="fa fa-angle-right"></i> 
							</li>
							<li class="item-current">
								<a class="bread-link bread-home" href="<?php echo esc_url($profile); ?>" title="<?php esc_html_e(" Profile", 'classiads') ?>">
								<?php esc_html_e(" Profile", 'classiads') ?>
								</a>
							</li>
							<li class="separator separator-home"> 
								<i class="fa fa-angle-right"></i> 
							</li>
							<li class="item-current ">
								<strong class="bread-current ">
									<?php esc_html_e(" edit profile", 'classiads') ?>
								</strong>
							</li>
						</ul>
						<h2>
							<?php esc_html_e(" Edit Profile", 'classiads') ?>
						</h2>
					</div>
				</div>
			</div>
		</div>
    	<div class="container padding-top-60">
			<div class="row">
				<div class="col-md-9 col-sm-12 col-xs-12">
					<div class="account-overview clearfix">
						<div class="col-sm-4 col-xs-12 first author-avatar-edit-post">
							<form method="POST" id="form_user_avatar_submit" enctype="multipart/form-data" action="">
								<?php
								
								$display_photo = trim(cs_get_user_avatar(0, $user_ID));
								$display = 'style="display:none"';
								if ($display_photo <> '') {
								   // $display = 'style="display:block"';
								}
								if ($display_photo <> '') {
									$user_avatar = cs_get_user_avatar(0, $user_ID);
								} else {
									$user_avatar = 'http://0.gravatar.com/avatar/6b4ee819723f1368f1d2d7459b62e41d?s=150&d=mm&r=g';
								}
								?>
								<div class="cs-user-avatar-loading"></div>
								<div class="page-wrap" id="user_avatar_display_box">
									<div class="thumb-contan">
										<span class="avatar-loading"></span>
										<span id="cs-user-avatar-ajax-display">
											<img src="<?php echo esc_url($user_avatar); ?>" width="150" alt=""/>
										</span>
									</div>
								</div>
								<div class="new-btn-container">
									<span class="upload-file-icon">
										<input id="uploadFile" placeholder="<?php esc_html_e('Add New Image','classiads'); ?>" class="file-upload" disabled="disabled" style="display:none;">
									</span>
									<div class="fileUpload">
										<input type="file" id="form_user_avatar" class="upload" name="user_avatar" value="">
										<label for="form_user_avatar" class="imageupload">
											<span><?php esc_html_e('Add New Image','classiads'); ?></span>
										</label>
										<input type="hidden" name="action" value="cs_user_avatar_upload">
									</div>
									<div class="cs-error-msg" style="color:#900;"></div>
								</div> 
								<script>
									document.getElementById("form_user_avatar").onchange = function () {
										cs_user_avatar_upload("<?php echo admin_url('admin-ajax.php'); ?>");
									};
								</script>
							</form>
						</div>
						<div class="col-sm-8 col-xs-12 b-l-1 p-30">
							<?php classiads_user_profile_status($user_ID); ?>
						</div>
					</div>
					<div id="edit-profile" class="ad-detail-content margin-bottom-90">
						<h5>
							<?php esc_html_e( 'EDIT PROFILE', 'classiads' ); ?>
						</h5>
						<div class="h3-seprator"></div>
						<form class="form-item row" action="" id="primaryPostForm" method="POST" enctype="multipart/form-data">

							<?php 

								$user_info = get_userdata($user_ID);

								if($_POST) {

								echo '<div class="alert alert-warning alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>'.esc_attr($message).'</div>';

								} 
							?>
								
							<input class="criteria-image-url" id="your_image_url" type="text" size="36" name="your_author_image_url" value="<?php if (isset($your_image_url)){ echo esc_url($your_image_url); }else{ echo esc_url($author_avatar_url) ;} ?>" style="display:none;" />
							
							<input class="criteria-image-id" id="your_image_id" type="text" size="36" name="your_author_image_id" style="display: none;" value="your_author_image_id" />
							
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="text" id="contactName" placeholder="<?php esc_html_e('First Name','classiads'); ?>" name="first_name" class="form-control" value="<?php echo esc_attr($user_info->first_name); ?>" />
							</div>
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="text" id="contactName" placeholder="<?php esc_html_e('Last Name','classiads'); ?>" name="last_name" class="form-control" value="<?php echo esc_attr($user_info->last_name); ?>"/>
							</div>
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="text" id="email" placeholder="<?php esc_html_e('Email','classiads'); ?>" name="email" class="form-control" value="<?php echo esc_attr
								($user_info->user_email); ?>" readonly />
							</div>
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="text" id="website" placeholder="<?php esc_html_e('WebSite','classiads'); ?>" name="website" class="form-control" value="<?php echo esc_attr($user_info->user_url); ?>"/>
							</div>
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="text" id="phone" placeholder="<?php esc_html_e('Phone','classiads'); ?>" name="phone" class="form-control" value="<?php echo esc_attr($user_info->phone); ?>" />
							</div>
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="text" id="facebook" placeholder="<?php esc_html_e('Facebook','classiads'); ?>" name="facebook" class="form-control" value="<?php echo esc_attr($user_info->facebook); ?>" />
							</div>
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="text" id="google" placeholder="<?php esc_html_e('Google','classiads'); ?>" name="google" class="form-control" value="<?php echo esc_attr($user_info->google); ?>" />
							</div>
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="text" id="twitter" placeholder="<?php esc_html_e('Twitter','classiads'); ?>" name="twitter" class="form-control" value="<?php echo esc_attr($user_info->twitter); ?>" />
							</div>
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="text" id="linkedin" placeholder="<?php esc_html_e('Linkedin','classiads'); ?>" name="linkedin" class="form-control" value="<?php echo esc_attr($user_info->linkedin); ?>" />
							</div>
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="text" id="instagram" placeholder="<?php esc_html_e('Instagram','classiads'); ?>" name="instagram" class="form-control" value="<?php echo esc_attr($user_info->instagram); ?>" />
							</div>
							<div class="col-md-12 col-sm-12 col-xs-12">
								<input type="text" id="address" placeholder="<?php esc_html_e('Address','classiads'); ?>" name="address" class="form-control" value="<?php echo esc_attr($user_info->address); ?>" />
							</div>
							<div class="col-md-12 col-sm-12 col-xs-12">
								<textarea name="desc" id="desc" placeholder="<?php esc_html_e('Author Bio','classiads'); ?>" class="form-control" rows="10"><?php echo esc_attr($user_info->description); ?></textarea>
							</div>
							
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="password" placeholder="<?php esc_html_e('Password','classiads'); ?>" id="password" name="pwd" class="form-control" maxlength="15" />
							</div>
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="password" placeholder="<?php esc_html_e('Confirm Password','classiads'); ?>" id="password" name="confirm" class="form-control" maxlength="15" />
							</div>
							<div class="col-md-6 col-sm-12 col-xs-12 form-s-select">
								<label for="disable_phone">
									<?php
										esc_html_e('Disable phone number for public on website','classiads');
										$disable_phone = $user_info->disable_phone;
										$selected = "selected='selected'";
									?>
								</label>
								<select class="form-select" name="disable_phone" id="disable_phone">
									<option value=""><?php esc_html_e('Select Options','classiads'); ?></option>
									<option value="yes" <?php if($disable_phone == 'yes'){ echo esc_attr($selected);} ?>><?php esc_html_e('Yes','classiads'); ?></option>
									<option value="no" <?php if($disable_phone == 'no'){ echo esc_attr($selected);} ?>><?php esc_html_e('No','classiads'); ?></option>
								</select>
							</div>
							<div class="col-md-12 col-sm-12 col-xs-12">
								<p class="help-block"><?php esc_html_e('If you would like to change the password type a new one. Otherwise leave this blank.', 'classiads') ?></p>
							</div>
							<div class="col-md-12 col-sm-12 col-xs-12">
								<div class="publish-ad-button">
									<?php wp_nonce_field('post_nonce', 'post_nonce_field'); ?>
									<input type="hidden" name="submitted" id="submitted" value="true" />
									<div class="clearfix"></div>
									<button class="btn form-submit" id="edit-submit" name="op" value="Publish Ad" type="submit">
										<?php esc_html_e('SAVE SETTINGS', 'classiads') ?>
									</button>
								</div>
							</div>
						</form>
					</div>
				</div>
				<div class="col-md-3 col-sm-12 col-xs-12 classi_sidebar">
					<?php get_sidebar('pages'); ?>
				</div>
			</div>
	    </div>
    </section>
    <?php endwhile; ?>