<?php
	global $redux_demo,$w_sidebar;
	$postid = get_the_ID();
	$ads_title_limit = $redux_demo['home-ads-title-limit'];
	$featured_post = get_post_meta($post->ID,'featured_post',true);
	$post_price = get_post_meta($post->ID, 'post_price', true);
	$category_icon_code = "";
	if($w_sidebar == true){
		$short_list = 'short-list';
	}else{
		$short_list = '';
	}
 ?>
<div class="col-xs-12 list-box-3 <?php echo esc_attr($short_list); ?> classiads-length" id="post-<?php echo $postid; ?>">
	<div class="ad-box">
	<?php
		if ( has_post_thumbnail()) {
			$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($postid), 'full');
			echo '<a class="ad-image" href="' .get_permalink($post->ID). '" title="' . the_title_attribute('echo=0') . '" >';
				echo classiads_images( $large_image_url[0], 270, 220,true );
			echo '</a>';
		}else{
			$large_image_url = '';
			echo '<a class="ad-image" href="' .get_permalink($post->ID). '" title="' . the_title_attribute('echo=0') . '" >';
				echo classiads_images( $large_image_url, 270, 220,true );
			echo '</a>';
		}   
	?>
	<?php

		$category = get_the_category();
		if ($category[0]->category_parent == 0) {
			$tag = $category[0]->cat_ID;
			$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
			if (isset($tag_extra_fields[$tag])) {
				$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
				$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
				$select_opt_icon = $tag_extra_fields[$tag]['select-opt-icon'];
				$select_opt_img_icon = $tag_extra_fields[$tag]['select_opt_img_icon'];
			}
		}else{
			$tag = $category[0]->category_parent;
			$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
			if (isset($tag_extra_fields[$tag])) {
				$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
				$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
				$select_opt_icon = $tag_extra_fields[$tag]['select-opt-icon'];
				$select_opt_img_icon = $tag_extra_fields[$tag]['select_opt_img_icon'];
			}
		}
		if(!empty($category_icon_code)) {
	
			$category_icon = stripslashes($category_icon_code); 

		}


	?>
	<div class="category-icon-v3">
		<?php 
			if( $select_opt_icon != 'imgicon' ){
				if( !empty( $category_icon_code ) ) { ?>
				<div style="background-color:<?php echo esc_attr( $category_icon_color ); ?>" class="category-icon-box">
					<?php 
						$category_icon = stripslashes($category_icon_code); 
						echo wp_kses_post( $category_icon );
					?>
				</div>
			<?php 
				}
			}else{ 
		?>
			<div class="category-icon-box cat-img-icon cat-icon-box-3" style="background-color:<?php echo esc_attr($category_icon_color); ?>;border-color:<?php echo esc_attr($category_icon_color); ?>">
				<img src="<?php echo esc_url( $select_opt_img_icon ); ?>" alt="img-category" class="img-responsive" />
			</div>
		<?php } ?>
	</div>
	</div>
	<div class="list-description3 <?php echo esc_attr( $short_list ); ?>">
		<div class="post-title-cat pull-left">

			<div class="post-title">
				<a href="<?php the_permalink(); ?>">
					<?php 
						$theTitle = get_the_title(); 
						$theTitle = (strlen($theTitle) > $ads_title_limit) ? substr($theTitle,0,$ads_title_limit).'...' : $theTitle; 
						echo $theTitle;
					?>
				</a>
				<?php
				if(!empty($post_price)){
				?>
				<div class="list-post-price">
					<span>
						<?php echo classiads_price(esc_attr($post_price, 'classiads')); ?>
					</span>
				</div>
				<?php } ?>
			</div>
			<a class="feat-category" href="<?php echo get_category_link( $category[0]->term_id ); ?>">
				<?php echo $category[0]->name; ?>
			</a>
		</div>
		<span class="ad-ratings">
			<?php classiads_avaerage_rating_stars( $postid ); ?>
		</span>
		<div class="ad-description">
			<?php 
				if($w_sidebar == true){
					echo substr(get_the_excerpt($postid), 0,150);
				}else{
					echo substr(get_the_excerpt($postid), 0,270);
				}
			?>
		</div>
		<?php if(has_tag()){ ?>
		<div class="ads-tags">
			<i class="fa fa-tags"></i><span class="tag-title"><a><?php _e('Tags', 'classiads'); ?>:</a></span><span><?php the_tags('','',''); ?></span>
		</div>
		<?php } ?>
		<a href="<?php the_permalink(); ?>" class="cl-default-button">
			<span><?php esc_html_e( 'READ MORE', 'classiads' ); ?></span>
		</a>
	</div>
</div>