<?php

/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme and one of the
 * two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * For example, it puts together the home page when no home.php file exists.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiads
 * @since classiads 3.5.2
 */
 

	global $redux_demo , $w_sidebar;
	$ads_title_limit = $redux_demo['home-ads-title-limit'];
	
	if($w_sidebar == true){
		$grid_c = 'col-md-4 col-sm-6 col-xs-12';
	}else{
		$grid_c = 'col-md-4 col-sm-6 col-xs-12';
	}
	$postid = get_the_ID();
	$featured_post = get_post_meta($postid,'featured_post',true);
	$post_address = get_post_meta($postid,'post_address',true);
	$user_id = $post->post_author;
	$wcemailverified = get_user_meta($user_id, "wcemailverified", true);
	$disable_phone = get_user_meta( $user_id, 'disable_phone', true );
	$phone = get_user_meta( $user_id, 'phone', true );
	$ph_number = preg_replace("/[^0-9]/", "", $phone);
	$current_user = wp_get_current_user();
	$c_userid = $current_user->ID;
	$t_likes = classiads_count_ad_likes($postid);
	$check_user_like = cl_check_user_like_ad($postid,$c_userid);
	$cl_liked = '';
	if( $check_user_like ==  1 ){
		$cl_liked = 'cl_liked';
	}  
 ?>
<div class="<?php echo esc_attr($grid_c); ?> classiads-grid grid-vr-4 classiads-length" data-featured="<?php echo esc_attr( $featured_post ); ?>">
	<div class="grid-box latest-posts-grid">
		<div class="grid-thumb clearfix pos-relative">
			<?php
				if ( has_post_thumbnail()) {
					$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($postid), 'full');
					echo '<a class="ad-image" href="' .get_permalink($post->ID). '" title="' . the_title_attribute('echo=0') . '" >';
						echo classiads_images( $large_image_url[0], 370, 230,0 );
					echo '</a>';
				}else{
					$large_image_url = '';
					echo '<a class="ad-image" href="' .get_permalink($post->ID). '" title="' . the_title_attribute('echo=0') . '" >';
						echo classiads_images( $large_image_url, 370, 230,0 );
					echo '</a>';
				}   
				
				$category = get_the_category($postid);
				
				if ($category[0]->category_parent == 0) {

					$tag = $category[0]->cat_ID;

					$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
					if (isset($tag_extra_fields[$tag])) {
						$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
						$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
						$select_opt_icon = $tag_extra_fields[$tag]['select-opt-icon'];
						$select_opt_img_icon = $tag_extra_fields[$tag]['select_opt_img_icon'];
					}

				} else {

					$tag = $category[0]->category_parent;

					$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
					if (isset($tag_extra_fields[$tag])) {
						$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
						$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
						$select_opt_icon = $tag_extra_fields[$tag]['select-opt-icon'];
						$select_opt_img_icon = $tag_extra_fields[$tag]['select_opt_img_icon'];
					}

				}

				if(!empty($category_icon_code)) {
					$category_icon = stripslashes($category_icon_code); 
				}
				$category_icon_code = "";
				if( $featured_post == 'on' ){
			?>
				<span class="featured_tag">
					<?php esc_html_e('Featured','classaids'); ?>
				</span>
				
			<?php } ?>
			
			<div class="cl_fav_btn_cont">
				<a href="#" class="cl_add_to_fav cl_fav_btn <?php echo esc_attr($cl_liked); ?>" data-userid="<?php echo esc_attr($c_userid); ?>" data-postid="<?php echo esc_attr( $postid ); ?>" data-fave_value="true" data-already_like="<?php echo $check_user_like; ?>">
					<i class="fa fa-heart"></i>
					<span class="cl_count_fav">
						<?php echo esc_attr( $t_likes ); ?>
					</span>
				</a>
			</div>
		</div>

		<div class="grid-title-cat clearfix">

			<div class="grid-title">
				<?php if( $select_opt_icon == 'fontawesome' ){ ?>
					<?php if( !empty($category_icon) ){ ?>
						<div class="grid-vr-cat-icon">
							<span>
								<?php echo wp_kses_post($category_icon); ?>
							</span>
						</div>
					<?php 
						} 
					}else{ 
						if( !empty($select_opt_img_icon) ){ ?>
						<div class="grid-vr-cat-icon">
							<span>
								<img src="<?php echo esc_url($select_opt_img_icon); ?>" alt="img-icon" class="img-responsive" />
							</span>
						</div>
					<?php } 
						} 
					?>
				<h5>
					<a href="<?php the_permalink(); ?>">
						<?php 
							$theTitle = get_the_title( $postid ); 
							$theTitle = (strlen($theTitle) > $ads_title_limit) ? substr($theTitle,0,$ads_title_limit).'...' : $theTitle;
							echo esc_attr( $theTitle );
							if( $wcemailverified == 'true'){
								echo '<img src="'.get_template_directory_uri().'/images/verified.png" alt="verified" class="margin-left-20" />';
							}
						?>
					</a>
				</h5>
			</div>
			<ul class="grid-bottom-line clearfix">
				<?php if( !empty($post_address) ){ ?>
				<li>
					<i class="fa fa-map-marker f-icon"></i>
					<span><?php echo esc_attr( $post_address ); ?></span>
				</li>
				<?php } ?>
				<?php if($disable_phone != 'no'){ ?>
					<?php if( !empty( $phone ) ){ ?>
					<li>
						<i class="fa fa-phone f-icon"></i>
						
						<a href="tel:+<?php echo esc_attr( $ph_number ); ?>" >
							<?php echo esc_attr( $phone ); ?>
						</a>
					</li>
					<?php } ?>
				<?php } ?>
				
				<li>
					<i class="f-icon"></i>
					<span>
						<i class="fa fa-star"></i>
						<i class="fa fa-star"></i>
						<i class="fa fa-star"></i>
						<i class="fa fa-star"></i>
						<i class="fa fa-star-o"></i>
					</span>
				</li>
			</ul>

		</div>
	</div>
</div>