<?php

/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme and one of the
 * two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * For example, it puts together the home page when no home.php file exists.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiads
 * @since classiads 3.5.2
 */
 

	global $redux_demo , $w_sidebar,$post;
	$ads_title_limit = $redux_demo['home-ads-title-limit'];
	
	if($w_sidebar == true){
		$grid_c = 'col-md-4 col-sm-6 col-xs-12 a';
	}else{
		$grid_c = 'col-md-3 col-sm-6 col-xs-12';
	}
	$featured_post = get_post_meta($post->ID,'featured_post',true);
	$post_price = get_post_meta($post->ID, 'post_price', true);
	$postid = $post->ID;
	$user_id = $post->post_author;
	$current_user = wp_get_current_user();
	$c_userid = $current_user->ID;
	$t_likes = classiads_count_ad_likes($postid);
	$check_user_like = cl_check_user_like_ad($postid,$c_userid);
	$category_icon_code = "";
	$category_icon_color = "";
	$cl_liked = '';
	if( $check_user_like ==  1 ){
		$cl_liked = 'cl_liked';
	} 
 ?>
<div class="<?php echo $grid_c; ?>  classiads-grid grid-vr-3 classiads-length">
	<div class="ad-box latest-posts-grid">
		<div class="ads-v2-thumb">
			<?php
				if ( has_post_thumbnail()) {
					$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($postid), 'full');
					echo '<a class="ad-image" href="' .get_permalink($post->ID). '" title="' . the_title_attribute('echo=0') . '" >';
						echo classiads_images( $large_image_url[0], 270, 220 );
					echo '</a>';
				}else{
					$large_image_url = '';
					echo '<a class="ad-image" href="' .get_permalink($post->ID). '" title="' . the_title_attribute('echo=0') . '" >';
						echo classiads_images( $large_image_url, 270, 220 );
					echo '</a>';
				}   
			?>
			<?php

				$category = get_the_category();

				if ($category[0]->category_parent == 0) {

					$tag = $category[0]->cat_ID;

					$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
					if (isset($tag_extra_fields[$tag])) {
						$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
						$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
					}

				} else {

					$tag = $category[0]->category_parent;

					$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
					if (isset($tag_extra_fields[$tag])) {
						$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
						$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
					}

				}

				if(!empty($category_icon_code)) {
					
					$category_icon = stripslashes($category_icon_code);

				}

				$category_icon_code = "";

			?>

			<?php if( !empty( $category_icon ) ){ ?>
				<div class="ads-vr-2-category-icon" style="background-color:<?php echo $category_icon_color; ?>"><span><?php echo wp_kses_post( $category_icon ); ?></span></div>
			<?php } ?>
			
			<?php if( $featured_post == 'on' ){ ?>
				<span class="featured_tag">
					<?php esc_html_e('Featured','classaids'); ?>
				</span>
			<?php } ?>
			<a href="#" class="cl_add_to_fav cl_fav_btn <?php echo esc_attr($cl_liked); ?>" data-userid="<?php echo esc_attr($c_userid); ?>" data-postid="<?php echo esc_attr( $postid ); ?>" data-fave_value="true" data-already_like="<?php echo $check_user_like; ?>">
				<i class="fa fa-heart-o"></i>
			</a>
	</div>

		<div class="post-title-cat">

			<div class="post-title">
				<a href="<?php the_permalink(); ?>">
					<?php $theTitle = get_the_title(); 
						$theTitle = (strlen($theTitle) > $ads_title_limit) ? substr($theTitle,0,$ads_title_limit).'...' : $theTitle; 
						echo $theTitle; 
					?>
				</a>
			</div>
			<div class="ads-bottom-line">
				<a class="feat-category" href="<?php echo get_category_link( $category[0]->term_id ); ?>">
					<?php echo $category[0]->name; ?>
				</a>
				<?php
				$post_price = get_post_meta($post->ID, 'post_price', true);
				if(!empty($post_price)){
				?>
				<div class="ads-price-v2"><span><?php echo classiads_price(esc_attr($post_price, 'classiads')); ?></span></div>
			<?php } ?>
			</div>

		</div>

	</div>
</div>