<?php

/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme and one of the
 * two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * For example, it puts together the home page when no home.php file exists.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiads
 * @since classiads 3.5.2
 */


	global $redux_demo , $w_sidebar,$post;
	$ads_title_limit = $redux_demo['home-ads-title-limit'];
	
	if($w_sidebar == true){
		$grid_c = 'col-md-4 col-sm-6 col-xs-12 ';
	}else{
		$grid_c = 'col-md-3 col-sm-6 col-xs-12';
	}
	$featured_post = get_post_meta($post->ID,'featured_post',true);
	$post_price = get_post_meta($post->ID, 'post_price', true);
	$postid = $post->ID;
	$user_id = $post->post_author;
	$current_user = wp_get_current_user();
	$c_userid = $current_user->ID;
	$t_likes = classiads_count_ad_likes($postid);
	$check_user_like = cl_check_user_like_ad($postid,$c_userid);
	$category_icon_code = "";
	$category_icon_color = "";
	$cl_liked = '';
	if( $check_user_like ==  1 ){
		$cl_liked = 'cl_liked';
	} 
	$category = get_the_category();
	$category_icon_code = "";

	if ($category[0]->category_parent == 0) {

		$tag = $category[0]->cat_ID;

		$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
		if (isset($tag_extra_fields[$tag])) {
			$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
			$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
		}

	} else {

		$tag = $category[0]->category_parent;

		$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
		if (isset($tag_extra_fields[$tag])) {
			$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
			$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
		}

	}

	if(!empty($category_icon_code)) {

		$category_icon = stripslashes($category_icon_code);
	}
		if(!empty($category_icon_color)) {
			
	?>
	<style>
		#post-<?php echo esc_attr($postid); ?>.grid-vr-2 > .ad-box .post-title-icon{border-color:<?php echo esc_attr($category_icon_color); ?>;}
		#post-<?php echo esc_attr($postid); ?>.grid-vr-2 > .ad-box .post-title-icon i{color:<?php echo esc_attr($category_icon_color); ?>;}
		#post-<?php echo esc_attr($postid); ?>.grid-vr-2 > .ad-box:hover .post-title-icon{background-color:<?php echo esc_attr($category_icon_color); ?>;}
		#post-<?php echo esc_attr($postid); ?>.grid-vr-2 > .ad-box:hover .post-title-icon i{color:#fff;}
	</style>
	<?php } ?>
<div id="post-<?php echo esc_attr($postid); ?>" class="<?php echo esc_attr($grid_c); ?> classiads-grid grid-vr-2 classiads-length">
	<div class="ad-box latest-posts-grid clearfix">
		<?php
			if ( has_post_thumbnail()) {
				$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($postid), 'full');
				echo '<a class="ad-image" href="' .get_permalink($post->ID). '" title="' . the_title_attribute('echo=0') . '" >';
					echo classiads_images( $large_image_url[0], 270, 274 );
				echo '</a>';
			}else{
				$large_image_url = '';
				echo '<a class="ad-image" href="' .get_permalink($post->ID). '" title="' . the_title_attribute('echo=0') . '" >';
					echo classiads_images( $large_image_url, 270, 274 );
				echo '</a>';
			}   
		?>
			<?php
			if(!empty($post_price)){
			?>
			<div class="add-price"><span><?php echo classiads_price(esc_attr($post_price)); ?></span><div class="pacman"></div></div>
			<?php } ?>

		<div class="post-title-cat">
			<?php if( $featured_post = 'on' ){ ?>
				<i class="fa fa-star"></i>
			<?php } ?>
			<div class="post-title clearfix">

				<div class="post-tit-lft">
					<a class="grid-post-tit" href="<?php the_permalink(); ?>"><?php $theTitle = get_the_title(); $theTitle = (strlen($theTitle) > $ads_title_limit) ? substr($theTitle,0,$ads_title_limit).'...' : $theTitle; echo esc_attr($theTitle); ?></a>

					<a class="feat-category" href="<?php echo get_category_link( $category[0]->term_id ); ?>">
						<?php echo esc_attr($category[0]->name); ?>
					</a>
				</div>
			<?php
				if(!empty($category_icon)) {
			?>
				<div class="post-title-icon">
					<?php
						echo wp_kses_post($category_icon);
					?>
				</div>
			<?php } ?>
			</div>
		</div>
	</div>
</div>