<?php

/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme and one of the
 * two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * For example, it puts together the home page when no home.php file exists.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiads
 * @since classiads 3.5.2
 */

	global $redux_demo , $w_sidebar;
	$ads_title_limit = $redux_demo['home-ads-title-limit'];
	
	if($w_sidebar == true){
		$grid_c = 'col-md-4 col-sm-6 col-xs-12';
	}else{
		$grid_c = 'col-md-3 col-sm-6 col-xs-12';
	}
	$featured_post = get_post_meta($post->ID,'featured_post',true);
	$post_price = get_post_meta($post->ID, 'post_price', true);
	$postid = $post->ID;
	$user_id = $post->post_author;
	$current_user = wp_get_current_user();
	$c_userid = $current_user->ID;
	$t_likes = classiads_count_ad_likes($postid);
	$check_user_like = cl_check_user_like_ad($postid,$c_userid);
	$category_icon_code = "";
	$category_icon_color = "";
	$cl_liked = '';
	if( $check_user_like ==  1 ){
		$cl_liked = 'cl_liked';
	} 
?>
<div class="<?php echo esc_attr( $grid_c ); ?> classiads-grid grid-vr-1 classiads-length">
	<div class="ad-box">
		<div class="grid-post-thumb pos-relative clearfix">
			<?php
				if ( has_post_thumbnail()) {
					$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($postid), 'full');
					echo '<a class="ad-image" href="' .get_permalink($post->ID). '" title="' . the_title_attribute('echo=0') . '" >';
						echo classiads_images( $large_image_url[0], 270, 220,true );
					echo '</a>';
				}else{
					$large_image_url = '';
					echo '<a class="ad-image" href="' .get_permalink($post->ID). '" title="' . the_title_attribute('echo=0') . '" >';
						echo classiads_images( $large_image_url, 270, 220,true );
					echo '</a>';
				}   
			?>
			<?php
			if(!empty($post_price)){
			?>
			<div class="add-price">
				<span>
					<?php echo classiads_price( $post_price ); ?>
				</span>
			</div>
			<?php }
				if( $featured_post == 'on' ){
			?>
			<span class="featured_tag">
				<?php esc_html_e('Featured','classaids'); ?>
			</span>
			<?php } ?>
			<div class="grid-1-overlay">
				<div class="grid-star-cont">
					<a href="#" class="cl_add_to_fav <?php echo esc_attr( $cl_liked ); ?>" data-userid="<?php echo esc_attr( $c_userid ); ?>" data-postid="<?php echo esc_attr( $postid ); ?>" data-fave_value="true" data-already_like="<?php echo esc_attr( $check_user_like ); ?>">
						<i class="fa fa-heart"></i>
						<i class="fa fa-heart-o"></i>
					</a>
					<div class="grid-rating">
						<?php classiads_avaerage_rating_stars( $postid ); ?>
					</div>
				</div>
			</div>
		</div>
		<div class="post-title-cat">
			<?php

				$category = get_the_category();

				if (isset($category ) && $category[0]->category_parent == 0) {

					$tag = $category[0]->cat_ID;

					$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
					if (isset($tag_extra_fields[$tag])) {
						if(isset( $tag_extra_fields[$tag]['category_icon_code'] )){
							$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
						}
						if(isset( $tag_extra_fields[$tag]['category_icon_color'] )){
							$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
						}
					}

				} else {

					$tag = $category[0]->category_parent;

					$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
					if (isset($tag_extra_fields[$tag])) {
						$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
						$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
					}

				}

				if(!empty($category_icon_code)) {
				
					$category_icon = stripslashes($category_icon_code);

				} 
			?>
			<div class="post-title">
				<?php if(!empty($category_icon)){ ?>
					<div class="post-title-icon" style="background-color:<?php echo esc_attr( $category_icon_color ); ?>">
						<?php echo wp_kses_post( $category_icon ); ?>
					</div>
				<?php } ?>
				<a href="<?php echo get_the_permalink( $postid ); ?>">
						
					<?php 
						
						$theTitle = classiads_post_title($post->ID); 
						$theTitle = (strlen($theTitle) > $ads_title_limit ) ? substr($theTitle,0,$ads_title_limit ).'...' : $theTitle; 
						echo esc_attr( $theTitle ); 
					?>
				</a>
			</div>
		</div>
	</div>
</div>