<?php
/**
 * Template name: Edit Ad
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiads
 * @since classiads 1.2.2
 */

global $redux_demo;
$post_id = $_GET['post'];
$post = get_post($post_id);		
$author = get_post_field ('post_author', $post_id);
$hide_map = $redux_demo['hide-map'];
$login = $redux_demo['login'];
$post_currency = $redux_demo['postcurrency'];
$defaultImage = $redux_demo['default-post-image'];
$rate_for_per_post = $redux_demo['rate-for-per-post'];
$rate_for_per_featured = $redux_demo['rate-for-per-featured'];
$uploadlimit = $redux_demo['image-limit'];
$free_listing_tag = $redux_demo['free_price_text'];	
$currency_setup = $redux_demo['currency-setup'];
$profile = $redux_demo['profile'];
$ai_info = $redux_demo['ai_info'];
$currency_setup = $redux_demo['currency-setup'];
$new_ad_required_fields = $redux_demo['new-ad-required-fields'];
$featured_ads_user = $redux_demo['featured-ads_user'];
$current_user = wp_get_current_user();
$userID = $current_user->ID;
$uesrdata = get_userdata($userID);
$user_login = $uesrdata->user_login;
$user_email = $uesrdata->user_email;
$post_r_title = $post_r_category = $post_r_location = $post_r_address = $post_r_price = $post_r_tags = $post_r_video = $permalink = $postContent = $defaultImageURL = $defaultImageID = $defaultImageID = $category_id = $category_parent = '';

if ( !is_user_logged_in() ) {
	wp_redirect( home_url() ); exit;
}
if(isset($_GET['post'])) {
		
	$posts_id = $_GET['post'];
	$author = get_post_field( 'post_author', $posts_id );
	if(current_user_can('administrator') ){
	}else{
		if($author != $userID) {
			wp_redirect( home_url() ); exit;
		}
	}
	$current_post = $post->ID;
	$title = get_the_title();
	$content = get_the_content($current_post);
	$posttags = get_the_tags($current_post);
	if ($posttags) {
	  foreach($posttags as $tag) {
		$tags_list = $tag->name . ' ';
	  }
	}
	$postcategory = get_the_category( $current_post );
	if($postcategory[0]->category_parent != 0){
		$category_id = $postcategory[0]->cat_ID;
		$category_parent = $postcategory[0]->category_parent;
	}else{
		$category_parent = $postcategory[0]->cat_ID;
		$category_id = '';
	}
	$post_category_type = get_post_meta($post->ID, 'post_category_type', true);
	$post_price = get_post_meta($post->ID, 'post_price', true);
	$post_location = get_post_meta($post->ID, 'post_location', true);
	$post_latitude = get_post_meta($post->ID, 'post_latitude', true);
	$post_longitude = get_post_meta($post->ID, 'post_longitude', true);
	$post_price_plan_id = get_post_meta($post->ID, 'post_price_plan_id', true);
	$post_address = get_post_meta($post->ID, 'post_address', true);
	$post_video = get_post_meta($post->ID, 'post_video', true);
	$fet_img = get_post_meta($post->ID, 'fet_img', true);
	$extrafields = get_post_meta($post->ID, 'extrafields', true);
	$ad_posttype = get_post_meta($post->ID, 'ad_posttype', true);		
	$featured_post = get_post_meta($post->ID, 'featured_post', true);

	if(empty($post_latitude)) {
		$post_latitude = 0;
	}

	if(empty($post_longitude)) {
		$post_longitude = 0;
		$mapZoom = 2;
	} else {
		$mapZoom = 16;
	}

	if ( has_post_thumbnail() ) {
		$post_thumbnail = get_the_post_thumbnail($current_post, 'thumbnail');
	}
}
global $current_post;
if(isset($_POST['submitted']) && isset($_POST['post_nonce_field']) && wp_verify_nonce($_POST['post_nonce_field'], 'post_nonce')) {
		$postTitle = (isset($_POST['postTitle']) && !empty($_POST['postTitle'])) ? $_POST['postTitle'] : '';
		$postContent = (isset($_POST['postContent']) && !empty($_POST['postContent'])) ? $_POST['postContent'] : '';
		$cat = (isset($_POST['cat']) && !empty($_POST['cat'])) ? $_POST['cat'] : '';
		$subcat = (isset($_POST['subcat']) && !empty($_POST['subcat'])) ? $_POST['subcat'] : '';
		if(!empty($subcat)){
			$ad_category_id  = $subcat;
		}else{
			
			$ad_category_id  = $cat;
		}
		$post_tags = (isset($_POST['post_tags']) && !empty($_POST['post_tags'])) ? $_POST['post_tags'] : '';
		$post_location = (isset($_POST['post_location']) && !empty($_POST['post_location'])) ? $_POST['post_location'] : '';
		$extraFields = (isset($_POST['extraFields']) && !empty($_POST['extraFields'])) ? $_POST['extraFields'] : '';		
		$mark_feautred = (isset($_POST['featured_post']) && !empty($_POST['featured_post'])) ? $_POST['featured_post'] : '';
		$post_price_status = trim($_POST['post_price']);
		if($currency_setup == 'cs-new'){
			$currency = '';
		}elseif($currency_setup == 'cs-old'){
			$currency = $redux_demo['postcurrency'];
		}
		if(empty($post_price_status)) {
			$post_price_content = $free_listing_tag;			
		} else {
			$post_price_content = $currency.$post_price_status;
		}
		$post_price = (isset($post_price_content) && !empty($post_price_content)) ? $post_price_content : '';
		$post_latitude = (isset($_POST['latitude']) && !empty($_POST['latitude'])) ? $_POST['latitude'] : '';
		$post_longitude = (isset($_POST['longitude']) && !empty($_POST['longitude'])) ? $_POST['longitude'] : '';
		$post_address = (isset($_POST['address']) && !empty($_POST['address'])) ? $_POST['address'] : '';
		$video = (isset($_POST['video']) && !empty($_POST['video'])) ? $_POST['video'] : '';
		$cl_cu_sub_array = classiads_check_user_for_ads_submission();
		$postStatus = $cl_cu_sub_array[0];
		$posttype = $cl_cu_sub_array[1];
		$featured = $cl_cu_sub_array[2];
		if(is_super_admin() ){
			$postStatus = 'publish';
		}elseif(!is_super_admin()){
			if($redux_demo['post-options-edit-on'] == 1){
				$postStatus = 'private';
			}else{
				$postStatus = 'publish';
			}
		}
		
		$post_information = array(
			'ID' => $current_post,
			'post_title' => esc_attr(strip_tags($postTitle)),
			'post_content' => wp_kses_post($postContent),
			'post-type' => 'post',
			'post_category' => array($ad_category_id),
			'tags_input'    => explode(',', $post_tags),
			'tax_input' => array(
				'location' => esc_attr($post_location),
			),
			'meta_input' => array(
				'extrafields' => esc_attr($extraFields),
				'post_price' => esc_attr($post_price),
				'post_latitude' => esc_attr($post_latitude),
				'post_longitude' => esc_attr($post_longitude),
				'post_address' => esc_attr($post_address),
				'post_video' => wp_kses_post($video),
				'ad_posttype' => esc_attr($ad_posttype),
			),
			'comment_status' => 'open',
			'ping_status' => 'open',
			'post_status' => $postStatus
		);
		$post_id = wp_update_post($post_information);
		classiads_update_c_fields_category($post_id,$cat,$subcat);
		
		if( $posttype == 'single-paid' || $posttype == 'free' ){
			
			if($mark_feautred == true){
				
				update_post_meta($post_id,'ad_featured_option','true');
				$featured_ads = 1;
				$regular_ads = '';
				$ad_price = $rate_for_per_featured ;
			
				$title = esc_html__('Pay for ','classiads') .$postTitle. esc_html__(' Ad','classiads');
				$insert_invoice = array(
					'post_title' => $title,
					'post_status' => 'publish',
					'post_date' => date('Y-m-d H:i:s'),
					'post_author' => $userID,
					'post_type' => 'invoice',
					'meta_input' => array(
						'_invoice_status' => 'unpaid',
						'_invoice_status_2' => 'in-progress',
						'_invoice_plan_name' => $title,
						'_invoice_billing_type' => '',
						'_invoice_item_id' => $post_id,
						'_invoice_item_price' => $ad_price,
						'_invoice_purchase_date' => '',
						'_invoice_buyer_id' => $userID,
						'_invoice_buyer_name' => $user_login,
						'_invoice_member' => 'false',
						'_invoice_featured_ads' => $featured_ads,
						'_invoice_regular_ads' => $regular_ads,
						'_invoice_expire_date' => '',
						'_invoice_complete_date' => '',
					)
				);
				$invoice_id = wp_insert_post( $insert_invoice );
				update_post_meta($post_id, 'ad_invoice_id', $invoice_id);
				update_post_meta($post_id, 'ad_payment', 'processing');
				$permalink = get_permalink( $post_id ).'?invoice-created="true"';
					
				
			}
			
		}elseif( $posttype == 'member' ){
			
			$invoice_id = get_user_meta($userID,'u_c_p_invoice_id',true);
			$featured_ads = get_user_meta($userID,'u_c_p_featured_ads',true);
			$regular_ads = get_user_meta($userID,'u_c_p_regular_ads',true);
			
			if($mark_feautred == true){
				if( !empty( $featured_ads ) && $featured_ads != 0 ){
					$new_F_ads = $featured_ads - 1 ;
					update_user_meta($userID,'u_c_p_featured_ads',$new_F_ads);
					update_post_meta($post_id,'ad_featured_option','true');
				}
			}
			
			update_post_meta($post_id, 'ad_invoice_id', $invoice_id);
			update_post_meta($post_id, 'ad_payment', 'paid');
			
			$permalink = get_permalink( $post_id );		
			
		}else{
			$permalink = get_permalink( $post_id );	
		}
		
		
		if (isset($_POST['jfiler-items-exclude-file'])) {
			$string = str_replace('"', '', $_POST['jfiler-items-exclude-file']);
			$string2 = str_replace("'", '', $string); 
			$string3 = str_replace('\\', '', $string2); 
			$string4 = str_replace('[', '', $string3);
			$string5 = str_replace(']', '', $string4);
			
			$values = $string5[0];
			
			$att_ids = explode(',', $values);
			foreach($att_ids as $key=>$att_id){
					wp_delete_attachment($att_id);
					
				}
		}
		//if(isset($_POST['featuredimage'])){
			//update_post_meta($post_id, 'fet_img', $_POST['featuredimage']);
		//}
		$gallery_images = (isset($_POST['gallery-images']) && !empty($_POST['gallery-images'])) ? $_POST['gallery-images'] : '';
		$featured_img = $_POST['featured-img'];
		if(!empty($_POST['gallery-images'])) {
		$parent_ids = array_filter(explode(',', $_POST['gallery-images']));
			foreach($parent_ids as $parent_id) {
				wp_update_post(
					array(
						'ID' => $parent_id, 
						'post_parent' => $post_id
					)
				);
			}
		}
		$stringf = str_replace("'", '',  $_POST['featured-img']);
			$stringf2 = str_replace('\\', '', $stringf); 
		add_post_meta($post_id,'_gallery_images',$gallery_images);
		update_post_meta($post_id, '_thumbnail_id',$stringf2);
		
		wp_redirect( $permalink );
		
}

get_header();  ?>
	<div class="ad-title">
		<h2><?php the_title(); ?></h2>
	</div>
    <section class="ads-main-page">
    	<div class="container">
			<div class="row margin-top-100">
				<div class="col-md-9 col-sm-12 first ad-post-main">
					<div id="upload-ad" class="ad-detail-content">
						<h5>
							<?php esc_html_e('EDIT YOUR AD', 'classiads') ?>
						</h5>
						<div class="h3-seprator"></div>
						<form class="form-item row" action="" id="primaryPostForm" method="POST" enctype="multipart/form-data">
							<div class="col-sm-6 col-xs-12">
								<?php
									if ( is_array($new_ad_required_fields) && in_array("post-r-title", $new_ad_required_fields)) {
										$post_r_title =  'validate[required]';
									}
								?>
								<input type="hidden" id="postAuthor"  name="postAuthor" value="<?php echo $author; ?>" size="60" maxlength="255" class="form-control">
								
								<input type="text" id="postTitle" name="postTitle" placeholder="<?php esc_html_e('Ad Title Goes here |', 'classiads') ?>" value="<?php echo esc_attr( $title ); ?>" size="60" maxlength="255" class="<?php echo esc_attr($post_r_title); ?> form-control" >
								
							</div>
							
							<div class="col-sm-6 col-xs-12 form-s-select">
								<?php
									if ( is_array($new_ad_required_fields) && in_array("post-r-category", $new_ad_required_fields)) {
										$post_r_category =  'validate[required]';
									}
								?>
								<select data-noresult="No results match" id="catID" name="cat" class="<?php echo esc_attr($post_r_category); ?> form-select catID" data-prompt-target="idElem_chosen" >
									<option value=" " ><?php esc_html_e( 'Category...', 'classiads' ); ?></option>
									<?php
									$args = array(
										'hierarchical' => '0',
										'hide_empty' => '0'
									);
									$categories = get_categories($args);
										foreach ($categories as $cat) {
											if ($cat->category_parent == 0) { 
												$catID = $cat->cat_ID;
											?>
											<option <?php if( $category_parent == $catID ){ echo 'selected="selected"'; } ?> value="<?php echo esc_attr($catID); ?>"><?php echo esc_attr($cat->cat_name); ?></option>
										<?php 
											} 
										} ?>
								</select>	
							</div>
							<div class="col-sm-6 col-xs-12 form-s-select sub-category-box">
								<?php $currCatID = $category_id; 
									if(!empty($category_parent)){
								?>
								<select data-noresult="No results match" id="subcat" name="subcat" class="<?php echo esc_attr($post_r_category); ?> form-select subcatID" data-prompt-target="idElem_chosen" data-catid="<?php echo $category_id; ?>" >
									<option value=" " ><?php esc_html_e( 'Category...', 'classiads' ); ?></option>
									<?php
										$args2 = array(
											'hide_empty' => '0',
											'parent' => $category_parent,
											'depth' => 1
										);
										$categories = get_categories($args2);
										foreach ($categories as $cat) {
												$catID = $cat->cat_ID;
											?>
											<option <?php if( $category_id == $catID ){ echo 'selected="selected"'; } ?> value="<?php echo esc_attr($catID); ?>"><?php echo esc_attr($cat->cat_name); ?></option>
										<?php 
										} 
									?>
								</select>	
								<?php } ?>
							</div>
							<div class="extra-fields-container2">
								<?php echo classiads_get_sticky_group_on_front_end(true); ?>
							</div>
							<div class="extra-fields-container">
								<div class="extra_fields_category">
									<?php echo get_frontend_custom_fields($category_parent); ?>
								</div>
								<div class="extra_fields_category2">
									<?php  echo get_frontend_custom_fields($category_id); ?>
								</div>
							</div>
								<?php
								if($ai_info == 1){
								?>
								<div class="extra-fields-container edit-page-extra-field">
									<?php
									if(!empty($extrafields)) {
										for ($i = 1; $i <= count($extrafields); $i++) {
									?>
										<div class="col-sm-6 col-xs-12">
											<input value="<?php echo $extrafields[0][$i]; ?>" type="text" name="extraFields[0][<?php echo $i; ?>]" placeholder="Title"  size="12" class="form-control first-extra">
										</div>
										<div class="col-sm-6 col-xs-12">
											<input value="<?php echo $extrafields[1][$i]; ?>" type="text" name="extraFields[1][<?php echo $i; ?>]" placeholder="Value"  size="12" class="form-control extra-field">
										</div>
										<?php } ?>
									<?php } ?>
								</div>
							<?php } ?>
								<div class="col-sm-6 col-xs-12">
								<?php
								
								if ( is_array($new_ad_required_fields) && in_array("post-r-price", $new_ad_required_fields)) {
									$post_r_price =  'validate[required]';
								}
								$post_price = get_post_meta($current_post, 'post_price', true);									$n_post_price = str_replace('$','',$post_price);
								global $redux_demo;
								$free_listing_tag = $redux_demo['free_price_text'];
								$currency_setup = $redux_demo['currency-setup'];
								if($currency_setup == 'cs-new'){
									$sign_admin = $redux_demo['currency-sign'];
									$letters =  $sign_admin;
									$numbers = $n_post_price;
								}else{
									$numbers = preg_replace('/[^0-9]/', '', classiads_price($post_price));
									$letters = preg_replace('/[^a-zA-Z]/', '', classiads_price($post_price));
								}								
								?>
									<input type="text" id="post_price" value="<?php echo esc_attr( $numbers ); ?>" name="post_price" placeholder="<?php esc_html_e('Price', 'classiads') ?>"  size="30" class="form-control <?php echo esc_attr($post_r_price); ?>">
									<?php if ( !empty( $letters ) ){ ?>
										<p style="margin-top:10px;">
										<?php esc_html_e('Currency sign is already set as','classiads'); ?>											
										<?php echo esc_attr( $letters ); ?>			
										<?php esc_html_e('Please do not use currency sign in price field. Only use numbers ex: 2345.','classiads'); ?>
										</p>
									<?php } ?>
								</div>
								<div class="col-sm-6 col-xs-12 form-s-select">
									<?php
										if ( is_array($new_ad_required_fields) && in_array("post-r-location", $new_ad_required_fields)) {
											$post_r_location =  'validate[required]';
										}	
										$location_term = wp_get_post_terms($post_id, 'location');
										$i = 0 ;
										$location_d = '';
										foreach($location_term as $location_te){	
											if ($i >= 1) {			
												break;					
											}						
											$location_d = $location_te->term_id;
											$i++;									
										}
									?>	
									<select data-noresult="<?php esc_html_e('No results match','classiads'); ?>" id="post_location" name="post_location" class="<?php echo esc_attr($post_r_location); ?> form-select" data-prompt-target="idElem_chosen" data-location_id="<?php echo $location_term->term_id; ?>" >
										<option value=""><?php esc_html_e('Select Location', 'classiads'); ?></option>
										<?php
										$locations = get_terms(
											'location',
												array(
													'order'=> 'ASC',
													'hide_empty' => false,
												)
										);
										foreach ($locations as $location) { ?>
											<option <?php if( $location_d == $location->term_id ){ echo 'selected="selected"'; } ?>  value="<?php echo wp_kses_post($location->term_id); ?>">
											<?php echo wp_kses_post($location->name); ?>
											</option>
											<?php } ?>
									</select>
								</div>
								<div class="col-xs-12">
									<?php
										$post_id = get_the_ID();
										$post    = get_post( $post_id, OBJECT, 'edit' );
										$content = $post->post_content; // current content
										$settings = array(
											'wpautop' => true,
											'postContent' => 'content',
											'media_buttons' => false,
											'tinymce' => array(
												'theme_advanced_buttons1' => 'bold,italic,underline,blockquote,separator,strikethrough,bullist,numlist,justifyleft,justifycenter,justifyright,undo,redo,link,unlink,fullscreen',
												'theme_advanced_buttons2' => 'pastetext,pasteword,removeformat,|,charmap,|,outdent,indent,|,undo,redo',
												'theme_advanced_buttons3' => '',
												'theme_advanced_buttons4' => ''
											),
											'quicktags' => array(
												'buttons' => 'b,i,ul,ol,li,link,close'
											)
										);
										wp_editor( $content, 'postContent', $settings );
									?>
								</div>
								<div id="map-container">
									<?php if( $hide_map == 1 ){ ?>
										<div class="col-sm-6 col-xs-12">
											<?php
												if ( is_array($new_ad_required_fields) && in_array("post-r-address", $new_ad_required_fields)) {
													$post_r_address =  'validate[required]';
												}
											?>
											<input id="address" value="<?php echo esc_attr( $post_address ); ?>" name="address" type="textbox" placeholder="<?php esc_html_e('Address', 'classiads'); ?>"  class="form-control <?php echo esc_attr($post_r_address); ?>">
											<p class="help-block"><?php esc_html_e('Start typing an address  and select from the dropdown.', 'classiads'); ?></p>
										</div>
									<?php } ?>
									<div class="col-sm-6 col-xs-12">
										<?php
											if ( is_array($new_ad_required_fields) && in_array("post-r-tags", $new_ad_required_fields)) {
												$post_r_tags =  'validate[required]';
											}

											echo "<input type='text' id='post_tags' placeholder='".esc_html__('Tags', 'classiads')."' name='post_tags' value='";

											$posttags = get_the_tags($current_post);
											if ($posttags) {
											  foreach($posttags as $tag) {
												$tags_list = $tag->name . ', ';
												echo $tags_list;
											  }
											}
											echo "' size='12' maxlength='110' class='form-control ".esc_attr( $post_r_tags )."'>";
										 ?>
									</div>
									<?php if( $hide_map == 1 ){ ?>
									<div class="col-xs-12">
										<div class="map-inner-div">
											<div class="map-inner-row">
												<div class="row">
													<div class="col-md-6 col-sm-12">
														<input type="text" value="<?php echo esc_attr( $post_latitude ); ?>" id="latitude" name="latitude" placeholder="<?php esc_html_e('Latitude', 'classiads') ?>"  class="form-control">
													</div>
													<div class="col-md-6 col-sm-12">
														<input type="text" value="<?php echo esc_attr( $post_longitude ); ?>" id="longitude" name="longitude" placeholder="<?php esc_html_e('Longitude', 'classiads') ?>"  class="form-control">
													</div>
												</div>
											</div>
											<div id="map-canvas" data-latitude="<?php echo esc_attr( $post_latitude ); ?>" data-longitude="<?php echo esc_attr( $post_longitude ); ?>"></div>
										</div>
									</div>								
									<?php } 
										$drag = esc_html__('Drag & Drop IMAGE here','classiads');
										$or = esc_html__('or','classiads');
										$browse = esc_html__('Browse IMAGE','classiads');									
										$limitnum = 'null';
										if( !empty( $uploadlimit ) ){
											$limitnum = $uploadlimit;
										}
									?>					
								</div>
								<div class="col-xs-12">
								<?php require_once(TEMPLATEPATH . '/inc/BFI_Thumb.php'); ?>
								<?php
									$full_imgad = array();						
									$post_thumbnail_id = '';
									$featured_image = get_the_post_thumbnail_url( $post_id, 'full' );
									if( !empty( $featured_image ) ){														
										$post_thumbnail_id = get_post_thumbnail_id( $post_id );
										$attachment_title = get_the_title($post_thumbnail_id);
										$full_img_url = $featured_image;					
										$size = getimagesize($full_img_url);				
										$ext = strtolower(end(explode('.', $full_img_url)));
										$full_imgad[0]['name'] = $post_thumbnail_id;	
										$full_imgad[0]['type'] = 'image/'.$ext;		
										$full_imgad[0]['size'] = '';		
										$full_imgad[0]['file'] = $full_img_url;	
										$full_imgad[0]['url'] = $full_img_url;	
										$count = 1;						
									}else{							
										$count = 0;						
									}
									$attachments = get_children(array(	
										'post_parent' => $post_id,
										'post_status' => 'inherit',
										'post_type' => 'attachment',
										'post_mime_type' => 'image',
										'order' => 'ASC',
										'orderby' => 'menu_order ID'));						
										if( !empty( $attachments ) ){							
											foreach($attachments as $att_id => $attachment) {								
												$attachment_ID = $attachment->ID;
												$attachment_title = get_the_title($attachment_ID);
												$full_img_url = wp_get_attachment_url($attachment->ID);
												$size = getimagesize($full_img_url);
												$ext = strtolower(end(explode('.', $full_img_url)));														if( $attachment_ID != $post_thumbnail_id ){
													
													$full_imgad[$count]['name'] = "'".$attachment_ID."'";
													$full_imgad[$count]['type'] = 'image/'.$ext;
													$full_imgad[$count]['size'] = '';
													$full_imgad[$count]['file'] = esc_url($full_img_url);
													$full_imgad[$count]['url'] = esc_url($full_img_url);
													$count++;
												
												}
											}													
										}
								?>
									<div id="filediv" class="jfiler-holder" data-limit="<?php echo esc_attr($limitnum) ?>" data-drag="<?php echo esc_attr($drag); ?>" data-or="<?php echo esc_attr($or); ?>" data-browse="<?php echo esc_attr($browse); ?>" data-filerr="<?php echo htmlspecialchars(json_encode($full_imgad), ENT_QUOTES, 'UTF-8'); ?>">
										<input type="file" name="file[]" id="filer_input2" multiple="multiple">
										<input type="hidden" name="gallery-images" class="gallery-images" value="" />
									</div>
								</div>
								<div class="col-xs-12">
									<?php								
										if ( is_array($new_ad_required_fields) && in_array("post-r-video", $new_ad_required_fields)) {
											$post_r_video =  'validate[required]';
										}
									?>
									<fieldset class="input-title">
										<textarea name="video" placeholder="<?php esc_html_e('Put here iframe or video url.', 'classiads'); ?>" id="video" cols="8" rows="5" ><?php echo $post_video; ?></textarea>
										<p class="help-block"><?php esc_html_e('Add video embedding code or video URL here (youtube, vimeo, etc)', 'classiads'); ?></p>
									</fieldset>
								</div>
							<?php
							if( $featured_ads_user == 1 ){									
								if( $featured_post != 'on' ){	
								?>
									<div class="col-xs-12">
										<div class="checkbox">
											<input type="checkbox" id="featured_post" value="on" name="featured_post"/>
											<label for="featured_post">
												<?php esc_html_e('Mark as Featured','classiads'); ?>
											</label>
										</div>
									</div>
								<?php 									
								}else{ ?>							
									<div class="col-xs-12">								
										<div class="checkbox">									
											<input type="checkbox" id="featured_post" value="on" name="featured_post" checked disabled />			
											<label for="featured_post">			
												<?php esc_html_e('Featured','classiads'); ?>
											</label>								
										</div>							
									</div>							
								<?php 									
								} 								
							} 							
							?>
							<div class="col-xs-12">
								<div class="publish-ad-button">
									<?php wp_nonce_field('post_nonce', 'post_nonce_field'); ?>
									<button class="btn form-submit" id="edit-submit" name="submitted" value="Publish Ad" type="submit"><?php _e('Update Ad', 'classiads') ?></button>
								</div>
							</div>
						</form>
					</div>
				</div>
				<div class="col-md-3 col-sm-12 classi_sidebar" >
					<?php get_sidebar('pages'); ?>
				</div>
			</div>
	    </div>
    </section>
<?php get_footer(); ?>