<?php

/**
 * Template name: New Ad Page
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiads
 * @since classiads 1.2.2
 */

global $redux_demo;
$hide_map = $redux_demo['hide-map'];
$login = $redux_demo['login'];
$post_currency = $redux_demo['postcurrency'];
$defaultImage = $redux_demo['default-post-image'];
$rate_for_per_post = $redux_demo['rate-for-per-post'];
$rate_for_per_featured = $redux_demo['rate-for-per-featured'];
$uploadlimit = $redux_demo['image-limit'];
$free_listing_tag = $redux_demo['free_price_text'];	
$currency_setup = $redux_demo['currency-setup'];
$profile = $redux_demo['profile'];
$ai_info = $redux_demo['ai_info'];
$currency_setup = $redux_demo['currency-setup'];
$new_ad_required_fields = (isset($redux_demo['new-ad-required-fields'])) ? $redux_demo['new-ad-required-fields'] : '' ;
$featured_ads_user = $redux_demo['featured-ads_user'];
$current_user = wp_get_current_user();
$userID = $current_user->ID;
$uesrdata = get_userdata($userID);
$user_login = $uesrdata->user_login;
$user_email = $uesrdata->user_email;
$post_r_title = $post_r_category = $post_r_location = $post_r_address = $post_r_price = $post_r_tags = $post_r_video = $permalink = $postContent = $defaultImageURL = $defaultImageID = $defaultImageID = '';
$cl_cu_sub_array = classiads_check_user_for_ads_submission();
if ( !is_user_logged_in() ) {
	wp_redirect( $login ); exit;
}
if(!empty( $defaultImage )){
	$defaultImageURL = $redux_demo['default-post-image']['url'];
	$defaultImageID = $redux_demo['default-post-image']['id'];
}

if(isset($_POST['submitted']) && isset($_POST['post_nonce_field']) && wp_verify_nonce($_POST['post_nonce_field'], 'post_nonce')) {
			
		$postTitle = (isset($_POST['postTitle']) && !empty($_POST['postTitle'])) ? $_POST['postTitle'] : '';
		$postContent = (isset($_POST['postContent']) && !empty($_POST['postContent'])) ? $_POST['postContent'] : '';
		$cat = (isset($_POST['cat']) && !empty($_POST['cat'])) ? $_POST['cat'] : '';
		$subcat = (isset($_POST['subcat']) && !empty($_POST['subcat'])) ? $_POST['subcat'] : '';
		if(!empty($subcat)){
			$ad_category_id  = $subcat;
		}else{
			
			$ad_category_id  = $cat;
		}
		$post_tags = (isset($_POST['post_tags']) && !empty($_POST['post_tags'])) ? $_POST['post_tags'] : '';
		$post_location = (isset($_POST['post_location']) && !empty($_POST['post_location'])) ? $_POST['post_location'] : '';
		$extraFields = (isset($_POST['extraFields']) && !empty($_POST['extraFields'])) ? $_POST['extraFields'] : '';		
		$mark_feautred = (isset($_POST['featured_post']) && !empty($_POST['featured_post'])) ? $_POST['featured_post'] : '';
		$post_price_status = trim($_POST['post_price']);				
		$catID = $_POST['cat'].'custom_field';		
		$custom_fields = '';		
		if(isset($_POST[$catID])){			
			$custom_fields = $_POST[$catID];		
		}
		if($currency_setup == 'cs-new'){
			$currency = '';
		}elseif($currency_setup == 'cs-old'){
			$currency = $redux_demo['postcurrency'];
		}
		if(empty($post_price_status)) {
			$post_price_content = $free_listing_tag;			
		} else {
			$post_price_content = $currency.$post_price_status;
		}
		$post_price = (isset($post_price_content) && !empty($post_price_content)) ? $post_price_content : '';
		$post_latitude = (isset($_POST['latitude']) && !empty($_POST['latitude'])) ? $_POST['latitude'] : 0;
		$post_longitude = (isset($_POST['longitude']) && !empty($_POST['longitude'])) ? $_POST['longitude'] : 0;
		$post_address = (isset($_POST['address']) && !empty($_POST['address'])) ? $_POST['address'] : 0;
		$video = (isset($_POST['video']) && !empty($_POST['video'])) ? $_POST['video'] : '';
		
		$cl_cu_sub_array = classiads_check_user_for_ads_submission();
		$postStatus = $cl_cu_sub_array[0];
		$posttype = $cl_cu_sub_array[1];
		$featured = $cl_cu_sub_array[2];
	
		$post_information = array(
			'post_title' => esc_attr(strip_tags($postTitle)),
			'post_content' => wp_kses_post($postContent),
			'post-type' => 'post',
			'post_category' => array($ad_category_id),
			'tags_input'    => explode(',', $post_tags),
			'tax_input' => array(
				'location' => esc_attr($post_location),
			),
			'meta_input' => array(
				'extrafields' => esc_attr($extraFields),
				'post_price' => esc_attr($post_price),
				'post_latitude' => esc_attr($post_latitude),
				'post_longitude' => esc_attr($post_longitude),
				'post_address' => esc_attr($post_address),
				'post_video' => wp_kses_post($video),
				'custom_field' => $custom_fields,
				'post_location' => $post_location,
				'ad_posttype' => $posttype,
			),
			'comment_status' => 'open',
			'ping_status' => 'open',
			'post_status' => $postStatus
		);
		$post_id = wp_insert_post($post_information);	
		classiads_update_c_fields_category($post_id,$cat,$subcat);
		$ad_name = $postTitle;			
		$ad_link = get_permalink($post_id);			
		$username = $user_login;				
		$email_to = $user_email;	
		
		if( $posttype == 'single-paid' ){
			
			if($mark_feautred == true){
				
				update_post_meta($post_id,'ad_featured_option','true');
				$featured_ads = 1;
				$regular_ads = '';
				$ad_price = $rate_for_per_featured ;
				
			}else{
				
				$featured_ads = '';
				$regular_ads = 1;
				$ad_price = $rate_for_per_post ;
				
			}
			
			$title = esc_html__('Pay for ','classiads') .$postTitle. esc_html__(' Ad','classiads');
			$insert_invoice = array(
				'post_title' => $title,
				'post_status' => 'publish',
				'post_date' => date('Y-m-d H:i:s'),
				'post_author' => $userID,
				'post_type' => 'invoice',
				'meta_input' => array(
					'_invoice_status' => 'unpaid',
					'_invoice_status_2' => 'in-progress',
					'_invoice_plan_name' => $title,
					'_invoice_billing_type' => '',
					'_invoice_item_id' => $post_id,
					'_invoice_item_price' => $ad_price,
					'_invoice_purchase_date' => '',
					'_invoice_buyer_id' => $userID,
					'_invoice_buyer_name' => $user_login,
					'_invoice_member' => 'false',
					'_invoice_featured_ads' => $featured_ads,
					'_invoice_regular_ads' => $regular_ads,
					'_invoice_expire_date' => '',
					'_invoice_complete_date' => '',
				)
			);
			$invoice_id = wp_insert_post( $insert_invoice );
			update_post_meta($post_id, 'ad_invoice_id', $invoice_id);
			update_post_meta($post_id, 'ad_payment', 'processing');
			$permalink = get_permalink( $post_id ).'?invoice-created="true"';
								
				
			
			if( $postStatus == 'pending' || $postStatus == 'private' ){							
				if( function_exists('classiads_email_paid_pending_status') ){
					classiads_email_paid_pending_status($ad_name,$email_to,$username,$ad_name,$ad_link);	
				}					
			}else{	
				if( function_exists('classiads_email_paid_publish_status') ){
					classiads_email_paid_publish_status($ad_name,$email_to,$username,$ad_name,$ad_link);	
				}
			}	
			
		}elseif( $posttype == 'member' ){
			
			$invoice_id = get_user_meta($userID,'u_c_p_invoice_id',true);
			$featured_ads = get_user_meta($userID,'u_c_p_featured_ads',true);
			$regular_ads = get_user_meta($userID,'u_c_p_regular_ads',true);
			
			if($mark_feautred == true){
				if( !empty( $featured_ads ) ){
					$new_F_ads = $featured_ads - 1 ;
					update_user_meta($userID,'u_c_p_featured_ads',$new_F_ads);
					update_post_meta($post_id,'ad_featured_option','true');
				}
			}else{
				if ( !empty( $regular_ads ) ){
					$new_R_ads = $regular_ads - 1 ;
					update_user_meta($userID,'u_c_p_regular_ads',$new_R_ads);
				}
			}			
			update_post_meta($post_id, 'ad_invoice_id', $invoice_id);
			update_post_meta($post_id, 'ad_payment', 'paid');
			
			if( $postStatus == 'pending' || $postStatus == 'private' ){							
				if( function_exists('classiads_email_pending_status') ){
					classiads_email_pending_status($ad_name,$email_to,$username,$ad_name,$ad_link);	
				}					
			}
			
			$permalink = get_permalink( $post_id );		
			
		}elseif( $posttype == 'free' ){
									
			if( $postStatus == 'pending' || $postStatus == 'private' ){							
				if( function_exists('classiads_email_pending_status') ){
					classiads_email_pending_status($ad_name,$email_to,$username,$ad_name,$ad_link);	
				}					
			}
			update_post_meta($post_id, 'ad_payment', 'free');
			$permalink = get_permalink( $post_id );					
		}
		
		if (isset($_POST['jfiler-items-exclude-file'])) {
			$string = str_replace('"', '', $_POST['jfiler-items-exclude-file']);
			$string2 = str_replace("'", '', $string); 
			$string3 = str_replace('\\', '', $string2); 
			$string4 = str_replace('[', '', $string3);
			$string5 = str_replace(']', '', $string4);
			
			$values = $string5[0];
			
			$att_ids = explode(',', $values);
			foreach($att_ids as $key=>$att_id){
					wp_delete_attachment($att_id);
					
				}
		}
		//if(isset($_POST['featuredimage'])){
			//update_post_meta($post_id, 'fet_img', $_POST['featuredimage']);
		//}
		$gallery_images = (isset($_POST['gallery-images']) && !empty($_POST['gallery-images'])) ? $_POST['gallery-images'] : '';
		$featured_img = $_POST['featured-img'];
		if(!empty($_POST['gallery-images'])) {
		$parent_ids = array_filter(explode(',', $_POST['gallery-images']));
			foreach($parent_ids as $parent_id) {
				wp_update_post(
					array(
						'ID' => $parent_id, 
						'post_parent' => $post_id
					)
				);
			}
		}
		$stringf = str_replace("'", '',  $_POST['featured-img']);
			$stringf2 = str_replace('\\', '', $stringf); 
		add_post_meta($post_id,'_gallery_images',$gallery_images);
		update_post_meta($post_id, '_thumbnail_id',$stringf2);
		
		wp_redirect( $permalink ); exit;
}

get_header(); 		
	while ( have_posts() ) : the_post();	
	$page = get_page($post->ID);
	$page_link = get_page_link($post->ID);
	$current_page_id = $page->ID;
	$page_slider = get_post_meta($current_page_id, 'page_slider', true); 
	$page_layout = classiads_page_meta_value('_page_layout'); 
	$page_title = classiads_page_meta_value('_page_title'); 

	if($page_layout == 'full_width'){
		$layout = 'col-md-12 col-sm-12 col-xs-12';
		$sidebar = '';
	}elseif($page_layout == 'left-sidebar'){
		$layout = 'col-md-9 col-sm-12 col-xs-12 pull-right';
		$sidebar = 'pull-left';
	}else{
		$layout = 'col-md-9 col-sm-12 col-xs-12';
		$sidebar = '';
	}
		if($page_title != '1'):
			classiads_breadcrumbs_with_title();
		endif;	
		
	?>
    <section class="ads-main-page">		
    	<div class="container padding-top-60">
			<div class="row">
				<div class="<?php echo esc_attr($layout); ?> first ad-post-main">
					<div class="account-overview clearfix">
						<div class="col-sm-4 first author-avatar-edit-post p-30">
							<?php 
							
								global $user_ID;
								$user_avatar = cs_get_user_avatar(0, $user_ID);	
								//$cl_cu_sub_array = classiads_check_user_for_ads_submission();
								//print_r($cl_cu_sub_array);
								
								
							?>
							<img class="author-avatar" src="<?php echo esc_url($user_avatar); ?>" alt="" />
							<div class="author-btn">
								<span class="author-profile-ad-details">
									<a href="<?php echo $profile; ?>" class="button-ag large green">
										<?php esc_html_e("Your Profile", 'classiads'); ?> 
									</a>
								</span>
							</div>
							
						</div>
						<div class="col-sm-8 b-l-1 p-30">
							<?php classiads_user_profile_status($userID); ?>
						</div>
					</div>
					<div id="upload-ad" class="ad-detail-content">
						<form class="form-item row" action="" id="primaryPostForm" method="POST" enctype="multipart/form-data">
							<div class="col-xs-12">
								<h5><?php esc_html_e('MAKE NEW AD', 'classiads') ?></h5>
								<div class="h3-seprator"></div>
							</div>	
							<div class="col-sm-6 col-xs-12">
								<?php
									if ( is_array($new_ad_required_fields) && in_array("post-r-title", $new_ad_required_fields)) {
										$post_r_title =  'validate[required]';
									}
								?>
								<input type="text" id="postTitle" name="postTitle" placeholder="<?php esc_html_e('Ad Title Goes here |', 'classiads') ?>" size="60" maxlength="255" class="<?php echo esc_attr($post_r_title); ?> form-control" >
							</div>
							<div class="col-sm-6 col-xs-12 form-s-select">
								<?php
									if ( is_array($new_ad_required_fields) && in_array("post-r-category", $new_ad_required_fields)) {
										$post_r_category =  'validate[required]';
									}
								?>
								<select data-noresult="No results match" id="catID" name="cat" class="<?php echo esc_attr($post_r_category); ?> form-select catID" data-prompt-target="idElem_chosen" >
									<option value=" " >
										<?php esc_html_e( 'Category...', 'classiads' ); ?>
									</option>
									<?php
									$args = array(
										'hierarchical' => '0',
										'hide_empty' => '0'
									);
									$categories = get_categories($args);
										foreach ($categories as $cat) {
											if ($cat->category_parent == 0) { 
												$catID = $cat->cat_ID;
											?>
											<option value="<?php echo esc_attr($catID); ?>"><?php echo esc_attr($cat->cat_name); ?></option>
										<?php } else {}
										} ?>
								</select>	
							</div>
							<div class="col-sm-12 col-xs-12">
								<div class="row">
									<div class="col-sm-6 col-xs-12 form-s-select sub-category-box">
									</div>
								</div>
							</div>
							<?php if($ai_info == 1){ ?>
								<div class="col-xs-12">
									<div id="add-btn">
										<?php esc_html_e('ADD CONTENT', 'classiads') ?>
									</div>
								</div>
							<?php } ?>
							<div class="extra-fields-container2">
								<?php echo classiads_get_sticky_group_on_front_end(); ?>
							</div>
							<div class="extra-fields-container">
								<div class="extra_fields_category">
								</div>
								<div class="extra_fields_category2">
								</div>
							</div>
							<div class="col-sm-6 col-xs-12">
								<?php
								if ( is_array($new_ad_required_fields) && in_array("post-r-price", $new_ad_required_fields)) {
									$post_r_price =  'validate[required]';
								}
								if($currency_setup == 'cs-new'){ ?>
								<input type="number" id="post_price" name="post_price" placeholder="<?php esc_html_e('Price', 'classiads') ?>"  size="30" class="form-control <?php echo esc_attr($post_r_price); ?>">
								<?php }elseif($currency_setup == 'cs-old'){ ?>
								<input type="text" id="post_price" name="post_price" placeholder="<?php esc_html_e('Price', 'classiads') ?>"  size="30" class="form-control <?php echo esc_attr($post_r_price); ?>">
								<?php } ?>
								<?php
								if($currency_setup == 'cs-new'){
									if(($redux_demo['sign-code'] == 'sign' ) ) {
										$sign_admin = $redux_demo['currency-sign'];
										$sign =  $sign_admin;
									}elseif(($redux_demo['sign-code'] == 'code' ) ) {
										$sign = $redux_demo['currency-code'];
									}
								}elseif($currency_setup == 'cs-old'){
									$sign = $redux_demo['postcurrency'];
								}		
									if (!empty( $sign )){
								?>									
								<p style="margin-top:10px;">
									<?php esc_html_e('Currency sign is already set as ','classiads')?>"<?php echo esc_attr($sign) ?>".<?php esc_html_e('Please do not use currency sign in price field. Only use numbers ex: 2345.', 'classiads'); ?>
								</p>
								<?php }elseif( !empty( $free_listing_tag ) ){
								?>									
									<p style="margin-top:10px;">
										<?php esc_html_e('If you will leave empty price field then your price tag will be ','classiads'); ?><?php echo esc_attr($free_listing_tag); ?>.
									</p>
								<?php } ?>
							</div>
							<div class="col-sm-6 col-xs-12 form-s-select">
								<?php
									if ( is_array($new_ad_required_fields) && in_array("post-r-location", $new_ad_required_fields)) {
										$post_r_location =  'validate[required]';
									}
								?>
								<select data-noresult="No results match" id="post_location" name="post_location" class="<?php echo esc_attr($post_r_location); ?> form-select" data-prompt-target="idElem_chosen" >
									<option value=" " ><?php esc_html_e( 'Select a Location', 'classiads' ); ?></option>
									<?php
										$locations = get_terms(
											'location', 
											array(
											'order'=> 'ASC',
											'hide_empty' => false, 
											)	
										);
										foreach ($locations as $location) {
											echo '<option value="'.esc_attr($location->term_id).'">'.esc_attr($location->name).'</option>';
										} 
									?>
								</select>	
							</div>
							<div class="col-xs-12">
								<?php
									$settings = array(
										'wpautop' => true,
										'postContent' => 'content',
										'media_buttons' => false,
										'tinymce' => array(
											'theme_advanced_buttons1' => 'bold,italic,underline,blockquote,separator,strikethrough,bullist,numlist,justifyleft,justifycenter,justifyright,undo,redo,link,unlink,fullscreen',
											'theme_advanced_buttons2' => 'pastetext,pasteword,removeformat,|,charmap,|,outdent,indent,|,undo,redo',
											'theme_advanced_buttons3' => '',
											'theme_advanced_buttons4' => ''
										),
										'quicktags' => array(
											'buttons' => 'b,i,ul,ol,li,link,close'
										)
									);
									wp_editor( $postContent, 'postContent', $settings );
								?>
							</div>
							<div id="map-container">
								<?php if( $hide_map == 1 ){ ?>
									<div class="col-sm-6 col-xs-12">
										<?php
											if ( is_array($new_ad_required_fields) && in_array("post-r-address", $new_ad_required_fields)) {
												$post_r_address =  'validate[required]';
											}
										?>
										<input id="address" name="address" type="textbox" placeholder="<?php esc_html_e('Address', 'classiads'); ?>"  class="form-control <?php echo esc_attr($post_r_address); ?>">
										<p class="help-block"><?php esc_html_e('Start typing an address  and select from the dropdown.', 'classiads'); ?></p>
									</div>
								<?php } ?>
								<div class="col-sm-6 col-xs-12">
									<?php
										if ( is_array($new_ad_required_fields) && in_array("post-r-tags", $new_ad_required_fields)) {
											$post_r_tags =  'validate[required]';
										}
									?>
									<input type="text" id="post_tags" name="post_tags" placeholder="<?php esc_html_e('Tags', 'classiads'); ?>"  size="12" maxlength="110" class="form-control <?php echo esc_attr($post_r_tags); ?>">
								</div>
								<?php if( $hide_map == 1 ){ ?>
								<div class="col-xs-12">
									<div class="map-inner-div">
										<div class="map-inner-row">
											<div class="row">
												<div class="col-md-6 col-sm-12">
													<input type="text" id="latitude" name="latitude" placeholder="<?php esc_html_e('Latitude', 'classiads') ?>"  class="form-control">
												</div>
												<div class="col-md-6 col-sm-12">
													<input type="text" id="longitude" name="longitude" placeholder="<?php esc_html_e('Longitude', 'classiads') ?>"  class="form-control">
												</div>
											</div>
										</div>
										<div id="map-canvas"></div>
									</div>
								</div>								
								<?php } 
									$drag = esc_html__('Drag & Drop IMAGE here','classiads');
									$or = esc_html__('or','classiads');
									$browse = esc_html__('Browse IMAGE','classiads');									
									$limitnum = 'null';
									if( !empty( $uploadlimit ) ){
										$limitnum = $uploadlimit;
									}
								?>					
							</div>
							<div class="col-xs-12">
								<div class="jfiler-holder" data-limit="<?php echo esc_attr($limitnum) ?>" data-drag="<?php echo esc_attr($drag); ?>" data-or="<?php echo esc_attr($or); ?>" data-browse="<?php echo esc_attr($browse); ?>">
									<input type="file" name="file[]" id="filer_input2" multiple="multiple">
									<input type="hidden" name="gallery-images" class="gallery-images" value="" />
								</div>
							</div>
							<div class="col-xs-12">
								<?php								
									if ( is_array($new_ad_required_fields) && in_array("post-r-video", $new_ad_required_fields)) {
										$post_r_video =  'validate[required]';
									}
								?>
								<fieldset class="input-title">
									<textarea name="video" id="video" cols="8" rows="5" placeholder="<?php esc_html_e('Put here iframe or video url.', 'classiads') ?>" class="<?php echo esc_attr($post_r_video); ?>" ></textarea>
									<p class="help-block"><?php esc_html_e('Add video embedding code or video URL here (youtube, vimeo, etc)', 'classiads'); ?></p>
								</fieldset>
							</div>
							<?php
							if( $featured_ads_user == 1 ){	
							?>
							<div class="col-xs-12">
								<div class="checkbox">
									<input type="checkbox" id="featured_post" value="on" name="featured_post"/>
									<label for="featured_post">
										<?php esc_html_e('Mark as Featured','classiads'); ?>
									</label>
								</div>
							</div>
							<?php } ?>
							<div class="col-xs-12">
								<div class="publish-ad-button">
									<?php wp_nonce_field('post_nonce', 'post_nonce_field'); ?>
									<input type="hidden" name="submitted" id="submitted" class="submit" value="true" />
									<button class="btn form-submit full-btn" id="edit-submit" name="op" value="<?php esc_html_e('Publish Ad', 'classiads'); ?>" type="submit"><?php esc_html_e('Publish Ad', 'classiads'); ?></button>
								</div>
							</div>
						</form>
					</div>
				</div>
				<?php if($page_layout != 'full_width'){ ?>
					<div class="col-md-3 col-sm-12 col-xs-12 classi_sidebar <?php echo esc_attr($sidebar) ?>" >
						<?php get_sidebar('pages'); ?>
					</div>
				<?php } ?>
			</div>
	    </div>
    </section>
    <?php endwhile; ?>
<?php get_footer(); ?>
