<?php
/**
 * The Template for displaying all single posts.
 *
 * @package WordPress
 * @subpackage classiads
 * @since classiads 1.2.2
 */
get_header(); ?>
	
	<?php while ( have_posts() ) : the_post(); ?>


<?php 

global $redux_demo,$current_user,$user_ID,$category_icon,$your_image_url,$category_icon_color; 
$hide_map = $redux_demo['hide-map'];

$current_user = wp_get_current_user(); 
$user_ID == $current_user->ID;

$contact_email = get_the_author_meta('user_email');
$edit_post_page_id = $redux_demo['edit_post'];
$hrSlider = $redux_demo['hr-slide-style']; 
$featured_ads_option = $redux_demo['featured-options-on'];
$ad_expiry = (isset($redux_demo['ad_expiry']) && !empty($redux_demo['ad_expiry'])) ? $redux_demo['ad_expiry'] : '';
$get_review_count = get_review_count($post->ID);
$get_comment_count = get_ads_comment_count($post->ID);
$category = get_the_category();
$location = get_the_term_list( $post->ID, 'location'); 

$post_price = get_post_meta($post->ID, 'post_price', true);
$post_video = get_post_meta($post->ID, 'post_video', true);
$wpcrown_custom_fields = get_post_meta($post->ID, 'custom_field', true);
		
?>
	<section class="ads-main-page">
		<div class="ad-title">
			<div class="container">
				<div class="row">
					<div class="col-xs-12">
						<?php echo classiads_breadcrumbs(); ?>
						<h2>
						<?php
							if ($post->post_author == $current_user->ID && get_post_status ( $post->ID ) == 'publish')  { ?>

							<?php 
								$postID = $post->ID;

								global $wp_rewrite;
								if ($wp_rewrite->permalink_structure == '')
								//we are using ?page_id
									$edit_post = $edit_post_page_id."&post=".$postID;
								else
								//we are using permalinks
									$edit_post = $edit_post_page_id."?post=".$postID;

								?>

							
								<a href="<?php echo esc_url($edit_post); ?>">
									<?php esc_html_e( 'Edit', 'classiads' ); ?>
								</a>
							
							<?php }elseif( current_user_can('administrator') )  { ?>

							<?php 
								$postID = $post->ID;

								global $wp_rewrite;
								if ($wp_rewrite->permalink_structure == '')
								//we are using ?page_id
									$edit_post = $edit_post_page_id."&post=".$postID;
								else
								//we are using permalinks
									$edit_post = $edit_post_page_id."?post=".$postID;

								?>
								<a href="<?php echo esc_url($edit_post); ?>">
									<?php esc_html_e( 'Edit', 'classiads' ); ?>
								</a>
							
							<?php } ?> 
							<?php the_title(); ?>
							<span class="ad-page-price">
								<?php				
									if ($category) {
										echo '<a href="' . get_category_link( $category[0]->term_id ) . '" title="' . sprintf( __( "View all posts in %s", "classiads" ), $category[0]->name ) . '" ' . '>' . $category[0]->name.'</a> ';
									}
								?>
							</span>
						</h2>
					</div>
				</div>
			</div>
		</div>
		
		<div class="container">
			<div class="row">
				<div class="col-md-12 col-sm-12 col-xs-12">
					<?php
					if ( get_post_status ( $post->ID ) == 'private' ) {
						$ReleasNote = __( 'Congratulation! Your Ad has submitted and pending for review. After review your Ad will be live for all users. You may not preview it more than once.', 'classiads' );
						echo '<div class="box-notification"><div class="box-notification-content">'.esc_attr($ReleasNote).'</div></div>';
					}
					?>
				</div>
			</div>
		</div>
		<div class="container">
			<div class="row padding-top-50">
				<div class="col-md-9 col-sm-9 col-xs-12" >
				
					<?php get_template_part('templates/single/single','slider'); ?>
					
					<?php if( !empty( $post_video ) ) { ?>
					<div id="ab-video-text">
						<span>
							<i class="fa fa-youtube-play"></i>
							<?php esc_html_e( 'Video', 'classiads' ); ?>
						</span>
					</div>
					<div id="ab-video">
						<?php
							if(wp_oembed_get( $post_video )){
								echo wp_oembed_get($post_video);
							}else{
								echo wp_kses_post($post_video);
							}
						?>
					</div>
					<?php } ?>
					
					<div class="post-detail">
						<div class="detail-cat clearfix">
							<?php
								$category = get_the_category();
								$tag = $category[0]->cat_ID;
								
									$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
									//print_r($tag_extra_fields);
									if (isset($tag_extra_fields[$tag])) {
										if (!empty($tag_extra_fields[$tag]['category_icon_code'])){
										$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
										}
										if (!empty($tag_extra_fields[$tag]['category_icon_color'])){
										$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
										}
										if (!empty($tag_extra_fields[$tag]['your_image_url'])){
										$your_image_url = $tag_extra_fields[$tag]['your_image_url'];
										}
									}

								if (empty($category_icon_code) || empty($category_icon_color) || empty($your_image_url)) {

									$tag = $category[0]->category_parent;

									$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
									if (isset($tag_extra_fields[$tag])) {
										if (empty($category_icon_code)){
											$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
										}
										if (empty($category_icon_color)){
											$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
										}
										if (empty($your_image_url)){
											$your_image_url = $tag_extra_fields[$tag]['your_image_url'];
										}
									}

								}
							?>
							<?php if(!empty($category_icon_code)) { ?>
								<div class="category-icon">
									<div class="category-icon-box">
										<?php 
											$category_icon = stripslashes($category_icon_code); 
											echo wp_kses_post($category_icon);
										?>
									</div>
								</div>
							<?php } ?>
							<?php 
								if ($category) {
									echo '<a href="' . get_category_link( $category[0]->term_id ) . '" title="' . sprintf( __( "View all posts in %s", "classiads" ), $category[0]->name ) . '" ' . '>' . $category[0]->name.'</a> ';
								}
							?>
						</div>	
					
						<table class="ad-detail-half-box first-half">
							<tr>
								<td>
									<?php
									
										$selected_cat = $category[0]->cat_ID;
										$main_cat = $category[0]->category_parent;
										echo classiads_get_c_fields_values_category($post->ID,$main_cat,$selected_cat); 
										
									?>
									<div class="ad-detail-info">
										<div class="custom-label">
											<?php esc_html_e( 'Date', 'classiads' ); ?>
										</div>
										<div class="ad-detail">
											<?php the_time('M j, Y') ?>
										</div>
									</div>
									<?php 
										if(!empty($location)){
											?>

											<div class="ad-detail-info">
												<div class="custom-label">
													<?php esc_html_e( 'Place', 'classiads' ); ?>
												</div>
												<div class="ad-detail">
													<?php
														echo $location;				
													 ?>
												</div>
											</div>
									
										<?php } ?>							

									<div class="ad-detail-info">
										<div class="custom-label">
											<?php esc_html_e( 'Total Views', 'classiads' ); ?>
										</div>
										<div class="ad-detail">
											<?php echo wpb_get_post_views(get_the_ID()); ?>
										</div>
									</div>


									<?php if(function_exists('the_ratings')) { ?>

										<div class="ad-detail-info">
											<div class="custom-label">
												<?php esc_html_e( 'Ratings', 'classiads' ); ?>
											</div>
											<div class="ad-detail">
												<?php 
				
													classiads_avaerage_rating_stars($post->ID);
				
												?>
											</div>
										</div>

									<?php } ?>
									
								</td>
							</tr>
						</table>
						<div class="single-description">
							<div class="description-title">
								<?php esc_html_e( 'DESCRIPTION', 'classiads' ); ?>
							</div>
							<?php echo the_content(); ?>
						</div>
						<div class="tags-share">
							<div class="ads-tags">

								<i class="fa fa-tags"></i><span class="tag-title"><a><?php esc_html_e('Tags', 'classiads'); ?>:</a></span><span><?php the_tags('','',''); ?></span>
							</div>
							<div class="single-share">
								<div class="share-icons">
									<a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" onclick="return !window.open(this.href, 'Facebook', 'width=500,height=500')"  class="fb"><i class="fa fa-facebook"></i></a>
									<a href="https://twitter.com/home?status=<?php the_permalink(); ?>" onclick="return !window.open(this.href, 'Twitter', 'width=500,height=500')"  class="tw"><i class="fa fa-twitter"></i></a>
									<a href="https://plus.google.com/share?url=<?php the_permalink(); ?>" onclick="return !window.open(this.href, 'Google', 'width=500,height=500')"  class="goo"><i class="fa fa-google"></i></a>
									<a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php the_title(); ?>&summary=&source=<?php the_permalink(); ?>" onclick="return !window.open(this.href, 'Linkedin', 'width=500,height=500')"  class="lin"><i class="fa fa-linkedin"></i></a>
									<a href="https://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=&description=" onclick="return !window.open(this.href, 'Pinterest', 'width=500,height=500')"  class="pin"><i class="fa fa-pinterest"></i></a>
									<a href="mailto:<?php echo bloginfo('admin_email'); ?>?&subject=<?php the_title(); ?>&body="  class="eml"><i class="fa fa-envelope-o"></i></a>
								</div>
							</div>
						</div>	
						<div class="clearfix"></div>
					</div>
					
					<div class="features-box">
						<div class="features-box-title">
							<h3><?php esc_html_e('FEATURES','classiads') ?></h3>
						</div>
						<div class="features-box-description">
							<ul id="mylist">
								<?php 
								$wpcrown_custom_fields = get_post_meta($post->ID, 'custom_field', true);
								if(!empty($wpcrown_custom_fields)) {
									for ($i = 0; $i < count($wpcrown_custom_fields); $i++) {
										if($wpcrown_custom_fields[$i][2] == 'checkbox'){
											?>
											<?php if(!empty($wpcrown_custom_fields[$i][1]) && !empty($wpcrown_custom_fields[$i][0]) ) { ?>
												<li>
													<span class="span-check">
														<span class="span-check-inner">
														</span>
													</span>
													<span class="">
														<?php echo $wpcrown_custom_fields[$i][0]; ?>
													</span>
												</li>
											<?php }  ?>
										<?php } ?>
									<?php } ?>
								<?php } ?>
							</ul>
						</div>
					</div>
					
					<?php 
					
						$extrafields = get_post_meta($post->ID, 'extrafields', true);
						if(!empty($extrafields)) {
					?>
						
					<div class="additional-box">
					
						<?php for ($i = 1; $i <= count($extrafields); $i++) { ?>
						<div class="additional-box-title">
							<h3><?php esc_html_e('ADDITIONAL INFORMATION','classiads'); ?></h3>
						</div>
						<?php } ?>
						
						<table class="ad-detail-half-box first-half">
							<tr>
								<td class="ai-con">
							<?php 
							
								for ($i = 1; $i <= count($extrafields); $i++) { ?>
									<?php if(!empty($extrafields[0][$i]) && !empty($extrafields[1][$i])){ ?>
									<div class="ad-detail-info">
										<div class="custom-label">
											<?php echo $extrafields[0][$i] ?>
										</div>
										<div class="ad-detail">
											<?php echo $extrafields[1][$i] ?>
										</div>
									</div>
									<?php } ?>
								<?php } ?>
								
								</td>
							</tr>
						</table>
					</div>
					
					<?php } ?>
					
					<?php 	
						if($hide_map == 1){
							get_template_part('templates/single/single','map');
						} 
					?>
					<div class="clearfix"></div>
					<?php get_template_part('templates/single/single','authorbox'); ?>
					<div class="ad-detail-content">	    			
						<?php wp_link_pages(); ?>
					</div>
					<div class="clearfix"></div>	
					<?php get_template_part('templates/single/single','tabs'); ?>
				</div>

				<div class="col-md-3 col-sm-3 col-xs-12 classi_sidebar">
					<?php  
						$orig_post = $post;  
						global $post;  
						$tags = wp_get_post_tags($post->ID);  
												  
						if ($tags) {  
							
							$tag_ids = array();  
							foreach($tags as $individual_tag) 
							$tag_ids[] = $individual_tag->term_id; 
								
							$args=array(  
								'tag__in' => $tag_ids,  
								'post__not_in' => array($post->ID),  
								'posts_per_page'=>3, // Number of related posts to display.  
								'ignore_sticky_posts'=>1  
							);  

						$current = -1;
							  
						$my_query = new wp_query( $args );
						if($my_query->have_posts()){ 
					?>
					<div class="related-abs">
						<div class= "" >
							<ul class="clearfix singleslide2 slick-carousel" data-items="1" data-items-tab-ls="1" data-items-tab="1" data-autoplay="true" data-autoplay-speed="1500"  data-loop="true"  data-dots="true">
							
							<?php  
								while( $my_query->have_posts() ) { 

										$my_query->the_post();  
										global $postID;

										$current++;
										
										$category = get_the_category();
										
										$tag = get_cat_ID( $category[0]->name );
										$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
										if (isset($tag_extra_fields[$tag])) {
											$category_icon_code = $tag_extra_fields[$tag]['category_icon_code']; 
											$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
										}
									
									?> 
									<li class="ad-box">
										<a href="<?php the_permalink(); ?>">
											<?php 

											$thumb_id = get_post_thumbnail_id();
											$thumb_url = wp_get_attachment_image_src($thumb_id,'thumbnail-size', true);

											$params = array( 'width' => 255, 'height' => 218, 'crop' => true );
											echo "<img src='" . bfi_thumb( "$thumb_url[0]", $params ) . "'/>";

											?>
										</a>
										<?php
										$post_price = get_post_meta($post->ID, 'post_price', true);
										if(!empty($post_price)){								
										?>
										<div class="add-price"><span><?php echo classiads_price(esc_attr($post_price, 'classiads'));  ?></span></div> 
										<?php } ?>
									</li>
						<?php 	}  ?>
							</ul>	
						</div>
					</div>
					<?php 
							}
						}  
						$post = $orig_post;  
						wp_reset_query();  
					?>
					
					<?php get_sidebar('pages'); ?>

				</div>
			</div>
	    </div>
    </section>
    <?php endwhile; ?>
	
	<?php if($featured_ads_option == 1) { ?>
	
		<?php if($hrSlider == 1) { ?>

		<?php get_template_part('templates/hr-slider1'); ?>

		<?php }elseif($hrSlider == 2){
			get_template_part('templates/hr-slider2');			
		}elseif($hrSlider == 3){
			get_template_part('templates/hr-slider3');			
		} ?> 
		
    <?php } ?>

<?php get_footer(); ?>