<?php
/**
 * The Template for displaying all single posts.
 *
 * @package WordPress
 * @subpackage classiads
 * @since classiads 1.2.2
 */
get_header(); ?>

	<section class="ads-main-page">
	   
		<?php
			// Start the Loop.
			while ( have_posts() ) : the_post();
		?>
		<div class="ad-title">
			<?php $current_user = wp_get_current_user(); ?>
			<h2>
				<?php the_title(); ?>
				<span class="ad-page-price">
					<?php $category = get_the_terms( $id, 'blog-category' );
						if ($category) {
							echo '<a href="' . get_term_link( $category[0]->term_id, 'blog-category' ) . '" title="' . sprintf( __( "View all posts in %s", "classiads" ), $category[0]->name ) . '" ' . '>' . $category[0]->name.'</a> ';
						}
					?>
				</span>
			</h2>
		</div>

    	<div class="container">
			<div class="row">

				<div class="col-md-9 col-sm-12 col-xs-12">
					<div class="row margin-top-60">

				   <?php     // Include the page content template.
							get_template_part( 'templates/blog/blog-loop' );

			 
				?>
						<div class="col-md-12 col-sm-12 col-xs-12">
							<div class="author-info blog-author-info clearfix">
								<div class="author-avatar">	
							<?php 
								$user_ID = get_the_author_meta( 'ID' );
								$user_avatar = cs_get_user_avatar(0, $user_ID);
							?>
								<img class="" src="<?php echo esc_url($user_avatar); ?>" alt="" />								
								</div>
								<div class="author-detail-right clearfix">
									<div class="author-title">
										<h3><?php the_author_meta( 'display_name', $user_ID ); ?> </h3>
									</div>
									<div class="author-description">
										<p>
											 <?php the_author_meta( 'description', $user_ID ); ?>
										</p>
									</div>
								</div>
							</div>	
							<?php

									 $prev_post = get_adjacent_post(false, '', true);
									 $next_post = get_adjacent_post(false, '', false);
								 if(!empty($prev_post) || $next_post ) {
								?>
							<div class="post-nav">
								<div class="prev-nav">
									 <?php 
										if(!empty($prev_post)) {
										echo '<a href="' . get_permalink($prev_post->ID) . '" title="' . $prev_post->post_title . '" class="blog-btn"> <i class="fa fa-angle-double-left"></i><span>'.__('Prev Post','classiads').'</span></a>'; }
									 ?> 
								</div>
								<div class="next-nav">
									<?php
										if(!empty($next_post)) {
										echo '<a href="' . get_permalink($next_post->ID) . '" title="' . $next_post->post_title . '" class="blog-btn"><span>'.__('Next Post','classiads').'</span><i class="fa fa-angle-double-right"></i></a>'; }
									?>
								</div>
							</div>
								 <?php } ?>
							
							<div class="related-post-container">
								<?php
									//Get array of terms
									$terms = get_the_terms( $post->ID , 'blog-category', 'string');
									$term_ids[] = '';
									if(!empty($terms)){
										$term_ids = wp_list_pluck($terms,'term_id');
									}									
									//Query posts with tax_query. Choose in 'IN' if want to query posts with any of the terms
									//Chose 'AND' if you want to query for posts with all terms
									$second_query = new WP_Query( array(
									  'post_type' => 'blog',
									  'tax_query' => array(
											array(
												'taxonomy' => 'blog-category',
												'field' => 'id',
												'terms' => $term_ids,
												'operator'=> 'IN' //Or 'AND' or 'NOT IN'
											 )										),
									  'posts_per_page' => 3,
									  'ignore_sticky_posts' => 1,
									  'orderby' => 'rand',
									  'post__not_in'=>array($post->ID)
									) );
									//Loop through posts and display...
										if($second_query->have_posts()) { ?>
											<div class="related-post-container">
												<div class="row">
													<?php while ($second_query->have_posts() ) : $second_query->the_post(); ?>
														 <div class="col-md-4 col-sm-6 col-xs-12">
															<div class="related-post">
																<div class="related-post-thumb">
																	<?php the_post_thumbnail(); ?>
																</div>
																<div class="related-post-des">
																	<div class="related-post-title">
																		<h3> <a href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h3>
																	</div>
																	<div class="blog-stat">
																		<ul>
																			<li>
																				<span><?php _e( 'Posted By', 'classiads' ); ?> -</span>
																				<span><?php the_author(); ?></span>
																			</li>
																		</ul>
																	</div>
																</div>
															</div>
														</div>
												   <?php endwhile; wp_reset_query(); ?>
												</div>
											</div>
									   <?php } ?>
								<div class="comments-box-container">
									<div id="ad-comments">
										<?php 
										$file ='';
										$separate_comments ='';
										?>
										<?php //comments_template( $file, $separate_comments ); ?>
										<?php comments_template( '', true ); ?>
										<?php  //if (is_single ()) comments_template (); ?>
									</div>	
								</div>
								<div class="ad-detail-content">	    			
									<?php wp_link_pages(); ?>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-md-3 col-sm-12 col-xs-12 sidebar blog-sidebar margin-top-60">
					<div class="sidebar-auther">
						<?php 
							$user_ID = 1;
							$user_avatar = cs_get_user_avatar(0, $user_ID);
						?>
						<img class="" src="<?php echo $user_avatar; ?>" alt="" />						<div class="sidebar-author-content">							<div class="author-title">								<h5><?php echo get_the_author_meta('display_name', $curauth); ?> </h5>							</div>							<div class="author-description">								<p>									 <?php echo get_the_author_meta( 'description', $curauth  ); ?>								</p>							</div>						</div>
					</div>					<?php get_sidebar('blogsidebar'); ?>
				</div>
				</div>
			</div>
	    </div>
<?php  endwhile; ?>
    </section>
<?php get_footer(); ?>