<?php


global $woocommerce;


// Remove Woocommerce Default Actions
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );

// Add Woocommerce Actions
add_action('woocommerce_before_main_content', 'classiads_woocommerce_wrapper_start', 10);
add_action('woocommerce_after_main_content', 'classiads_woocommerce_wrapper_end', 10);
add_action( 'woocommerce_share', 'classiads_woocommerce_social_share_icons', 10 );

// Add Woocommerce Filters
add_filter('woocommerce_checkout_fields', 'classiads_bootstrap_checkout_fields' );
add_filter( 'woocommerce_default_address_fields' , 'classiads_woo_default_fields' );


// Woocommerce Wrapper Start
if ( !function_exists('classiads_woocommerce_wrapper_start') ){
	function classiads_woocommerce_wrapper_start() {
		classiads_breadcrumbs_with_title();
		echo '<div class="classiads-woocommerce-page">';
			echo '<div class="container">';
				echo '<div class="row">';
	}
}
// Woocommerce Wrapper End
if ( !function_exists('classiads_woocommerce_wrapper_end') ){
	function classiads_woocommerce_wrapper_end() {
				echo '</div>';
			echo '</div>';
		echo '</div>';
	}
}

if ( !function_exists('classiads_woocommerce_social_share_icons') ){
	function classiads_woocommerce_social_share_icons() {
		
		echo'<div class="footer-social-widget widget-social">';
			echo '<a href="https://www.facebook.com/sharer/sharer.php?u='.get_the_permalink().'" onclick="return !window.open(this.href, "Facebook", "width=500,height=500")"  class="fb"><i class="fa fa-facebook"></i></a>';
			echo '<a href="https://twitter.com/home?status='.get_the_permalink().'" onclick="return !window.open(this.href, "Twitter", "width=500,height=500")"  class="tw"><i class="fa fa-twitter"></i></a>';
			echo '<a href="https://plus.google.com/share?url='.get_the_permalink().'" onclick="return !window.open(this.href, "Google", "width=500,height=500")"  class="goo"><i class="fa fa-google"></i></a>';
			echo '<a href="https://www.linkedin.com/shareArticle?mini=true&url='.get_the_permalink().'&title='.get_the_title().'&summary=&source='. get_the_permalink().'" onclick="return !window.open(this.href, "Linkedin", "width=500,height=500")"  class="lin"><i class="fa fa-linkedin"></i></a>';
			echo '<a href="https://pinterest.com/pin/create/button/?url='.get_the_permalink().'&media=&description=" onclick="return !window.open(this.href, "Pinterest", "width=500,height=500")"  class="pin"><i class="fa fa-pinterest"></i></a>';
		echo'</div>';
		
	}
}


function classiads_bootstrap_checkout_fields($fields) {
    foreach ($fields as &$fieldset) {
        foreach ($fieldset as &$field) {
            // if you want to add the form-group class around the label and the input
            $field['class'][] = 'form-group'; 

            // add form-control to the actual input
            $field['input_class'][] = 'form-control';

            // add form-control to the actual input
           // $field['placeholder'] =  $field['name'];
			
            // remove label property
            unset($field['label']);
        }
    }
    $fields['order']['order_comments']['placeholder'] = esc_html__('Your Order Notes','classiads');
    return $fields;
}

function classiads_woo_default_fields( $fields ) {
	
	$fields['first_name']['placeholder'] = esc_html__('First Name *','classiads');
	$fields['last_name']['placeholder'] = esc_html__('Last Name *','classiads');
	$fields['company']['placeholder'] = esc_html__('Comapany Name','classiads');
	$fields['address_1']['placeholder'] = esc_html__('Address *','classiads');
	$fields['address_2']['placeholder'] = esc_html__('Optional','classiads');
	$fields['city']['placeholder'] = esc_html__('Town,City *','classiads');
	$fields['state']['placeholder'] = esc_html__('State *','classiads');
	$fields['postcode']['placeholder'] = esc_html__('Postcode,Zip *','classiads');
	$fields['phone']['placeholder'] = esc_html__('Phone','classiads');

	return $fields;
	 
}

function yourtheme_woocommerce_image_dimensions() {
	global $pagenow;
 
	if ( ! isset( $_GET['activated'] ) || $pagenow != 'themes.php' ) {
		return;
	}
  	$catalog = array(
		'width' 	=> '270',	// px
		'height'	=> '370',	// px
		'crop'		=> 1 		// true
	);
	$thumbnail = array(
		'width' 	=> '270',	// px
		'height'	=> '370',	// px
		'crop'		=> 0 		// false
	);
	// Image sizes
	update_option( 'shop_catalog_image_size', $catalog ); 		// Product category thumbs
	update_option( 'shop_thumbnail_image_size', $thumbnail ); 	// Image gallery thumbs
}
add_action( 'after_switch_theme', 'yourtheme_woocommerce_image_dimensions', 1 );

function woocommerce_template_loop_product_thumbnail(){
	global $product;
	$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($product->get_id()), 'full');
	echo classiads_images( $large_image_url[0], 270, 370, 1 );
}



 ?>