<?php
class TWRecentPostWidget extends WP_Widget {
    function __construct() {
        $widget_ops = array('classname' => 'TWRecentPostWidget', 'description' => 'designinvento recent posts.');
        parent::__construct(false, 'designinvento recent posts', $widget_ops);
    }
    function widget($args, $instance) {
        global $post;
        extract(array(
            'title' => '',
            'number_posts' => 2,
            'theme' => 'post_nothumbnailed',
            'post_order' => 'latest',
            'post_type' => 'post'
        ));
        extract($args);
        $title = apply_filters('widget_title', $instance['title']);
        $post_count = 2; 
        if (isset($instance['number_posts']))
            $post_count = $instance['number_posts'];
        $q['posts_per_page'] = $post_count;
        $cats = (array) $instance['post_category'];
        $q['paged'] = 1;
        $q['post_type'] = $instance['post_type'];
        if (count($cats) > 0) {
            $typ = 'category';
	    if ($instance['post_type'] != 'post')
		$typ = 'catalog';
            $catq = '';
            $sp = '';
            foreach ($cats as $mycat) {
                $catq = $catq . $sp . $mycat;
                $sp = ',';
            }
            $catq = explode(',', $catq);
            $q['tax_query'] = Array(
			Array(
                    'taxonomy' => $typ,
                    'terms' => $catq,
                    'field' => 'id',

                )
            );
			if ($instance['post_order'] == 'commented'){
				$q['tax_query'] = Array(
				Array(
						'taxonomy' => $typ,
						'terms' => $catq,
						'field' => 'id',
						 'meta_query' => array(
						array(
							 'key' => 'featured_post',
							 'value' => '1',
							 'compare' => '=='
							 )
						),
					)
				);
			}
        }
        if ($instance['post_order'] == 'commented')


		$current = -1;
		$featuredCurrent = 0;

        query_posts($q);

        if (isset($before_widget))
            echo $before_widget;
        if ($title != '')
            echo $args['before_title'] . $title . $args['after_title'];
      		  echo '<div class="jw-recent-posts-widget">';
        echo '<ul>';
        while ( have_posts() ) : the_post();
		if ($instance['post_order'] == 'commented'){

		   ?>
				<li class="widget-ad-list latestads-widget featured-widget">


					<?php require_once(TEMPLATEPATH . '/inc/BFI_Thumb.php'); ?>

				<?php

					$thumb_id = get_post_thumbnail_id();
					$thumb_url = wp_get_attachment_image_src($thumb_id,'thumbnail-size', true);

					global $redux_demo;
					$footer_styles = $redux_demo['footer-styles']; // Footer Styles ID
					if ($footer_styles == 1){
						$params = array( 'width' => 120, 'height' => 80, 'crop' => true );
					}
					elseif ($footer_styles == 2){
						$params = array( 'width' => 85, 'height' => 90, 'crop' => true );
					}
					elseif ($footer_styles == 3){
						$params = array( 'width' => 80, 'height' => 70, 'crop' => true );
					}
					elseif ($footer_styles == 4){
						$params = array( 'width' => 80, 'height' => 70, 'crop' => true );
					}
					echo '<a href="'. esc_url(get_permalink($post->ID)).' " >';
					echo "<img alt='image' class='widget-ad-image' src='" . bfi_thumb( "$thumb_url[0]", $params ) . "'/>";
					echo "</a>";
				?>

					<span class="widget-ad-list-content">

					<span class="widget-ad-list-content-title"><a href="<?php the_permalink(); ?>"><?php $theTitle = get_the_title(); $theTitle = (strlen($theTitle) > 60) ? substr($theTitle,0,60).'...' : $theTitle; echo $theTitle; ?></a></span>
					<p class="ad-price"><?php the_time('d M, Y'); ?></p>

					</span>


				</li>
			<?php

		}else{
            ?>
			<li class="widget-ad-list latestads-widget">


				<?php require_once(TEMPLATEPATH . '/inc/BFI_Thumb.php'); ?>

				<?php

					$thumb_id = get_post_thumbnail_id();
					$thumb_url = wp_get_attachment_image_src($thumb_id,'thumbnail-size', true);


						$params = array( 'width' => 120, 'height' => 80, 'crop' => true );

					echo '<a href="'. esc_url(get_permalink($post->ID)).' " >';
					echo "<img alt='image' class='widget-ad-image' src='" . bfi_thumb( "$thumb_url[0]", $params ) . "'/>";
					echo "</a>";
				?>

					<span class="widget-ad-list-content">

					<span class="widget-ad-list-content-title"><a href="<?php the_permalink(); ?>"><?php $theTitle = get_the_title(); $theTitle = (strlen($theTitle) > 30) ? substr($theTitle,0,30).'...' : $theTitle; echo $theTitle; ?></a></span>
					<p class="add-price"><?php the_time('d M, Y'); ?></p>

					</span>

			</li>
			<?php
			}
        endwhile;
        echo '</ul>';
        echo '</div>';
        if (isset($after_widget))
            echo $after_widget;
        wp_reset_query();
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        /* Strip tags (if needed) and update the widget settings. */
        $instance['title'] = strip_tags($new_instance['title']);
        if ($new_instance['post_type'] == 'post') {
	    $instance['post_category'] = $_REQUEST['post_category'];
	} else {
	    $tax = get_object_taxonomies($new_instance['post_type']);
	    $instance['post_category'] = $_REQUEST['tax_input'][$tax[0]];
	}
        $instance['number_posts'] = strip_tags($new_instance['number_posts']);
        $instance['post_type'] = strip_tags($new_instance['post_type']);
        $instance['post_order'] = strip_tags($new_instance['post_order']);
        $instance['theme'] = strip_tags($new_instance['theme']);
        return $instance;
    }

    function form($instance) {
        //Output admin widget options form
        extract(shortcode_atts(array(
                    'title' => '',
                    'theme' => 'post_nothumbnailed',
                    'number_posts' => 2,
                    'post_order' => 'latest',
                    'post_type' => 'post'
                        ), $instance));
        $defaultThemes = Array(
            Array("name" => 'Thumbnailed posts', 'user_func' => 'post_thumbnailed'),
            Array("name" => 'Default posts', 'user_func' => 'post_nonthumbnailed')
        );
        $themes = apply_filters('jw_recent_posts_widget_theme_list', $defaultThemes);
        $defaultPostTypes = Array(Array("name" => 'Post', 'post_type' => 'post')); ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e("Title:", "classiads");?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $title; ?>"  />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('post_order'); ?>">Post order:</label>
            <select class="widefat" id="<?php echo $this->get_field_id('post_order'); ?>" name="<?php echo $this->get_field_name('post_order'); ?>">
                <option value="latest" <?php if ($post_order == 'latest') print 'selected="selected"'; ?>>Latest Ads</option>
                <option value="commented" <?php if ($post_order == 'commented') print 'selected="selected"'; ?>>Featured Ads</option>
            </select>
        </p>
       <?php
        $customTypes = apply_filters('jw_recent_posts_widget_type_list', $defaultPostTypes);
        if (count($customTypes) > 0) { ?>
            <p style="display: none;">
                <label for="<?php echo $this->get_field_id('post_type'); ?>">Post from:</label>
                <select rel="<?php echo $this->get_field_id('post_cats'); ?>" onChange="jw_get_post_terms(this);" class="widefat" id="<?php echo $this->get_field_id('post_type'); ?>" name="<?php echo $this->get_field_name('post_type'); ?>"><?php
                    foreach ($customTypes as $postType) { ?>
                        <option value="<?php print $postType['post_type'] ?>" <?php echo selected($post_type, $postType['post_type']); ?>><?php print $postType['name'] ?></option><?php
                    } ?>
                </select>
            </p><?php
        } ?>
        <p><?php _e('If you were not selected for cats, it will show all categories.','classiads'); ?></p>
        <div id="<?php echo $this->get_field_id('post_cats'); ?>" style="height:150px; overflow:auto; border:1px solid #dfdfdf;"><?php
            $post_type='post';
            $tax = get_object_taxonomies($post_type);

            $selctedcat = false;
            if (isset($instance['post_category']) && $instance['post_category'] != ''){
                $selctedcat = $instance['post_category'];
            }
            wp_terms_checklist(0, array('taxonomy' => $tax[0], 'checked_ontop' => false, 'selected_cats' => $selctedcat)); ?>
        </div>
        <p>
            <label for="<?php echo $this->get_field_id('number_posts'); ?>">Number of posts to show:</label>
            <input  id="<?php echo $this->get_field_id('number_posts'); ?>" name="<?php echo $this->get_field_name('number_posts'); ?>" value="<?php echo $number_posts; ?>" size="3"  />
        </p><?php
    }
}
add_action('widgets_init', create_function('', 'return register_widget("TWRecentPostWidget");'));
add_action('wp_ajax_themewave_recent_post_terms', 'get_post_type_terms');
function get_post_type_terms() {
    $cat = 'post';
    if (isset($_REQUEST['post_format']) && $_REQUEST['post_format'] != '')
        $cat = $_REQUEST['post_format'];
    $tax = get_object_taxonomies($cat);
    wp_terms_checklist(0, array('taxonomy' => $tax[0], 'checked_ontop' => false, 'selected_cats' => false));
    die;
} ?>
