<?php

/**
	ReduxFramework Sample Config File
	For full documentation, please visit http://reduxframework.com/docs/
**/


/**

	Most of your editing will be done in this section.

	Here you can override default values, uncomment args and change their values.
	No $args are required, but they can be overridden if needed.

**/
$args = array();


// For use with a tab example below
$tabs = array();

ob_start();

$ct = wp_get_theme();
$theme_data = $ct;
$item_name = $theme_data->get('Name');
$tags = $ct->Tags;
$screenshot = $ct->get_screenshot();
$class = $screenshot ? 'has-screenshot' : '';

$customize_title = sprintf( __( 'Customize &#8220;%s&#8221;','classiads' ), $ct->display('Name') );

?>
<div id="current-theme" class="<?php echo esc_attr( $class ); ?>">
	<?php if ( $screenshot ) : ?>
		<?php if ( current_user_can( 'edit_theme_options' ) ) : ?>
		<a href="<?php echo wp_customize_url(); ?>" class="load-customize hide-if-no-customize" title="<?php echo esc_attr( $customize_title ); ?>">
			<img src="<?php echo esc_url( $screenshot ); ?>" alt="<?php esc_attr_e( 'Current theme preview' , 'classiads' ); ?>" />
		</a>
		<?php endif; ?>
		<img class="hide-if-customize" src="<?php echo esc_url( $screenshot ); ?>" alt="<?php esc_attr_e( 'Current theme preview' , 'classiads'); ?>" />
	<?php endif; ?>

	<h4>
		<?php echo $ct->display('Name'); ?>
	</h4>

	<div>
		<ul class="theme-info">
			<li><?php printf( __('By %s','classiads'), $ct->display('Author') ); ?></li>
			<li><?php printf( __('Version %s','classiads'), $ct->display('Version') ); ?></li>
			<li><?php echo '<strong>'.__('Tags', 'classiads').':</strong> '; ?><?php printf( $ct->display('Tags') ); ?></li>
		</ul>
		<p class="theme-description"><?php echo $ct->display('Description'); ?></p>
		<?php if ( $ct->parent() ) {
			printf( ' <p class="howto">' . __( 'This <a href="%1$s">child theme</a> requires its parent theme, %2$s.' , 'classiads') . '</p>',
				__( 'http://codex.wordpress.org/Child_Themes','classiads' ),
				$ct->parent()->display( 'Name' ) );
		} ?>

	</div>

</div>

<?php
$item_info = ob_get_contents();

ob_end_clean();

$sampleHTML = '';
if( file_exists( dirname(__FILE__).'/info-html.html' )) {
	/** @global WP_Filesystem_Direct $wp_filesystem  */
	global $wp_filesystem;
	if (empty($wp_filesystem)) {
		require_once(ABSPATH .'/wp-admin/includes/file.php');
		WP_Filesystem();
	}
	$sampleHTML = $wp_filesystem->get_contents(dirname(__FILE__).'/info-html.html');
}

// BEGIN Sample Config

// Setting dev mode to true allows you to view the class settings/info in the panel.
// Default: true
$args['dev_mode'] = false;

// Set the icon for the dev mode tab.
// If $args['icon_type'] = 'image', this should be the path to the icon.
// If $args['icon_type'] = 'iconfont', this should be the icon name.
// Default: info-sign
//$args['dev_mode_icon'] = 'info-sign';

// Set the class for the dev mode tab icon.
// This is ignored unless $args['icon_type'] = 'iconfont'
// Default: null
$args['dev_mode_icon_class'] = 'icon-large';

// Set a custom option name. Don't forget to replace spaces with underscores!
$args['opt_name'] = 'redux_demo';

// Setting system info to true allows you to view info useful for debugging.
// Default: false
//$args['system_info'] = true;


// Set the icon for the system info tab.
// If $args['icon_type'] = 'image', this should be the path to the icon.
// If $args['icon_type'] = 'iconfont', this should be the icon name.
// Default: info-sign
//$args['system_info_icon'] = 'info-sign';

// Set the class for the system info tab icon.
// This is ignored unless $args['icon_type'] = 'iconfont'
// Default: null
//$args['system_info_icon_class'] = 'icon-large';

$theme = wp_get_theme();

$args['display_name'] = $theme->get('Name');
//$args['database'] = "theme_mods_expanded";
$args['display_version'] = $theme->get('Version');

// If you want to use Google Webfonts, you MUST define the api key.
$args['google_api_key'] = 'AIzaSyAX_2L_UzCDPEnAHTG7zhESRVpMPS4ssII';

// Define the starting tab for the option panel.
// Default: '0';
//$args['last_tab'] = '0';

// Define the option panel stylesheet. Options are 'standard', 'custom', and 'none'
// If only minor tweaks are needed, set to 'custom' and override the necessary styles through the included custom.css stylesheet.
// If replacing the stylesheet, set to 'none' and don't forget to enqueue another stylesheet!
// Default: 'standard'
//$args['admin_stylesheet'] = 'standard';
$ucat = array(
 'post_type' => 'post',
  'hide_empty' => false,
  'orderby' => 'count',
  'order' => 'ASC'
);
$categories = get_terms( 'category',$ucat);

	foreach($categories as $category) {
		$cat[]=array($category->term_id => $category->name);
	} /* Categories */
// Setup custom links in the footer for share icons


// Enable the import/export feature.
// Default: true
//$args['show_import_export'] = false;

// Set the icon for the import/export tab.
// If $args['icon_type'] = 'image', this should be the path to the icon.
// If $args['icon_type'] = 'iconfont', this should be the icon name.
// Default: refresh
//$args['import_icon'] = 'refresh';

// Set the class for the import/export tab icon.
// This is ignored unless $args['icon_type'] = 'iconfont'
// Default: null
$args['import_icon_class'] = 'icon-large';

/**
 * Set default icon class for all sections and tabs
 * @since 3.0.9
 */
$args['default_icon_class'] = 'icon-large';


// Set a custom menu icon.
//$args['menu_icon'] = '';

// Set a custom title for the options page.
// Default: Options
$args['menu_title'] = __('Theme Settings', 'classiads');

// Set a custom page title for the options page.
// Default: Options
$args['page_title'] = __('Theme Settings', 'classiads');

// Set a custom page slug for options page (wp-admin/themes.php?page=***).
// Default: redux_options
$args['page_slug'] = 'redux_options';

$args['default_show'] = true;
$args['default_mark'] = '*';

// Set a custom page capability.
// Default: manage_options
//$args['page_cap'] = 'manage_options';

// Set the menu type. Set to "menu" for a top level menu, or "submenu" to add below an existing item.
// Default: menu
$args['page_type'] = 'submenu';

// Set the parent menu.
// Default: themes.php
// A list of available parent menus is available at http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
$args['page_parent'] = 'classiads-dashborad';

// Set a custom page location. This allows you to place your menu where you want in the menu order.
// Must be unique or it will override other items!
// Default: null
//$args['page_position'] = null;

// Set a custom page icon class (used to override the page icon next to heading)
//$args['page_icon'] = 'icon-themes';

// Set the icon type. Set to "iconfont" for Elusive Icon, or "image" for traditional.
// Redux no longer ships with standard icons!
// Default: iconfont
//$args['icon_type'] = 'image';

// Disable the panel sections showing as submenu items.
// Default: true
//$args['allow_sub_menu'] = false;

// Set ANY custom page help tabs, displayed using the new help tab API. Tabs are shown in order of definition.
$args['help_tabs'][] = array(
    'id' => 'redux-opts-1',
    'title' => __('Theme Information 1', 'classiads'),
    'content' => __('<p>This is the tab content, HTML is allowed.</p>', 'classiads')
);
$args['help_tabs'][] = array(
    'id' => 'redux-opts-2',
    'title' => __('Theme Information 2', 'classiads'),
    'content' => __('<p>This is the tab content, HTML is allowed.</p>', 'classiads')
);

// Set the help sidebar for the options page.
$args['help_sidebar'] = __('<p>This is the sidebar content, HTML is allowed.</p>', 'classiads');


// Add HTML before the form.
/*
if (!isset($args['global_variable']) || $args['global_variable'] !== false ) {
	if (!empty($args['global_variable'])) {
		$v = $args['global_variable'];
	} else {
		$v = str_replace("-", "_", $args['opt_name']);
	}
	$args['intro_text'] = sprintf( __('<p>Did you know that Redux sets a global variable for you? To access any of your saved options from within your code you can use your global variable: <strong>$%1$s</strong></p>', 'classiads' ), $v );
} else {
	$args['intro_text'] = __('<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'classiads');
}

// Add content after the form.
$args['footer_text'] = __('<p>This text is displayed below the options panel. It isn\'t required, but more info is always better! The footer_text field accepts all HTML.</p>', 'classiads');
*/

// Set footer/credit line.
//$args['footer_credit'] = __('<p>This text is displayed in the options panel footer across from the WordPress version (where it normally says \'Thank you for creating with WordPress\'). This field accepts all HTML.</p>', 'classiads');


$sections = array();

//Background Patterns Reader
$sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
$sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
$sample_patterns      = array();

if ( is_dir( $sample_patterns_path ) ) :

  if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) :
  	$sample_patterns = array();

    while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

      if( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
      	$name = explode(".", $sample_patterns_file);
      	$name = str_replace('.'.end($name), '', $sample_patterns_file);
      	$sample_patterns[] = array( 'alt'=>$name,'img' => $sample_patterns_url . $sample_patterns_file );
      }
    }
  endif;
endif;

$help_image = ReduxFramework::$_url . '';




$sections[] = array(
	'icon' => 'el-icon-cogs',
	'icon_class' => 'icon-large',
    'title' => __('General Settings', 'classiads'),
	'fields' => array(
		array(
			'id'=>'logo',
			'type' => 'media',
			'url'=> true,
			'title' => __('Logo', 'classiads'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload your logo.', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'default'=>array('url'=> get_template_directory_uri().'/images/logo.png'),
			),
		array(
				'id' => 'logo-width',
				'type' => 'slider',
				'title' => __('Maximum Logo Width', 'classiads'),
				'desc' => __('Select Maximum Logo Width. Min: 0, max: 900, step: 5, default value: 200', 'classiads'),
				"default" => 200,
				"min" => 0,
				"step" => 5,
				"max" => 900,
				'display_value' => 'text'
			),
		array(
			'id'=>'favicon',
			'type' => 'media',
			'url'=> true,
			'title' => __('Favicon', 'classiads'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload your favicon.', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'default'=>array('url'=> get_template_directory_uri().'/images/favicon.png'),
			),
		array(
			'id'=>'layout-version',
			'type' => 'radio',
			'title' => __('Layout', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'options' => array('1' => 'Wide', '2' => 'Boxed'),//Must provide key => value pairs for radio options
			'default' => 1,
			),
		array(
			'id'=>'title-bg',
			'type' => 'media',
			'url'=> true,
			'title' => __('Page title Background', 'classiads'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload page title BG.', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'default'=>array('url'=>''),
			),
		array(
			'id'=>'measure-system',
			'type' => 'radio',
			'title' => __('Measurement system', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'options' => array('1' => 'Miles', '2' => 'Kilometers'),//Must provide key => value pairs for radio options
			'default' => 2,
			),

		array(
			'id'=>'max_range',
			'type' => 'text',
			'title' => __('Maxim Range', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('You can add the max geolocation range (default: 1000', 'classiads'),
			'default' => '1000'
			),
		array(
			'id'=>'blog-slider',
			'type' => 'text',
			'title' => __('Blog Slider (Use if neccessory)', 'classiads'),
			'subtitle' => __('Put here Layerslider Shortcode', 'classiads'),
			'desc' => __('Leave empty if you do not want to use slider on blog page', 'classiads'),
			'default' => ''
			),
		array(
			'id'=>'ad_expiry',
			'type' => 'select',
			'title' => __('Regular Ads Expiry', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'options' => array('7' => 'One week', '30' => 'One Month', '60' => 'Two Months', '90' => 'Three Months', '120' => 'Four Months', '150' => 'Five Months', '180' => 'Six Month', '365' => 'One Year', '730' => 'Two Year', '1095' => 'Three Year', '1460' => 'Four Year', '1825' => 'Five Year', '2190' => 'Six Year'),//Must provide key => value pairs for radio options
			'default' => 365
			),
		array(
			'id'=>'featured_ad_expiry',
			'type' => 'text',
			'title' => __('Featured Ads Expiry', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('Featured Ad Expiry date will be work with days', 'classiads'),
			'default' => 15
			),
		array(
            'id' => 'featured-options-on',
            'type' => 'switch',
            'title' => __('Ads slider', 'classiads'),
            'subtitle' => __('', 'classiads'),
            'default' => 1,
            ),
		array(
            'id' => 'hide-map',
            'type' => 'switch',
            'title' => __('Enable/Disable Map from whole website', 'classiads'),
            'subtitle' => __('', 'classiads'),
            'default' => 1,
            ),
		array(
            'id' => 'post-options-edit-on',
            'type' => 'switch',
            'title' => __('Post moderation On every edit post', 'classiads'),
            'subtitle' => __('', 'classiads'),
            'default' => 1,
           ),
		array(
            'id' => 'featured-options-cat',
            'type' => 'switch',
            'title' => __('Featured Ads on category related to category', 'classiads'),
            'subtitle' => __('', 'classiads'),
            'default' => 0,
            ),
		array(
			'id'=>'tags_limit',
			'type' => 'text',
			'title' => __('Number of tags in tag Cloud widget', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('Put here a number. Example "16"', 'classiads'),
			'default' => '15'
			),
		array(
			'id'=>'google_id',
			'type' => 'text',
			'title' => __('Google Analytics Domain ID', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('Get analytics on your site. Enter Google Analytics Domain ID (ex: UA-123456-1)', 'classiads'),
			'default' => ''
			),
		array(
			'id'=>'top_phone',
			'type' => 'text',
			'title' => __('Top Bar Phone Text', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('You can add text here.', 'classiads'),
			'default' => '+444-8888-444'
			),
		array(
			'id'=>'top_phone_icon',
			'type' => 'text',
			'title' => __('Top Bar Phone Icon Code', 'classiads'),
			'subtitle' => __('<a href="http://fontawesome.io/icons/" target="_blank">Click Here to get Code</a>', 'classiads'),
			'desc' => __('<i class="fa fa-phone"></i>.', 'classiads'),
			'default' => ''
			),
		array(
			'id'=>'contact-email-icon',
			'type' => 'text',
			'title' => __('Top Bar Phone Icon Code', 'classiads'),
			'subtitle' => __('<a href="http://fontawesome.io/icons/" target="_blank">Click Here to get Code</a>', 'classiads'),
			'desc' => __('<i class="fa fa-envelope"></i>.', 'classiads'),
			'default' => ''
			),
		array(
			'id'=>'contact-email',
			'type' => 'text',
			'title' => __('Your email address', 'classiads'),
			'subtitle' => __('This must be an email address.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'email',
			'default' => ''
			),
		array(
			'id'=>'home-ads-featured',
			'type' => 'text',
			'title' => __('How many Featured ads on Featured ad Section', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'default' => 8
			),
		array(
			'id'=>'button-styles',
			'type' => 'button_set',
			'title' => __('Button Styles', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('<a target="_block" href="'.$help_image.'help/button.jpg">Click here to view options</a>', 'classiads'),
			'options' => array('1' => 'Style 1', '2' => 'Style 2', '3' => 'Style 3'),//Must provide key => value pairs for radio options
			'default' => 1,
			),
		array(
			'id'=>'home-ads-featured-order',
			'type' => 'select',
			'title' => __('Featured Ads Order', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'options' => array('none' => 'Latest', 'rand' => 'Random'),
			'default' => 'none'
			),
		array(
			'id'=>'home-ads-view',
			'type' => 'button_set',
			'title' => __('Select Ads view type', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'options' => array('grid_view' => 'Grid view', 'list_view' => 'List view'),
			'default' => 'grid_view'
			),
		array(
			'id'=>'home-ads-title-limit',
			'type' => 'text',
			'title' => __('Grid & List Style Title Letters Limit', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'default' => '25'
			),
		array(
			'id'=>'section-title-st',
			'type' => 'button_set',
			'title' => __('Section Title Style', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'options' => array('1' => 'Style 1', '2' => 'Style 2', '3' => 'Style 3'),
			'default' => 1
			),
		array(
			'id'=>'search-page-st',
			'type' => 'button_set',
			'title' => __('Search Page Style', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'options' => array('1' => 'Default Search Page', '2' => 'Google Map with sidebar listing'),
			'default' => 1
			),
		array(
			'id'=>'search-style',
			'type' => 'select',
			'title' => __('Search Styles', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('<a target="_block" href="'.$help_image.'help/search.jpg">Click here to view options</a>', 'classiads'),
			'options' => array('1' => 'Style 1', '2' => 'Style 2', '3' => 'Style 3', '4' => 'Style 4', '5' => 'Style 5', '6' => 'Style 6'),//Must provide key => value pairs for radio options
			'default' => 1
			),
		array(
			'id'=>'hr-slide-style',
			'type' => 'select',
			'title' => __('Horizontal Slider Styles', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('<a target="_block" href="'.$help_image.'help/hr-slidr.jpg">Click here to view options</a>', 'classiads'),
			'options' => array('1' => 'Style 1', '2' => 'Style 2', '3' => 'Style 3'),//Must provide key => value pairs for radio options
			'default' => 1
			),
		array(
			'id'=>'ads-tabs-style',
			'type' => 'select',
			'title' => __('Ads Tab Style', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'options' => array('1' => 'Style 1', '2' => 'Style 2', '3' => 'Style 3'),
			'default' => 1
			),
		array(
			'id'=>'home-ads-style',
			'type' => 'select',
			'title' => __('Select Ads Grid Style', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('<a target="_block" href="'.$help_image.'help/home-ads.jpg">Click here to view options</a>', 'classiads'),
			'options' => array('1' => 'Style 1', '2' => 'Style 2', '3' => 'Style 3', '4' => 'Style 4'),
			'default' => 1
			),
		array(
			'id'=>'home-ads-list-style',
			'type' => 'select',
			'title' => __('Select Ads List Style', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('<a target="_block" href="'.$help_image.'help/home-ads-list.jpg">Click here to view options</a>', 'classiads'),
			'options' => array('1' => 'Style 1', '2' => 'Style 2', '3' => 'Style 3'),
			'default' => 1
			),
			
		array(
			'id'=>'contact-email-error',
			'type' => 'text',
			'title' => __('Email error message', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'default' => 'You entered an invalid email.'
			),

		array(
			'id'=>'contact-name-error',
			'type' => 'text',
			'title' => __('Name error message', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'default' => 'You forgot to enter your name.'
			),

		array(
			'id'=>'contact-message-error',
			'type' => 'text',
			'title' => __('Message error', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'default' => 'You forgot to enter your message.'
			),

		array(
			'id'=>'contact-thankyou-message',
			'type' => 'text',
			'title' => __('Thank you message', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'default' => 'Thank you! We will get back to you as soon as possible.'
			),
		),
	);

$sections[] = array(
	'icon' => 'el-icon-cogs',
	'icon_class' => 'icon-large',
    'title' => __('Header settings', 'classiads'),
	'fields' => array(
		array(
				'id'=>'header-style',
				'type' => 'select',
				'title' => __('Header Styles', 'classiads'),
				'subtitle' => __('', 'classiads'),
				'desc' => __('<a target="_block" href="'.$help_image.'help/header.jpg">Click here to view options</a>', 'classiads'),
				'options' => array('1' => 'Version 1', '2' => 'Version 2', '3' => 'Version 3', '4' => 'Version 4', '5' => 'Version 5', '6' => 'Version 6', '7' => 'Version 7' ,'8' => 'Version 8'),//Must provide key => value pairs for radio options
				'default' => 1,
			),
			array(
				'id'=>'header-position',
				'type' => 'button_set',
				'title' => __('Header Position', 'classiads'),
				'subtitle' => __('', 'classiads'),
				'desc' => __('', 'classiads'),
				'options' => array('1' => 'Absolute', '2' => 'Static'),//Must provide key => value pairs for radio options
				'default' => 1,
				'required' => array( 'header-style', '=', '5' )
			),
			array(
				'id'=>'header-sticky',
				'type' => 'button_set',
				'title' => __('Sticky Header', 'classiads'),
				'subtitle' => __('', 'classiads'),
				'desc' => __('', 'classiads'),
				'options' => array('1' => 'Yes', '2' => 'No'),//Must provide key => value pairs for radio options
				'default' => 2,

			),
		array(
				'id'=>'sticky-header-logo',
				'type' => 'media',
				'url'=> true,
				'title' => __('Sticky Header Logo', 'classiads'),
				'compiler' => 'true',
				//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'=> __('Upload your logo for Sticky header.', 'classiads'),
				'subtitle' => __('', 'classiads'),
				'default'=>array('url'=>''),
				'required' => array( 'header-sticky', '=', '1' )
			),
		array(
				'id'=>'header-post-btn',
				'type' => 'text',
				'title' => __('Header Post Submit Botton Text', 'classiads'),
				'subtitle' => __('', 'classiads'),
				'desc' => __('Add here Header Post Submit Botton Text', 'classiads'),
				'default' => 'Make new ad'
			),
	)
);


$sections[] = array(
	'icon' => 'el-icon-cogs',
	'icon_class' => 'icon-large',
    'title' => __('Ad Detail Page Settings', 'classiads'),
	'fields' => array(

		array(
			'id'=>'ads-detail-page-slider',
			'type' => 'select',
			'title' => __('Ad Detail Page Slider', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'options' => array(
				'1' => esc_html__('Style 1','classiads'),
				'2' => esc_html__('Style 2','classiads')
				),
			'default' => 1
			),
		array(
            'id' => 'featured-options-on-single',
            'type' => 'switch',
            'title' => __('Featured Ads Slider on single page', 'classiads'),
            'default' => 1,
            ),
		array(
            'id' => 'author-msg-box-off',
            'type' => 'switch',
            'title' => __('Author Message Box On/OFF', 'classiads'),
            'subtitle' => __('Author Message box on ad detail page', 'classiads'),
            'default' => 1,
            ),
		array(
            'id' => 'ad-review-box',
            'type' => 'switch',
            'title' => __('Ad Review Box On/OFF', 'classiads'),
            'default' => 1,
            ),
		array(
            'id' => 'ad-comment-box',
            'type' => 'switch',
            'title' => __('Ad Comment Box On/OFF', 'classiads'),
            'default' => 1,
            ),
	)
);

$sections[] = array(
	'icon' => 'el-icon-cogs',
	'icon_class' => 'icon-large',
    'title' => __('Make new ad Page Settings', 'classiads'),
	'fields' => array(
		array(
			'id'=>'default-post-image',
			'type' => 'media',
			'url'=> true,
			'title' => __('Default post image', 'classiads'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload image which will be default image if anyone will not upload image in his post', 'classiads'),
			'subtitle' => __('Preferred image size is 800x500', 'classiads'),
			'default'=> array('url'=> get_template_directory_uri().'/images/default-thumb.jpg'),
			),
		array(
			'id'=>'image-limit',
			'type' => 'text',
			'url'=> true,
			'title' => __('Image Limits', 'classiads'),
			'desc'=> __('Enter here Quantity of Image Limits', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'default'=> '8',
			),
		array(
			'id'=>'rate-for-per-post',
			'type' => 'text',
			'title' => __('Price For Per Post', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('Do not use currency sign here.', 'classiads'),
			'default' => '10',
			'required' => array( 'pay-per-post-system', '=', 1 )
			),
		array(
			'id'=>'rate-for-per-featured',
			'type' => 'text',
			'title' => __('Price For Per Featured Post', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('Do not use currency sign here.', 'classiads'),
			'default' => '25',
			'required' => array( 'pay-per-post-system', '=', 1 )
			),
		array(
            'id' => 'ai_info',
            'type' => 'switch',
            'title' => __('User controlled additional information on ad submit page', 'classiads'),
            'subtitle' => __('', 'classiads'),
            'default' => 0,
            ),
		array(
            'id' => 'featured-ads_user',
            'type' => 'switch',
            'title' => __('Featured ads posting for users On/OFF', 'classiads'),
            'subtitle' => __('This option will not let users to post featured ads', 'classiads'),
            'default' => 1,
            ),
		array(
            'id' => 'regular-ads',
            'type' => 'switch',
            'title' => __('Free ad posting for users On/OFF', 'classiads'),
            'subtitle' => __('Regular ad posting On/OFF', 'classiads'),
            'default' => 1,
            ),
		array(
			'id'=>'free_price_text',
			'type' => 'text',
			'title' => __('Free listing tag', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('Add here the text tag for free listings', 'classiads'),
			'default' => 'Free',
			'required' => array( 'regular-ads', '=', 1 )
			),
		array(
			'id' => 'pay-per-post-system',
			'type' => 'switch',
			'title' => __('Pay Per Post System On/OFF', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'default' => 1,
			'required' => array( 'regular-ads', '=', 0 )
            ),
		array(
            'id' => 'post-options-on',
            'type' => 'switch',
            'title' => __('Post moderation', 'classiads'),
            'subtitle' => __('', 'classiads'),
            'default' => 1,
           ),
		 array(
			'id'       => 'new-ad-required-fields',
			'type'     => 'select',
			'multi'    => true,
			'title'    => __('Make new ad fields to required ', 'classiads'),
			'subtitle' => __('Multi Select Options', 'classiads'),
			'options'  => array(
				'post-r-title' => 'Post Title',
				'post-r-category' => 'Post Category',
				'post-r-location' => 'Post Location',
				'post-r-price' => 'Post Price',
				'post-r-address' => 'Post Address',
				'post-r-tags' => 'Post Tags',
				'post-r-video' => 'Post Video Url',
			),
		),
	)
);
$sections[] = array(
	'icon' => 'el-icon-cogs',
	'icon_class' => 'icon-large',
    'title' => __('Footer settings', 'classiads'),
	'fields' => array(
			array(
			'id'=>'footer_copyright',
			'type' => 'text',
			'title' => __('Footer Copyright Text', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('You can add text and HTML in here.', 'classiads'),
			'default' => ''
			),

			array(
			'id'=>'footer-styles',
			'type' => 'button_set',
			'title' => __('Footer Style ', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'options' => array('1' => 'Style 1', '2' => 'Style 2', '3' => 'Style 3', '4' => 'Style 4', '5' => 'Style 5'),
			'default' => 1
			),
			array(
			'id'=>'footer-grid',
			'type' => 'button_set',
			'title' => __('Footer Column Style', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'options' => array('1' => 'Grids 3', '2' => 'Grids 4'),
			'default' => 1,
			),
		array(
            'id' => 'footer-upper-bar',
            'type' => 'switch',
            'title' => __('Footer Upper Bar', 'classiads'),
            'subtitle' => __('', 'classiads'),
            'default' => 2,
            ),
		array(
            'id' => 'footer-upper-bar-address',
            'type' => 'switch',
            'title' => __('Address in Footer Upper Bar', 'classiads'),
            'subtitle' => __('', 'classiads'),
            'default' => '043 B street # 2 boston XO city New York, United States',
            ),
		array(
            'id' => 'scroll-to-top',
            'type' => 'switch',
            'title' => __('Scroll to Top', 'classiads'),
            'subtitle' => __('', 'classiads'),
            'default' => 1,
            ),
			
		array(
            'id' => 'scroll-to-top-effect',
            'type' => 'button_set',
            'title' => __('Scroll to Top Effects', 'classiads'),
            'subtitle' => __('', 'classiads'),
			'options' => array('1' => 'Style 1', '2' => 'Style 2'),
            'default' => 1,
            'required' => array( 'scroll-to-top', '=', '1' )
            ),
			array(
            'id' => 'footer-menu',
            'type' => 'switch',
            'title' => __('Footer Menu', 'classiads'),
            'subtitle' => __('', 'classiads'),
            'default' => 0,
            ),
		array(
			'id'       => 'footer-bg-color',
	        'type'     => 'color',
	        'title'    => __('Footer Background Color', 'classiads'),
	        'subtitle' => __('Pick a Footer Background Color (default: #171919).', 'classiads'),
	        'default'  => '#171919',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'footer-heading-color',
	        'type'     => 'color',
	        'title'    => __('Footer heading Color', 'classiads'),
	        'subtitle' => '',
	        'default'  => '#ffffff',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'footer-text-color',
	        'type'     => 'color',
	        'title'    => __('Footer Text Color', 'classiads'),
	        'subtitle' => __('Pick a Footer Background Color (default: #ffffff).', 'classiads'),
	        'default'  => '#ffffff',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'footer-bottom-bg-color',
	        'type'     => 'color',
	        'title'    => __('Footer Bottom Bar Background Color', 'classiads'),
	        'subtitle' => __('Pick a Footer Bottom Bar Background Color (default: #aaa).', 'classiads'),
	        'default'  => '#aaa',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'footer-bottom-text-color',
	        'type'     => 'color',
	        'title'    => __('Footer Bottom Text Color', 'classiads'),
	        'subtitle' => __('Pick a Footer Bottom Text Color (default: #333).', 'classiads'),
	        'default'  => '#333',
	        'validate' => 'color',
	        'transparent' => false,
			),

	)
);


$sections[] = array(
	'icon' => 'el-icon-globe',
	'icon_class' => 'icon-large',
    'title' => __('Google Map', 'classiads'),
	'fields' => array(

		array(
			'id'=>'map_key',
			'type' => 'text',
			'title' => __('Google Map Api Key (USE ONLY WHEN YOUR GOOGLE MAP IS NOT WORKING)', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('Put here Google map api key, <a target=_blank href="https://www.youtube.com/watch?v=LaiE9qAfNnY">CLICK HERE</a> and see how to create Google map api key.', 'classiads'),
			'default' => ''
			),
		array(
			'id'=>'map_default_lattitude',
			'type' => 'text',
			'title' => esc_html__('Google Map Default Latitude', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'default' => '40.7128'
			),
		array(
			'id'=>'map_default_longitude',
			'type' => 'text',
			'title' => esc_html__('Google Map Default Longitude', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'default' => '74.0059'
			),
		array(
			'id'=>'google_map_zoom_level',
			'type' => 'select',
			'title' => esc_html__('Google Map Zoom Level', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'options' => array(
				1 => 1,
				2 => 2,
				3 => 3,
				4 => 4,
				5 => 5,
				6 => 6,
				7 => 7,
				8 => 8,
				9 => 9,
				10 => 10,
				11 => 11,
				12 => 12,
				13 => 13,
				14 => 14,
				15 => 15,
				16 => 16,
				17 => 17,
				18 => 18,
			),
			'default' => 5
			),
		array(
			'id'=>'map-style',
	        'type' => 'textarea',
	        'title' => __('Map Styles', 'classiads'),
	        'subtitle' => __('Check <a href="http://snazzymaps.com/" target="_blank">snazzymaps.com</a> for a list of nice google map styles.', 'classiads'),
	        'desc' => __('Ad here your google map style.', 'classiads'),
	        'validate' => 'html_custom',
	        'default' => '',
	        'allowed_html' => array(
	            'a' => array(
	                'href' => array(),
	                'title' => array()
	            ),
	            'br' => array(),
	            'em' => array(),
	            'strong' => array()
	       		)
			),


		),
	);

$sections[] = array(
	'icon' => 'el-icon-globe',
	'icon_class' => 'icon-large',
    'title' => __('Translation Text Jquery', 'classiads'),
	'fields' => array(
		array(
			'id'=>'load_more',
			'type' => 'text',
			'title' => __('Load More Button Text', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'default' => 'LOAD MORE'
			),
		array(
			'id'=>'no_more',
			'type' => 'text',
			'title' => __('No More Button Text', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'default' => 'NO MORE'
			),
		array(
			'id'=>'loading',
			'type' => 'text',
			'title' => __('Loading Button Text', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'default' => 'Loading...'
			),
		),
	);

$sections[] = array(
	'icon' => 'el-icon-website',
	'icon_class' => 'icon-large',
    'title' => __('Pages', 'classiads'),
	'fields' => array(

		array(
			'id'=>'login',
			'type' => 'text',
			'title' => __('Login Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'profile',
			'type' => 'text',
			'title' => __('Profile Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),
		array(
			'id'=>'new_post',
			'type' => 'text',
			'title' => __('New Ad Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'edit_post',
			'type' => 'text',
			'title' => __('Edit Ad Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'featured_plans',
			'type' => 'text',
			'title' => __('Featured Plans Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		),
	);



$sections[] = array(
	'icon' => 'el-icon-font',
	'icon_class' => 'icon-large',
    'title' => __('Fonts', 'classiads'),
	'fields' => array(

		array(
            'id' => 'heading1-font',
            'type' => 'typography',
            'title' => __('H1 Font', 'classiads'),
            'subtitle' => __('Specify the headings font properties.', 'classiads'),
            'google' => true,
            'output' => array('h1, h1 a, h1 span'),
            'default' => array(
                'color' => '#333333',
                'font-size' => '48px',
                'font-family' => 'Montserrat',
                'font-weight' => '700',
                'line-height' => '40px',
                ),
         	),

		array(
            'id' => 'heading2-font',
            'type' => 'typography',
            'title' => __('H2 Font', 'classiads'),
            'subtitle' => __('Specify the headings font properties.', 'classiads'),
            'google' => true,
            'output' => array('h2, h2 a, h2 span'),
            'default' => array(
                'color' => '#333333',
                'font-size' => '40px',
                'font-family' => 'Montserrat',
                'font-weight' => '700',
                'line-height' => '40px',
                ),
         	),

		array(
            'id' => 'heading3-font',
            'type' => 'typography',
            'title' => __('H3 Font', 'classiads'),
            'subtitle' => __('Specify the headings font properties.', 'classiads'),
            'google' => true,
            'output' => array('h3, h3 a, h3 span'),
            'default' => array(
                'color' => '#333333',
                'font-size' => '32px',
                'font-family' => 'Montserrat',
                'font-weight' => '700',
                'line-height' => '40px',
                ),
         	),

		array(
            'id' => 'heading4-font',
            'type' => 'typography',
            'title' => __('H4 Font', 'classiads'),
            'subtitle' => __('Specify the headings font properties.', 'classiads'),
            'google' => true,
            'output' => array('h4, h4 a, h4 span'),
            'default' => array(
				'color' => '#333333',
                'font-size' => '24px',
                'font-family' => 'Montserrat',
                'font-weight' => '700',
                'line-height' => '32px',
                ),
         	),

		array(
            'id' => 'heading5-font',
            'type' => 'typography',
            'title' => __('H5 Font', 'classiads'),
            'subtitle' => __('Specify the headings font properties.', 'classiads'),
            'google' => true,
            'output' => array('h5, h5 a, h5 span'),
            'default' => array(
                'color' => '#333333',
                'font-size' => '18px',
                'font-family' => 'Montserrat',
                'font-weight' => '700',
                'line-height' => '24px',
                ),
         	),

		array(
            'id' => 'heading6-font',
            'type' => 'typography',
            'title' => __('H6 Font', 'classiads'),
            'subtitle' => __('Specify the headings font properties.', 'classiads'),
            'google' => true,
            'output' => array('h6, h6 a, h6 span'),
            'default' => array(
                'color' => '#333333',
                'font-size' => '14px',
                'font-family' => 'Montserrat',
                'font-weight' => '700',
                'line-height' => '18px',
                ),
         	),

		array(
            'id' => 'body-font',
            'type' => 'typography',
            'title' => __('Body Font', 'classiads'),
            'subtitle' => __('Specify the body font properties.', 'classiads'),
            'google' => true,
            'output' => array('.ad-detail-half-box .ad-detail-info,span.ad-page-price,html, body, applet, object, iframe p, blockquote, a, abbr, acronym, address, big, cite, del, dfn, em, img, ins, kbd, q, s, samp, small, strike, sub, sup, tt, var, b, u, center, dl, dt, dd, ol, ul, li, fieldset, form, label, legend, table, caption, article, aside, canvas, details, embed, figure, figcaption, footer, header, hgroup, menu, nav, output, ruby, section, summary, time, mark, audio, video'),
            'default' => array(
                'color' => '#555',
                'font-size' => '14px',
                'font-family' => 'Lato',
                'font-weight' => 'Normal',
                'line-height' => '24px',
                ),
         	),
		array(
            'id' => 'a-heading-font',
            'type' => 'typography',
            'title' => __('Anchor heading Font', 'classiads'),
            'subtitle' => __('Specify the Anchor heading font properties.', 'classiads'),
            'google' => true,
            'output' => array('.ad-detail-info .description,.post-title a,.three-tabs li a'),
            'default' => array(
                'color' => '#444',
                'font-size' => '14px',
                'font-family' => 'Raleway',
                'font-weight' => 'Normal',
                'line-height' => '24px',
                ),
         	),
		array(
            'id' => 'main-font-1',
            'type' => 'typography',
            'title' => __('Main Font 1', 'classiads'),
            'subtitle' => __('Specify the Main Font 1 properties.', 'classiads'),
            'google' => true,
			'color' => false,
			'subsets' => false,
			'text-align' => false,
			'font-size' => false,
			'font-weight' => false,
			'font-style' => false,
			'line-height' => false,
            'output' => array('#register-login-block-top ul li a ,.header-pos-static .header-v5-login-register li a,.header-v5 .make-new-ad,.header-pos-static .header-v6-login-register li a,.header-v6 .make-new-ad,.header-v6 .register-btn,.header-v6 .make-new-ad a,.header-v6 .register-btn a,.header-v6-login-register.afterlogin li.first a,.header-v6-login-register.afterlogin li.last a,.post-title a,.ad-box .add-price span ,#classiads-featured-posts .ad-hover-content .post-title a ,#classiads-featured-posts .ad-box .add-price span ,.post-title-cat .post-title a,.category-btn a ,.cat-title h4 ,.more-btn-inner,.more-btn-inner a,#ads-homepage ul.tabs li a ,.subscribe_email #wp-subscribe h4.title,.single-slider .single-ad-price,.single-description .description-title,.detail-cat a,.author-form h3,#uploadTrigger,#latitude-field input, #longitude-field input,.ad-post-main #edit-submit, #edit-profile #edit-submit,.marker-info-title a,.marker-info-price ,.map-box-style-2 .marker-info-holder .add-price span,.map-box-style-2 .marker-info-title a,.map-box-style-2 .marker-info-left .feat-category,.map-box-style-3 .feat-category,.author-btn .button-ag,.search-bar-version2 .search-your-keyword-txt label,.search-bar-version3 #edit-submit-search-view span,.search-bar-version4 #edit-submit-search-view span,#classiads-featured-posts .ad-box .add-price span,.categories-homepage-vr-3 .category-title-v3 a h4,.categories-homepage-vr-3 .category-content-v3 ul li a,#ads-homepage.grid-vr-3 .feat-category,#ads-homepage.grid-vr-3 .ads-price-v2,.listing-ads-vr-3 .post-title-cat .post-title .list-post-price,#ads-homepage.grid-vr-2  .ad-box .add-price span,#ads-homepage.listing-ads-vr-2  .ad-box .add-price span,.plan-vr-2.single-plan #submit-plan,.location-version-3 .location-content a,.main_menu a,h4.block-title,.callout-inner h4,.callout-inner h4 span,.callout-inner p,.ad-title h2, .ad-title h2 a,.ad-title .ad-page-price aa.register-social-button-facebook,a.register-social-button-twitter,a.register-social-button-google,section#locations .location .span3 a,.my-ad-details a.my-ad-title,.my-ad-details span, .my-ad-details span a,.listing-ads .read-more-btn-inner a,.single-plan .product-title h3,.pro-price,.single-plan #submit-plan,.popular-title,.menu-v3 a,.log-forms #edit-submit,.log-forms input#edit-submit,.log-forms .register-page-title h5,.contact-meta .contact-single-meta h3,.page-template-template-profile-php .my-ad-box .post-title-my-ad a,.blog-date,.blog-month,.blog-title h2 a,.blog-title h2,.blog-btn,.blog-btn a,.blog-author-info .author-title h3,.related-post-title h3 a,.comments-header h3,.comment-author,.comment-title,.comment-reply a,.banner-text-one-h3-2,.banner-text-second-h2-2,.footer-menu #menu-footer li a ,.footer-menu #menu-footer li a,.woocommerce div.product .woocommerce-tabs ul.tabs li a,.woocommerce button.single_add_to_cart_button,.woocommerce ul.shop_table li.item-heading strong,ul.shop_table li .button,th,thead,td,.button,.classiads-payment-methods li label'),
            'default' => array(
                'font-family' => 'Montserrat',
                ),
         	),
		array(
            'id' => 'main-font-2',
            'type' => 'typography',
            'title' => __('Main Font 2', 'classiads'),
            'subtitle' => __('Specify the Main Font 2 properties.', 'classiads'),
            'google' => true,
			'color' => false,
			'subsets' => false,
			'text-align' => false,
			'font-size' => false,
			'font-weight' => false,
			'font-style' => false,
			'line-height' => false,
            'output' => array('.controls input ,.views-exposed-form .views-exposed-widget .btn-primary,#upload-ad .input-title input#postTitle ,#upload-ad .input-title input#post_location,#edit-profile .input-title input.text,#edit-profile .input-title textarea.text, .subscribe_email #wp-subscribe p,.subscribe_email #wp-subscribe p.text,.subscribe_email #wp-subscribe input.email-field,.subscribe_email #wp-subscribe input.submit,.plan-vr-2.single-plan .plan-tag,input[type="submit"],.sticky li p,.banner-text-third-2,.woocommerce ul.shop_attributes li strong'),
            'default' => array(
                'font-family' => 'Lato',
                ),
         	),
		),
	);

$sections[] = array(
	'icon' => 'el-icon-adjust',
	'icon_class' => 'icon-large',
    'title' => __('Colors', 'classiads'),
	'fields' => array(
		
		array(
			'id'       => 'header-bg-color',
	        'type'     => 'color',
	        'title'    => __('Header Background Color', 'classiads'),
	        'subtitle' => __('Header Background Color (default: #ffffff).', 'classiads'),
	        'default'  => '#ffffff',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'header-bg-sticky-color',
	        'type'     => 'color',
	        'title'    => __('Sticky Header Background Color', 'classiads'),
	        'subtitle' => __('Sticky Header Background Color (default: #ffffff).', 'classiads'),
	        'default'  => '#ffffff',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'ad-btn-bg-color',
	        'type'     => 'color',
	        'title'    => __('Make New Ad Button Background Color', 'classiads'),
	        'subtitle' => __('Pick a Make New Ad Button Background Color (default: #7bab47).', 'classiads'),
	        'default'  => '#7bab47',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'ad-btn-bg-hover-color',
	        'type'     => 'color',
	        'title'    => __('Make New Ad Button Hover Background Color', 'classiads'),
	        'subtitle' => __('Pick a Make New Ad Button Hover Background Color (default: #333333).', 'classiads'),
	        'default'  => '#333333',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'ad-btn-text-color',
	        'type'     => 'color',
	        'title'    => __('Make New Ad Text Color', 'classiads'),
	        'subtitle' => __('Pick a Make New Ad Button Text Color (default: #fff).', 'classiads'),
	        'default'  => '#fff',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'ad-btn-text-hover-color',
	        'type'     => 'color',
	        'title'    => __('Make New Ad Text Hover Color', 'classiads'),
	        'subtitle' => __('Pick a Make New Ad Button Text Color (default: #fff).', 'classiads'),
	        'default'  => '#fff',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'sm-sub-menu-bg-color',
	        'type'     => 'color',
	        'title'    => __('Small submenu background color', 'classiads'),
	        'subtitle' => __('Pick a Small submenu background color (default: #fff).', 'classiads'),
	        'default'  => '#fff',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'sm-sub-menu-bg-hover-color',
	        'type'     => 'color',
	        'title'    => __('Small submenu hover background color', 'classiads'),
	        'subtitle' => __('Pick a Small submenu hover background color (default: #f8f8f8).', 'classiads'),
	        'default'  => '#f8f8f8',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'sm-sub-menu-text-color',
	        'type'     => 'color',
	        'title'    => __('Small submenu text color', 'classiads'),
	        'subtitle' => __('Pick a Small submenu text color (default: #888888).', 'classiads'),
	        'default'  => '#888888',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'sm-sub-menu-text-hover-color',
	        'type'     => 'color',
	        'title'    => __('Small submenu hover text color', 'classiads'),
	        'subtitle' => __('Pick a Small submenu hover text color (default: #333333).', 'classiads'),
	        'default'  => '#333333',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'mg-sub-menu-bg-color',
	        'type'     => 'color',
	        'title'    => __('Mega Menu Background Color', 'classiads'),
	        'subtitle' => __('Pick a megamenu background color (default: #fff).', 'classiads'),
	        'default'  => '#fff',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'mg-sub-menu-text-color',
	        'type'     => 'color',
	        'title'    => __('Mega Menu Text Color', 'classiads'),
	        'subtitle' => __('Pick a megamenu text color (default: #888888).', 'classiads'),
	        'default'  => '#888888',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'mg-sub-menu-text-hover-color',
	        'type'     => 'color',
	        'title'    => __('Mega Menu Text Hover Color', 'classiads'),
	        'subtitle' => __('Pick a megamenu text hover color (default: #333333).', 'classiads'),
	        'default'  => '#333333',
	        'validate' => 'color',
	        'transparent' => false,
			),
		array(
			'id'       => 'color-primary',
	        'type'     => 'color',
	        'title'    => __('Primary Color', 'classiads'),
	        'subtitle' => __('Pick a Primary Color (default: #444).', 'classiads'),
	        'default'  => '#444',
	        'validate' => 'color',
	        'transparent' => false,
			),

		array(
			'id'       => 'color-main',
	        'type'     => 'color',
	        'title'    => __('Link Color', 'classiads'),
	        'subtitle' => __('Pick a color for link (default: #666).', 'classiads'),
	        'default'  => '#666',
	        'validate' => 'color',
	        'transparent' => false,
			),

		array(
			'id'       => 'color-main-hover',
	        'type'     => 'color',
	        'title'    => __('Hover/Active Link State Color', 'classiads'),
	        'subtitle' => __('Pick a color for hover/active link state (default: #e96969).', 'classiads'),
	        'default'  => '#e96969',
	        'validate' => 'color',
	        'transparent' => false,
			),

		array(
			'id'       => 'button-color-main',
	        'type'     => 'color',
	        'title'    => __('Buttons Color', 'classiads'),
	        'subtitle' => __('Pick a color for buttons (default: #f8f8f8).', 'classiads'),
	        'default'  => '#f8f8f8',
	        'validate' => 'color',
	        'transparent' => false,
			),

		array(
			'id'       => 'button-color-main-hover',
	        'type'     => 'color',
	        'title'    => __('Buttons Hover State Color', 'classiads'),
	        'subtitle' => __('Pick a color for buttons hover state (default: #e96969).', 'classiads'),
	        'default'  => '#e96969',
	        'validate' => 'color',
	        'transparent' => false,
			),

		),
	);

$sections[] = array(
	'icon' => 'el-icon-group',
	'icon_class' => 'icon-large',
    'title' => __('Social Links', 'classiads'),
	'fields' => array(

		array(
			'id'=>'facebook-link',
			'type' => 'text',
			'title' => __('Facebook Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'twitter-link',
			'type' => 'text',
			'title' => __('Twitter Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'dribbble-link',
			'type' => 'text',
			'title' => __('Dribbble Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'flickr-link',
			'type' => 'text',
			'title' => __('Flickr Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'github-link',
			'type' => 'text',
			'title' => __('Github Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'pinterest-link',
			'type' => 'text',
			'title' => __('Pinterest Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'youtube-link',
			'type' => 'text',
			'title' => __('Youtube Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'google-plus-link',
			'type' => 'text',
			'title' => __('Google+ Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'linkedin-link',
			'type' => 'text',
			'title' => __('LinkedIn Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'tumblr-link',
			'type' => 'text',
			'title' => __('Tumblr Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		array(
			'id'=>'vimeo-link',
			'type' => 'text',
			'title' => __('Vimeo Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),
			array(
			'id'=>'instagram-link',
			'type' => 'text',
			'title' => __('Instagram Page URL', 'classiads'),
			'subtitle' => __('This must be an URL.', 'classiads'),
			'desc' => __('', 'classiads'),
			'validate' => 'url',
			'default' => ''
			),

		),

	);
	$sections[] = array(
	'icon' => 'el-icon-website',
	'icon_class' => 'icon-large',
    'title' => __('Custom Ads', 'classiads'),
    'description' => __('These ads will be display on Homepage, Locations Page and Categories Page', 'classiads'),
	'fields' => array(

			array(
			'id'=>'page-ad-btn',
			'type' => 'button_set',
			'title' => __('Enable Ads Section', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'options' => array('1' => 'Custom Ads', '2' => 'Google Adsense'),//Must provide key => value pairs for radio options
			'default' => 1
			),
		array(
			'id'=>'home_ad1',
			'type' => 'media',
			'url'=> true,
			'title' => __('Ad 1', 'classiads'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload your Ad Image.', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'default'=>array('url'=>''),
            'required' => array( 'page-ad-btn', '=', '1' )
			),
		array(
			'id'=>'home_ad1_url',
			'type' => 'text',
			'title' => __('Ad 1 link URL', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('You can add URL.', 'classiads'),
			'default' => '',
			'validate' => 'url',
            'required' => array( 'page-ad-btn', '=', '1' )
			),
			array(
			'id'=>'home_ad2',
			'type' => 'media',
			'url'=> true,
			'title' => __('Ad 2', 'classiads'),
			'compiler' => 'true',
			//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
			'desc'=> __('Upload your Ad Image.', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'default'=>array('url'=>''),
            'required' => array( 'page-ad-btn', '=', '1' )
			),
		array(
			'id'=>'home_ad2_url',
			'type' => 'text',
			'title' => __('Ad 2 link URL', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('You can add URL.', 'classiads'),
			'default' => '',
			'validate' => 'url',
            'required' => array( 'page-ad-btn', '=', '1' )
			),
			array(
				'id'=>'googlead-tcode',
				'type' => 'textarea',
				'title' => __('Enter Here Google Adsense Code 1', 'classiads'),
				'subtitle' => __('', 'classiads'),
				'desc' => __('Enter here Your Google Adsense Code', 'classiads'),
				'default' => '',
            'required' => array( 'page-ad-btn', '=', '2' )
			),
			array(
				'id'=>'googlead-tcode2',
				'type' => 'textarea',
				'title' => __('Enter Here Google Adsense Code 2', 'classiads'),
				'subtitle' => __('', 'classiads'),
				'desc' => __('Enter here Your Google Adsense Code', 'classiads'),
				'default' => '',
            'required' => array( 'page-ad-btn', '=', '2' )
			),
		),
	);
	$sections[] = array(
	'icon' => 'el-icon-twitter',
	'icon_class' => 'icon-large',
    'title' => __('Twitter Api', 'classiads'),
	'fields' => array(

		array(
			'id'=>'consumer_key',
			'type' => 'text',
			'title' => __('Consumer Key', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'default' => ''
			),

		array(
			'id'=>'consumer_secret',
			'type' => 'text',
			'title' => __('Consumer Secret', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'default' => ''
			),

		array(
			'id'=>'access_token',
			'type' => 'text',
			'title' => __('User Access Token', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'default' => ''
			),

		array(
			'id'=>'access_token_secret',
			'type' => 'text',
			'title' => __('User Access Token Secret', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'default' => ''
			),



		),
	);

$sections[] = array(
  		'title' => esc_html__('Currency Settings', 'classiads'),
  		'desc' => esc_html__('', 'classiads'),
  		'icon' => 'el-icon-shopping-cart',
  		'fields' => array(
		array(
		'id' => 'currency-setup',
		'type' => 'button_set',
		'title' => esc_html__('Currency Setup','classiads'),
		'subtitle' => esc_html__('', 'classiads'),
		'desc' => esc_html__('','classiads'),
		'options' => array(
		'cs-new' => esc_html__('Currency Setup New','classiads'),
		'cs-old' => esc_html__('Currency Setup Old','classiads')
		),
		'default' => 'cs-new',
		),
		array(
			'id'=>'postcurrency',
			'type' => 'text',
			'required' => array('currency-setup', 'equals', 'cs-old'),
			'title' => __('Please Put here your own currency sign for new ad post price field.', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('Leave empty if you do not want to dictate this for user.', 'classiads'),
			'default' => ''
			),
		array(
		'id' => 'sign-code',
		'type' => 'button_set',
		'required' => array('currency-setup', 'equals', 'cs-new'),
		'title' => esc_html__('Select Currency Sign / Code','classiads'),
		'subtitle' => esc_html__('', 'classiads'),
		'desc' => esc_html__('','classiads'),
		'options' => array(
		'sign' => esc_html__('Currency Sign','classiads'),
		'code' => esc_html__('Currency Code','classiads')
		),
		'default' => 'sign',
		),
  		array(
  		  'id' => 'currency-sign',
          'type' => 'text',
  		  'required' => array('sign-code', 'equals', 'sign'),
          'title' => esc_html__('Currency Sign','classiads'),
          'desc' => esc_html__('','classiads'),
          'default' => '$',
  			),
  		array(
  			'id' => 'currency-code',
          'type' => 'select',
  				'required' => array('sign-code', 'equals', 'code'),
          'title' => esc_html__('Currency Sign','classiads'),
          'desc' => esc_html__('','classiads'),
          "options" => array(
             "AED" => "United Arab Emirates dirham (&#x62f;.&#x625;)",
             "AFN" => "Afghan afghani (&#x60b;)",
             "ALL" => "Albanian lek (L)",
             "AMD" => "Armenian dram (AMD)",
             "ANG" => "Netherlands Antillean guilder (&fnof;)",
             "AOA" => "Angolan kwanza (Kz)",
             "ARS" => "Argentine peso (&#36;)",
             "AUD" => "Australian dollar (&#36;)",
             "AWG" => "Aruban florin (&fnof;)",
             "AZN" => "Azerbaijani manat (AZN)",
             "BAM" => "Bosnia and Herzegovina convertible mark (KM)",
             "BBD" => "Barbadian dollar (&#36;)",
             "BDT" => "Bangladeshi taka (&#2547;&nbsp;)",
             "BGN" => "Bulgarian lev (&#1083;&#1074;.)",
             "BHD" => "Bahraini dinar (.&#x62f;.&#x628;)",
             "BIF" => "Burundian franc (Fr)",
             "BMD" => "Bermudian dollar (&#36;)",
             "BND" => "Brunei dollar (&#36;)",
             "BOB" => "Bolivian boliviano (Bs.)",
             "BRL" => "Brazilian real (&#82;&#36;)",
             "BSD" => "Bahamian dollar (&#36;)",
             "BTC" => "Bitcoin (&#3647;)",
             "BTN" => "Bhutanese ngultrum (Nu.)",
             "BWP" => "Botswana pula (P)",
             "BYR" => "Belarusian ruble (Br)",
             "BZD" => "Belize dollar (&#36;)",
             "CAD" => "Canadian dollar (&#36;)",
             "CDF" => "Congolese franc (Fr)",
             "CHF" => "Swiss franc (&#67;&#72;&#70;)",
             "CLP" => "Chilean peso (&#36;)",
             "CNY" => "Chinese yuan (&yen;)",
             "COP" => "Colombian peso (&#36;)",
             "CRC" => "Costa Rican col&oacute;n (&#x20a1;)",
             "CUC" => "Cuban convertible peso (&#36;)",
             "CUP" => "Cuban peso (&#36;)",
             "CVE" => "Cape Verdean escudo (&#36;)",
             "CZK" => "Czech koruna (&#75;&#269;)",
             "DJF" => "Djiboutian franc (Fr)",
             "DKK" => "Danish krone (DKK)",
             "DOP" => "Dominican peso (RD&#36;)",
             "DZD" => "Algerian dinar (&#x62f;.&#x62c;)",
             "EGP" => "Egyptian pound (EGP)",
             "ERN" => "Eritrean nakfa (Nfk)",
             "ETB" => "Ethiopian birr (Br)",
             "EUR" => "Euro (&euro;)",
             "FJD" => "Fijian dollar (&#36;)",
             "FKP" => "Falkland Islands pound (&pound;)",
             "GBP" => "Pound sterling (&pound;)",
             "GEL" => "Georgian lari (&#x10da;)",
             "GGP" => "Guernsey pound (&pound;)",
             "GHS" => "Ghana cedi (&#x20b5;)",
             "GIP" => "Gibraltar pound (&pound;)",
             "GMD" => "Gambian dalasi (D)",
             "GNF" => "Guinean franc (Fr)",
             "GTQ" => "Guatemalan quetzal (Q)",
             "GYD" => "Guyanese dollar (&#36;)",
             "HKD" => "Hong Kong dollar (&#36;)",
             "HNL" => "Honduran lempira (L)",
             "HRK" => "Croatian kuna (Kn)",
             "HTG" => "Haitian gourde (G)",
             "HUF" => "Hungarian forint (&#70;&#116;)",
             "IDR" => "Indonesian rupiah (Rp)",
             "ILS" => "Israeli new shekel (&#8362;)",
             "IMP" => "Manx pound (&pound;)",
             "INR" => "Indian rupee (&#8377;)",
             "IQD" => "Iraqi dinar (&#x639;.&#x62f;)",
             "IRR" => "Iranian rial (&#xfdfc;)",
             "ISK" => "Icelandic kr&oacute;na (Kr.)",
             "JEP" => "Jersey pound (&pound;)",
             "JMD" => "Jamaican dollar (&#36;)",
             "JOD" => "Jordanian dinar (&#x62f;.&#x627;)",
             "JPY" => "Japanese yen (&yen;)",
             "KES" => "Kenyan shilling (KSh)",
             "KGS" => "Kyrgyzstani som (&#x43b;&#x432;)",
             "KHR" => "Cambodian riel (&#x17db;)",
             "KMF" => "Comorian franc (Fr)",
             "KPW" => "North Korean won (&#x20a9;)",
             "KRW" => "South Korean won (&#8361;)",
             "KWD" => "Kuwaiti dinar (&#x62f;.&#x643;)",
             "KYD" => "Cayman Islands dollar (&#36;)",
             "KZT" => "Kazakhstani tenge (KZT)",
             "LAK" => "Lao kip (&#8365;)",
             "LBP" => "Lebanese pound (&#x644;.&#x644;)",
             "LKR" => "Sri Lankan rupee (&#xdbb;&#xdd4;)",
             "LRD" => "Liberian dollar (&#36;)",
             "LSL" => "Lesotho loti (L)",
             "LYD" => "Libyan dinar (&#x644;.&#x62f;)",
             "MAD" => "Moroccan dirham (&#x62f;.&#x645;.)",
             "MDL" => "Moldovan leu (L)",
             "MGA" => "Malagasy ariary (Ar)",
             "MKD" => "Macedonian denar (&#x434;&#x435;&#x43d;)",
             "MMK" => "Burmese kyat (Ks)",
             "MNT" => "Mongolian t&ouml;gr&ouml;g (&#x20ae;)",
             "MOP" => "Macanese pataca (P)",
             "MRO" => "Mauritanian ouguiya (UM)",
             "MUR" => "Mauritian rupee (&#x20a8;)",
             "MVR" => "Maldivian rufiyaa (.&#x783;)",
             "MWK" => "Malawian kwacha (MK)",
             "MXN" => "Mexican peso (&#36;)",
             "MYR" => "Malaysian ringgit (&#82;&#77;)",
             "MZN" => "Mozambican metical (MT)",
             "NAD" => "Namibian dollar (&#36;)",
             "NGN" => "Nigerian naira (&#8358;)",
             "NIO" => "Nicaraguan c&oacute;rdoba (C&#36;)",
             "NOK" => "Norwegian krone (&#107;&#114;)",
             "NPR" => "Nepalese rupee (&#8360;)",
             "NZD" => "New Zealand dollar (&#36;)",
             "OMR" => "Omani rial (&#x631;.&#x639;.)",
             "PAB" => "Panamanian balboa (B/.)",
             "PEN" => "Peruvian nuevo sol (S/.)",
             "PGK" => "Papua New Guinean kina (K)",
             "PHP" => "Philippine peso (&#8369;)",
             "PKR" => "Pakistani rupee (&#8360;)",
             "PLN" => "Polish z&#x142;oty (&#122;&#322;)",
             "PRB" => "Transnistrian ruble (&#x440;.)",
             "PYG" => "Paraguayan guaran&iacute; (&#8370;)",
             "QAR" => "Qatari riyal (&#x631;.&#x642;)",
             "RON" => "Romanian leu (lei)",
             "RSD" => "Serbian dinar (&#x434;&#x438;&#x43d;.)",
             "RUB" => "Russian ruble (&#8381;)",
             "RWF" => "Rwandan franc (Fr)",
             "SAR" => "Saudi riyal (&#x631;.&#x633;)",
             "SBD" => "Solomon Islands dollar (&#36;)",
             "SCR" => "Seychellois rupee (&#x20a8;)",
             "SDG" => "Sudanese pound (&#x62c;.&#x633;.)",
             "SEK" => "Swedish krona (&#107;&#114;)",
             "SGD" => "Singapore dollar (&#36;)",
             "SHP" => "Saint Helena pound (&pound;)",
             "SLL" => "Sierra Leonean leone (Le)",
             "SOS" => "Somali shilling (Sh)",
             "SRD" => "Surinamese dollar (&#36;)",
             "SSP" => "South Sudanese pound (&pound;)",
             "STD" => "S&atilde;o Tom&eacute; and Pr&iacute;ncipe dobra (Db)",
             "SYP" => "Syrian pound (&#x644;.&#x633;)",
             "SZL" => "Swazi lilangeni (L)",
             "THB" => "Thai baht (&#3647;)",
             "TJS" => "Tajikistani somoni (&#x405;&#x41c;)",
             "TMT" => "Turkmenistan manat (m)",
             "TND" => "Tunisian dinar (&#x62f;.&#x62a;)",
             "TOP" => "Tongan pa&#x2bb;anga (T&#36;)",
             "TRY" => "Turkish lira (&#8378;)",
             "TTD" => "Trinidad and Tobago dollar (&#36;)",
             "TWD" => "New Taiwan dollar (&#78;&#84;&#36;)",
             "TZS" => "Tanzanian shilling (Sh)",
             "UAH" => "Ukrainian hryvnia (&#8372;)",
             "UGX" => "Ugandan shilling (UGX)",
             "USD" => "United States dollar (&#36;)",
             "UYU" => "Uruguayan peso (&#36;)",
             "UZS" => "Uzbekistani som (UZS)",
             "VEF" => "Venezuelan bol&iacute;var (Bs F)",
             "VND" => "Vietnamese &#x111;&#x1ed3;ng (&#8363;)",
             "VUV" => "Vanuatu vatu (Vt)",
             "WST" => "Samoan t&#x101;l&#x101; (T)",
             "XAF" => "Central African CFA franc (Fr)",
             "XCD" => "East Caribbean dollar (&#36;)",
             "XOF" => "West African CFA franc (Fr)",
             "XPF" => "CFP franc (Fr)",
             "YER" => "Yemeni rial (&#xfdfc;)",
             "ZAR" => "South African rand (&#82;)",
             "ZMW" => "Zambian kwacha (ZK)"
          ),
          'default' => 'USD',
  		),
        array(
          'id' => 'currency-position',
          'type' => 'select',
		'required' => array('currency-setup', 'equals', 'cs-new'),
          'title' => esc_html__('Currency Position','classiads'),
  				'subtitle' => esc_html__('Prefix / Suffix', 'classiads'),
          'desc' => esc_html__('','classiads'),
          'options' => array(
            'p' => esc_html__('Prefix - &#36;10','classiads'),
            's' => esc_html__('Suffix - 10&#36;','classiads')
          ),
          'default' => 'p',
        ),
        array(
          'id' => 'currency-decimals',
          'type' => 'text',
		'required' => array('currency-setup', 'equals', 'cs-new'),
          'title' => esc_html__('Decimal Places (required)','classiads'),
  				'subtitle' => esc_html__('', 'classiads'),
          'desc' => esc_html__('','classiads'),
          'default' => '00',
        ),
        array(
          'id' => 'currency-char-decimal',
          'type' => 'text',
		'required' => array('currency-setup', 'equals', 'cs-new'),
          'title' => esc_html__('Decimal Separator','classiads'),
  				'subtitle' => esc_html__('', 'classiads'),
          'desc' => esc_html__('','classiads'),
          'default' => '.',
        ),
        array(
          'id' => 'currency-char-thousand',
          'type' => 'text',
			'required' => array('currency-setup', 'equals', 'cs-new'),
          'title' => esc_html__('Thousands Separator','classiads'),
  				'subtitle' => esc_html__('', 'classiads'),
          'desc' => esc_html__('','classiads'),
          'default' => ',',
        )
  		),
  	);
	
	$sections[] = array(
		'title' => esc_html__('Payment Gateways', 'classiads'),
		'desc' => esc_html__('', 'classiads'),
		'icon' => 'el-icon-website',
	);
$sections[] = array(
	'icon' => 'el-icon-cogs',
	'icon_class' => 'icon-large',
    'title' => __('Paypal Settings', 'classiads'),
	'subsection' => true,
	'fields' => array(
		
		array(
			'id' => 'paypal-method',
			'type' => 'switch',
			'title' => esc_html__('Enable/Disable', 'classiads'),
			'subtitle' => esc_html__('Paypal Payment Method.', 'classiads'),
			'desc' => esc_html__('', 'classiads'),
			"default" => 0,
			'on' => 'Enable',
			'off' => 'Disable',
		),
		array(
			'id'=>'paypal_api_environment',
			'type' => 'radio',
			'title' => __('PayPal environment', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'options' => array('1' => 'Sandbox - Testing', '2' => 'Live - Production'),//Must provide key => value pairs for radio options
			'default' => 1
			),

		array(
			'id'=>'paypal_api_username',
			'type' => 'text',
			'title' => __('API Username (required)', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'default' => ''
			),

		array(
			'id'=>'paypal_api_password',
			'type' => 'password',
			'title' => __('API Password (required)', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'default' => ''
			),

		array(
			'id'=>'paypal_api_signature',
			'type' => 'password',
			'title' => __('API Signature (required)', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'default' => ''
			),		
		array(			
			'id'=>'paypal_payment_message',			
			'type' => 'textarea',			
			'title' => __('Description about Paypal Payment Method', 'classiads'),			
			'desc' => __('', 'classiads'),			
			'default' => ''			
			),
		array(
			'id'=>'currency_code',
			'type' => 'select',
			'title' => __('Currency', 'classiads'),
			'subtitle' => __('Select your currency.', 'classiads'),
			'options' => array('AUD'=>'Australian Dollar', 'CAD'=>'Canadian Dollar', 'CZK'=>'Czech Koruna', 'DKK'=>'Danish Krone', 'EUR'=>'Euro', 'HKD'=>'Hong Kong Dollar', 'HUF'=>'Hungarian Forint', 'JPY'=>'Japanese Yen', 'MYR'=>'Malaysian Ringgit ','MXN'=>'Mexican Peso ','NOK'=>'Norwegian Krone', 'NZD'=>'New Zealand Dollar', 'PHP'=>'Philippine Peso','PLN'=>'Polish Zloty', 'GBP'=>'Pound Sterling', 'SEK'=>'Swedish Krona', 'SGD'=>'Singapore Dollar', 'CHF'=>'Swiss Franc', 'USD'=>'U.S. Dollar','BRL'=>'Brazilian Real',),
			'default' => 'USD',
			),
		),
	);
$sections[] = array(
	'icon' => 'el-icon-cogs',
	'icon_class' => 'icon-large',
    'title' => __('Authorized Settings', 'classiads'),
	'subsection' => true,
		'fields' => array(
			array(
				'id' => 'authorized-method',
				'type' => 'switch',
				'title' => esc_html__('Enable/Disable', 'classiads'),
				'subtitle' => esc_html__('Authorize Payment Method.', 'classiads'),
				'desc' => esc_html__('', 'classiads'),
				"default" => 0,
				'on' => 'Enable',
				'off' => 'Disable',
			),
		array(
			'id'=>'authorized_api_environment',
			'type' => 'radio',
			'title' => __('Authorized environment', 'classiads'),
			'subtitle' => __('', 'classiads'),
			'desc' => __('', 'classiads'),
			'options' => array('1' => 'Sandbox - Testing', '2' => 'Live - Production'),//Must provide key => value pairs for radio options
			'default' => 1
			),
			array(
				'id' => 'authorize-description',
				'type' => 'textarea',
				'title' => esc_html__('Description', 'classiads'),
				'subtitle' => esc_html__('', 'classiads'),
				'desc' => esc_html__('This controls the description which the user sees during checkout.', 'classiads'),
				'default' => '',
			),
			array(
				'id' => 'authorize-login-id',
				'type' => 'password',
				'title' => esc_html__('Login ID', 'classiads'),
				'subtitle' => esc_html__('', 'classiads'),
				'desc' => __('This is API Login ID <a href="https://www.authorize.net/support/CP/helpfiles/Account/Settings/Security_Settings/General_Settings/API_Login_ID_and_Transaction_Key.htm" target="_blank">How to Get</a>', 'classiads'),
        'default' => '',
			),
      array(
        'id' => 'authorize-transaction-key',
        'type' => 'password',
        'title' => esc_html__('Transaction Key','classiads'),
        'desc' => __('Transaction Key API <a href="https://www.authorize.net/support/CP/helpfiles/Account/Settings/Security_Settings/General_Settings/API_Login_ID_and_Transaction_Key.htm" target="_blank">How to Get</a>','classiads'),
        'default' => '',
      ),
      array(
        'id' => 'authorize-md5-hash-key',
        'type' => 'password',
        'title' => esc_html__('MD5 Hash Key','classiads'),
        'desc' => __('MD5 Hash Key is required to validate the response from Authorize.net. Refer:  <a href="http://www.indatos.com/developer-documentation/md5-hash-security-feature-authorize-net/?ref=auth-sim" target="_blank">MD5 Security</a> Feature for help.','classiads'),
        'default' => '',
      ),
      array(
        'id' => 'authorize-success-msg',
        'type' => 'textarea',
        'title' => esc_html__('Transaction Success Message','classiads'),
        'desc' => esc_html__('Message to be displayed on successful transaction.','classiads'),
        'default' => '',
      ),
      array(
        'id' => 'authorize-failed-msg',
        'type' => 'textarea',
        'title' => esc_html__('Transaction Failed Message','classiads'),
        'desc' => esc_html__('Message to be displayed on failed transaction.','classiads'),
        'default' => '',
      ),
		),
	);
	
$sections[] = array(
	'icon' => 'el-icon-cogs',
	'icon_class' => 'icon-large',
    'title' => __('Direct Bank', 'classiads'),
	'subsection' => true,
		'fields' => array(			array(				'id' => 'directbank-method',				'type' => 'switch',				'title' => esc_html__('Enable/Disable', 'classiads'),				'subtitle' => esc_html__('Direct Bank Method.', 'classiads'),				'desc' => esc_html__('', 'classiads'),				"default" => 0,				'on' => 'Enable',				'off' => 'Disable',			),
			array(
				'id' => 'directbank-description',
				'type' => 'textarea',
				'title' => esc_html__('Description', 'classiads'),
				'subtitle' => esc_html__('', 'classiads'),
				'desc' => esc_html__('This controls the description which the user sees during checkout.', 'classiads'),
				'default' => '',
			),
			array(
				'id' => 'directbank-success-msg',
				'type' => 'textarea',
				'title' => esc_html__('Transaction Success Message','classiads'),
				'desc' => esc_html__('Message to be displayed on successful transaction.','classiads'),
				'default' => '',
			),
			array(
				'id' => 'directbank-failed-msg',
				'type' => 'textarea',
				'title' => esc_html__('Transaction Failed Message','classiads'),
				'desc' => esc_html__('Message to be displayed on failed transaction.','classiads'),
				'default' => '',
			),
		),
	);
	
if (function_exists('wp_get_theme')){
	$theme_data = wp_get_theme();
	$theme_uri = $theme_data->get('ThemeURI');
	$description = $theme_data->get('Description');
	$author = $theme_data->get('Author');
	$version = $theme_data->get('Version');
	$tags = $theme_data->get('Tags');
}else{
	$theme_data = wp_get_theme(trailingslashit(get_stylesheet_directory()).'style.css');
	$theme_uri = $theme_data['URI'];
	$description = $theme_data['Description'];
	$author = $theme_data['Author'];
	$version = $theme_data['Version'];
	$tags = $theme_data['Tags'];
}
$theme_info = '<div class="redux-framework-section-desc">';
$theme_info .= '<p class="redux-framework-theme-data description theme-uri">'.__('<strong>Theme URL:</strong> ', 'classiads').'<a href="'.$theme_uri.'" target="_blank">'.$theme_uri.'</a></p>';
$theme_info .= '<p class="redux-framework-theme-data description theme-author">'.__('<strong>Author:</strong> ', 'classiads').$author.'</p>';
$theme_info .= '<p class="redux-framework-theme-data description theme-version">'.__('<strong>Version:</strong> ', 'classiads').$version.'</p>';
$theme_info .= '<p class="redux-framework-theme-data description theme-description">'.$description.'</p>';
if ( !empty( $tags ) ) {
	$theme_info .= '<p class="redux-framework-theme-data description theme-tags">'.__('<strong>Tags:</strong> ', 'classiads').implode(', ', $tags).'</p>';
}
$theme_info .= '</div>';
if(file_exists(dirname(__FILE__).'/README.md')){
	$sections['theme_docs'] = array(
		'icon' => ReduxFramework::$_url.'assets/img/glyphicons/glyphicons_071_book.png',
		'title' => __('Documentation', 'classiads'),
		'fields' => array(
			array(
				'id'=>'17',
				'type' => 'raw',
				'content' => file_get_contents(dirname(__FILE__).'/README.md')
				),
		),
	);
}
$sections[] = array(
	'icon' => 'el-icon-info-sign',
	'title' => __('Theme Information', 'classiads'),
	'desc' => __('<p class="description">This is the Description. Again HTML is allowed</p>', 'classiads'),
	'fields' => array(
		array(
			'id'=>'raw_new_info',
			'type' => 'raw',
			'content' => $item_info,
			)
		),
	);
	
$sections[] = array(
	'icon' => 'el-icon-info-sign',
	'title' => __('Custom Code', 'classiads'),
	'desc' => __('<p class="description"></p>', 'classiads'),
	'fields' => array(
			array(
				'id'       => 'css_editor',
				'type'     => 'ace_editor',
				'title'    => __('CSS Code', 'classiads'),
				'subtitle' => __('Paste your CSS code here.', 'classiads'),
				'mode'     => 'css',
				'theme'    => 'monokai',
				'desc'     => 'Enter Here Your Custom Css Code.',
				'default'  => "#header{\nmargin: 0 auto;\n}"
			),
			array(
				'id'       => 'js_editor',
				'type'     => 'ace_editor',
				'title'    => __('Javascript Code', 'classiads'),
				'subtitle' => __('Paste your Javascript code here.', 'classiads'),
				'mode'     => 'javascript',
				'theme'    => 'chroome',
				'desc'     => 'Enter Here Your Custom Javascript Code.',
				'default'  => "fucntion(){\n //alert('Hello World'); \n}"
			)
		),
	);
	


if(file_exists(trailingslashit(dirname(__FILE__)) . 'README.html')) {
    $tabs['docs'] = array(
		'icon' => 'el-icon-book',
		'icon_class' => 'icon-large',
        'title' => __('Documentation', 'classiads'),
        'content' => nl2br(file_get_contents(trailingslashit(dirname(__FILE__)) . 'README.html'))
    );
}

global $ReduxFramework;
$ReduxFramework = new ReduxFramework($sections, $args, $tabs);

// END Sample Config


/**

	Filter hook for filtering the args array given by a theme, good for child themes to override or add to the args array.

**/
function change_framework_args($args){
    //$args['dev_mode'] = true;

    return $args;
}
add_filter('redux/options/redux_demo/args', 'change_framework_args');
// replace redux_demo with your opt_name

/**

	Filter hook for filtering the default value of any given field. Very useful in development mode.

**/
function change_option_defaults($defaults){
    $defaults['str_replace'] = "Testing filter hook!";

    return $defaults;
}
add_filter('redux/options/redux_demo/defaults', 'change_option_defaults');
// replace redux_demo with your opt_name


/**

	Custom function for the callback referenced above

 */
function my_custom_field($field, $value) {
    print_r($field);
    print_r($value);
}


/**

	Custom function for the callback validation referenced above

**/
function validate_callback_function($field, $value, $existing_value) {
    $error = false;
    $value =  'just testing';
    /*
    do your validation

    if(something) {
        $value = $value;
    } elseif(something else) {
        $error = true;
        $value = $existing_value;
        $field['msg'] = 'your custom error message';
    }
    */

    $return['value'] = $value;
    if($error == true) {
        $return['error'] = $field;
    }
    return $return;
}

/**

	This is a test function that will let you see when the compiler hook occurs.
	It only runs if a field	set with compiler=>true is changed.

**/
function testCompiler() {
	echo "Compiler hook!";
}
//add_filter('redux/options/redux_demo/compiler', 'testCompiler');
// replace redux_demo with your opt_name




/**

	Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.

**/
if ( class_exists('ReduxFrameworkPlugin') ) {
	//remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );
}


/**

	Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.

**/
function removeDemoModeLink() {
	if ( class_exists('ReduxFrameworkPlugin') ) {
		remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_meta_demo_mode_link'), null, 2 );
	}
}
add_action('init', 'removeDemoModeLink');
