<?php
	// Post latitude
	add_action( 'add_meta_boxes', 'post_latitude' );
	function post_latitude() {
	    add_meta_box(
	        'post_latitude',
	        __( 'Latitude', 'classiads' ),
	        'post_latitude_content',
	        'post',
			'side',
	        'high'

	    );
	}

	function post_latitude_content( $post ) {
		wp_nonce_field( 'myplugin_meta_boxe', 'myplugin_meta_box_noncee' );
		$post_latitude = get_post_meta( $post->ID, 'post_latitude', true );

		echo '<label for="post_latitude"></label>';
		echo '<input type="text" id="post_latitude" name="post_latitude" placeholder="'._e('Enter location here','classiads').'" value="';
		echo $post_latitude;
		echo '">';

	}

	add_action( 'save_post', 'post_latitude_save' );
	function post_latitude_save( $post_id ) {

		global $post_latitude;
		if ( ! isset( $_POST['myplugin_meta_box_noncee'] ) ) {
		return;
		}
		if ( ! wp_verify_nonce( $_POST['myplugin_meta_box_noncee'], 'myplugin_meta_boxe' ) ) {
			return;
		}
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		if(isset($_POST["post_latitude"]))
		$post_latitude = $_POST['post_latitude'];
		update_post_meta( $post_id, 'post_latitude', $post_latitude );

	}

	// Post longitude
	add_action( 'add_meta_boxes', 'post_longitude' );
	function post_longitude() {
	    add_meta_box(
	        'post_longitude',
	        __( 'Longitude', 'classiads' ),
	        'post_longitude_content',
	        'post',
	        'side',
	        'high'
	    );
	}

	function post_longitude_content( $post ) {

		wp_nonce_field( 'myplugin_meta_box', 'myplugin_meta_box_nonce' );

		$post_longitude = get_post_meta( $post->ID, 'post_longitude', true );

		echo '<label for="post_longitude"></label>';
		echo '<input type="text" id="post_longitude" name="post_longitude" placeholder="'._e('Enter location here','classiads').'" value="';
		echo $post_longitude;
		echo '">';

	}

	add_action( 'save_post', 'post_longitude_save' );
	function post_longitude_save( $post_id ) {
	global $post_longitude;

	if ( ! isset( $_POST['myplugin_meta_box_nonce'] ) ) {
		return;
	}
	if ( ! wp_verify_nonce( $_POST['myplugin_meta_box_nonce'], 'myplugin_meta_box' ) ) {
		return;
	}
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}



		if(isset($_POST["post_longitude"]))
		$post_longitude = $_POST['post_longitude'];
		update_post_meta( $post_id, 'post_longitude', $post_longitude );

	}

	$location_labels = array(
		'name' => __( 'Location', 'classiads' ),
		'singular_name' => __( 'Location', 'classiads' ),
		'search_items' =>  __( 'Search Locations', 'classiads' ),
		'popular_items' => __( 'Popular Locations', 'classiads' ),
		'all_items' => __( 'All Locations', 'classiads' ),
		'parent_item' => __( 'Parent Location', 'classiads' ),
		'parent_item_colon' => __( 'Parent Location:', 'classiads' ),
		'edit_item' => __( 'Edit Location', 'classiads' ),
		'update_item' => __( 'Update Location', 'classiads' ),
		'add_new_item' => __( 'Add New Location', 'classiads' ),
		'new_item_name' => __( 'New Location Name', 'classiads' ),
		'separate_items_with_commas' => __( 'Separate Locations with commas', 'classiads' ),
		'add_or_remove_items' => __( 'Add or remove Location', 'classiads' ),
		'choose_from_most_used' => __( 'Choose from the most used Locations', 'classiads' ),
		'menu_name' => __( 'Locations', 'classiads' )
	);
	register_taxonomy("location",
			array("post"),
			 array("hierarchical" => true,
			 'labels' => $location_labels,
			 'show_ui' => true,
                'query_var' => true,
                'rewrite' => array('slug' => __('location', 'classiads'))
			 )
		 );

?>
