<?php
add_theme_support( 'post-formats', array( 'gallery', 'video', 'audio' ) );
remove_post_type_support( 'blog', 'post-formats' );
add_post_type_support( 'blog', 'post-formats', array( 'gallery', 'video', 'audio' ) );
/* ================================================================================== */
/*      Add metabox
/* ================================================================================== */
add_action('admin_init', 'minelife_custom_box');
if (!function_exists('minelife_custom_box')) {
    function minelife_custom_box() {
        global $minelife_gallery,$minelife_video;
        add_meta_box('minelife_gallery_settings',__( 'Gallery settings', 'classiads' ),'settings_gallery','blog','normal','high');
        add_meta_box('minelife_video_settings',__( 'Video settings (Video URL (oEmbed) or Embed Code)', 'classiads' ),'minelife_video_callback','blog','normal','high');
        add_meta_box('minelife_audio_settings',__( 'Audio settings (Audio URL (oEmbed) or Embed Code)', 'classiads' ),'minelife_audio_callback','blog','normal','high');

    }
}

/* ================================================================================== */
/*      Gallery Callback
/* ================================================================================== */
if (!function_exists('settings_gallery')) {
    function settings_gallery(){
        global $post;
        $meta = get_post_meta( $post->ID, 'gallery_image_ids', true );
        $gallery_thumbs = '';
        $button_text = ($meta) ? __('Edit Gallery', 'classiads') : __('Upload Images', 'classiads');
        if( $meta ) {
            $thumbs = explode(',', $meta);
            foreach( $thumbs as $thumb ) {
                $gallery_thumbs .= '<li>' . wp_get_attachment_image( $thumb, array(32,32) ) . '</li>';
            }
        }


		?>
        <tr>

            <td>
                <input type="button" class="button" name="gallery_image_ids" id="gallery_images_upload" value="<?php echo$button_text; ?>" />
                <input type="hidden" name="gallery_image_ids" id="gallery_image_ids" value="<?php echo $meta ? $meta : 'false'; ?>" />
                <ul class="gallery-thumbs"><?php echo $gallery_thumbs;?></ul>
            </td>
        </tr><?php
    }
}
/* ================================================================================== */
/*      Save gallery images
/* ================================================================================== */

function minelife_save_images() {

	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
		return;

	if ( !isset($_POST['ids']) || !isset($_POST['nonce']) || !wp_verify_nonce( $_POST['nonce'], 'minelife-ajax' ) )
		return;

	if ( !current_user_can( 'edit_posts' ) ) return;

	$ids = strip_tags(rtrim($_POST['ids'], ','));
	update_post_meta($_POST['post_id'], 'gallery_image_ids', $ids);

	// update thumbs
	$thumbs = explode(',', $ids);
	$gallery_thumbs = '';
	foreach( $thumbs as $thumb ) {
		$gallery_thumbs .= '<li>' . wp_get_attachment_image( $thumb, array(32,32) ) . '</li>';
	}

	echo wp_kses_post($gallery_thumbs);

	die();
}
add_action('wp_ajax_minelife_save_images', 'minelife_save_images');

/* ================================================================================== */
/*      Video Callback
/* ================================================================================== */
if (!function_exists('minelife_video_callback')) {
function minelife_video_callback( $post ) {
		wp_nonce_field( 'minelife_metabox', 'minelife_metabox_nonce' );
		$video_content = get_post_meta( $post->ID, 'video_content', true );

		echo '<textarea id="video_content" name="video_content" placeholder="'._e('Enter Your Embed code Or Video URL','classiads').'">';
		echo wp_kses_post($video_content);
		echo '</textarea>';

	}
}

/* ================================================================================== */
/*      Save video
/* ================================================================================== */
add_action( 'save_post', 'minelife_video_save' );
	function minelife_video_save( $post_id ) {

		global $video_content;

		if ( ! isset( $_POST['minelife_metabox_nonce'] ) ) {
		return;
		}
		if ( ! wp_verify_nonce( $_POST['minelife_metabox_nonce'], 'minelife_metabox' ) ) {
			return;
		}
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		if(isset($_POST["video_content"]))
		$video_content = $_POST['video_content'];
		update_post_meta( $post_id, 'video_content', $video_content );

	}


/* ================================================================================== */
/*      Audio Callback
/* ================================================================================== */
if (!function_exists('minelife_audio_callback')) {
function minelife_audio_callback( $post ) {
		wp_nonce_field( 'minelife_metabox', 'minelife_metabox_nonce' );
		$audio_content = get_post_meta( $post->ID, 'audio_content', true );

		echo '<textarea id="audio_content" name="audio_content" placeholder="'._e('Enter Your Embed code Or audio URL','classiads').'">';
		echo wp_kses_post($audio_content);
		echo '</textarea>';

	}
}

/* ================================================================================== */
/*      Save Audio
/* ================================================================================== */
add_action( 'save_post', 'minelife_audio_save' );
	function minelife_audio_save( $post_id ) {

		global $audio_content;

		if ( ! isset( $_POST['minelife_metabox_nonce'] ) ) {
		return;
		}
		if ( ! wp_verify_nonce( $_POST['minelife_metabox_nonce'], 'minelife_metabox' ) ) {
			return;
		}
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		if(isset($_POST["audio_content"]))
		$audio_content = $_POST['audio_content'];
		update_post_meta( $post_id, 'audio_content', $audio_content );

	}
