<?php

function post_type_blog() {
	$labels = array(
		'name' => _x('Blog Posts', 'post type general name', 'classiads'),
		'singular_name' => _x('Blog Post', 'post type singular name', 'classiads'),
		'add_new' => _x('Add New Blog Post', 'book', 'classiads'),
		'add_new_item' => __('Add New Blog Post', 'classiads'),
		'edit_item' => __('Edit Blog Post', 'classiads'),
		'new_item' => __('New Blog Post', 'classiads'),
		'view_item' => __('View Post', 'classiads'),
		'search_items' => __('Search Blog Post', 'classiads'),
		'not_found' =>  __('No Blog Post found', 'classiads'),
		'not_found_in_trash' => __('No Blog Post found in Trash', 'classiads'),
		'parent_item_colon' => ''
	);
	$args = array(
		'labels' => $labels,
		'public' => true,
		'publicly_queryable' => true,
		'show_ui' => true,
		'query_var' => 'blog',
		'rewrite' => true,
		'capability_type' => 'post',
		'hierarchical' => false,
		'menu_position' => null,
		'supports' => array('title','editor', 'thumbnail','comments', 'tags'),
		'menu_icon'=> 'dashicons-welcome-write-blog'
	);

	register_post_type( 'blog', $args );
}

add_action('init', 'post_type_blog');

function blog_category() {
    register_taxonomy(
        'blog-category',
        'blog',
        array(
            'labels' => array(
                'name' => __('Categories','classiads'),
                'add_new_item' => __('Add New Category','classiads'),
                'new_item_name' => __('New Category','classiads')
            ),
            'show_ui' => true,
            'show_tagcloud' => false,
            'hierarchical' => true
			)
    );

}
add_action( 'init', 'blog_category', 0 );
function blog_tags() {
register_taxonomy(
    'blog-tag',
    'blog',
		array(
			'hierarchical'  => false,
			'label'         => "tags",
			'singular_name' => "tag",
			'show_ui' => true,
			'rewrite'       => true,
			'query_var'     => true,
		)
	);
}
add_action( 'init', 'blog_tags', 0 );
function theme_prefix_rewrite_flush() {
    flush_rewrite_rules();
}
add_action( 'after_switch_theme', 'theme_prefix_rewrite_flush' );
?>
