<?php



function post_notification_meta_box( $post ){
	add_meta_box( 'post_n_meta_box', __( 'Notify User About Post', 'classiads' ), 'post_notification', 'post');
}
add_action( 'add_meta_boxes', 'post_notification_meta_box' );

function post_notification( $post ){
	if( isset( $post ) ){
	?>
	<table class='form-table'>
		<tr>
			<th>
				<label><?php _e( 'Notification Text', 'classiads' ); ?></label>
			</th>
			<td>
				<?php
					global $post_id,$post ;
					$p_id = $post->ID;
					$author_id = $post->post_author;
					$u_email = get_the_author_meta( 'user_email', $author_id );
				?>
				<input type="hidden" class="form-control" name="p_title" value="<?php the_title(); ?>" />
				<input type="hidden" class="form-control" name="p_email" value="<?php echo esc_attr($u_email);?>" />
				<textarea class="form-control" name="post_notification" cols="8" rows="8"></textarea>
			</td>
		</tr>
	</table>
<?php
	}
}

if( !function_exists('notify_update') ){
	add_action( 'save_post', 'notify_update' );
	function notify_update( $post_id ){
		if ( isset( $_REQUEST['post_notification'] ) ) {
			if ( !empty( $_REQUEST['post_notification'] ) ) {
				
				global $redux_demo ;
				$ad_name = $_POST['p_title'];
				$email_to = $_POST['p_email'];
				$ad_author_name = get_the_author_meta('user_login');
				$message = $_POST['post_notification'];
				$ad_link = get_permalink($post_id);
				$email_title = esc_html__('New Notification on your','classiads').' '.esc_attr($ad_name).' '.esc_html__('ad','classiads');
				
				classiads_email_notify_to_user_about_ad($email_title, '', $email_to ,$ad_author_name,$ad_name,$message,$ad_link);
			}
		}
	}
}

if ( !function_exists('classiads_mail_sender') ){
	
	function classiads_mail_sender($email_title = '', $sender_email = '', $email_to = '', $email_message = '', $preMesaage='') {
		
		global $redux_demo;
		$equine_logo = $redux_demo['logo']['url'];
		if( !empty( $sender_email ) ){
		}else{
			$sender_email = get_option("admin_email");
		}
		$message = '<img src="'.$equine_logo.'" alt=""/>'
					. "\r\n\r\n"
					.'Thank you for registering with Clasiads. Please click the link below to verify your email address and start using our website.'
					. "\r\n\r\n";
		$header = "From: $email_title <$sender_email> \r\n";
		$header .= "MIME-Version: 1.0\r\n";
		$header .= "Content-type: text/html\r\n";
		$preMesaage = classaids_email_template($email_message);
		
		wp_mail($email_to, $email_title, $preMesaage, $header);
		
	}
	
}

if( !function_exists('classiads_replace_stuff_for_me') ){
	
	function classiads_replace_stuff_for_me($find, $replace, $message){
		$i = 0;
		foreach($find as $item)
		{
			$replace_with = $replace[$i];
			$message = str_replace($item, $replace_with, $message);	
			$i++;
		}
		
		return $message;
	}
	
}
//New Email From Admin Panel
add_filter('wp_mail_from', 'new_mail_from');
add_filter('wp_mail_from_name', 'new_mail_from_name');

if( !function_exists('new_mail_from') ){
	
	function new_mail_from( $admin_email ) {
				
		$cl_email_from_address = get_option('cl_email_from_address');
		
		if( !empty( $cl_email_from_address ) ){
			
			$cl_email_from = $cl_email_from_address;
			
		}else{
			
			$cl_email_from = $admin_email;
			
		}
			
		return $cl_email_from;
	 
	}
	
}

if( !function_exists('new_mail_from_name') ){
	
	function new_mail_from_name($admin_email_name) {
				
		$cl_email_from_name = get_option('cl_email_from_name');
		
		if( !empty( $cl_email_from_name ) ){
			
			$cl_email_name_from = $cl_email_from_name;
			
		}else{
			
			$cl_email_name_from = get_bloginfo( 'name' );
			
		}
			
		return $cl_email_name_from;
	 
	}
	
}

if( !function_exists('classiads_email_template') ){
	
	function classaids_email_template($message = ''){
		
		$cl_email_bottom_text = get_option('cl_email_bottom_text');
		$cl_allow_html_in_email = get_option('cl_allow_html_in_email');
		
		$output ='';
		
		if( !empty($message) ){
			if( $cl_allow_html_in_email == 'yes' ){
				$output .= '<!doctype html>';
					$output .= '<html>';
					  $output .= '<head>';
						$output .= '<meta name="viewport" content="width=device-width" />';
						$output .= '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />';
						$output .= '<title>Simple Transactional Email</title>';
						$output .= '<style>';
						$output .= 'img{border:none;-ms-interpolation-mode:bicubic;max-width:100%;} body{background-color:#f6f6f6;font-family:sans-serif;-webkit-font-smoothing:antialiased;font-size:14px;line-height:1.4;margin:0;padding:0;-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;} table{border-collapse:separate;mso-table-lspace:0pt;mso-table-rspace:0pt;width:100%;} table td{font-family:sans-serif;font-size:14px;vertical-align:top;} .body{background-color:#f6f6f6;width:100%;} .container{display:block;Margin:0 auto !important;max-width:580px;padding:10px;width:580px;} .content{box-sizing:border-box;display:block;Margin:0 auto;max-width:580px;padding:10px;} .main{background:#fff;border-radius:3px;width:100%;} .wrapper{box-sizing:border-box;padding:20px;} .footer{clear:both;padding-top:10px;text-align:center;width:100%;} .footer td, .footer p, .footer span, .footer a{color:#999999;font-size:12px;text-align:center;} h1, h2, h3, h4{color:#000000;font-family:sans-serif;font-weight:400;line-height:1.4;margin:0;Margin-bottom:30px;} h1{font-size:35px;font-weight:300;text-align:center;text-transform:capitalize;} p, ul, ol{font-family:sans-serif;font-size:14px;font-weight:normal;margin:0;Margin-bottom:15px;} p li, ul li, ol li{list-style-position:inside;margin-left:5px;} a{color:#3498db;text-decoration:underline;} .btn{box-sizing:border-box;width:100%;} .btn > tbody > tr > td{padding-bottom:15px;} .btn table{width:auto;} .btn table td{background-color:#ffffff;border-radius:5px;text-align:center;} .btn a{background-color:#ffffff;border:solid 1px #3498db;border-radius:5px;box-sizing:border-box;color:#3498db;cursor:pointer;display:inline-block;font-size:14px;font-weight:bold;margin:0;padding:12px 25px;text-decoration:none;text-transform:capitalize;} .btn-primary table td{background-color:#3498db;} .btn-primary a{background-color:#3498db;border-color:#3498db;color:#ffffff;} .last{margin-bottom:0;} .first{margin-top:0;} .align-center{text-align:center;} .align-right{text-align:right;} .align-left{text-align:left;} .clear{clear:both;} .mt0{margin-top:0;} .mb0{margin-bottom:0;} .preheader{color:transparent;display:none;height:0;max-height:0;max-width:0;opacity:0;overflow:hidden;mso-hide:all;visibility:hidden;width:0;} .powered-by a{text-decoration:none;} hr{border:0;border-bottom:1px solid #f6f6f6;Margin:20px 0;} @media only screen and (max-width:620px){table[class=body] h1{font-size:28px !important;margin-bottom:10px !important;} table[class=body] p, table[class=body] ul, table[class=body] ol, table[class=body] td, table[class=body] span, table[class=body] a{font-size:16px !important;} table[class=body] .wrapper, table[class=body] .article{padding:10px !important;} table[class=body] .content{padding:0 !important;} table[class=body] .container{padding:0 !important;width:100% !important;} table[class=body] .main{border-left-width:0 !important;border-radius:0 !important;border-right-width:0 !important;} table[class=body] .btn table{width:100% !important;} table[class=body] .btn a{width:100% !important;} table[class=body] .img-responsive{height:auto !important;max-width:100% !important;width:auto !important;}} @media all{.ExternalClass{width:100%;} .ExternalClass, .ExternalClass p, .ExternalClass span, .ExternalClass font, .ExternalClass td, .ExternalClass div{line-height:100%;} .apple-link a{color:inherit !important;font-family:inherit !important;font-size:inherit !important;font-weight:inherit !important;line-height:inherit !important;text-decoration:none !important;} .btn-primary table td:hover{background-color:#34495e !important;} .btn-primary a:hover{background-color:#34495e !important;border-color:#34495e !important;} }';
						$output .= '</style>';
					  $output .= '</head>';
					  $output .= '<body class="">';
						$output .= '<table border="0" cellpadding="0" cellspacing="0" class="body">';
						 $output .= ' <tr>';
						   $output .= ' <td>&nbsp;</td>';
							$output .= '<td class="container">';
							  $output .= '<div class="content">';
								$output .= '<span class="preheader">This is preheader text. Some clients will show this text as a preview.</span>';
								$output .= '<table class="main">';
								  $output .= '<tr>';
									$output .= '<td class="wrapper">';
									  $output .= '<table border="0" cellpadding="0" cellspacing="0">';
									   $output .= ' <tr>';
										  $output .= '<td>';
											$output .= apply_filters('the_content', $message);
										  $output .= '</td>';
									   $output .= ' </tr>';
									  $output .= '</table>';
									$output .= '</td>';
								  $output .= '</tr>';
								 $output .= ' </table>';
								$output .= '<div class="footer">';
								  $output .= '<table border="0" cellpadding="0" cellspacing="0">';
									$output .= '<tr>';
									 $output .= ' <td class="content-block">';
										$output .= '<span class="apple-link">'.esc_attr($cl_email_bottom_text).'</span>';
										$output .= '<br>'.esc_html__('Dont like these emails?', 'classiads').' <a href="http://i.imgur.com/CScmqnj.gif">'.esc_html__('Unsubscribe', 'classiads').'</a>.';
									  $output .= '</td>';
									$output .= '</tr>';
									$output .= '<tr>';
									 $output .= ' <td class="content-block powered-by">';
										$output .= esc_html__('Powered by ', 'classiads').'<a href="#">'.esc_html__('Designinvento', 'classiads').'</a>';
									 $output .= ' </td>';
								   $output .= ' </tr>';
								 $output .= ' </table>';
								$output .= '</div>';
								$output .= '</div>';
						   $output .= ' </td>';
						   $output .= ' <td>&nbsp;</td>';
						 $output .= ' </tr>';
					   $output .= ' </table>';
					  $output .= '</body>';
					$output .= '</html>';
				}else{
					
					$output .= apply_filters('the_content', $message);   
					
				}

		}else{
			
			$output .= '';
			
		}
		
		return $output;
		
	}
	
}

if( !function_exists('classiads_email_pending_status') ){

	function classiads_email_pending_status($email_title = '',$email_to = '',$username = '',$ad_name = '',$ad_link = ''){
		
		/*
		* %%username%%
		* %%ad_name%%
		* %%site_login_url%% 
		* %%ad_link%%	
		* %%your_site_name%%	
		*/ 
		global $redux_demo;
		$site_login_url = $redux_demo['login'];
		$your_site_name = get_option('cl_email_from_name');
		$cl_email_message = get_option('cl_message_pending_for_user');	 
		
		$find 		= array('%%username%%', '%%ad_name%%', '%%site_login_url%%', '%%ad_link%%','%%your_site_name%%');
   		$replace 	= array($username,  $ad_name, $site_login_url, $ad_link,$your_site_name);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, '', $email_to, $email_message );
		
		$email_to2 = get_option('cl_email_from_address');
		$email_message2 = 'New submission Recieved and waiting for review at '.$your_site_name;
		classiads_mail_sender($email_title, '', $email_to2, $email_message2 );
		
	}
	
}


if( !function_exists('classiads_email_publish_status') ){

	function classiads_email_publish_status($email_title = '',$email_to = '',$username = '',$ad_name = '',$ad_link = ''){
		
		/*
		* %%username%%
		* %%ad_name%%
		* %%site_login_url%% 
		* %%ad_link%%	
		* %%your_site_name%%	
		*/ 
		global $redux_demo;
		$site_login_url = $redux_demo['login'];
		$your_site_name = get_option('cl_email_from_name');
		$cl_email_message = get_option('cl_message_publish_for_user');	 
		
		$find 		= array('%%username%%', '%%ad_name%%', '%%site_login_url%%', '%%ad_link%%','%%your_site_name%%');
   		$replace 	= array($username,  $ad_name, $site_login_url, $ad_link,$your_site_name);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, '', $email_to, $email_message );
		
	}
	
}

if( !function_exists('classiads_email_paid_pending_status') ){

	function classiads_email_paid_pending_status($email_title = '',$email_to = '',$username = '',$ad_name = '',$ad_link = ''){
		
		/*
		* %%username%%
		* %%ad_name%%
		* %%site_login_url%% 
		* %%ad_link%%	
		* %%your_site_name%%	
		*/  
		global $redux_demo;
		$site_login_url = $redux_demo['login'];
		$your_site_name = get_option('cl_email_from_name');
		$cl_email_message = get_option('cl_message_paid_pending_for_user');	 
		
		$find 		= array('%%username%%', '%%ad_name%%', '%%site_login_url%%', '%%ad_link%%','%%your_site_name%%');
   		$replace 	= array($username,  $ad_name, $site_login_url, $ad_link,$your_site_name);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, '', $email_to, $email_message );
		
		$email_to2 = get_option('cl_email_from_address');
		$email_message2 = 'New submission Recieved and waiting for review at '.$your_site_name;
		classiads_mail_sender($email_title, '', $email_to2, $email_message2 );
		
	}
	
}

if( !function_exists('classiads_email_notify_to_user_about_ad') ){

	function classiads_email_notify_to_user_about_ad($email_title = '', $sender_email = '', $email_to = '',$ad_author_name = '',$ad_name = '',$message = '',$ad_link = ''){
		
		/*
		* %%ad_author_name%%
		* %%ad_name%%
		* %%message%%
		* %%site_login_url%% 
		* %%ad_link%% 
		* %%your_site_name%% 
		*/
		global $redux_demo;
		$site_login_url = $redux_demo['login'];
		$your_site_name = get_option('cl_email_from_name');
		$cl_email_message = get_option('cl_message_notify_for_user');	
		
		$find 		= array('%%ad_author_name%%', '%%ad_name%%', '%%message%%', '%%site_login_url%%','%%ad_link%%','%%your_site_name%%');
   		$replace 	= array($ad_author_name,  $ad_name, $message, $site_login_url, $ad_link, $your_site_name);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, $sender_email, $email_to, $email_message );
		
	}
	
}


if( !function_exists('classiads_email_near_ads_expiry_status') ){

	function classiads_email_near_ads_expiry_status($email_title = '',$email_to = '',$username = '',$ad_name = '',$ad_link = ''){
		
		/*
		* %%username%%
		* %%ad_name%%
		* %%site_login_url%% 
		* %%selected_days%% 
		* %%ad_link%%	
		* %%your_site_name%%	
		*/ 
		global $redux_demo;
		$site_login_url = $redux_demo['login'];
		$your_site_name = get_option('cl_email_from_name');
		$cl_email_message = get_option('cl_message_near_expire_for_user');	 
		$selected_days = get_option('cl_days_near_expire_for_user');	 
		
		$find = array('%%username%%', '%%ad_name%%', '%%selected_days%%', '%%site_login_url%%', '%%ad_link%%','%%your_site_name%%');
   		$replace 	= array($username,  $ad_name, $selected_days, $site_login_url, $ad_link,$your_site_name);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, '', $email_to, $email_message );
		
	}
	
}

if( !function_exists('classiads_email_featured_ads_expired_status') ){

	function classiads_email_featured_ads_expired_status($email_title = '',$email_to = '',$username = '',$ad_name = '',$ad_link = '',$ad_id = ''){
		
		/*
		* %%username%%
		* %%ad_name%%
		* %%site_login_url%% 
		* %%ad_id%% 
		* %%ad_link%%	
		* %%your_site_name%%	
		*/ 
		global $redux_demo;
		$site_login_url = $redux_demo['login'];
		$your_site_name = get_option('cl_email_from_name');
		$cl_email_message = get_option('cl_message_featured_expired_for_user');	 
		
		$find = array('%%username%%', '%%ad_name%%', '%%ad_id%%', '%%site_login_url%%', '%%ad_link%%','%%your_site_name%%');
   		$replace 	= array($username,  $ad_name, $ad_id, $site_login_url, $ad_link,$your_site_name);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, '', $email_to, $email_message );
		
	}
	
}

if( !function_exists('classiads_email_near_featured_ads_expiry_status') ){

	function classiads_email_near_featured_ads_expiry_status($email_title = '',$email_to = '',$username = '',$ad_name = '',$ad_link = ''){
		
		/*
		* %%username%%
		* %%ad_name%%
		* %%site_login_url%% 
		* %%selected_days%% 
		* %%ad_link%%	
		* %%your_site_name%%	
		*/ 
		global $redux_demo;
		$site_login_url = $redux_demo['login'];
		$your_site_name = get_option('cl_email_from_name');
		$cl_email_message = get_option('cl_message_featured_near_expire_for_user');	 
		$selected_days = get_option('cl_days_featured_near_expire_for_user');	 
		
		$find = array('%%username%%', '%%ad_name%%', '%%selected_days%%', '%%site_login_url%%', '%%ad_link%%','%%your_site_name%%');
   		$replace 	= array($username,  $ad_name, $selected_days, $site_login_url, $ad_link,$your_site_name);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, '', $email_to, $email_message );
		
	}
	
}

if( !function_exists('classiads_email_near_ads_expired_status') ){

	function classiads_email_near_ads_expired_status($email_title = '',$email_to = '',$username = '',$ad_name = '',$ad_link = '',$ad_id = ''){
		
		/*
		* %%username%%
		* %%ad_name%%
		* %%site_login_url%% 
		* %%ad_id%% 
		* %%ad_link%%	
		* %%your_site_name%%	
		*/ 
		global $redux_demo;
		$site_login_url = $redux_demo['login'];
		$your_site_name = get_option('cl_email_from_name');
		$cl_email_message = get_option('cl_message_expired_for_user');	 
		
		$find = array('%%username%%', '%%ad_name%%', '%%ad_id%%', '%%site_login_url%%', '%%ad_link%%','%%your_site_name%%');
   		$replace 	= array($username,  $ad_name, $ad_id, $site_login_url, $ad_link,$your_site_name);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, '', $email_to, $email_message );
		
	}
	
}

if( !function_exists('classiads_email_new_user_registration_email') ){

	function classiads_email_new_user_registration_email($email_title = '',$email_to = '',$username = '',$password = '',$verify_link = ''){
		
		/*
		* %%username%%
		* %%your_site_name%%
		* %%verify_link%% 
		* %%login_url%% 
		* %%password%%	
		*/ 
		global $redux_demo;
		$login_url = $redux_demo['login'];
		$your_site_name = get_option('cl_email_from_name');
		$cl_email_message = get_option('cl_message_registration_email');	 
		
		$find = array('%%username%%', '%%your_site_name%%', '%%verify_link%%', '%%login_url%%','%%password%%');
   		$replace 	= array($username, $your_site_name, $verify_link, $login_url, $password);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, '', $email_to, $email_message );
		
	}
	
}

if( !function_exists('classiads_email_new_user_registration_email_to_admin') ){

	function classiads_email_new_user_registration_email_to_admin($email_title = '',$email_to = '',$username = '',$password = ''){
		
		/*
		* %%username%%
		* %%your_site_name%%
		* %%verify_link%% 
		* %%login_url%% 
		* %%password%%	
		*/ 
		global $redux_demo;
		$login_url = $redux_demo['login'];
		$your_site_name = get_option('cl_email_from_name');
		$cl_email_message = get_option('cl_message_registration_email_to_admin');	 
		
		$find = array('%%username%%', '%%your_site_name%%', '%%verify_link%%', '%%login_url%%','%%password%%');
   		$replace 	= array($username, $your_site_name, $verify_link, $login_url, $password);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, '', $email_to, $email_message);
		
	}
	
}

if( !function_exists('classiads_email_user_forgot_email') ){

	function classiads_email_user_forgot_email($email_title = '',$email_to = '',$username = '',$password = ''){
		
		/*
		* %%username%%
		* %%site_login_url%%
		* %%your_site_name%% 
		* %%password%% 
		*/ 
		global $redux_demo;
		$site_login_url = $redux_demo['login'];
		$your_site_name = get_option('cl_email_from_name');
		$cl_email_message = get_option('cl_message_forgot_email');	 
		
		$find = array('%%username%%', '%%site_login_url%%', '%%your_site_name%%', '%%password%%');
   		$replace 	= array($username, $site_login_url, $your_site_name, $password);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, '', $email_to, $email_message );
		
	}
	
}

if( !function_exists('classiads_email_buy_membership') ){

	function classiads_email_buy_membership($email_title = '',$email_to = '',$username = '',$plan_name = '',$invoice_id = ''){
		
		/*
		* %%username%%
		* %%plan_name%%
		* %%invoice_id%% 
		* %%site_login_url%%
		* %%your_site_name%% 
		*/ 
		global $redux_demo;
		$site_login_url = $redux_demo['login'];
		$your_site_name = get_option('cl_email_from_name');
		$cl_email_message = get_option('cl_buy_message_email');	 
		
		$find = array('%%username%%', '%%plan_name%%', '%%invoice_id%%', '%%your_site_name%%','%%site_login_url%%');
   		$replace 	= array($username, $plan_name, $invoice_id, $your_site_name,$site_login_url);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, '', $email_to, $email_message );
		
	}
	
}

if( !function_exists('classiads_email_near_expire_membership') ){

	function classiads_email_near_expire_membership($email_title = '',$email_to = '',$username = '',$plan_name = '',$invoice_id = ''){
		
		/*
		* %%username%%
		* %%plan_name%%
		* %%invoice_id%%
		* %%site_login_url%%
		* %%selected_days%%
		* %%your_site_name%%
		*/ 
		
		global $redux_demo;
		$site_login_url = $redux_demo['login'];
		$your_site_name = get_option('cl_email_from_name');
		$cl_email_message = get_option('cl_buy_near_message_email');	 
		$selected_days = get_option('cl_days_buy_near_message_email');	 
		
		$find = array('%%username%%', '%%plan_name%%', '%%invoice_id%%', '%%your_site_name%%','%%site_login_url%%','%%selected_days%%');
   		$replace 	= array($username, $plan_name, $invoice_id, $your_site_name,$site_login_url,$selected_days);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, '', $email_to, $email_message );
		
	}
	
}

if( !function_exists('classiads_email_expire_membership') ){

	function classiads_email_expire_membership($email_title = '',$email_to = '',$username = '',$plan_name = '',$invoice_id = ''){
		
		/*
		* %%username%%
		* %%plan_name%%
		* %%invoice_id%%
		* %%site_login_url%%
		* %%your_site_name%%
		*/ 
		
		global $redux_demo;
		$site_login_url = $redux_demo['login'];
		$your_site_name = get_option('cl_email_from_name');
		$cl_email_message = get_option('cl_message_membership_expired');	 
		
		$find = array('%%username%%', '%%plan_name%%', '%%invoice_id%%', '%%your_site_name%%','%%site_login_url%%');
   		$replace 	= array($username, $plan_name, $invoice_id, $your_site_name,$site_login_url);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, '', $email_to, $email_message );
		
	}
	
}



if( !function_exists('classiads_email_leave_reply_to_author') ){

	function classiads_email_leave_reply_to_author($email_title = '', $sender_email = '', $email_to = '',$ad_author_name = '',$sender_message = '',$ad_link = '',$sender_name = ''){
		
		/*
		* %%ad_author_name%%
		* %%sender_message%%
		* %%ad_link%% 
		* %%sender_name%%	
		*/
		
		$cl_email_message = get_option('cl_l_reply_to_author');	
		
		$find 		= array('%%ad_author_name%%', '%%sender_message%%', '%%ad_link%%', '%%sender_name%%');
   		$replace 	= array($ad_author_name,  $sender_message, $ad_link, $sender_name);
		
		$email_message 	= classiads_replace_stuff_for_me($find, $replace, $cl_email_message);

		classiads_mail_sender($email_title, $sender_email, $email_to, $email_message );
		
	}
	
}


if( !function_exists('classiads_publish_status') ){
	
	//add_action( 'save_post', 'classiads_publish_status' );
	add_action(  'transition_post_status',  'classiads_publish_status', 10, 3 );
	function classiads_publish_status( $new_status, $old_status, $post  ) { 
	   
		$post_id = $post->ID;
		$author_id = $post->post_author;
		$user = get_userdata($author_id);
		$username = $user->user_login;
		$email_to = $user->user_email;
		$ad_link = get_permalink( $post_id );
		$ad_name = get_the_title( $post_id ); 
		$post_type = get_post_type( $post_id ); 
		$post_status = get_post_status( $post_id ); 
		$email_title = esc_html__('Your','classiads').' '.$ad_name.' '.esc_html__('ad','classiads');
		
		if( $post_type == 'post' ){
			if ( $new_status == 'publish' && $new_status != $old_status ) {
					
				classiads_email_publish_status($email_title,$email_to,$username,$ad_name,$ad_link);
				 
				
			}
		}
			
	}
	
}


 ?>