<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="user-scalable = yes">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?php wp_title( '|', true, 'right' ); ?></title>
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php 
	if(is_single()){
		$ID = $wp_query->post->ID;
		$feat_image = wp_get_attachment_url( get_post_thumbnail_id($ID) );
		?>
		<meta property="og:image" content="<?php echo esc_attr($feat_image); ?>"/>
		<?php
	}
	?>
	<?php 
	if (isset($_SERVER['HTTP_USER_AGENT']) &&
    (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false))
        header('X-UA-Compatible: IE=9');
	global $redux_demo; 
	$favicon = $redux_demo['favicon']['url'];
	?>

	<?php if (!empty($favicon)) : ?>
	<link rel="shortcut icon" href="<?php echo esc_attr($favicon); ?>" type="image/x-icon" />
	<?php endif; ?>
	<!--[if lt IE 9]>
	<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js"></script>
	<![endif]-->
	<?php wp_head(); ?>
</head>
<?php 

	$layout = $redux_demo['layout-version'];	
	if(function_exists('classiads_purchase_iframe')){
		classiads_purchase_iframe();
	}
	
?>

<body <?php if($layout == 2){ ?>id="boxed" <?php } ?> <?php body_class(); ?>>

<?php do_action('classiads_headers'); ?>


